@extends('layouts.app')

@section('title', 'Purchase Order Details')

@section('content')
<div class="px-4 sm:px-6 lg:px-8 py-8">
    <div class="max-w-5xl mx-auto">
        <!-- Header -->
        <div class="mb-6 flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-semibold text-gray-900">Purchase Order: {{ $purchaseOrder->po_number }}</h1>
                <p class="mt-2 text-sm text-gray-700">View purchase order details and status</p>
            </div>
            <div class="flex gap-2">
                <a href="{{ route('purchase-orders.index') }}" class="px-4 py-2 bg-gray-600 text-white rounded-md hover:bg-gray-700 text-sm">
                    Back to List
                </a>
                <a href="{{ route('purchase-orders.print', $purchaseOrder->id) }}" target="_blank" class="px-4 py-2 bg-purple-600 text-white rounded-md hover:bg-purple-700 text-sm flex items-center gap-2">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"/>
                    </svg>
                    Print Receipt
                </a>
                @if($purchaseOrder->status === 'draft')
                    <form action="{{ route('purchase-orders.confirm', $purchaseOrder->id) }}" method="POST" class="inline">
                        @csrf
                        <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 text-sm">
                            Confirm PO
                        </button>
                    </form>
                @endif
                @if(in_array($purchaseOrder->status, ['confirmed', 'partial']))
                    <a href="{{ route('purchase-orders.receive', $purchaseOrder->id) }}" class="px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700 text-sm">
                        Receive Stock
                    </a>
                @endif
            </div>
        </div>

        <!-- PO Information -->
        <div class="bg-white shadow rounded-lg overflow-hidden mb-6">
            <div class="px-6 py-4 bg-gray-50 border-b border-gray-200">
                <h2 class="text-lg font-medium text-gray-900">Purchase Order Information</h2>
            </div>
            <div class="px-6 py-4">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <h3 class="text-sm font-medium text-gray-500">Supplier</h3>
                        <p class="mt-1 text-sm text-gray-900">{{ $purchaseOrder->supplier_name }}</p>
                        @if($purchaseOrder->contact_person)
                            <p class="mt-1 text-xs text-gray-500">Contact: {{ $purchaseOrder->contact_person }}</p>
                        @endif
                        @if($purchaseOrder->phone)
                            <p class="mt-1 text-xs text-gray-500">Phone: {{ $purchaseOrder->phone }}</p>
                        @endif
                    </div>
                    <div>
                        <h3 class="text-sm font-medium text-gray-500">Status</h3>
                        @php
                            $statusColors = [
                                'draft' => 'bg-gray-100 text-gray-800',
                                'confirmed' => 'bg-blue-100 text-blue-800',
                                'partial' => 'bg-yellow-100 text-yellow-800',
                                'received' => 'bg-green-100 text-green-800',
                                'cancelled' => 'bg-red-100 text-red-800',
                            ];
                        @endphp
                        <span class="mt-1 inline-flex px-3 py-1 text-sm font-semibold rounded-full {{ $statusColors[$purchaseOrder->status] ?? 'bg-gray-100 text-gray-800' }}">
                            {{ ucfirst($purchaseOrder->status) }}
                        </span>
                    </div>
                    <div>
                        <h3 class="text-sm font-medium text-gray-500">Order Date</h3>
                        <p class="mt-1 text-sm text-gray-900">{{ \Carbon\Carbon::parse($purchaseOrder->order_date)->format('d M Y') }}</p>
                    </div>
                    <div>
                        <h3 class="text-sm font-medium text-gray-500">Expected Delivery</h3>
                        <p class="mt-1 text-sm text-gray-900">
                            {{ $purchaseOrder->expected_date ? \Carbon\Carbon::parse($purchaseOrder->expected_date)->format('d M Y') : 'Not specified' }}
                        </p>
                    </div>
                    <div>
                        <h3 class="text-sm font-medium text-gray-500">Created By</h3>
                        <p class="mt-1 text-sm text-gray-900">{{ $purchaseOrder->created_by_name }}</p>
                        <p class="mt-1 text-xs text-gray-500">{{ \Carbon\Carbon::parse($purchaseOrder->created_at)->format('d M Y H:i') }}</p>
                    </div>
                    @if(in_array($purchaseOrder->status, ['partial', 'received']))
                        <div>
                            <h3 class="text-sm font-medium text-gray-500">Received By</h3>
                            <p class="mt-1 text-sm text-gray-900">{{ $purchaseOrder->received_by_name ?? '-' }}</p>
                            @if($purchaseOrder->received_at)
                                <p class="mt-1 text-xs text-gray-500">{{ \Carbon\Carbon::parse($purchaseOrder->received_at)->format('d M Y H:i') }}</p>
                            @endif
                        </div>
                    @endif
                </div>

                @if($purchaseOrder->notes)
                    <div class="mt-6">
                        <h3 class="text-sm font-medium text-gray-500">Notes</h3>
                        <p class="mt-1 text-sm text-gray-900">{{ $purchaseOrder->notes }}</p>
                    </div>
                @endif
            </div>
        </div>

        <!-- Items List -->
        <div class="bg-white shadow rounded-lg overflow-hidden">
            <div class="px-6 py-4 bg-gray-50 border-b border-gray-200">
                <h2 class="text-lg font-medium text-gray-900">Order Items</h2>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">SKU</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Product Name</th>
                            <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Ordered</th>
                            <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Received</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Unit Price</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Subtotal</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($items as $item)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                    {{ $item->sku }}
                                </td>
                                <td class="px-6 py-4 text-sm text-gray-900">
                                    {{ $item->product_name }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center text-sm text-gray-900">
                                    {{ $item->qty_ordered }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center">
                                    <span class="text-sm {{ $item->qty_received >= $item->qty_ordered ? 'text-green-600 font-bold' : 'text-gray-900' }}">
                                        {{ $item->qty_received }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm text-gray-900">
                                    RM {{ number_format($item->unit_cost, 2) }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium text-gray-900">
                                    RM {{ number_format($item->total_cost, 2) }}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr class="bg-gray-50">
                            <td colspan="5" class="px-6 py-4 text-right font-bold text-gray-900">Total Amount:</td>
                            <td class="px-6 py-4 text-right text-lg font-bold text-gray-900">
                                RM {{ number_format($purchaseOrder->total_amount, 2) }}
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
