@extends('layouts.app')

@section('title', 'Receive Stock')

@section('content')
<div class="px-4 sm:px-6 lg:px-8 py-8">
    <div class="max-w-5xl mx-auto">
        <!-- Header -->
        <div class="mb-6">
            <h1 class="text-2xl font-semibold text-gray-900">Receive Stock - {{ $purchaseOrder->po_number }}</h1>
            <p class="mt-2 text-sm text-gray-700">Enter the quantities received for each item</p>
        </div>

        <!-- PO Info Summary -->
        <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mb-6">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <p class="text-sm text-gray-600">Supplier</p>
                    <p class="font-medium text-gray-900">{{ $purchaseOrder->supplier_name }}</p>
                </div>
                <div>
                    <p class="text-sm text-gray-600">Order Date</p>
                    <p class="font-medium text-gray-900">{{ \Carbon\Carbon::parse($purchaseOrder->order_date)->format('d M Y') }}</p>
                </div>
                <div>
                    <p class="text-sm text-gray-600">Status</p>
                    @php
                        $statusColors = [
                            'confirmed' => 'bg-blue-100 text-blue-800',
                            'partial' => 'bg-yellow-100 text-yellow-800',
                        ];
                    @endphp
                    <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full {{ $statusColors[$purchaseOrder->status] ?? 'bg-gray-100 text-gray-800' }}">
                        {{ ucfirst($purchaseOrder->status) }}
                    </span>
                </div>
            </div>
        </div>

        <form action="{{ route('purchase-orders.process-receive', $purchaseOrder->id) }}" method="POST" class="bg-white shadow rounded-lg overflow-hidden" x-data="receiveForm()">
            @csrf

            <div class="px-6 py-4 bg-gray-50 border-b border-gray-200 flex items-center justify-between">
                <h2 class="text-lg font-medium text-gray-900">Items to Receive</h2>
                <button type="button" @click="receiveAll()" class="px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700 text-sm flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                    Receive All Remaining
                </button>
            </div>

            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">SKU</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Product Name</th>
                            <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Ordered</th>
                            <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Already Received</th>
                            <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Receiving Now</th>
                            <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Remaining</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($items as $index => $item)
                            <tr x-data="{
                                ordered: {{ $item->qty_ordered }},
                                alreadyReceived: {{ $item->qty_received }},
                                receiving: {{ $item->qty_ordered - $item->qty_received }},
                                get remaining() {
                                    return this.ordered - this.alreadyReceived - parseInt(this.receiving || 0);
                                }
                            }" x-ref="row{{ $index }}">
                                <input type="hidden" name="items[{{ $index }}][id]" value="{{ $item->id }}">

                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                    {{ $item->sku }}
                                </td>
                                <td class="px-6 py-4 text-sm text-gray-900">
                                    {{ $item->product_name }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center text-sm text-gray-900">
                                    {{ $item->qty_ordered }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center text-sm text-gray-600">
                                    {{ $item->qty_received }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center">
                                    <input type="number"
                                           name="items[{{ $index }}][quantity_received]"
                                           x-model="receiving"
                                           min="0"
                                           max="{{ $item->qty_ordered - $item->qty_received }}"
                                           value="{{ $item->qty_ordered - $item->qty_received }}"
                                           class="w-24 px-3 py-2 border border-gray-300 rounded-md text-center focus:ring-indigo-500 focus:border-indigo-500">
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-center">
                                    <span class="text-sm font-medium" :class="remaining === 0 ? 'text-green-600' : 'text-gray-900'" x-text="remaining"></span>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Notes -->
            <div class="px-6 py-4 border-t border-gray-200">
                <label for="receive_notes" class="block text-sm font-medium text-gray-700">Receiving Notes</label>
                <textarea name="receive_notes" id="receive_notes" rows="3"
                          placeholder="Add any notes about this delivery (optional)"
                          class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500"></textarea>
            </div>

            <!-- Actions -->
            <div class="px-6 py-4 bg-gray-50 border-t border-gray-200 flex items-center justify-end gap-3">
                <a href="{{ route('purchase-orders.show', $purchaseOrder->id) }}" class="px-4 py-2 border border-gray-300 rounded-md text-sm font-medium text-gray-700 hover:bg-gray-50">
                    Cancel
                </a>
                <button type="submit" class="px-4 py-2 bg-green-600 border border-transparent rounded-md text-sm font-medium text-white hover:bg-green-700">
                    Confirm Receipt
                </button>
            </div>
        </form>
    </div>
</div>

<script>
function receiveForm() {
    return {
        items: @json($items->map(function($item) {
            return [
                'qty_ordered' => $item->qty_ordered,
                'qty_received' => $item->qty_received,
                'remaining' => $item->qty_ordered - $item->qty_received
            ];
        })),

        receiveAll() {
            // Set all receiving inputs to their remaining quantities
            const inputs = document.querySelectorAll('input[name*="quantity_received"]');
            inputs.forEach((input, index) => {
                const remaining = this.items[index].remaining;
                input.value = remaining;
                // Trigger input event to update Alpine.js binding
                input.dispatchEvent(new Event('input'));
            });

            // Show confirmation
            alert('All items set to receive remaining quantities!');
        }
    }
}
</script>
@endsection
