<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Purchase Order - {{ $purchaseOrder->po_number }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            font-size: 11pt;
            line-height: 1.4;
            color: #000;
            padding: 20mm;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #000;
            padding-bottom: 15px;
        }

        .header h1 {
            font-size: 20pt;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .header .po-number {
            font-size: 14pt;
            font-weight: bold;
            color: #333;
        }

        .info-section {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }

        .info-box {
            width: 48%;
        }

        .info-box h3 {
            font-size: 12pt;
            font-weight: bold;
            margin-bottom: 8px;
            border-bottom: 1px solid #ccc;
            padding-bottom: 3px;
        }

        .info-box p {
            margin: 3px 0;
            font-size: 10pt;
        }

        .info-box .label {
            font-weight: bold;
            display: inline-block;
            width: 120px;
        }

        .status-badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 4px;
            font-weight: bold;
            font-size: 10pt;
        }

        .status-draft { background: #e5e7eb; color: #374151; }
        .status-confirmed { background: #dbeafe; color: #1e40af; }
        .status-partial { background: #fef3c7; color: #92400e; }
        .status-received { background: #d1fae5; color: #065f46; }

        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }

        table thead {
            background: #f3f4f6;
        }

        table th {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
            font-size: 10pt;
            font-weight: bold;
        }

        table td {
            border: 1px solid #000;
            padding: 6px 8px;
            font-size: 10pt;
        }

        table td.text-right {
            text-align: right;
        }

        table td.text-center {
            text-align: center;
        }

        table tfoot td {
            font-weight: bold;
            background: #f9fafb;
        }

        .totals {
            margin-top: 10px;
            text-align: right;
        }

        .totals .total-row {
            font-size: 14pt;
            font-weight: bold;
            margin-top: 5px;
        }

        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #ccc;
        }

        .signature-section {
            display: flex;
            justify-content: space-between;
            margin-top: 40px;
        }

        .signature-box {
            width: 45%;
        }

        .signature-box p {
            margin: 5px 0;
            font-size: 10pt;
        }

        .signature-line {
            border-top: 1px solid #000;
            margin-top: 50px;
            padding-top: 5px;
            text-align: center;
        }

        .print-info {
            text-align: center;
            font-size: 9pt;
            color: #666;
            margin-top: 20px;
        }

        @media print {
            body {
                padding: 10mm;
            }

            .no-print {
                display: none;
            }
        }

        .print-button {
            position: fixed;
            top: 20px;
            right: 20px;
            padding: 12px 24px;
            background: #4f46e5;
            color: white;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 600;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .print-button:hover {
            background: #4338ca;
        }
    </style>
</head>
<body>
    <button onclick="window.print()" class="print-button no-print">🖨️ Print Receipt</button>

    <div class="header">
        <h1>PURCHASE ORDER</h1>
        <p class="po-number">{{ $purchaseOrder->po_number }}</p>
        <p style="margin-top: 5px;">
            <span class="status-badge status-{{ $purchaseOrder->status }}">{{ strtoupper($purchaseOrder->status) }}</span>
        </p>
    </div>

    <div class="info-section">
        <div class="info-box">
            <h3>Supplier Information</h3>
            <p><span class="label">Supplier:</span> {{ $purchaseOrder->supplier_name }}</p>
            @if($purchaseOrder->contact_person)
                <p><span class="label">Contact Person:</span> {{ $purchaseOrder->contact_person }}</p>
            @endif
            @if($purchaseOrder->phone)
                <p><span class="label">Phone:</span> {{ $purchaseOrder->phone }}</p>
            @endif
            @if($purchaseOrder->email)
                <p><span class="label">Email:</span> {{ $purchaseOrder->email }}</p>
            @endif
            @if($purchaseOrder->supplier_address)
                <p><span class="label">Address:</span> {{ $purchaseOrder->supplier_address }}</p>
            @endif
        </div>

        <div class="info-box">
            <h3>Order Information</h3>
            <p><span class="label">PO Number:</span> {{ $purchaseOrder->po_number }}</p>
            <p><span class="label">Order Date:</span> {{ \Carbon\Carbon::parse($purchaseOrder->order_date)->format('d M Y') }}</p>
            <p><span class="label">Expected Date:</span> {{ $purchaseOrder->expected_date ? \Carbon\Carbon::parse($purchaseOrder->expected_date)->format('d M Y') : 'Not specified' }}</p>
            <p><span class="label">Created By:</span> {{ $purchaseOrder->created_by_name }}</p>
            @if(in_array($purchaseOrder->status, ['partial', 'received']))
                <p><span class="label">Received By:</span> {{ $purchaseOrder->received_by_name ?? '-' }}</p>
                @if($purchaseOrder->received_at)
                    <p><span class="label">Received Date:</span> {{ \Carbon\Carbon::parse($purchaseOrder->received_at)->format('d M Y H:i') }}</p>
                @endif
            @endif
        </div>
    </div>

    @if($purchaseOrder->notes)
        <div style="margin-bottom: 15px; padding: 10px; background: #f9fafb; border: 1px solid #e5e7eb; border-radius: 4px;">
            <strong>Notes:</strong> {{ $purchaseOrder->notes }}
        </div>
    @endif

    <table>
        <thead>
            <tr>
                <th style="width: 8%;">No.</th>
                <th style="width: 15%;">SKU</th>
                <th style="width: 32%;">Product Name</th>
                <th style="width: 12%; text-align: center;">Qty Ordered</th>
                <th style="width: 12%; text-align: center;">Qty Received</th>
                <th style="width: 10%; text-align: right;">Unit Cost</th>
                <th style="width: 11%; text-align: right;">Total Cost</th>
            </tr>
        </thead>
        <tbody>
            @foreach($items as $index => $item)
                <tr>
                    <td class="text-center">{{ $index + 1 }}</td>
                    <td>{{ $item->sku }}</td>
                    <td>{{ $item->product_name }}</td>
                    <td class="text-center">{{ $item->qty_ordered }}</td>
                    <td class="text-center" style="{{ $item->qty_received > 0 ? 'font-weight: bold;' : '' }}">
                        {{ $item->qty_received }}
                    </td>
                    <td class="text-right">RM {{ number_format($item->unit_cost, 2) }}</td>
                    <td class="text-right">RM {{ number_format($item->total_cost, 2) }}</td>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr>
                <td colspan="6" class="text-right">TOTAL AMOUNT:</td>
                <td class="text-right" style="font-size: 12pt;">RM {{ number_format($purchaseOrder->total_amount, 2) }}</td>
            </tr>
        </tfoot>
    </table>

    <div class="signature-section">
        <div class="signature-box">
            <p><strong>Prepared By:</strong></p>
            <div class="signature-line">
                <p>{{ $purchaseOrder->created_by_name }}</p>
                <p style="font-size: 9pt; color: #666;">Name & Signature</p>
            </div>
        </div>

        <div class="signature-box">
            <p><strong>Received By:</strong></p>
            <div class="signature-line">
                <p>{{ $purchaseOrder->received_by_name ?? '______________________' }}</p>
                <p style="font-size: 9pt; color: #666;">Name & Signature</p>
            </div>
        </div>
    </div>

    <div class="print-info">
        <p>Printed on {{ now()->format('d M Y H:i:s') }} | OmniaBoss Production System</p>
        <p>This is a computer-generated document. No signature is required unless specified.</p>
    </div>
</body>
</html>
