@extends('layouts.app')

@section('title', 'Purchase Orders')

@section('content')
<div class="px-4 sm:px-6 lg:px-8 py-8">
    <div class="sm:flex sm:items-center justify-between mb-6">
        <div>
            <h1 class="text-2xl font-semibold text-gray-900">Purchase Orders</h1>
            <p class="mt-2 text-sm text-gray-700">Manage purchase orders from suppliers</p>
        </div>
        <div class="mt-4 sm:mt-0">
            <a href="{{ route('purchase-orders.create') }}" class="inline-flex items-center px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
                </svg>
                Create PO
            </a>
        </div>
    </div>

    <!-- Status Filter -->
    <div class="mb-6 flex gap-2">
        <a href="{{ route('purchase-orders.index') }}" class="px-4 py-2 rounded-md {{ !$status ? 'bg-indigo-600 text-white' : 'bg-gray-200 text-gray-700 hover:bg-gray-300' }}">
            All
        </a>
        <a href="{{ route('purchase-orders.index', ['status' => 'draft']) }}" class="px-4 py-2 rounded-md {{ $status == 'draft' ? 'bg-indigo-600 text-white' : 'bg-gray-200 text-gray-700 hover:bg-gray-300' }}">
            Draft
        </a>
        <a href="{{ route('purchase-orders.index', ['status' => 'confirmed']) }}" class="px-4 py-2 rounded-md {{ $status == 'confirmed' ? 'bg-indigo-600 text-white' : 'bg-gray-200 text-gray-700 hover:bg-gray-300' }}">
            Confirmed
        </a>
        <a href="{{ route('purchase-orders.index', ['status' => 'partial']) }}" class="px-4 py-2 rounded-md {{ $status == 'partial' ? 'bg-indigo-600 text-white' : 'bg-gray-200 text-gray-700 hover:bg-gray-300' }}">
            Partial
        </a>
        <a href="{{ route('purchase-orders.index', ['status' => 'received']) }}" class="px-4 py-2 rounded-md {{ $status == 'received' ? 'bg-indigo-600 text-white' : 'bg-gray-200 text-gray-700 hover:bg-gray-300' }}">
            Received
        </a>
    </div>

    <div class="bg-white shadow rounded-lg overflow-hidden">
        @if($purchaseOrders->count() > 0)
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">PO Number</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Supplier</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Order Date</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Total Amount</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($purchaseOrders as $po)
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-gray-900">{{ $po->po_number }}</div>
                                <div class="text-xs text-gray-500">{{ $po->created_by_name }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                {{ $po->supplier_name }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                {{ \Carbon\Carbon::parse($po->order_date)->format('d M Y') }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium text-gray-900">
                                RM {{ number_format($po->total_amount, 2) }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @php
                                    $statusColors = [
                                        'draft' => 'bg-gray-100 text-gray-800',
                                        'confirmed' => 'bg-blue-100 text-blue-800',
                                        'partial' => 'bg-yellow-100 text-yellow-800',
                                        'received' => 'bg-green-100 text-green-800',
                                        'cancelled' => 'bg-red-100 text-red-800',
                                    ];
                                @endphp
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $statusColors[$po->status] ?? 'bg-gray-100 text-gray-800' }}">
                                    {{ ucfirst($po->status) }}
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <a href="{{ route('purchase-orders.show', $po->id) }}" class="text-indigo-600 hover:text-indigo-900 mr-3">View</a>
                                @if($po->status == 'draft')
                                    <a href="{{ route('purchase-orders.edit', $po->id) }}" class="text-indigo-600 hover:text-indigo-900">Edit</a>
                                @elseif(in_array($po->status, ['confirmed', 'partial']))
                                    <a href="{{ route('purchase-orders.receive', $po->id) }}" class="text-green-600 hover:text-green-900">Receive</a>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

            <div class="px-6 py-4 bg-gray-50">
                {{ $purchaseOrders->appends(['status' => $status])->links() }}
            </div>
        @else
            <div class="text-center py-12">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900">No purchase orders</h3>
                <p class="mt-1 text-sm text-gray-500">Get started by creating a new purchase order.</p>
                <div class="mt-6">
                    <a href="{{ route('purchase-orders.create') }}" class="inline-flex items-center px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700">
                        Create PO
                    </a>
                </div>
            </div>
        @endif
    </div>
</div>
@endsection
