@extends('layouts.app')

@section('title', 'Staff Performance Dashboard')

@section('content')
<div class="px-4 sm:px-6 lg:px-8">
    <!-- Header -->
    <div class="sm:flex sm:items-center justify-between mb-6">
        <div class="sm:flex-auto">
            <h1 class="text-2xl font-semibold text-gray-900">Staff Performance Dashboard</h1>
            <p class="mt-2 text-sm text-gray-700">Track production staff productivity and performance metrics</p>
        </div>
    </div>

    <!-- Date Range and Staff Filter -->
    <div class="bg-white rounded-lg shadow mb-6 p-4">
        <form method="GET" action="{{ route('performance') }}" class="space-y-4">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <!-- This Month Quick Filter -->
                <div class="flex items-end">
                    <a href="{{ route('performance', ['date_from' => now()->startOfMonth()->format('Y-m-d'), 'date_to' => now()->endOfMonth()->format('Y-m-d')]) }}"
                       class="w-full inline-flex items-center justify-center px-3 py-2 bg-indigo-600 text-white text-sm font-medium rounded-md hover:bg-indigo-700 shadow-sm transition-colors h-[38px]">
                        <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                        </svg>
                        This Month
                    </a>
                </div>

                <!-- Date From -->
                <div>
                    <label for="date_from" class="block text-sm font-medium text-gray-700 mb-1">
                        Date From
                    </label>
                    <input type="date"
                           name="date_from"
                           id="date_from"
                           value="{{ $dateFrom }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 text-sm">
                </div>

                <!-- Date To -->
                <div>
                    <label for="date_to" class="block text-sm font-medium text-gray-700 mb-1">
                        Date To
                    </label>
                    <input type="date"
                           name="date_to"
                           id="date_to"
                           value="{{ $dateTo }}"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 text-sm">
                </div>

                <!-- Staff Filter -->
                <div>
                    <label for="staff_id" class="block text-sm font-medium text-gray-700 mb-1">
                        Filter by Staff
                    </label>
                    <select name="staff_id"
                            id="staff_id"
                            class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 text-sm">
                        <option value="">All Staff</option>
                        @foreach($allStaff as $staff)
                            <option value="{{ $staff->staff_id }}" {{ $staffFilter == $staff->staff_id ? 'selected' : '' }}>
                                {{ $staff->staff_name }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="flex items-center gap-2">
                <button type="submit"
                        class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 shadow-sm">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                    </svg>
                    Generate Report
                </button>

                @if($staffFilter || $dateFrom != now()->subDays(30)->format('Y-m-d') || $dateTo != now()->format('Y-m-d'))
                    <a href="{{ route('performance') }}"
                       class="inline-flex items-center px-4 py-2 bg-gray-200 text-gray-700 text-sm font-medium rounded-md hover:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-500">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                        Reset
                    </a>
                @endif

                <div class="ml-auto text-sm text-gray-600">
                    <span class="font-medium">Period:</span>
                    {{ \Carbon\Carbon::parse($dateFrom)->format('d M Y') }} - {{ \Carbon\Carbon::parse($dateTo)->format('d M Y') }}
                    ({{ \Carbon\Carbon::parse($dateFrom)->diffInDays(\Carbon\Carbon::parse($dateTo)) + 1 }} days)
                </div>
            </div>
        </form>
    </div>

    <!-- Performance Summary Cards -->
    @if(count($staffPerformance) > 0)
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
            <!-- Total Packed -->
            <div class="bg-gradient-to-br from-blue-50 to-blue-100 rounded-lg shadow p-6 border-l-4 border-blue-500">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <svg class="h-12 w-12 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"/>
                        </svg>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-700 truncate">Total Orders Packed</dt>
                            <dd class="text-3xl font-bold text-blue-700">
                                {{ number_format($staffPerformance->sum('total_packed')) }}
                            </dd>
                        </dl>
                    </div>
                </div>
            </div>

            <!-- Total Completed -->
            <div class="bg-gradient-to-br from-green-50 to-green-100 rounded-lg shadow p-6 border-l-4 border-green-500">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <svg class="h-12 w-12 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-700 truncate">Total Orders Completed</dt>
                            <dd class="text-3xl font-bold text-green-700">
                                {{ number_format($staffPerformance->sum('total_completed')) }}
                            </dd>
                        </dl>
                    </div>
                </div>
            </div>

            <!-- Active Staff -->
            <div class="bg-gradient-to-br from-purple-50 to-purple-100 rounded-lg shadow p-6 border-l-4 border-purple-500">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <svg class="h-12 w-12 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                        </svg>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-700 truncate">Active Staff Members</dt>
                            <dd class="text-3xl font-bold text-purple-700">
                                {{ count($staffPerformance) }}
                            </dd>
                        </dl>
                    </div>
                </div>
            </div>
        </div>

        <!-- Staff Performance Table -->
        <div class="bg-white shadow overflow-hidden sm:rounded-lg">
            <div class="px-4 py-5 sm:px-6 bg-gray-50 border-b border-gray-200">
                <h3 class="text-lg leading-6 font-medium text-gray-900">Individual Staff Performance</h3>
                <p class="mt-1 text-sm text-gray-500">Detailed breakdown of each staff member's productivity</p>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-300">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col" class="py-3.5 pl-4 pr-3 text-left text-sm font-semibold text-gray-900 sm:pl-6">Rank</th>
                            <th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-900">Staff Name</th>
                            <th scope="col" class="px-3 py-3.5 text-center text-sm font-semibold text-gray-900">Orders Packed</th>
                            <th scope="col" class="px-3 py-3.5 text-center text-sm font-semibold text-gray-900">Orders Completed</th>
                            <th scope="col" class="px-3 py-3.5 text-center text-sm font-semibold text-gray-900">Total Orders</th>
                            <th scope="col" class="px-3 py-3.5 text-center text-sm font-semibold text-gray-900">Daily Average</th>
                            <th scope="col" class="px-3 py-3.5 text-center text-sm font-semibold text-gray-900">Performance</th>
                            <th scope="col" class="px-3 py-3.5 text-center text-sm font-semibold text-gray-900">Report</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200 bg-white">
                        @foreach($staffPerformance as $index => $staff)
                            @php
                                $totalOrders = $staff['total_packed'] + $staff['total_completed'];
                                $dayCount = \Carbon\Carbon::parse($dateFrom)->diffInDays(\Carbon\Carbon::parse($dateTo)) + 1;
                                $dailyAverage = round($totalOrders / $dayCount, 1);

                                // Performance rating
                                if ($dailyAverage >= 50) {
                                    $performanceClass = 'bg-green-100 text-green-800';
                                    $performanceLabel = 'Excellent';
                                } elseif ($dailyAverage >= 30) {
                                    $performanceClass = 'bg-blue-100 text-blue-800';
                                    $performanceLabel = 'Good';
                                } elseif ($dailyAverage >= 15) {
                                    $performanceClass = 'bg-yellow-100 text-yellow-800';
                                    $performanceLabel = 'Average';
                                } else {
                                    $performanceClass = 'bg-gray-100 text-gray-800';
                                    $performanceLabel = 'Below Average';
                                }
                            @endphp
                            <tr class="hover:bg-gray-50">
                                <!-- Rank -->
                                <td class="whitespace-nowrap py-4 pl-4 pr-3 text-sm font-medium text-gray-900 sm:pl-6">
                                    @if($index == 0)
                                        <span class="inline-flex items-center justify-center w-8 h-8 rounded-full bg-yellow-400 text-yellow-900 font-bold">
                                            🏆
                                        </span>
                                    @elseif($index == 1)
                                        <span class="inline-flex items-center justify-center w-8 h-8 rounded-full bg-gray-300 text-gray-700 font-bold">
                                            🥈
                                        </span>
                                    @elseif($index == 2)
                                        <span class="inline-flex items-center justify-center w-8 h-8 rounded-full bg-orange-300 text-orange-900 font-bold">
                                            🥉
                                        </span>
                                    @else
                                        <span class="inline-flex items-center justify-center w-8 h-8 rounded-full bg-gray-100 text-gray-600 font-semibold">
                                            {{ $index + 1 }}
                                        </span>
                                    @endif
                                </td>

                                <!-- Staff Name -->
                                <td class="px-3 py-4 text-sm">
                                    <div class="font-medium text-gray-900">{{ $staff['staff_name'] }}</div>
                                    <div class="text-xs text-gray-500">ID: {{ $staff['staff_id'] }}</div>
                                </td>

                                <!-- Orders Packed -->
                                <td class="px-3 py-4 text-sm text-center">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                        {{ number_format($staff['total_packed']) }}
                                    </span>
                                </td>

                                <!-- Orders Completed -->
                                <td class="px-3 py-4 text-sm text-center">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                        {{ number_format($staff['total_completed']) }}
                                    </span>
                                </td>

                                <!-- Total Orders -->
                                <td class="px-3 py-4 text-sm text-center">
                                    <span class="font-bold text-gray-900">{{ number_format($totalOrders) }}</span>
                                </td>

                                <!-- Daily Average -->
                                <td class="px-3 py-4 text-sm text-center">
                                    <span class="font-medium text-gray-700">{{ $dailyAverage }}</span>
                                    <span class="text-xs text-gray-500">/day</span>
                                </td>

                                <!-- Performance -->
                                <td class="px-3 py-4 text-sm text-center">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $performanceClass }}">
                                        {{ $performanceLabel }}
                                    </span>
                                </td>

                                <!-- Print Report -->
                                <td class="px-3 py-4 text-sm text-center">
                                    <a href="{{ route('performance.print', ['staffId' => $staff['staff_id'], 'date_from' => $dateFrom, 'date_to' => $dateTo]) }}"
                                       target="_blank"
                                       class="inline-flex items-center gap-1.5 px-3 py-1.5 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 shadow-sm hover:shadow-md transition-all text-xs font-medium"
                                       title="Print performance report for {{ $staff['staff_name'] }}">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"/>
                                        </svg>
                                        Print
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

    @else
        <!-- No Data -->
        <div class="bg-white shadow sm:rounded-lg">
            <div class="px-4 py-12 text-center">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900">No performance data</h3>
                <p class="mt-1 text-sm text-gray-500">No staff activity found for the selected period.</p>
            </div>
        </div>
    @endif
</div>
@endsection
