<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'OmniaBoss Production')</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
</head>
<body class="bg-gray-100">
    <nav class="bg-white shadow-lg">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex">
                    <div class="flex-shrink-0 flex items-center">
                        <h1 class="text-xl font-bold text-gray-800">OmniaBoss Production</h1>
                    </div>
                    <div class="hidden sm:ml-6 sm:flex sm:space-x-8">
                        @php
                            $userRoles = $user['roles'] ?? [];
                            $isManagerOrAdmin = in_array('admin', $userRoles) || in_array('production-manager', $userRoles);
                        @endphp

                        <!-- Dashboard with Dropdown -->
                        <div class="relative" x-data="{ open: false }" @click.away="open = false">
                            <div class="{{ request()->routeIs('dashboard') || request()->routeIs('performance*') ? 'border-indigo-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300' }} inline-flex items-center border-b-2 h-16">
                                <a href="{{ route('dashboard') }}" class="inline-flex items-center px-1 text-sm font-medium">
                                    Dashboard
                                </a>
                                <button @click="open = !open" class="inline-flex items-center pl-1 pr-1">
                                    <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                    </svg>
                                </button>
                            </div>
                            <div x-show="open" x-transition class="absolute left-0 top-full mt-2 w-48 rounded-md shadow-lg bg-white ring-1 ring-black ring-opacity-5 z-50">
                                <div class="py-1">
                                    <a href="{{ route('dashboard') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Orders</a>
                                    @if($isManagerOrAdmin)
                                        <a href="{{ route('performance') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Staff KPI</a>
                                    @endif
                                </div>
                            </div>
                        </div>

                        @if($isManagerOrAdmin)
                            <!-- Inventory with Dropdown -->
                            <div class="relative" x-data="{ open: false }" @click.away="open = false">
                                <div class="{{ request()->routeIs('inventory*') || request()->routeIs('purchase-orders*') || request()->routeIs('suppliers*') ? 'border-indigo-500 text-gray-900' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300' }} inline-flex items-center border-b-2 h-16">
                                    <a href="{{ route('inventory.index') }}" class="inline-flex items-center px-1 text-sm font-medium">
                                        Inventory
                                    </a>
                                    <button @click="open = !open" class="inline-flex items-center pl-1 pr-1">
                                        <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                        </svg>
                                    </button>
                                </div>
                                <div x-show="open" x-transition class="absolute left-0 top-full mt-2 w-56 rounded-md shadow-lg bg-white ring-1 ring-black ring-opacity-5 z-50">
                                    <div class="py-1">
                                        <a href="{{ route('inventory.index') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Items</a>
                                        <a href="{{ route('purchase-orders.index') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Purchasing</a>
                                        <a href="{{ route('suppliers.index') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Suppliers</a>
                                        <div class="border-t border-gray-100"></div>
                                        <span class="block px-4 py-2 text-sm text-gray-400 cursor-not-allowed">Warehouse <span class="text-xs">(Soon)</span></span>
                                        <span class="block px-4 py-2 text-sm text-gray-400 cursor-not-allowed">Lost & Adjustment <span class="text-xs">(Soon)</span></span>
                                        <a href="{{ route('inventory.movements') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Inventory History</a>
                                        <span class="block px-4 py-2 text-sm text-gray-400 cursor-not-allowed">Report <span class="text-xs">(Soon)</span></span>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
                <div class="flex items-center">
                    <div class="relative">
                        <button onclick="toggleDropdown()" class="flex items-center text-gray-700 hover:text-gray-900 focus:outline-none">
                            <span class="text-sm font-medium">{{ $user['name'] ?? 'User' }}</span>
                            <svg class="ml-2 h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </button>

                        <div id="userDropdown" class="hidden absolute right-0 mt-2 w-56 rounded-md shadow-lg bg-white ring-1 ring-black ring-opacity-5 z-50">
                            <div class="py-1">
                                <!-- User Info -->
                                <div class="px-4 py-3 border-b border-gray-200">
                                    <p class="text-sm font-medium text-gray-900">{{ $user['name'] ?? 'User' }}</p>
                                    <p class="text-xs text-gray-500 truncate">{{ $user['email'] ?? '' }}</p>
                                </div>

                                @php
                                    $userRoles = $user['roles'] ?? [];
                                    $hasModuleAccess = !empty(array_intersect($userRoles, ['admin', 'production-manager']));
                                @endphp

                                @if($hasModuleAccess)
                                    <!-- Module Navigation (Admin/Manager) -->
                                    <div class="border-t border-gray-100"></div>
                                    <div class="px-4 py-2">
                                        <div class="text-xs font-semibold text-gray-400 uppercase tracking-wider">Modules</div>
                                    </div>

                                    <a href="http://127.0.0.1:8001/sso/redirect?user_id={{ $user['user_id'] }}&target_url={{ urlencode('http://omnia.test/dashboard') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                        <div class="flex items-center">
                                            <svg class="mr-3 h-5 w-5 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                                            </svg>
                                            Marketing
                                        </div>
                                    </a>

                                    <a href="http://127.0.0.1:8001/sso/redirect?user_id={{ $user['user_id'] }}&target_url={{ urlencode('http://127.0.0.1:8003/dashboard') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                        <div class="flex items-center">
                                            <svg class="mr-3 h-5 w-5 text-orange-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4"></path>
                                            </svg>
                                            Kitchen
                                        </div>
                                    </a>

                                    <div class="block px-4 py-2 text-sm text-gray-400 cursor-not-allowed">
                                        <div class="flex items-center justify-between">
                                            <div class="flex items-center">
                                                <svg class="mr-3 h-5 w-5 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                                </svg>
                                                Finance
                                            </div>
                                            <span class="text-xs bg-gray-100 text-gray-500 px-2 py-1 rounded">Soon</span>
                                        </div>
                                    </div>

                                    <div class="block px-4 py-2 text-sm text-gray-400 cursor-not-allowed">
                                        <div class="flex items-center justify-between">
                                            <div class="flex items-center">
                                                <svg class="mr-3 h-5 w-5 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                                </svg>
                                                HR
                                            </div>
                                            <span class="text-xs bg-gray-100 text-gray-500 px-2 py-1 rounded">Soon</span>
                                        </div>
                                    </div>
                                @endif

                                <!-- Logout -->
                                <div class="border-t border-gray-100"></div>
                                <a href="{{ env('AUTH_SERVICE_URL') }}/logout" class="block px-4 py-2 text-sm text-red-600 hover:bg-red-50">
                                    Logout
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </nav>

    <main class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        @if(session('success'))
            <div class="mb-4 bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative" role="alert">
                <span class="block sm:inline">{{ session('success') }}</span>
            </div>
        @endif

        @if(session('error'))
            <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
                <span class="block sm:inline">{{ session('error') }}</span>
            </div>
        @endif

        @yield('content')
    </main>

    <script>
        function toggleDropdown() {
            const dropdown = document.getElementById('userDropdown');
            dropdown.classList.toggle('hidden');
        }

        // Close dropdown when clicking outside
        document.addEventListener('click', function(event) {
            const dropdown = document.getElementById('userDropdown');
            const button = event.target.closest('button[onclick="toggleDropdown()"]');

            if (!button && !dropdown.contains(event.target)) {
                dropdown.classList.add('hidden');
            }
        });
    </script>
</body>
</html>
