<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventory', function (Blueprint $table) {
            $table->id();
            $table->string('sku')->unique();
            $table->string('product_name');
            $table->integer('quantity')->default(0);
            $table->string('location')->nullable();
            $table->integer('reorder_point')->default(10);
            $table->decimal('average_cost', 10, 2)->nullable();
            $table->timestamp('last_restocked_at')->nullable();
            $table->timestamps();

            $table->index('sku');
            $table->index(['quantity', 'reorder_point']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventory');
    }
};
