<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SupplierController extends Controller
{
    public function index()
    {
        $user = request()->input('omnia_user');

        $suppliers = DB::table('suppliers')
            ->orderBy('is_active', 'desc')
            ->orderBy('name')
            ->paginate(20);

        return view('suppliers.index', compact('suppliers', 'user'));
    }

    public function create()
    {
        $user = request()->input('omnia_user');
        return view('suppliers.create', compact('user'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'contact_person' => 'nullable|string|max:255',
            'email' => 'nullable|email|max:255',
            'phone' => 'nullable|string|max:255',
            'address' => 'nullable|string',
            'notes' => 'nullable|string',
        ]);

        DB::table('suppliers')->insert([
            'name' => $request->name,
            'contact_person' => $request->contact_person,
            'email' => $request->email,
            'phone' => $request->phone,
            'address' => $request->address,
            'is_active' => true,
            'notes' => $request->notes,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        return redirect()->route('suppliers.index')->with('success', 'Supplier created successfully');
    }

    public function edit($id)
    {
        $user = request()->input('omnia_user');
        $supplier = DB::table('suppliers')->where('id', $id)->first();

        if (!$supplier) {
            abort(404, 'Supplier not found');
        }

        return view('suppliers.edit', compact('supplier', 'user'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'contact_person' => 'nullable|string|max:255',
            'email' => 'nullable|email|max:255',
            'phone' => 'nullable|string|max:255',
            'address' => 'nullable|string',
            'is_active' => 'required|boolean',
            'notes' => 'nullable|string',
        ]);

        DB::table('suppliers')
            ->where('id', $id)
            ->update([
                'name' => $request->name,
                'contact_person' => $request->contact_person,
                'email' => $request->email,
                'phone' => $request->phone,
                'address' => $request->address,
                'is_active' => $request->is_active,
                'notes' => $request->notes,
                'updated_at' => now(),
            ]);

        return redirect()->route('suppliers.index')->with('success', 'Supplier updated successfully');
    }

    public function destroy($id)
    {
        DB::table('suppliers')->where('id', $id)->delete();
        return redirect()->route('suppliers.index')->with('success', 'Supplier deleted successfully');
    }
}
