<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;

// Redirect root to login
Route::get('/', function () {
    return redirect('/login');
});

// Show login page
Route::get('/login', function () {
    return view('login');
})->name('login');

// Handle login form submission (web)
Route::post('/auth/login', [AuthController::class, 'loginWeb'])->name('auth.login');

// Logout (web)
Route::post('/auth/logout', [AuthController::class, 'logoutWeb'])->name('auth.logout');

// SSO Redirect (for cross-module navigation)
Route::get('/sso/redirect', [AuthController::class, 'ssoRedirect'])->name('sso.redirect');

// Test route
Route::get('/test-web', function () {
    return response()->json(['message' => 'Web route works!']);
});
