# SSO Session Cleanup Pattern - TODO

## Overview
Currently, only the **Production** module implements proper session cleanup. Other modules (Marketing, Kitchen, Finance, HR) should implement the same pattern for better security and UX.

## Current Implementation Status

### ✅ Production Module (IMPLEMENTED)
- **Location**: `services/production/app/Http/Middleware/OmniaSSOAuth.php` (lines 48-61)
- **Behavior**:
  1. Receives URL with `?omnia_session=xxx`
  2. Stores session as HTTP-only cookie
  3. Redirects to clean URL (removes query parameter)
  4. Subsequent requests use cookie instead of query parameter

### ❌ Marketing Module (NOT IMPLEMENTED)
- Currently shows `?omnia_session=xxx` in URL after SSO redirect
- Should implement same cleanup pattern

### ❌ Kitchen Module (NOT IMPLEMENTED)
- Currently shows `?omnia_session=xxx` in URL after SSO redirect
- Should implement same cleanup pattern

### ❌ Finance Module (PLACEHOLDER)
- Will need this implementation when built

### ❌ HR Module (PLACEHOLDER)
- Will need this implementation when built

## Implementation Pattern

### Code Reference (from Production)
```php
// In SSO Middleware - after session validation
if ($request->query('omnia_session')) {
    return redirect($request->url())->cookie(
        'omnia_session',
        $sessionId,
        1440, // 24 hours
        '/',
        null, // Current domain only
        false, // secure (set true for HTTPS)
        true,  // httpOnly
        false, // raw
        'lax'  // sameSite
    );
}
```

## Benefits of Session Cleanup

1. **Security**: Session tokens not exposed in browser history
2. **UX**: Cleaner URLs without visible session parameters
3. **Consistency**: All modules behave the same way
4. **Best Practice**: Sensitive data shouldn't be in URLs

## Implementation Steps (for each module)

1. Create/update SSO middleware similar to Production's `OmniaSSOAuth`
2. Add session cleanup logic after successful session validation
3. Set HTTP-only, SameSite=Lax cookie
4. Redirect to clean URL
5. Test cross-module navigation

## Priority
- **Low**: System works fine without this
- **Nice to have**: Improves security and UX
- **Recommended**: Implement when doing security audit or UX improvements

## Related Files
- Auth Service: `services/auth/app/Http/Controllers/Api/AuthController.php` (SSO redirect endpoint)
- Production: `services/production/app/Http/Middleware/OmniaSSOAuth.php`
- Marketing: Would need similar middleware
- Kitchen: Would need similar middleware

---
**Note**: Created on 2025-11-25 for future implementation reference
