<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Testing;

class TrafficRule extends \Google\Model
{
  /**
   * Bandwidth in kbits/second.
   *
   * @var float
   */
  public $bandwidth;
  /**
   * Burst size in kbits.
   *
   * @var float
   */
  public $burst;
  /**
   * Packet delay, must be >= 0.
   *
   * @var string
   */
  public $delay;
  /**
   * Packet duplication ratio (0.0 - 1.0).
   *
   * @var float
   */
  public $packetDuplicationRatio;
  /**
   * Packet loss ratio (0.0 - 1.0).
   *
   * @var float
   */
  public $packetLossRatio;

  /**
   * Bandwidth in kbits/second.
   *
   * @param float $bandwidth
   */
  public function setBandwidth($bandwidth)
  {
    $this->bandwidth = $bandwidth;
  }
  /**
   * @return float
   */
  public function getBandwidth()
  {
    return $this->bandwidth;
  }
  /**
   * Burst size in kbits.
   *
   * @param float $burst
   */
  public function setBurst($burst)
  {
    $this->burst = $burst;
  }
  /**
   * @return float
   */
  public function getBurst()
  {
    return $this->burst;
  }
  /**
   * Packet delay, must be >= 0.
   *
   * @param string $delay
   */
  public function setDelay($delay)
  {
    $this->delay = $delay;
  }
  /**
   * @return string
   */
  public function getDelay()
  {
    return $this->delay;
  }
  /**
   * Packet duplication ratio (0.0 - 1.0).
   *
   * @param float $packetDuplicationRatio
   */
  public function setPacketDuplicationRatio($packetDuplicationRatio)
  {
    $this->packetDuplicationRatio = $packetDuplicationRatio;
  }
  /**
   * @return float
   */
  public function getPacketDuplicationRatio()
  {
    return $this->packetDuplicationRatio;
  }
  /**
   * Packet loss ratio (0.0 - 1.0).
   *
   * @param float $packetLossRatio
   */
  public function setPacketLossRatio($packetLossRatio)
  {
    $this->packetLossRatio = $packetLossRatio;
  }
  /**
   * @return float
   */
  public function getPacketLossRatio()
  {
    return $this->packetLossRatio;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(TrafficRule::class, 'Google_Service_Testing_TrafficRule');
