<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SQLAdmin;

class SqlOutOfDiskReport extends \Google\Model
{
  /**
   * Unspecified state
   */
  public const SQL_OUT_OF_DISK_STATE_SQL_OUT_OF_DISK_STATE_UNSPECIFIED = 'SQL_OUT_OF_DISK_STATE_UNSPECIFIED';
  /**
   * The instance has plenty space on data disk
   */
  public const SQL_OUT_OF_DISK_STATE_NORMAL = 'NORMAL';
  /**
   * Data disk is almost used up. It is shutdown to prevent data corruption.
   */
  public const SQL_OUT_OF_DISK_STATE_SOFT_SHUTDOWN = 'SOFT_SHUTDOWN';
  /**
   * The minimum recommended increase size in GigaBytes This field is consumed
   * by the frontend * Writers: * the proactive database wellness job for OOD. *
   * Readers:
   *
   * @var int
   */
  public $sqlMinRecommendedIncreaseSizeGb;
  /**
   * This field represents the state generated by the proactive database
   * wellness job for OutOfDisk issues. * Writers: * the proactive database
   * wellness job for OOD. * Readers: * the proactive database wellness job
   *
   * @var string
   */
  public $sqlOutOfDiskState;

  /**
   * The minimum recommended increase size in GigaBytes This field is consumed
   * by the frontend * Writers: * the proactive database wellness job for OOD. *
   * Readers:
   *
   * @param int $sqlMinRecommendedIncreaseSizeGb
   */
  public function setSqlMinRecommendedIncreaseSizeGb($sqlMinRecommendedIncreaseSizeGb)
  {
    $this->sqlMinRecommendedIncreaseSizeGb = $sqlMinRecommendedIncreaseSizeGb;
  }
  /**
   * @return int
   */
  public function getSqlMinRecommendedIncreaseSizeGb()
  {
    return $this->sqlMinRecommendedIncreaseSizeGb;
  }
  /**
   * This field represents the state generated by the proactive database
   * wellness job for OutOfDisk issues. * Writers: * the proactive database
   * wellness job for OOD. * Readers: * the proactive database wellness job
   *
   * Accepted values: SQL_OUT_OF_DISK_STATE_UNSPECIFIED, NORMAL, SOFT_SHUTDOWN
   *
   * @param self::SQL_OUT_OF_DISK_STATE_* $sqlOutOfDiskState
   */
  public function setSqlOutOfDiskState($sqlOutOfDiskState)
  {
    $this->sqlOutOfDiskState = $sqlOutOfDiskState;
  }
  /**
   * @return self::SQL_OUT_OF_DISK_STATE_*
   */
  public function getSqlOutOfDiskState()
  {
    return $this->sqlOutOfDiskState;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SqlOutOfDiskReport::class, 'Google_Service_SQLAdmin_SqlOutOfDiskReport');
