<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\OrgPolicyAPI;

class GoogleCloudOrgpolicyV2ListConstraintsResponse extends \Google\Collection
{
  protected $collection_key = 'constraints';
  protected $constraintsType = GoogleCloudOrgpolicyV2Constraint::class;
  protected $constraintsDataType = 'array';
  /**
   * Page token used to retrieve the next page. This is currently not used.
   *
   * @var string
   */
  public $nextPageToken;

  /**
   * The collection of constraints that are available on the targeted resource.
   *
   * @param GoogleCloudOrgpolicyV2Constraint[] $constraints
   */
  public function setConstraints($constraints)
  {
    $this->constraints = $constraints;
  }
  /**
   * @return GoogleCloudOrgpolicyV2Constraint[]
   */
  public function getConstraints()
  {
    return $this->constraints;
  }
  /**
   * Page token used to retrieve the next page. This is currently not used.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudOrgpolicyV2ListConstraintsResponse::class, 'Google_Service_OrgPolicyAPI_GoogleCloudOrgpolicyV2ListConstraintsResponse');
