<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Integrations;

class GoogleCloudIntegrationsV1alphaCreateCloudFunctionRequest extends \Google\Model
{
  /**
   * Unspecified.
   */
  public const GCF_API_VERSION_GCF_API_VERSION_UNSPECIFIED = 'GCF_API_VERSION_UNSPECIFIED';
  /**
   * V1 API version.
   */
  public const GCF_API_VERSION_API_VERSION_V1 = 'API_VERSION_V1';
  /**
   * V2 API version.
   */
  public const GCF_API_VERSION_API_VERSION_V2 = 'API_VERSION_V2';
  /**
   * The function name of CF to be created
   *
   * @var string
   */
  public $functionName;
  /**
   * The function region of CF to be created
   *
   * @var string
   */
  public $functionRegion;
  /**
   * Optional. The api version of CF to be created
   *
   * @var string
   */
  public $gcfApiVersion;
  /**
   * Indicates the id of the GCP project that the function will be created in.
   *
   * @var string
   */
  public $projectId;

  /**
   * The function name of CF to be created
   *
   * @param string $functionName
   */
  public function setFunctionName($functionName)
  {
    $this->functionName = $functionName;
  }
  /**
   * @return string
   */
  public function getFunctionName()
  {
    return $this->functionName;
  }
  /**
   * The function region of CF to be created
   *
   * @param string $functionRegion
   */
  public function setFunctionRegion($functionRegion)
  {
    $this->functionRegion = $functionRegion;
  }
  /**
   * @return string
   */
  public function getFunctionRegion()
  {
    return $this->functionRegion;
  }
  /**
   * Optional. The api version of CF to be created
   *
   * Accepted values: GCF_API_VERSION_UNSPECIFIED, API_VERSION_V1,
   * API_VERSION_V2
   *
   * @param self::GCF_API_VERSION_* $gcfApiVersion
   */
  public function setGcfApiVersion($gcfApiVersion)
  {
    $this->gcfApiVersion = $gcfApiVersion;
  }
  /**
   * @return self::GCF_API_VERSION_*
   */
  public function getGcfApiVersion()
  {
    return $this->gcfApiVersion;
  }
  /**
   * Indicates the id of the GCP project that the function will be created in.
   *
   * @param string $projectId
   */
  public function setProjectId($projectId)
  {
    $this->projectId = $projectId;
  }
  /**
   * @return string
   */
  public function getProjectId()
  {
    return $this->projectId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudIntegrationsV1alphaCreateCloudFunctionRequest::class, 'Google_Service_Integrations_GoogleCloudIntegrationsV1alphaCreateCloudFunctionRequest');
