<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Firebaseappcheck;

class GoogleFirebaseAppcheckV1AppAttestConfig extends \Google\Model
{
  /**
   * Required. The relative resource name of the App Attest configuration
   * object, in the format: ```
   * projects/{project_number}/apps/{app_id}/appAttestConfig ```
   *
   * @var string
   */
  public $name;
  /**
   * Specifies the duration for which App Check tokens exchanged from App Attest
   * artifacts will be valid. If unset, a default value of 1 hour is assumed.
   * Must be between 30 minutes and 7 days, inclusive.
   *
   * @var string
   */
  public $tokenTtl;

  /**
   * Required. The relative resource name of the App Attest configuration
   * object, in the format: ```
   * projects/{project_number}/apps/{app_id}/appAttestConfig ```
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Specifies the duration for which App Check tokens exchanged from App Attest
   * artifacts will be valid. If unset, a default value of 1 hour is assumed.
   * Must be between 30 minutes and 7 days, inclusive.
   *
   * @param string $tokenTtl
   */
  public function setTokenTtl($tokenTtl)
  {
    $this->tokenTtl = $tokenTtl;
  }
  /**
   * @return string
   */
  public function getTokenTtl()
  {
    return $this->tokenTtl;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleFirebaseAppcheckV1AppAttestConfig::class, 'Google_Service_Firebaseappcheck_GoogleFirebaseAppcheckV1AppAttestConfig');
