<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DLP;

class GooglePrivacyDlpV2CategoricalStatsConfig extends \Google\Model
{
  protected $fieldType = GooglePrivacyDlpV2FieldId::class;
  protected $fieldDataType = '';

  /**
   * Field to compute categorical stats on. All column types are supported
   * except for arrays and structs. However, it may be more informative to use
   * NumericalStats when the field type is supported, depending on the data.
   *
   * @param GooglePrivacyDlpV2FieldId $field
   */
  public function setField(GooglePrivacyDlpV2FieldId $field)
  {
    $this->field = $field;
  }
  /**
   * @return GooglePrivacyDlpV2FieldId
   */
  public function getField()
  {
    return $this->field;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GooglePrivacyDlpV2CategoricalStatsConfig::class, 'Google_Service_DLP_GooglePrivacyDlpV2CategoricalStatsConfig');
