<?php $__env->startSection('title', 'Order #' . $order->order_number); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6 flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold">Order #<?php echo e($order->order_number); ?></h1>
            <p class="text-gray-600 dark:text-gray-400">
                <?php if($order->store): ?>
                    Store: <?php echo e($order->store->name); ?> (WooCommerce)
                <?php elseif($order->webhookSource): ?>
                    Source: <?php echo e($order->webhookSource->name); ?> (<?php echo e(ucfirst($order->webhookSource->type)); ?> Webhook)
                <?php else: ?>
                    Source: Unknown
                <?php endif; ?>
            </p>
        </div>
        <div class="flex space-x-2">
            <a href="<?php echo e(route('invoices.show', $order)); ?>"
               class="px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700 inline-flex items-center">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                </svg>
                View Invoice
            </a>
            <a href="<?php echo e(route('invoices.download', $order)); ?>"
               class="px-4 py-2 bg-purple-600 text-white rounded-md hover:bg-purple-700 inline-flex items-center">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                </svg>
                Download PDF
            </a>
            <a href="<?php echo e(route('orders.edit', $order)); ?>"
               class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700">
                Edit Order
            </a>
            <a href="<?php echo e(route('orders.index')); ?>"
               class="px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md hover:bg-gray-50 dark:hover:bg-gray-700">
                Back to Orders
            </a>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Order Details -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Order Status -->
            <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
                <h3 class="text-lg font-semibold mb-4">Order Information</h3>
                <dl class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div>
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Status</dt>
                        <dd class="mt-1">
                            <?php
                                $statusColors = [
                                    'processing' => 'yellow',
                                    'completed' => 'green',
                                    'pending' => 'gray',
                                    'on-hold' => 'orange',
                                    'cancelled' => 'red',
                                    'refunded' => 'purple',
                                    'failed' => 'red'
                                ];
                                $color = $statusColors[$order->status] ?? 'gray';
                            ?>
                            <span class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full 
                                bg-<?php echo e($color); ?>-100 text-<?php echo e($color); ?>-800
                                dark:bg-<?php echo e($color); ?>-900 dark:text-<?php echo e($color); ?>-200">
                                <?php echo e(ucfirst($order->status)); ?>

                            </span>
                        </dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Payment Method</dt>
                        <dd class="mt-1 text-sm"><?php echo e($order->payment_method_title); ?></dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Order Date</dt>
                        <dd class="mt-1 text-sm"><?php echo e($order->date_created ? $order->date_created->format('M d, Y H:i') : 'N/A'); ?></dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Modified Date</dt>
                        <dd class="mt-1 text-sm"><?php echo e($order->date_modified ? $order->date_modified->format('M d, Y H:i') : 'N/A'); ?></dd>
                    </div>
                </dl>
            </div>

            <!-- Order Items -->
            <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
                <h3 class="text-lg font-semibold mb-4">Order Items</h3>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                        <thead>
                            <tr>
                                <th class="px-4 py-2 text-left text-xs font-medium uppercase">Item</th>
                                <th class="px-4 py-2 text-left text-xs font-medium uppercase">Price</th>
                                <th class="px-4 py-2 text-left text-xs font-medium uppercase">Qty</th>
                                <th class="px-4 py-2 text-right text-xs font-medium uppercase">Total</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                            <?php if(is_array($order->line_items)): ?>
                                <?php $__currentLoopData = $order->getExpandedLineItems(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expandedItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $item = $expandedItem['item'];
                                    $isBundle = $expandedItem['is_bundle'];
                                    $bundleDetails = $expandedItem['bundle_details'];
                                ?>
                                <tr class="<?php echo e($isBundle ? 'bg-purple-50 dark:bg-purple-900/10' : ''); ?>">
                                    <td class="px-4 py-3">
                                        <div class="text-sm font-medium flex items-center gap-2">
                                            <?php echo e($item['name'] ?? 'N/A'); ?>

                                            <?php if($isBundle): ?>
                                                <span class="px-2 py-0.5 text-xs font-medium rounded bg-purple-100 text-purple-800 dark:bg-purple-900 dark:text-purple-200">
                                                    BUNDLE
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                        <?php if(isset($item['sku'])): ?>
                                            <div class="text-xs text-gray-500 dark:text-gray-400">SKU: <?php echo e($item['sku']); ?></div>
                                        <?php endif; ?>

                                        <?php if($isBundle && $bundleDetails): ?>
                                            <div class="mt-2 ml-4 text-sm space-y-1">
                                                <?php $__currentLoopData = $bundleDetails['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bundleItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="text-gray-600 dark:text-gray-400">
                                                        - <?php echo e($bundleItem['name'] ?? $bundleItem['sku']); ?> x<?php echo e($bundleItem['quantity']); ?>

                                                        <?php if(isset($bundleItem['sku']) && $bundleItem['sku']): ?>
                                                            <span class="text-gray-500">(<?php echo e($bundleItem['sku']); ?>)</span>
                                                        <?php endif; ?>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-4 py-3 text-sm">
                                        <?php echo e($order->formatCurrency($item['price'] ?? 0)); ?>

                                    </td>
                                    <td class="px-4 py-3 text-sm">
                                        <?php echo e($item['quantity'] ?? 0); ?>

                                    </td>
                                    <td class="px-4 py-3 text-sm text-right font-medium">
                                        <?php echo e($order->formatCurrency($item['total'] ?? 0)); ?>

                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </tbody>
                        <tfoot class="border-t-2 border-gray-300 dark:border-gray-600">
                            <tr class="border-b border-gray-200 dark:border-gray-700">
                                <td colspan="3" class="px-4 py-2 text-right text-sm text-gray-600 dark:text-gray-400">Subtotal:</td>
                                <td class="px-4 py-2 text-right text-sm font-medium">
                                    <?php echo e($order->formatCurrency($order->calculated_subtotal)); ?>

                                </td>
                            </tr>
                            <?php if($order->shipping_total > 0): ?>
                            <tr class="border-b border-gray-200 dark:border-gray-700">
                                <td colspan="3" class="px-4 py-2 text-right text-sm text-gray-600 dark:text-gray-400">
                                    Shipping<?php echo e($order->shipping_method_title ? ' (' . $order->shipping_method_title . ')' : ''); ?>:
                                </td>
                                <td class="px-4 py-2 text-right text-sm font-medium">
                                    <?php echo e($order->formatCurrency($order->shipping_total)); ?>

                                </td>
                            </tr>
                            <?php endif; ?>
                            <?php if($order->calculated_fee > 0): ?>
                            <tr class="border-b border-gray-200 dark:border-gray-700">
                                <td colspan="3" class="px-4 py-2 text-right text-sm text-gray-600 dark:text-gray-400">Processing Fee:</td>
                                <td class="px-4 py-2 text-right text-sm font-medium">
                                    <?php echo e($order->formatCurrency($order->calculated_fee)); ?>

                                </td>
                            </tr>
                            <?php endif; ?>
                            <?php if($order->discount_total > 0): ?>
                            <tr class="border-b border-gray-200 dark:border-gray-700">
                                <td colspan="3" class="px-4 py-2 text-right text-sm text-red-600 dark:text-red-400">Discount:</td>
                                <td class="px-4 py-2 text-right text-sm font-medium text-red-600 dark:text-red-400">
                                    -<?php echo e($order->formatCurrency($order->discount_total)); ?>

                                </td>
                            </tr>
                            <?php endif; ?>
                            <tr>
                                <td colspan="3" class="px-4 py-3 text-right font-semibold">Total:</td>
                                <td class="px-4 py-3 text-right font-bold text-lg">
                                    <?php echo e($order->formatCurrency()); ?>

                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

            <!-- Customer Notes -->
            <?php if($order->notes): ?>
            <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
                <h3 class="text-lg font-semibold mb-4">Customer Notes</h3>
                <div class="bg-yellow-50 dark:bg-yellow-900/20 border-l-4 border-yellow-400 p-4">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                            </svg>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm text-gray-700 dark:text-gray-300 whitespace-pre-line"><?php echo e($order->notes); ?></p>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <!-- Customer Information -->
        <div class="space-y-6">
            <!-- Billing Details -->
            <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
                <h3 class="text-lg font-semibold mb-4">Billing Details</h3>
                <dl class="space-y-2 text-sm">
                    <div>
                        <dt class="font-medium text-gray-500 dark:text-gray-400">Name</dt>
                        <?php
                            // Support both WooCommerce format (first_name/last_name) and sales page format (name)
                            $billingName = $order->billing['name'] ?? trim(($order->billing['first_name'] ?? '') . ' ' . ($order->billing['last_name'] ?? ''));
                        ?>
                        <dd class="uppercase"><?php echo e($billingName); ?></dd>
                    </div>
                    <div>
                        <dt class="font-medium text-gray-500 dark:text-gray-400">Email</dt>
                        <dd><?php echo e($order->billing['email'] ?? 'N/A'); ?></dd>
                    </div>
                    <div>
                        <dt class="font-medium text-gray-500 dark:text-gray-400">Phone</dt>
                        <dd class="flex items-center space-x-2">
                            <span><?php echo e(App\Helpers\PhoneHelper::display($order->billing['phone'] ?? null) ?? 'N/A'); ?></span>
                            <?php if(!empty($order->billing['phone'])): ?>
                                <a href="<?php echo e(App\Helpers\PhoneHelper::getWhatsAppUrl($order->billing['phone'])); ?>"
                                   target="_blank"
                                   class="inline-flex items-center px-2 py-1 bg-green-500 hover:bg-green-600 text-white text-xs font-medium rounded-md transition-colors"
                                   title="Contact via WhatsApp">
                                    <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
                                        <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.890-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/>
                                    </svg>
                                    <span class="ml-1">WhatsApp</span>
                                </a>
                            <?php endif; ?>
                        </dd>
                    </div>
                    <div>
                        <dt class="font-medium text-gray-500 dark:text-gray-400">Address</dt>
                        <?php
                            // Support both WooCommerce format (address_1) and sales page format (address)
                            $billingAddress1 = $order->billing['address_1'] ?? $order->billing['address'] ?? '';
                            $billingAddress2 = $order->billing['address_2'] ?? '';
                        ?>
                        <dd class="uppercase">
                            <?php echo e($billingAddress1); ?><br>
                            <?php if($billingAddress2): ?>
                                <?php echo e($billingAddress2); ?><br>
                            <?php endif; ?>
                            <?php echo e($order->billing['city'] ?? ''); ?>, <?php echo e($order->billing['state'] ?? ''); ?><br>
                            <?php echo e($order->billing['postcode'] ?? ''); ?><br>
                            <?php echo e($order->billing['country'] ?? ''); ?>

                        </dd>
                    </div>
                </dl>
            </div>

            <!-- Shipping Details -->
            <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
                <h3 class="text-lg font-semibold mb-4">Shipping Details</h3>
                <dl class="space-y-2 text-sm">
                    <div>
                        <dt class="font-medium text-gray-500 dark:text-gray-400">Name</dt>
                        <?php
                            // Support both WooCommerce format (first_name/last_name) and sales page format (name)
                            $shippingName = $order->shipping['name'] ?? $order->billing['name'] ?? trim(($order->shipping['first_name'] ?? $order->billing['first_name'] ?? '') . ' ' . ($order->shipping['last_name'] ?? $order->billing['last_name'] ?? ''));
                        ?>
                        <dd class="uppercase"><?php echo e($shippingName); ?></dd>
                    </div>
                    <div>
                        <dt class="font-medium text-gray-500 dark:text-gray-400">Address</dt>
                        <?php
                            // Support both WooCommerce format (address_1) and sales page format (address)
                            $shippingAddress1 = $order->shipping['address_1'] ?? $order->shipping['address'] ?? $order->billing['address_1'] ?? $order->billing['address'] ?? '';
                            $shippingAddress2 = $order->shipping['address_2'] ?? $order->billing['address_2'] ?? '';
                        ?>
                        <dd class="uppercase">
                            <?php echo e($shippingAddress1); ?><br>
                            <?php if($shippingAddress2): ?>
                                <?php echo e($shippingAddress2); ?><br>
                            <?php endif; ?>
                            <?php echo e($order->shipping['city'] ?? $order->billing['city'] ?? ''); ?>, <?php echo e($order->shipping['state'] ?? $order->billing['state'] ?? ''); ?><br>
                            <?php echo e($order->shipping['postcode'] ?? $order->billing['postcode'] ?? ''); ?><br>
                            <?php echo e($order->shipping['country'] ?? $order->billing['country'] ?? ''); ?>

                        </dd>
                    </div>
                </dl>
            </div>

            <!-- Pos Laju Tracking -->
            <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
                <h3 class="text-lg font-semibold mb-4">Courier & Tracking</h3>

                <?php if($order->tracking_number): ?>
                    <!-- Tracking Info Display -->
                    <div class="space-y-3">
                        <div>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Courier</dt>
                            <dd class="mt-1 text-sm font-medium"><?php echo e($order->courier ?? 'Pos Laju'); ?></dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Tracking Number</dt>
                            <dd class="mt-1">
                                <div class="flex items-center space-x-2">
                                    <span class="text-sm font-mono bg-gray-100 dark:bg-gray-700 px-3 py-1 rounded">
                                        <?php echo e($order->tracking_number); ?>

                                    </span>
                                    <button onclick="copyTrackingNumber()"
                                            class="text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300"
                                            title="Copy tracking number">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"/>
                                        </svg>
                                    </button>
                                </div>
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Generated At</dt>
                            <dd class="mt-1 text-sm"><?php echo e($order->awb_generated_at ? $order->awb_generated_at->format('M d, Y H:i') : 'N/A'); ?></dd>
                        </div>
                        <div class="pt-3 border-t border-gray-200 dark:border-gray-700">
                            <div class="flex flex-wrap gap-2">
                                <!-- Track Shipment Button -->
                                <a href="https://tracking.pos.com.my/tracking/<?php echo e($order->tracking_number); ?>"
                                   target="_blank"
                                   class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-md hover:bg-blue-700 transition-colors">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                                    </svg>
                                    Track Shipment
                                </a>

                                <!-- Print AWB Button -->
                                <a href="<?php echo e(route('orders.awb.print', $order)); ?>"
                                   target="_blank"
                                   class="inline-flex items-center px-4 py-2 bg-green-600 text-white text-sm font-medium rounded-md hover:bg-green-700 transition-colors">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"/>
                                    </svg>
                                    Print AWB
                                </a>

                                <!-- Download AWB Button -->
                                <a href="<?php echo e(route('orders.awb.download', $order)); ?>"
                                   class="inline-flex items-center px-4 py-2 bg-gray-600 text-white text-sm font-medium rounded-md hover:bg-gray-700 transition-colors">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"/>
                                    </svg>
                                    Download AWB
                                </a>
                            </div>

                            <!-- Mark as Completed Button -->
                            <?php if($order->status !== 'completed'): ?>
                            <div class="pt-3 border-t border-gray-200 dark:border-gray-700 mt-3">
                                <form action="<?php echo e(route('orders.mark-completed', $order)); ?>" method="POST" onsubmit="return confirm('Mark this order as completed? This will update the order status in the system and sync to WooCommerce/webhook source if applicable.');">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit"
                                            class="w-full inline-flex items-center justify-center px-4 py-2 bg-green-600 text-white text-sm font-medium rounded-md hover:bg-green-700 transition-colors">
                                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                        </svg>
                                        Mark as Completed
                                    </button>
                                </form>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php else: ?>
                    <!-- Push AWB Button -->
                    <div class="text-center py-4">
                        <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">No tracking number generated yet</p>
                        <button id="generateAwbBtn"
                                onclick="generateAWB()"
                                class="inline-flex items-center px-4 py-2 bg-green-600 text-white font-medium rounded-md hover:bg-green-700 transition-colors disabled:opacity-50 disabled:cursor-not-allowed">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                            </svg>
                            Push AWB
                        </button>
                        <div id="awbStatus" class="mt-3 text-sm"></div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function generateAWB() {
    const btn = document.getElementById('generateAwbBtn');
    const status = document.getElementById('awbStatus');

    // Disable button and show loading
    btn.disabled = true;
    btn.innerHTML = '<svg class="animate-spin h-5 w-5 mr-2 inline-block" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>Pushing AWB...';
    status.innerHTML = '<span class="text-blue-600">Connecting to Pos Laju API...</span>';

    fetch('<?php echo e(route('orders.generate-awb', $order)); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            status.innerHTML = '<span class="text-green-600 font-medium">✓ AWB generated successfully! Tracking: ' + data.tracking_number + '</span>';
            setTimeout(() => {
                window.location.reload();
            }, 1500);
        } else {
            status.innerHTML = '<span class="text-red-600">✗ ' + data.message + '</span>';
            btn.disabled = false;
            btn.innerHTML = '<svg class="w-5 h-5 mr-2 inline-block" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/></svg>Push AWB';
        }
    })
    .catch(error => {
        status.innerHTML = '<span class="text-red-600">✗ Error: ' + error.message + '</span>';
        btn.disabled = false;
        btn.innerHTML = '<svg class="w-5 h-5 mr-2 inline-block" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/></svg>Push AWB';
    });
}

function copyTrackingNumber() {
    const trackingNumber = '<?php echo e($order->tracking_number); ?>';
    navigator.clipboard.writeText(trackingNumber).then(() => {
        alert('Tracking number copied to clipboard!');
    });
}
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\multistore\resources\views/orders/show.blade.php ENDPATH**/ ?>