<?php $__env->startSection('title', 'Sales Forecasting & Business Intelligence'); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Header -->
    <div class="mb-6 flex items-center justify-between">
        <div>
            <h1 class="text-2xl font-bold text-gray-900 dark:text-white">📈 Sales Forecasting & AI Insights</h1>
            <p class="text-gray-600 dark:text-gray-400">Business intelligence, KPI tracking, and AI-powered recommendations</p>
        </div>
        <div class="flex gap-4">
            <a href="<?php echo e(route('forecasting.expenses')); ?>" class="px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700">
                Update Expenses
            </a>
            <a href="<?php echo e(route('forecasting.import')); ?>" class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700">
                Import Data
            </a>
            <button onclick="loadProphetForecast(6)" class="px-4 py-2 bg-purple-600 text-white rounded-md hover:bg-purple-700 flex items-center gap-2">
                <img src="<?php echo e(asset('images/chatbot-aicon.png')); ?>" alt="AI" class="w-5 h-5">
                Forecast (AI)
            </button>
        </div>
    </div>

    <?php echo $__env->make('forecasting.partials.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Year Filter -->
    <div class="mb-6">
        <form method="GET" action="<?php echo e(route('forecasting.index')); ?>" class="flex items-center gap-4">
            <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Year:</label>
            <select name="year" onchange="this.form.submit()" class="px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md dark:bg-gray-700 dark:text-white">
                <?php for($y = 2022; $y <= date('Y'); $y++): ?>
                    <option value="<?php echo e($y); ?>" <?php echo e($year == $y ? 'selected' : ''); ?>><?php echo e($y); ?></option>
                <?php endfor; ?>
            </select>
        </form>
    </div>

    <!-- Forecasting Insights -->
    <?php if(isset($forecast) && $forecast['confidence'] !== 'low'): ?>
    <div class="mb-6 bg-gradient-to-r from-blue-500 to-purple-600 rounded-lg shadow-lg p-6 text-white">
        <h2 class="text-xl font-bold mb-4">AI Forecasting Insights</h2>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div>
                <div class="text-sm opacity-90">Year-End Projection</div>
                <div class="text-2xl font-bold">RM <?php echo e(number_format($forecast['year_end_projection'], 2)); ?></div>
                <div class="text-xs opacity-75">Confidence: <?php echo e(ucfirst($forecast['confidence'])); ?></div>
            </div>
            <div>
                <div class="text-sm opacity-90">Trend Analysis</div>
                <div class="text-2xl font-bold">
                    <?php if($forecast['trend'] === 'growing'): ?>
                        📈 Growing
                    <?php elseif($forecast['trend'] === 'declining'): ?>
                        📉 Declining
                    <?php else: ?>
                        ➡️ Stable
                    <?php endif; ?>
                </div>
                <div class="text-xs opacity-75">YoY: <?php echo e(number_format($forecast['yoy_growth'], 1)); ?>%</div>
            </div>
            <div>
                <div class="text-sm opacity-90">Next Month Forecast</div>
                <div class="text-2xl font-bold">RM <?php echo e(number_format($forecast['next_month_revenue'], 2)); ?></div>
                <div class="text-xs opacity-75">~<?php echo e(number_format($forecast['next_month_orders'])); ?> orders</div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Summary Stats -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
        <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
            <div class="text-sm text-gray-600 dark:text-gray-400">Revenue</div>
            <div class="text-2xl font-bold text-gray-900 dark:text-white">RM <?php echo e(number_format($summary['revenue'], 2)); ?></div>
        </div>
        <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
            <div class="text-sm text-gray-600 dark:text-gray-400">Orders</div>
            <div class="text-2xl font-bold text-gray-900 dark:text-white"><?php echo e(number_format($summary['orders'])); ?></div>
        </div>
        <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
            <div class="text-sm text-gray-600 dark:text-gray-400">AOV</div>
            <div class="text-2xl font-bold text-gray-900 dark:text-white">RM <?php echo e(number_format($summary['aov'], 2)); ?></div>
        </div>
        <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
            <div class="text-sm text-gray-600 dark:text-gray-400">YoY Growth</div>
            <div class="text-2xl font-bold <?php echo e($summary['yoy_growth'] >= 0 ? 'text-green-600' : 'text-red-600'); ?>">
                <?php echo e(number_format($summary['yoy_growth'], 1)); ?>%
            </div>
        </div>
    </div>

    <!-- Multi-Year Quarterly Trend Chart (Collapsible) -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow mb-8">
        <!-- Accordion Header (Clickable) -->
        <button onclick="toggleMultiYearChart()" class="w-full p-6 flex justify-between items-center hover:bg-gray-50 dark:hover:bg-gray-700/50 transition-colors">
            <div class="flex items-center gap-3">
                <svg id="multiYearChevron" class="w-5 h-5 text-gray-500 dark:text-gray-400 transform transition-transform duration-200" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                </svg>
                <div class="text-left">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">📊 Multi-Year Quarterly Sales Trend</h3>
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Compare sales performance across up to 5 years (quarterly view)</p>
                </div>
            </div>
            <span class="text-sm text-gray-500 dark:text-gray-400">Click to expand</span>
        </button>

        <!-- Accordion Content (Hidden by default) -->
        <div id="multiYearChartContent" class="hidden border-t border-gray-200 dark:border-gray-700">
            <div class="p-6">
                <div class="flex justify-between items-center mb-4">
                    <div>
                        <h4 class="text-base font-medium text-gray-700 dark:text-gray-300">Chart Controls</h4>
                    </div>
                    <div class="flex gap-2">
                        <button onclick="exportChart()" class="px-3 py-2 bg-gray-600 text-white text-sm rounded-md hover:bg-gray-700 flex items-center gap-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path>
                            </svg>
                            Export PNG
                        </button>
                        <button id="projectFutureBtn" onclick="projectFutureYear()" class="px-3 py-2 bg-purple-600 text-white text-sm rounded-md hover:bg-purple-700 flex items-center gap-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                            </svg>
                            Project Future
                        </button>
                    </div>
                </div>

        <!-- Controls -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6 p-4 bg-gray-50 dark:bg-gray-900/50 rounded-lg border border-gray-200 dark:border-gray-700">
            <!-- Year Selection -->
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Select Years:</label>
                <div id="yearCheckboxes" class="space-y-2">
                    <!-- Will be populated by JavaScript -->
                </div>
            </div>

            <!-- Channel Selection -->
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Channel:</label>
                <div class="space-y-2">
                    <label class="flex items-center">
                        <input type="radio" name="channel" value="total" checked onchange="updateChart()" class="mr-2">
                        <span class="text-sm text-gray-700 dark:text-gray-300">All Channels (Total)</span>
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="channel" value="stokis" onchange="updateChart()" class="mr-2">
                        <span class="text-sm text-blue-600 dark:text-blue-400">Stokis Only</span>
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="channel" value="agent" onchange="updateChart()" class="mr-2">
                        <span class="text-sm text-green-600 dark:text-green-400">Agent Only</span>
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="channel" value="hq" onchange="updateChart()" class="mr-2">
                        <span class="text-sm text-purple-600 dark:text-purple-400">HQ Only</span>
                    </label>
                </div>
            </div>

            <!-- Metric Selection -->
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">View Metric:</label>
                <div class="space-y-2">
                    <label class="flex items-center">
                        <input type="radio" name="metric" value="revenue" checked onchange="updateChart()" class="mr-2">
                        <span class="text-sm text-gray-700 dark:text-gray-300">Revenue (RM)</span>
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="metric" value="orders" onchange="updateChart()" class="mr-2">
                        <span class="text-sm text-gray-700 dark:text-gray-300">Orders</span>
                    </label>
                    <label class="flex items-center">
                        <input type="radio" name="metric" value="aov" onchange="updateChart()" class="mr-2">
                        <span class="text-sm text-gray-700 dark:text-gray-300">AOV (RM)</span>
                    </label>
                </div>
            </div>
        </div>

        <!-- Chart Container -->
        <div id="multiYearChartContainer" class="relative">
            <canvas id="multiYearChart" style="height: 500px;"></canvas>
            <div id="chartLoading" class="absolute inset-0 flex items-center justify-center bg-white dark:bg-gray-800 bg-opacity-90">
                <div class="text-center">
                    <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-purple-600 mx-auto mb-3"></div>
                    <p class="text-gray-600 dark:text-gray-400">Loading multi-year data...</p>
                </div>
            </div>
        </div>
            </div>
        </div>
    </div>

    <!-- Sales Channel Breakdown Chart -->
    <?php if($salesBreakdown->count() > 0): ?>
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
        <!-- Stacked Bar Chart -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Sales by Channel (<?php echo e($year); ?>)</h3>
            <canvas id="salesChannelChart"></canvas>
        </div>

        <!-- Line Chart for Trends -->
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Monthly Sales Trend (<?php echo e($year); ?>)</h3>
            <canvas id="salesTrendChart"></canvas>
        </div>
    </div>
    <?php endif; ?>

    <!-- Monthly Breakdown -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow overflow-hidden">
        <div class="p-6 border-b border-gray-200 dark:border-gray-700">
            <h2 class="text-lg font-semibold text-gray-900 dark:text-white"><?php echo e($year); ?> Monthly Performance</h2>
            <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">K = Thousands, M = Millions | Hover for exact amounts</p>
            <div class="mt-2 p-3 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-md">
                <p class="text-xs text-blue-800 dark:text-blue-200">
                    <strong>Editable Fields (click to edit):</strong>
                    <span class="font-semibold">Orders</span>,
                    <span class="text-blue-600 dark:text-blue-400 font-semibold">Stokis</span>, and
                    <span class="text-green-600 dark:text-green-400 font-semibold">Agent</span> sales.
                    <span class="text-purple-600 dark:text-purple-400 font-semibold">HQ</span> sales are auto-calculated from system.
                    <br>
                    <strong>Auto-calculated:</strong> Revenue = HQ + Stokis + Agent | AOV = Revenue / Orders | Net = Revenue - Expenses
                </p>
            </div>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                <thead class="bg-gray-50 dark:bg-gray-900">
                    <tr>
                        <th class="px-3 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Month</th>
                        <th class="px-2 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Orders</th>
                        <th class="px-2 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Stokis (RM)</th>
                        <th class="px-2 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Agent (RM)</th>
                        <th class="px-2 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">HQ (RM)</th>
                        <th class="px-2 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Revenue (RM)</th>
                        <th class="px-2 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Expenses (RM)</th>
                        <th class="px-2 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Net (RM)</th>
                        <th class="px-2 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">AOV (RM)</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    <?php $__currentLoopData = $currentYearSales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $formatCompact = function($value) {
                            if ($value >= 1000000) {
                                return number_format($value / 1000000, 2) . 'M';
                            } elseif ($value >= 1000) {
                                return number_format($value / 1000, 1) . 'K';
                            } else {
                                return number_format($value, 2);
                            }
                        };
                        $netProfit = $data['revenue'] - ($data['expenses'] ?? 0);
                    ?>
                    <tr>
                        <td class="px-3 py-3 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">
                            <span class="hidden lg:inline"><?php echo e(date('F', mktime(0, 0, 0, $month, 1))); ?></span>
                            <span class="lg:hidden"><?php echo e(date('M', mktime(0, 0, 0, $month, 1))); ?></span>
                        </td>
                        <td class="px-2 py-3 whitespace-nowrap text-sm text-right text-gray-700 dark:text-gray-300 editable-cell cursor-pointer hover:bg-gray-100 dark:hover:bg-gray-700/50"
                            title="<?php echo e(number_format($data['orders'])); ?> - Click to edit"
                            data-year="<?php echo e($year); ?>"
                            data-month="<?php echo e($month); ?>"
                            data-value="<?php echo e($data['orders']); ?>"
                            onclick="editOrders(this)">
                            <span class="value-display"><?php echo e(number_format($data['orders'])); ?></span>
                            <svg class="inline w-3 h-3 ml-1 opacity-0 hover:opacity-100" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.232 5.232l3.536 3.536m-2.036-5.036a2.5 2.5 0 113.536 3.536L6.5 21.036H3v-3.572L16.732 3.732z"></path>
                            </svg>
                        </td>
                        <td class="px-2 py-3 whitespace-nowrap text-sm text-right text-blue-600 dark:text-blue-400 editable-cell cursor-pointer hover:bg-blue-50 dark:hover:bg-blue-900/20"
                            title="RM <?php echo e(number_format($data['stokis_sales'] ?? 0, 2)); ?> - Click to edit"
                            data-year="<?php echo e($year); ?>"
                            data-month="<?php echo e($month); ?>"
                            data-channel="stokis_sales"
                            data-value="<?php echo e($data['stokis_sales'] ?? 0); ?>"
                            onclick="editChannelSales(this)">
                            <span class="value-display"><?php echo e($formatCompact($data['stokis_sales'] ?? 0)); ?></span>
                            <svg class="inline w-3 h-3 ml-1 opacity-0 hover:opacity-100" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.232 5.232l3.536 3.536m-2.036-5.036a2.5 2.5 0 113.536 3.536L6.5 21.036H3v-3.572L16.732 3.732z"></path>
                            </svg>
                        </td>
                        <td class="px-2 py-3 whitespace-nowrap text-sm text-right text-green-600 dark:text-green-400 editable-cell cursor-pointer hover:bg-green-50 dark:hover:bg-green-900/20"
                            title="RM <?php echo e(number_format($data['agent_sales'] ?? 0, 2)); ?> - Click to edit"
                            data-year="<?php echo e($year); ?>"
                            data-month="<?php echo e($month); ?>"
                            data-channel="agent_sales"
                            data-value="<?php echo e($data['agent_sales'] ?? 0); ?>"
                            onclick="editChannelSales(this)">
                            <span class="value-display"><?php echo e($formatCompact($data['agent_sales'] ?? 0)); ?></span>
                            <svg class="inline w-3 h-3 ml-1 opacity-0 hover:opacity-100" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.232 5.232l3.536 3.536m-2.036-5.036a2.5 2.5 0 113.536 3.536L6.5 21.036H3v-3.572L16.732 3.732z"></path>
                            </svg>
                        </td>
                        <td class="px-2 py-3 whitespace-nowrap text-sm text-right text-purple-600 dark:text-purple-400" title="RM <?php echo e(number_format($data['hq_sales'] ?? 0, 2)); ?>">
                            <?php echo e($formatCompact($data['hq_sales'] ?? 0)); ?>

                        </td>
                        <td class="px-2 py-3 whitespace-nowrap text-sm text-right font-medium text-gray-900 dark:text-white" title="RM <?php echo e(number_format($data['revenue'], 2)); ?>">
                            <?php echo e($formatCompact($data['revenue'])); ?>

                        </td>
                        <td class="px-2 py-3 whitespace-nowrap text-sm text-right text-red-600 dark:text-red-400" title="RM <?php echo e(number_format($data['expenses'] ?? 0, 2)); ?>">
                            <?php echo e($formatCompact($data['expenses'] ?? 0)); ?>

                        </td>
                        <td class="px-2 py-3 whitespace-nowrap text-sm text-right font-medium <?php echo e($netProfit >= 0 ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400'); ?>" title="RM <?php echo e(number_format($netProfit, 2)); ?>">
                            <?php echo e($formatCompact($netProfit)); ?>

                        </td>
                        <td class="px-2 py-3 whitespace-nowrap text-sm text-right text-gray-700 dark:text-gray-300" title="RM <?php echo e(number_format($data['aov'], 2)); ?>">
                            <?php echo e(number_format($data['aov'], 0)); ?>

                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Historical Data Section -->
    <?php if($historicalData->count() > 0): ?>
    <div class="mt-8 bg-white dark:bg-gray-800 rounded-lg shadow overflow-hidden">
        <div class="p-6 border-b border-gray-200 dark:border-gray-700">
            <h2 class="text-lg font-semibold text-gray-900 dark:text-white">All Historical Data</h2>
            <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">Complete sales history from imported data</p>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                <thead class="bg-gray-50 dark:bg-gray-900">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Period</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Orders</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Revenue</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">AOV</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase">Notes</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    <?php $__currentLoopData = $historicalData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">
                            <?php echo e($record->period); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-gray-700 dark:text-gray-300">
                            <?php echo e(number_format($record->orders)); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-gray-700 dark:text-gray-300">
                            RM <?php echo e(number_format($record->revenue, 2)); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-right text-gray-700 dark:text-gray-300">
                            RM <?php echo e(number_format($record->aov, 2)); ?>

                        </td>
                        <td class="px-6 py-4 text-sm text-gray-700 dark:text-gray-300">
                            <?php echo e($record->notes); ?>

                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php else: ?>
    <div class="mt-8 bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 rounded-lg p-6">
        <p class="text-yellow-800 dark:text-yellow-200">
            📊 No historical data found. <a href="<?php echo e(route('forecasting.import')); ?>" class="underline font-medium">Import your data</a> to see historical trends.
        </p>
    </div>
    <?php endif; ?>
</div>

<!-- Prophet Forecast Modal -->
<div id="prophetModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
    <div class="relative top-10 mx-auto p-5 border w-full max-w-6xl shadow-lg rounded-md bg-white dark:bg-gray-800">
        <div class="flex justify-between items-center mb-4">
            <h3 class="text-xl font-bold text-gray-900 dark:text-white flex items-center gap-2">
                <img src="<?php echo e(asset('images/chatbot-aicon.png')); ?>" alt="AI" class="w-6 h-6">
                AI-Powered Sales Forecast
            </h3>
            <div class="flex items-center gap-4">
                <select id="forecastPeriod" onchange="changeForecastPeriod()" class="px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md bg-white dark:bg-gray-700 text-gray-900 dark:text-white text-sm">
                    <option value="3">3 Months</option>
                    <option value="6" selected>6 Months</option>
                    <option value="12">12 Months</option>
                </select>
                <button onclick="closeProphetModal()" class="text-gray-400 hover:text-gray-600 dark:hover:text-gray-200">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </button>
            </div>
        </div>
        <div id="prophetContent" class="text-gray-700 dark:text-gray-300">
            <div class="flex justify-center items-center py-12">
                <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-purple-600"></div>
                <span class="ml-3 text-base font-medium">Loading forecast...</span>
            </div>
        </div>
    </div>
</div>

<!-- Extract Blade variables for use in JavaScript -->
<script>
const ROUTES = {
    prophet: '<?php echo e(route('forecasting.prophet')); ?>',
    aiInsights: '<?php echo e(route('forecasting.ai-insights')); ?>',
    channelSalesUpdate: '<?php echo e(route('forecasting.channel-sales.update')); ?>',
    ordersUpdate: '<?php echo e(route('forecasting.orders.update')); ?>',
    multiYearData: '<?php echo e(route('forecasting.multi-year-data')); ?>',
    projectFuture: '<?php echo e(route('forecasting.project-future')); ?>'
};
const CSRF_TOKEN = '<?php echo e(csrf_token()); ?>';
const ASSET_AI_ICON = '<?php echo e(asset('images/chatbot-aicon.png')); ?>';
</script>


<script>
// Prophet Forecast Function
function loadProphetForecast(periods = 6) {
    document.getElementById('prophetModal').classList.remove('hidden');
    document.getElementById('forecastPeriod').value = periods;
    document.getElementById('prophetContent').innerHTML = `
        <div class="flex justify-center items-center py-12">
            <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-purple-600"></div>
            <span class="ml-3 text-base font-medium">Loading forecast and AI insights...</span>
        </div>
    `;

    fetch(ROUTES.prophet + '?periods=' + periods)
        .then(response => response.json())
        .then(data => {
            if (data.error) {
                document.getElementById('prophetContent').innerHTML = `
                    <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg p-6">
                        <h4 class="text-lg font-semibold text-red-800 dark:text-red-200 mb-2">Error</h4>
                        <p class="text-red-700 dark:text-red-300 mb-4">${data.error}</p>
                        ${data.install_command ? `
                            <div class="bg-gray-900 text-green-400 p-4 rounded font-mono text-sm">
                                ${data.install_command}
                            </div>
                            <p class="text-sm font-medium text-red-600 dark:text-red-400 mt-2">Run this command to install the forecasting engine</p>
                        ` : ''}
                    </div>
                `;
                return;
            }

            // Capture periods in closure
            const forecastPeriods = periods;
            const totalLabel = forecastPeriods === 3 ? '3-Month' : (forecastPeriods === 6 ? '6-Month' : '12-Month');

            let html = `
                <div class="mb-6 bg-gradient-to-r from-purple-500 to-pink-600 rounded-lg p-6 text-white">
                    <h4 class="text-lg font-bold mb-4">Summary (${totalLabel} Forecast)</h4>
                    <div class="grid grid-cols-3 gap-4">
                        <div>
                            <div class="text-sm font-semibold opacity-95">Trend</div>
                            <div class="text-2xl font-bold">${data.trend === 'growing' ? '📈 Growing' : (data.trend === 'declining' ? '📉 Declining' : '➡️ Stable')}</div>
                        </div>
                        <div>
                            <div class="text-sm font-semibold opacity-95">Data Points</div>
                            <div class="text-2xl font-bold">${data.data_points} months</div>
                        </div>
                        <div>
                            <div class="text-sm font-semibold opacity-95">Next Month</div>
                            <div class="text-2xl font-bold">RM ${formatNumber(data.summary.next_month_revenue)}</div>
                            <div class="text-xs opacity-75">${data.forecasts[0]?.month_name || 'N/A'} ${data.forecasts[0]?.year || ''}</div>
                        </div>
                    </div>
                </div>

                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                        <thead class="bg-gray-50 dark:bg-gray-900">
                            <tr>
                                <th class="px-4 py-3 text-left text-sm font-semibold text-gray-700 dark:text-gray-300 uppercase">Month</th>
                                <th class="px-4 py-3 text-right text-sm font-semibold text-gray-700 dark:text-gray-300 uppercase">Forecast</th>
                                <th class="px-4 py-3 text-right text-sm font-semibold text-gray-700 dark:text-gray-300 uppercase">Lower Bound</th>
                                <th class="px-4 py-3 text-right text-sm font-semibold text-gray-700 dark:text-gray-300 uppercase">Upper Bound</th>
                                <th class="px-4 py-3 text-center text-sm font-semibold text-gray-700 dark:text-gray-300 uppercase">Confidence</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
            `;

            data.forecasts.forEach(forecast => {
                html += `
                    <tr class="bg-white dark:bg-gray-800 hover:bg-gray-50 dark:hover:bg-gray-700">
                        <td class="px-4 py-3 text-sm font-medium text-gray-900 dark:text-white">${forecast.month_name} ${forecast.year}</td>
                        <td class="px-4 py-3 text-sm text-right font-bold text-purple-600 dark:text-purple-400">RM ${formatNumber(forecast.forecast_revenue)}</td>
                        <td class="px-4 py-3 text-sm text-right text-gray-600 dark:text-gray-400">RM ${formatNumber(forecast.lower_bound)}</td>
                        <td class="px-4 py-3 text-sm text-right text-gray-600 dark:text-gray-400">RM ${formatNumber(forecast.upper_bound)}</td>
                        <td class="px-4 py-3 text-sm text-center">
                            <span class="px-3 py-1 text-sm font-semibold rounded ${
                                forecast.confidence === 'high' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' :
                                forecast.confidence === 'medium' ? 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-200' :
                                'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200'
                            }">
                                ${forecast.confidence.toUpperCase()}
                            </span>
                        </td>
                    </tr>
                `;
            });

            html += `
                        </tbody>
                        <tfoot class="bg-gray-50 dark:bg-gray-900">
                            <tr class="bg-gray-50 dark:bg-gray-900">
                                <td class="px-4 py-3 text-sm font-bold text-gray-900 dark:text-white">${totalLabel} Total</td>
                                <td class="px-4 py-3 text-sm text-right font-bold text-purple-600 dark:text-purple-400">RM ${formatNumber(data.summary.next_6_months_total)}</td>
                                <td colspan="3" class="px-4 py-3 text-sm text-gray-600 dark:text-gray-400">
                                    Average: RM ${formatNumber(data.summary.average_monthly)}/month
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="mt-6 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4">
                    <p class="text-sm font-medium text-blue-800 dark:text-blue-200">
                        <strong>Note:</strong> This forecast uses Facebook's advanced time series forecasting algorithm with automatic seasonality detection.
                        The forecast includes 95% confidence intervals (lower/upper bounds) showing the range of likely outcomes.
                    </p>
                </div>

                <!-- AI Insights Section -->
                <div class="mt-8">
                    <div class="flex justify-between items-center mb-6">
                        <div>
                            <h4 class="text-xl font-bold text-gray-900 dark:text-white flex items-center gap-2">
                                <img src="${ASSET_AI_ICON}" alt="AI" class="w-6 h-6">
                                Executive Business Intelligence Report
                            </h4>
                            <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">AI-powered strategic insights & recommendations for board presentation</p>
                        </div>
                        <div class="flex gap-2">
                            <button onclick="printInsights()" id="printBtn" class="hidden px-4 py-2 bg-gray-600 text-white text-sm font-semibold rounded-lg hover:bg-gray-700 transition-all">
                                <svg class="inline w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
                                </svg>
                                Print Report
                            </button>
                            <button onclick="generateAIInsights(${forecastPeriods})" class="px-5 py-2 bg-gradient-to-r from-blue-600 to-indigo-600 text-white text-sm font-semibold rounded-lg hover:from-blue-700 hover:to-indigo-700 transition-all shadow-md">
                                <svg class="inline w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                                </svg>
                                Generate Intelligence Report
                            </button>
                        </div>
                    </div>
                    <div id="aiInsightsContent" class="bg-gradient-to-br from-gray-50 to-blue-50 dark:from-gray-900 dark:to-blue-900/20 rounded-xl p-8 min-h-[150px] border border-gray-200 dark:border-gray-700">
                        <div class="text-center py-12">
                            <img src="${ASSET_AI_ICON}" alt="AI" class="w-16 h-16 mx-auto mb-4 opacity-50">
                            <p class="text-gray-600 dark:text-gray-400 text-base mb-2">Ready to generate your executive intelligence report</p>
                            <p class="text-sm text-gray-500 dark:text-gray-500 max-w-2xl mx-auto">
                                This report will analyze your sales data, market trends, and provide strategic recommendations based on proven business methodologies including Blue Ocean Strategy, Porter's Five Forces, and data-driven growth tactics.
                            </p>
                        </div>
                    </div>
                </div>
            `;

            document.getElementById('prophetContent').innerHTML = html;
        })
        .catch(error => {
            document.getElementById('prophetContent').innerHTML = `
                <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg p-6">
                    <h4 class="text-lg font-semibold text-red-800 dark:text-red-200 mb-2">Error Loading Forecast</h4>
                    <p class="text-red-700 dark:text-red-300">${error.message}</p>
                </div>
            `;
        });
}

function changeForecastPeriod() {
    const periods = parseInt(document.getElementById('forecastPeriod').value);
    loadProphetForecast(periods);
}

function closeProphetModal() {
    document.getElementById('prophetModal').classList.add('hidden');
}

function formatNumber(num) {
    return parseFloat(num).toLocaleString('en-MY', {minimumFractionDigits: 2, maximumFractionDigits: 2});
}

// Generate AI Insights
async function generateAIInsights(periods) {
    const insightsDiv = document.getElementById('aiInsightsContent');

    // Show loading state
    insightsDiv.innerHTML = `
        <div class="flex items-center justify-center py-8">
            <div class="animate-spin rounded-full h-8 w-8 border-b-2 border-purple-600"></div>
            <span class="ml-3 text-base font-medium">Analyzing data with AI...</span>
        </div>
    `;

    try {
        const response = await fetch(ROUTES.aiInsights + '?periods=' + periods, {
            method: 'GET',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': CSRF_TOKEN,
            },
        });

        const data = await response.json();

        if (data.error) {
            insightsDiv.innerHTML = `
                <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg p-4">
                    <p class="text-red-800 dark:text-red-200">${data.error}</p>
                </div>
            `;
            return;
        }

        // Parse sections and create professional card layout
        const sections = data.insights.split('##').filter(s => s.trim());

        let insightsHTML = '<div class="space-y-6">';

        // Icon mapping for each section (matching AI response headers)
        const sectionIcons = {
            'Performance Summary': { icon: '📊', color: 'blue', gradient: 'from-blue-500 to-cyan-500' },
            'Sales Channel Analysis': { icon: '📈', color: 'green', gradient: 'from-green-500 to-emerald-500' },
            'Strategic Initiatives': { icon: '🚀', color: 'indigo', gradient: 'from-indigo-500 to-blue-500' },
            'Market Position & Competitive Advantage': { icon: '🏆', color: 'purple', gradient: 'from-purple-600 to-pink-600' },
            'ROI Projections & Financial Impact': { icon: '💰', color: 'green', gradient: 'from-green-600 to-teal-600' },
            'Risk Factors & Mitigation': { icon: '⚠️', color: 'red', gradient: 'from-red-500 to-orange-500' },
            'Implementation Timeline': { icon: '📅', color: 'blue', gradient: 'from-blue-600 to-indigo-600' },
            'Actionable Recommendations': { icon: '💡', color: 'yellow', gradient: 'from-yellow-500 to-orange-500' }
        };

        sections.forEach((section, index) => {
            const lines = section.trim().split('\n');
            const rawTitle = lines[0].trim();
            const content = lines.slice(1).join('\n').trim();

            // Remove emoji from title (they appear at the start)
            const title = rawTitle.replace(/^[\u{1F300}-\u{1F9FF}][\u{FE00}-\u{FE0F}]?\s*/u, '').trim();

            // Find matching icon config
            let iconConfig = { icon: '📋', color: 'gray', gradient: 'from-gray-500 to-gray-600' };
            for (const [key, config] of Object.entries(sectionIcons)) {
                if (title.includes(key)) {
                    iconConfig = config;
                    break;
                }
            }

            insightsHTML += `
                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg border border-gray-200 dark:border-gray-700 overflow-hidden transform transition-all hover:shadow-xl">
                    <div class="bg-gradient-to-r ${iconConfig.gradient} p-4">
                        <h5 class="text-lg font-bold text-white flex items-center gap-3">
                            <span class="text-2xl">${iconConfig.icon}</span>
                            ${title}
                        </h5>
                    </div>
                    <div class="p-6">
            `;

            // Parse content
            const paragraphs = content.split('\n\n');
            paragraphs.forEach(para => {
                if (para.includes('**')) {
                    // Bold text
                    para = para.replace(/\*\*(.*?)\*\*/g, '<strong class="font-semibold text-gray-900 dark:text-white">$1</strong>');
                }

                if (para.includes('•') || para.includes('-') || para.match(/^\d+\./)) {
                    // List items
                    const items = para.split('\n').filter(line => line.trim());
                    insightsHTML += '<ul class="space-y-3 mb-4">';
                    items.forEach(item => {
                        let cleanItem = item.replace(/^[•\-]\s*/, '').replace(/^\d+\.\s*/, '').trim();
                        if (cleanItem.includes('**')) {
                            cleanItem = cleanItem.replace(/\*\*(.*?)\*\*/g, '<strong class="font-semibold text-gray-900 dark:text-white">$1</strong>');
                        }
                        if (cleanItem) {
                            insightsHTML += `
                                <li class="flex items-start gap-3 text-sm text-gray-700 dark:text-gray-300">
                                    <span class="flex-shrink-0 w-6 h-6 rounded-full bg-${iconConfig.color}-100 dark:bg-${iconConfig.color}-900/30 flex items-center justify-center text-${iconConfig.color}-600 dark:text-${iconConfig.color}-400 font-semibold text-xs mt-0.5">✓</span>
                                    <span class="flex-1 leading-relaxed">${cleanItem}</span>
                                </li>
                            `;
                        }
                    });
                    insightsHTML += '</ul>';
                } else if (para.trim()) {
                    // Regular paragraph
                    insightsHTML += `<p class="text-sm text-gray-700 dark:text-gray-300 leading-relaxed mb-3">${para.trim()}</p>`;
                }
            });

            insightsHTML += `
                    </div>
                </div>
            `;
        });

        insightsHTML += '</div>';

        // Show print button
        document.getElementById('printBtn').classList.remove('hidden');

        insightsDiv.innerHTML = insightsHTML;

    } catch (error) {
        console.error('Error generating AI insights:', error);
        insightsDiv.innerHTML = `
            <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg p-4">
                <p class="text-red-800 dark:text-red-200">Failed to generate AI insights. Please try again.</p>
            </div>
        `;
    }
}

// Edit Channel Sales (Stokis/Agent) - Inline Editing
function editChannelSales(cell) {
    // Prevent multiple edits
    if (cell.querySelector('input')) {
        return;
    }

    const year = cell.dataset.year;
    const month = cell.dataset.month;
    const channel = cell.dataset.channel;
    const currentValue = parseFloat(cell.dataset.value);
    const channelName = channel === 'stokis_sales' ? 'Stokis' : 'Agent';

    // Hide display value
    const displaySpan = cell.querySelector('.value-display');
    const editIcon = cell.querySelector('svg');
    displaySpan.style.display = 'none';
    editIcon.style.display = 'none';

    // Create input field
    const input = document.createElement('input');
    input.type = 'number';
    input.step = '0.01';
    input.min = '0';
    input.value = currentValue;
    input.className = 'w-full px-2 py-1 text-sm text-right border border-gray-300 dark:border-gray-600 rounded bg-white dark:bg-gray-700 text-gray-900 dark:text-white focus:ring-2 focus:ring-blue-500 focus:border-transparent';

    cell.insertBefore(input, displaySpan);
    input.focus();
    input.select();

    // Save on Enter or blur
    const saveEdit = async () => {
        const newValue = parseFloat(input.value) || 0;

        // Remove input
        input.remove();
        displaySpan.style.display = 'inline';
        editIcon.style.display = 'inline';

        // Show loading state
        displaySpan.innerHTML = '<span class="animate-pulse">Saving...</span>';

        try {
            const response = await fetch(ROUTES.channelSalesUpdate, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': CSRF_TOKEN,
                },
                body: JSON.stringify({
                    year: year,
                    month: month,
                    channel: channel,
                    amount: newValue,
                }),
            });

            const data = await response.json();

            if (data.success) {
                // Update cell data
                cell.dataset.value = newValue;
                cell.title = 'RM ' + formatNumber(newValue) + ' - Click to edit';
                displaySpan.textContent = data.formatted_value;

                // Update related columns in the same row
                const row = cell.closest('tr');
                const cells = row.querySelectorAll('td');

                // Update HQ column (index 4) if provided
                if (data.updated_hq !== undefined) {
                    const hqCell = cells[4];
                    if (hqCell) {
                        hqCell.title = 'RM ' + formatNumber(data.updated_hq);
                        hqCell.textContent = data.formatted_hq;
                    }
                }

                // Update Revenue column (index 5)
                const revenueCell = cells[5];
                if (revenueCell) {
                    revenueCell.title = 'RM ' + formatNumber(data.updated_revenue);
                    revenueCell.textContent = data.formatted_revenue;
                }

                // Update Net column (index 7)
                const netCell = cells[7];
                if (netCell) {
                    netCell.title = 'RM ' + formatNumber(data.updated_net);
                    netCell.textContent = data.formatted_net;
                    // Update color based on profit/loss
                    if (data.updated_net >= 0) {
                        netCell.className = 'px-2 py-3 whitespace-nowrap text-sm text-right font-medium text-green-600 dark:text-green-400';
                    } else {
                        netCell.className = 'px-2 py-3 whitespace-nowrap text-sm text-right font-medium text-red-600 dark:text-red-400';
                    }
                }

                // Update AOV column (index 8)
                const aovCell = cells[8];
                if (aovCell) {
                    aovCell.title = 'RM ' + formatNumber(data.updated_aov);
                    aovCell.textContent = data.formatted_aov;
                }

                // Show success message
                showNotification(data.message, 'success');

                // Reload page after 2 seconds to update summary stats and AI forecasting
                setTimeout(() => {
                    window.location.reload();
                }, 2000);
            } else {
                displaySpan.textContent = cell.dataset.value;
                showNotification('Failed to update ' + channelName + ' sales', 'error');
            }
        } catch (error) {
            console.error('Error updating channel sales:', error);
            displaySpan.textContent = cell.dataset.value;
            showNotification('Error updating ' + channelName + ' sales', 'error');
        }
    };

    input.addEventListener('blur', saveEdit);
    input.addEventListener('keypress', (e) => {
        if (e.key === 'Enter') {
            saveEdit();
        } else if (e.key === 'Escape') {
            input.remove();
            displaySpan.style.display = 'inline';
            editIcon.style.display = 'inline';
        }
    });
}

// Edit Orders - Inline Editing
function editOrders(cell) {
    // Prevent multiple edits
    if (cell.querySelector('input')) {
        return;
    }

    const year = cell.dataset.year;
    const month = cell.dataset.month;
    const currentValue = parseInt(cell.dataset.value);

    // Hide display value
    const displaySpan = cell.querySelector('.value-display');
    const editIcon = cell.querySelector('svg');
    displaySpan.style.display = 'none';
    editIcon.style.display = 'none';

    // Create input field
    const input = document.createElement('input');
    input.type = 'number';
    input.step = '1';
    input.min = '0';
    input.value = currentValue;
    input.className = 'w-full px-2 py-1 text-sm text-right border border-gray-300 dark:border-gray-600 rounded bg-white dark:bg-gray-700 text-gray-900 dark:text-white focus:ring-2 focus:ring-blue-500 focus:border-transparent';

    cell.insertBefore(input, displaySpan);
    input.focus();
    input.select();

    // Save on Enter or blur
    const saveEdit = async () => {
        const newValue = parseInt(input.value) || 0;

        // Remove input
        input.remove();
        displaySpan.style.display = 'inline';
        editIcon.style.display = 'inline';

        // Show loading state
        displaySpan.innerHTML = '<span class="animate-pulse">Saving...</span>';

        try {
            const response = await fetch(ROUTES.ordersUpdate, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': CSRF_TOKEN,
                },
                body: JSON.stringify({
                    year: year,
                    month: month,
                    orders: newValue,
                }),
            });

            const data = await response.json();

            if (data.success) {
                // Update cell data
                cell.dataset.value = newValue;
                cell.title = data.formatted_orders + ' - Click to edit';
                displaySpan.textContent = data.formatted_orders;

                // Update AOV column in the same row
                const row = cell.closest('tr');
                const cells = row.querySelectorAll('td');

                // Update AOV column (index 8)
                const aovCell = cells[8];
                if (aovCell) {
                    aovCell.title = 'RM ' + formatNumber(data.updated_aov);
                    aovCell.textContent = data.formatted_aov;
                }

                // Show success message
                showNotification(data.message, 'success');

                // Reload page after 2 seconds to update summary stats
                setTimeout(() => {
                    window.location.reload();
                }, 2000);
            } else {
                displaySpan.textContent = currentValue.toLocaleString();
                showNotification('Failed to update orders', 'error');
            }
        } catch (error) {
            console.error('Error updating orders:', error);
            displaySpan.textContent = currentValue.toLocaleString();
            showNotification('Error updating orders', 'error');
        }
    };

    input.addEventListener('blur', saveEdit);
    input.addEventListener('keypress', (e) => {
        if (e.key === 'Enter') {
            saveEdit();
        } else if (e.key === 'Escape') {
            input.remove();
            displaySpan.style.display = 'inline';
            editIcon.style.display = 'inline';
        }
    });
}

// Print insights report
function printInsights() {
    const insightsContent = document.getElementById('aiInsightsContent').innerHTML;
    const printWindow = window.open('', '', 'height=800,width=1000');

    printWindow.document.write(`
        <html>
        <head>
            <title>Executive Business Intelligence Report</title>
            <style>
                body {
                    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
                    padding: 40px;
                    line-height: 1.6;
                    color: #333;
                }
                h1 {
                    color: #1e40af;
                    border-bottom: 3px solid #3b82f6;
                    padding-bottom: 10px;
                    margin-bottom: 30px;
                }
                .card {
                    page-break-inside: avoid;
                    margin-bottom: 30px;
                    border: 1px solid #e5e7eb;
                    border-radius: 8px;
                    overflow: hidden;
                }
                .card-header {
                    padding: 15px 20px;
                    color: white;
                    font-weight: bold;
                    font-size: 18px;
                }
                .card-body {
                    padding: 20px;
                }
                ul {
                    list-style: none;
                    padding: 0;
                }
                li {
                    margin-bottom: 12px;
                    padding-left: 0;
                }
                strong {
                    color: #111827;
                }
                @media print {
                    body { padding: 20px; }
                    .card { page-break-inside: avoid; }
                }
            </style>
        </head>
        <body>
            <h1>📊 Executive Business Intelligence Report</h1>
            <p><strong>Generated:</strong> ${new Date().toLocaleDateString('en-MY', { year: 'numeric', month: 'long', day: 'numeric' })}</p>
            <hr style="margin: 20px 0; border: 0; border-top: 1px solid #e5e7eb;">
            ${insightsContent}
        </body>
        </html>
    `);

    printWindow.document.close();
    setTimeout(() => {
        printWindow.print();
    }, 500);
}

// Show notification
function showNotification(message, type = 'success') {
    const notification = document.createElement('div');
    notification.className = `fixed top-4 right-4 px-6 py-3 rounded-lg shadow-lg text-white z-50 ${
        type === 'success' ? 'bg-green-600' : 'bg-red-600'
    }`;
    notification.textContent = message;
    document.body.appendChild(notification);

    setTimeout(() => {
        notification.remove();
    }, 3000);
}

// ========================================
// MULTI-YEAR QUARTERLY TREND CHART
// ========================================

let multiYearChart = null;
let multiYearData = null;
let projectionData = null;

// Year colors (colorblind-friendly palette)
const yearColors = [
    { border: '#2563eb', bg: 'rgba(37, 99, 235, 0.1)' }, // Blue
    { border: '#16a34a', bg: 'rgba(22, 163, 74, 0.1)' }, // Green
    { border: '#dc2626', bg: 'rgba(220, 38, 38, 0.1)' }, // Red
    { border: '#ea580c', bg: 'rgba(234, 88, 12, 0.1)' }, // Orange
    { border: '#8b5cf6', bg: 'rgba(139, 92, 246, 0.1)' }, // Purple
];

// Load multi-year data on page load
document.addEventListener('DOMContentLoaded', function() {
    loadMultiYearData();
});

async function loadMultiYearData() {
    try {
        const response = await fetch(ROUTES.multiYearData);
        const result = await response.json();

        if (result.success) {
            multiYearData = result.data;

            // Populate year checkboxes (last 3 years checked by default)
            const yearCheckboxContainer = document.getElementById('yearCheckboxes');
            yearCheckboxContainer.innerHTML = '';

            const currentYear = new Date().getFullYear();
            result.years.forEach((year, index) => {
                const isRecent = year >= (currentYear - 2); // Last 3 years
                const checkbox = document.createElement('label');
                checkbox.className = 'flex items-center';
                checkbox.innerHTML = `
                    <input type="checkbox" value="${year}" ${isRecent ? 'checked' : ''} onchange="updateChart()" class="mr-2">
                    <span class="text-sm text-gray-700 dark:text-gray-300">
                        ${year}
                    </span>
                `;
                yearCheckboxContainer.appendChild(checkbox);
            });

            // Initialize chart
            updateChart();
        }
    } catch (error) {
        console.error('Error loading multi-year data:', error);
        document.getElementById('chartLoading').innerHTML = `
            <div class="text-center text-red-600">
                <p>Failed to load multi-year data</p>
            </div>
        `;
    }
}

function updateChart() {
    if (!multiYearData) return;

    // Hide loading
    document.getElementById('chartLoading').style.display = 'none';

    // Get selected years
    const selectedYears = Array.from(document.querySelectorAll('#yearCheckboxes input[type="checkbox"]:checked'))
        .map(cb => parseInt(cb.value));

    if (selectedYears.length === 0) {
        showNotification('Please select at least one year', 'error');
        return;
    }

    // Get selected channel and metric
    const channel = document.querySelector('input[name="channel"]:checked').value;
    const metric = document.querySelector('input[name="metric"]:checked').value;

    // Prepare chart data
    const datasets = [];

    selectedYears.forEach((year, index) => {
        const yearQuarters = multiYearData[year];
        if (!yearQuarters) return;

        const color = yearColors[index % yearColors.length];
        const data = yearQuarters.map(q => {
            if (metric === 'revenue') {
                return channel === 'total' ? q.total : q[channel];
            } else if (metric === 'orders') {
                return q.orders;
            } else { // aov
                return q.aov;
            }
        });

        datasets.push({
            label: year.toString(),
            data: data,
            borderColor: color.border,
            backgroundColor: color.bg,
            borderWidth: 3,
            tension: 0.4,
            fill: true,
            pointRadius: 5,
            pointHoverRadius: 7,
        });
    });

    // Add projection data if available
    if (projectionData && projectionData.projections) {
        const projColor = { border: '#f59e0b', bg: 'rgba(245, 158, 11, 0.1)' }; // Amber
        const projValues = projectionData.projections.map(p => p.value);

        datasets.push({
            label: `${projectionData.projections[0].year} (Projected)`,
            data: projValues,
            borderColor: projColor.border,
            backgroundColor: projColor.bg,
            borderWidth: 3,
            borderDash: [10, 5],
            tension: 0.4,
            fill: false,
            pointRadius: 5,
            pointHoverRadius: 7,
            pointStyle: 'triangle',
        });
    }

    // Labels (quarters)
    const labels = multiYearData[selectedYears[0]].map(q => q.quarter);

    // Destroy existing chart
    if (multiYearChart) {
        multiYearChart.destroy();
    }

    // Create new chart
    const ctx = document.getElementById('multiYearChart').getContext('2d');
    multiYearChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: labels,
            datasets: datasets
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'top',
                    labels: {
                        color: document.documentElement.classList.contains('dark') ? '#fff' : '#374151',
                        usePointStyle: true,
                        padding: 15,
                        font: { size: 13 }
                    }
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            let label = context.dataset.label || '';
                            if (label) {
                                label += ': ';
                            }
                            if (metric === 'revenue' || metric === 'aov') {
                                label += 'RM ' + context.parsed.y.toLocaleString('en-MY', {minimumFractionDigits: 2});
                            } else {
                                label += context.parsed.y.toLocaleString('en-MY');
                            }
                            return label;
                        }
                    }
                }
            },
            scales: {
                x: {
                    grid: {
                        color: document.documentElement.classList.contains('dark') ? '#374151' : '#e5e7eb'
                    },
                    ticks: {
                        color: document.documentElement.classList.contains('dark') ? '#9ca3af' : '#6b7280',
                        font: { size: 12 }
                    }
                },
                y: {
                    beginAtZero: true,
                    grid: {
                        color: document.documentElement.classList.contains('dark') ? '#374151' : '#e5e7eb'
                    },
                    ticks: {
                        color: document.documentElement.classList.contains('dark') ? '#9ca3af' : '#6b7280',
                        callback: function(value) {
                            if (metric === 'revenue' || metric === 'aov') {
                                return 'RM ' + value.toLocaleString('en-MY');
                            }
                            return value.toLocaleString('en-MY');
                        }
                    }
                }
            }
        }
    });
}

// Toggle Multi-Year Chart accordion
function toggleMultiYearChart() {
    const content = document.getElementById('multiYearChartContent');
    const chevron = document.getElementById('multiYearChevron');

    if (content.classList.contains('hidden')) {
        // Show content
        content.classList.remove('hidden');
        chevron.style.transform = 'rotate(90deg)';
    } else {
        // Hide content
        content.classList.add('hidden');
        chevron.style.transform = 'rotate(0deg)';
    }
}

// Project future year based on selected years and trend
async function projectFutureYear() {
    const selectedYears = Array.from(document.querySelectorAll('#yearCheckboxes input[type="checkbox"]:checked'))
        .map(cb => parseInt(cb.value));

    if (selectedYears.length < 2) {
        showNotification('Please select at least 2 years for accurate projection', 'error');
        return;
    }

    const channel = document.querySelector('input[name="channel"]:checked').value;
    const btn = document.getElementById('projectFutureBtn');

    btn.disabled = true;
    btn.innerHTML = `
        <div class="animate-spin rounded-full h-4 w-4 border-b-2 border-white"></div>
        Projecting...
    `;

    try {
        const response = await fetch(ROUTES.projectFuture, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': CSRF_TOKEN,
            },
            body: JSON.stringify({
                years: selectedYears,
                channel: channel,
            }),
        });

        const result = await response.json();

        if (result.success) {
            projectionData = result;
            updateChart();

            showNotification(
                `Future projection added! Growth rate: ${result.growth_rate}% (${result.confidence} confidence)`,
                'success'
            );
        } else {
            showNotification(result.error || 'Failed to project future', 'error');
        }
    } catch (error) {
        console.error('Error projecting future:', error);
        showNotification('Error generating projection', 'error');
    } finally {
        btn.disabled = false;
        btn.innerHTML = `
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
            </svg>
            Project Future
        `;
    }
}

// Export chart as PNG
function exportChart() {
    if (!multiYearChart) {
        showNotification('No chart to export', 'error');
        return;
    }

    const canvas = document.getElementById('multiYearChart');
    const url = canvas.toDataURL('image/png');
    const link = document.createElement('a');
    link.download = `multi-year-sales-trend-${new Date().getTime()}.png`;
    link.href = url;
    link.click();

    showNotification('Chart exported successfully!', 'success');
}
</script>


<?php if($salesBreakdown->count() > 0): ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Prepare data for charts
    const salesData = <?php echo json_encode($salesBreakdown, 15, 512) ?>;
    const months = salesData.map(d => d.month);
    const stokisData = salesData.map(d => d.stokis);
    const agentData = salesData.map(d => d.agent);
    const hqData = salesData.map(d => d.hq);
    const totalData = salesData.map(d => d.total);

    // Stacked Bar Chart - Sales by Channel
    const ctx1 = document.getElementById('salesChannelChart');
    if (ctx1) {
        new Chart(ctx1, {
            type: 'bar',
            data: {
                labels: months,
                datasets: [
                    {
                        label: 'Stokis Sales',
                        data: stokisData,
                        backgroundColor: 'rgba(59, 130, 246, 0.8)',
                        borderColor: 'rgb(59, 130, 246)',
                        borderWidth: 1
                    },
                    {
                        label: 'Agent Sales',
                        data: agentData,
                        backgroundColor: 'rgba(34, 197, 94, 0.8)',
                        borderColor: 'rgb(34, 197, 94)',
                        borderWidth: 1
                    },
                    {
                        label: 'HQ Sales',
                        data: hqData,
                        backgroundColor: 'rgba(168, 85, 247, 0.8)',
                        borderColor: 'rgb(168, 85, 247)',
                        borderWidth: 1
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        position: 'bottom',
                        labels: {
                            color: document.documentElement.classList.contains('dark') ? '#fff' : '#374151',
                            padding: 15,
                            font: {
                                size: 12
                            }
                        }
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                let label = context.dataset.label || '';
                                if (label) {
                                    label += ': ';
                                }
                                label += 'RM ' + context.parsed.y.toLocaleString('en-MY', {minimumFractionDigits: 2, maximumFractionDigits: 2});
                                return label;
                            }
                        }
                    }
                },
                scales: {
                    x: {
                        stacked: true,
                        grid: {
                            color: document.documentElement.classList.contains('dark') ? '#374151' : '#e5e7eb'
                        },
                        ticks: {
                            color: document.documentElement.classList.contains('dark') ? '#9ca3af' : '#6b7280'
                        }
                    },
                    y: {
                        stacked: true,
                        beginAtZero: true,
                        grid: {
                            color: document.documentElement.classList.contains('dark') ? '#374151' : '#e5e7eb'
                        },
                        ticks: {
                            color: document.documentElement.classList.contains('dark') ? '#9ca3af' : '#6b7280',
                            callback: function(value) {
                                return 'RM ' + value.toLocaleString('en-MY');
                            }
                        }
                    }
                }
            }
        });
    }

    // Line Chart - Sales Trend
    const ctx2 = document.getElementById('salesTrendChart');
    if (ctx2) {
        new Chart(ctx2, {
            type: 'line',
            data: {
                labels: months,
                datasets: [
                    {
                        label: 'Stokis Sales',
                        data: stokisData,
                        borderColor: 'rgb(59, 130, 246)',
                        backgroundColor: 'rgba(59, 130, 246, 0.1)',
                        tension: 0.4,
                        fill: true
                    },
                    {
                        label: 'Agent Sales',
                        data: agentData,
                        borderColor: 'rgb(34, 197, 94)',
                        backgroundColor: 'rgba(34, 197, 94, 0.1)',
                        tension: 0.4,
                        fill: true
                    },
                    {
                        label: 'HQ Sales',
                        data: hqData,
                        borderColor: 'rgb(168, 85, 247)',
                        backgroundColor: 'rgba(168, 85, 247, 0.1)',
                        tension: 0.4,
                        fill: true
                    },
                    {
                        label: 'Total Revenue',
                        data: totalData,
                        borderColor: 'rgb(234, 179, 8)',
                        backgroundColor: 'rgba(234, 179, 8, 0.1)',
                        borderWidth: 3,
                        borderDash: [5, 5],
                        tension: 0.4,
                        fill: false
                    }
                ]
            },
            options: {
                responsive: true,
                maintainAspectRatio: true,
                plugins: {
                    legend: {
                        position: 'bottom',
                        labels: {
                            color: document.documentElement.classList.contains('dark') ? '#fff' : '#374151',
                            padding: 15,
                            font: {
                                size: 12
                            }
                        }
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                let label = context.dataset.label || '';
                                if (label) {
                                    label += ': ';
                                }
                                label += 'RM ' + context.parsed.y.toLocaleString('en-MY', {minimumFractionDigits: 2, maximumFractionDigits: 2});
                                return label;
                            }
                        }
                    }
                },
                scales: {
                    x: {
                        grid: {
                            color: document.documentElement.classList.contains('dark') ? '#374151' : '#e5e7eb'
                        },
                        ticks: {
                            color: document.documentElement.classList.contains('dark') ? '#9ca3af' : '#6b7280'
                        }
                    },
                    y: {
                        beginAtZero: true,
                        grid: {
                            color: document.documentElement.classList.contains('dark') ? '#374151' : '#e5e7eb'
                        },
                        ticks: {
                            color: document.documentElement.classList.contains('dark') ? '#9ca3af' : '#6b7280',
                            callback: function(value) {
                                return 'RM ' + value.toLocaleString('en-MY');
                            }
                        }
                    }
                }
            }
        });
    }
});
</script>
<?php endif; ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\multistore\resources\views/forecasting/index.blade.php ENDPATH**/ ?>