<?php $__env->startSection('body'); ?>
<div class="min-h-screen bg-gray-50 dark:bg-gray-900">
    <!-- Navigation -->
    <nav class="bg-white border-b border-gray-200 dark:bg-gray-800 dark:border-gray-700 mb-6 relative z-50" x-data="{ mobileMenuOpen: false }">
        <div class="px-4 mx-auto max-w-7xl sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex">
                    <!-- Logo -->
                    <div class="flex items-center shrink-0">
                        <a href="<?php echo e(route('dashboard')); ?>" class="flex items-center">
                            <?php if(App\Models\SystemSetting::getSiteLogo()): ?>
                                <img src="<?php echo e(App\Models\SystemSetting::getSiteLogo()); ?>" alt="<?php echo e(App\Models\SystemSetting::getSiteTitle()); ?>" class="h-8 object-contain">
                            <?php else: ?>
                                <svg class="w-8 h-8 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"/>
                                </svg>
                                <span class="ml-2 text-xl font-bold text-gray-900 dark:text-white"><?php echo e(App\Models\SystemSetting::getSiteTitle()); ?></span>
                            <?php endif; ?>
                        </a>
                    </div>

                    <!-- Navigation Links -->
                    <?php if(auth()->guard()->check()): ?>
                    <div class="hidden space-x-8 sm:-my-px sm:ml-10 sm:flex">
                        <!-- Dashboard -->
                        <a href="<?php echo e(route('dashboard')); ?>" class="inline-flex items-center px-1 pt-1 text-sm font-medium border-b-2 <?php echo e(request()->routeIs('dashboard') ? 'border-indigo-500 text-gray-900 dark:text-white' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300'); ?>">
                            Dashboard
                        </a>

                        <!-- Orders -->
                        <a href="<?php echo e(route('orders.index')); ?>" class="inline-flex items-center px-1 pt-1 text-sm font-medium border-b-2 <?php echo e(request()->routeIs('orders.*') && !request()->routeIs('checkout*') ? 'border-indigo-500 text-gray-900 dark:text-white' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300'); ?>">
                            Orders
                        </a>

                        <!-- Checkout -->
                        <a href="<?php echo e(route('checkout')); ?>" class="inline-flex items-center px-1 pt-1 text-sm font-medium border-b-2 <?php echo e(request()->routeIs('checkout*') ? 'border-indigo-500 text-gray-900 dark:text-white' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300'); ?>">
                            Checkout
                        </a>

                        <!-- Products Dropdown -->
                        <div x-data="{ open: false }" class="relative inline-flex items-center">
                            <button @click="open = !open" class="inline-flex items-center px-1 pt-1 text-sm font-medium border-b-2 <?php echo e(request()->routeIs('products.*') ? 'border-indigo-500 text-gray-900 dark:text-white' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300'); ?>">
                                Products
                                <svg class="w-4 h-4 ml-1" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"/>
                                </svg>
                            </button>
                            <div x-show="open" @click.away="open = false" x-transition x-cloak class="absolute top-full left-0 z-20 w-48 mt-1 origin-top-left bg-white rounded-md shadow-lg dark:bg-gray-800 ring-1 ring-black ring-opacity-5">
                                <div class="py-1">
                                    <a href="<?php echo e(route('products.index')); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                        All Products
                                    </a>
                                    <a href="<?php echo e(route('products.index', ['type' => 'single'])); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                        Single Products
                                    </a>
                                    <a href="<?php echo e(route('products.index', ['type' => 'bundle'])); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                        Bundles / Packages
                                    </a>
                                    <div class="border-t border-gray-200 dark:border-gray-700 my-1"></div>
                                    <a href="<?php echo e(route('products.create')); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                        + Add New Product
                                    </a>
                                </div>
                            </div>
                        </div>

                        <!-- Reports Dropdown -->
                        <div x-data="{ open: false }" class="relative inline-flex items-center">
                            <button @click="open = !open" class="inline-flex items-center px-1 pt-1 text-sm font-medium border-b-2 <?php echo e(request()->routeIs('reports.*') ? 'border-indigo-500 text-gray-900 dark:text-white' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300'); ?>">
                                Reports
                                <svg class="w-4 h-4 ml-1" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"/>
                                </svg>
                            </button>
                            <div x-show="open" @click.away="open = false" x-transition x-cloak class="absolute top-full left-0 z-20 w-48 mt-1 origin-top-left bg-white rounded-md shadow-lg dark:bg-gray-800 ring-1 ring-black ring-opacity-5">
                                <div class="py-1">
                                    <a href="<?php echo e(route('reports.sales')); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                        Sales Report
                                    </a>
                                    <!-- Future reports can be added here -->
                                </div>
                            </div>
                        </div>

                        <!-- Forecasting (Admin Only) -->
                        <?php if(auth()->user()->isAdmin()): ?>
                            <a href="<?php echo e(route('forecasting.index')); ?>" class="inline-flex items-center px-1 pt-1 text-sm font-medium border-b-2 <?php echo e(request()->routeIs('forecasting.*') ? 'border-indigo-500 text-gray-900 dark:text-white' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300'); ?>">
                                Forecasting
                            </a>
                        <?php endif; ?>

                        <!-- Management Menu (Last) -->
                        <?php if(auth()->user()->isAdmin()): ?>
                            <!-- Admin: Dropdown with Store, Channel, Page, User Management -->
                            <div x-data="{ open: false }" class="relative inline-flex items-center">
                                <button @click="open = !open" class="inline-flex items-center px-1 pt-1 text-sm font-medium border-b-2 <?php echo e(request()->routeIs('stores.*') || request()->routeIs('users.*') || request()->routeIs('settings.*') || request()->routeIs('sales-pages.*') || request()->routeIs('seller-domains.*') || request()->routeIs('tiktok-shops-management.*') ? 'border-indigo-500 text-gray-900 dark:text-white' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300'); ?>">
                                    Management
                                    <svg class="w-4 h-4 ml-1" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"/>
                                    </svg>
                                </button>
                                <div x-show="open" @click.away="open = false" x-transition x-cloak class="absolute top-full left-0 z-20 w-56 mt-1 origin-top-left bg-white rounded-md shadow-lg dark:bg-gray-800 ring-1 ring-black ring-opacity-5">
                                    <div class="py-1">
                                        <a href="<?php echo e(route('stores.index')); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                            Store
                                        </a>
                                        <a href="<?php echo e(route('stores.webhooks.index')); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                            Channel
                                        </a>
                                        <a href="<?php echo e(route('sales-pages.index')); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                            Page
                                        </a>
                                        <div class="border-t border-gray-200 dark:border-gray-700 my-1"></div>
                                        <a href="<?php echo e(route('users.index')); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                            User Management
                                        </a>
                                        <a href="<?php echo e(route('tiktok-shops-management.index')); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                            TikTok Shops
                                        </a>
                                        <div class="border-t border-gray-200 dark:border-gray-700 my-1"></div>
                                        <a href="<?php echo e(route('settings.index')); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                            System Settings
                                        </a>
                                        <a href="<?php echo e(route('seller-domains.index')); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                            Custom Domains
                                        </a>
                                        <a href="<?php echo e(route('cloudflare-settings.index')); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                            Cloudflare Settings
                                        </a>
                                        <div class="border-t border-gray-200 dark:border-gray-700 my-1"></div>
                                        <a href="<?php echo e(route('tiktok-shop.index')); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                            TikTok Shop
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php elseif(auth()->user()->isManager()): ?>
                            <!-- Manager: Management Dropdown (Custom Domains hidden) -->
                            <div x-data="{ open: false }" class="relative inline-flex items-center">
                                <button @click="open = !open" class="inline-flex items-center px-1 pt-1 text-sm font-medium border-b-2 <?php echo e(request()->routeIs('stores.*') || request()->routeIs('users.*') || request()->routeIs('sales-pages.*') || request()->routeIs('tiktok-shop.*') ? 'border-indigo-500 text-gray-900 dark:text-white' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300'); ?>">
                                    Management
                                    <svg class="w-4 h-4 ml-1" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"/>
                                    </svg>
                                </button>
                                <div x-show="open" @click.away="open = false" x-transition x-cloak class="absolute top-full left-0 z-20 w-48 mt-1 origin-top-left bg-white rounded-md shadow-lg dark:bg-gray-800 ring-1 ring-black ring-opacity-5">
                                    <div class="py-1">
                                        <a href="<?php echo e(route('users.index', ['role' => 'seller'])); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                            View Sellers
                                        </a>
                                        <a href="<?php echo e(route('stores.index')); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                            View Stores
                                        </a>
                                        <a href="<?php echo e(route('sales-pages.index')); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                            View Pages
                                        </a>
                                        <?php if(auth()->user()->can_manage_tiktok_shop): ?>
                                        <div class="border-t border-gray-200 dark:border-gray-700 my-1"></div>
                                        <a href="<?php echo e(route('tiktok-shop.index')); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                            TikTok Shop
                                        </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php else: ?>
                            <!-- Seller: Dropdown for My Stores (Custom Domains hidden) -->
                            <div x-data="{ open: false }" class="relative inline-flex items-center">
                                <button @click="open = !open" class="inline-flex items-center px-1 pt-1 text-sm font-medium border-b-2 <?php echo e(request()->routeIs('stores.*') || request()->routeIs('sales-pages.*') ? 'border-indigo-500 text-gray-900 dark:text-white' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300'); ?>">
                                    My Stores
                                    <svg class="w-4 h-4 ml-1" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"/>
                                    </svg>
                                </button>
                                <div x-show="open" @click.away="open = false" x-transition x-cloak class="absolute top-full left-0 z-20 w-48 mt-1 origin-top-left bg-white rounded-md shadow-lg dark:bg-gray-800 ring-1 ring-black ring-opacity-5">
                                    <div class="py-1">
                                        <a href="<?php echo e(route('stores.index')); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                            View My Stores
                                        </a>
                                        <a href="<?php echo e(route('sales-pages.index')); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                            View My Pages
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                </div>

                <!-- Right Side -->
                <div class="hidden sm:flex sm:items-center sm:ml-6 sm:space-x-4">
                    <!-- Stop Impersonating Button (Secret Agent Icon) -->
                    <?php if(session()->has('impersonate_admin_id')): ?>
                        <?php
                            $adminId = session('impersonate_admin_id');
                            $admin = \App\Models\User::find($adminId);
                        ?>
                        <form action="<?php echo e(route('users.stop-impersonating')); ?>" method="POST" class="inline">
                            <?php echo csrf_field(); ?>
                            <button type="submit"
                                    class="inline-flex items-center gap-2 px-3 py-2 text-white bg-orange-500 hover:bg-orange-600 rounded-lg border border-orange-600 transition-colors focus:outline-none focus:ring-2 focus:ring-orange-500 shadow-md"
                                    title="Admin Mode: Viewing as <?php echo e(auth()->user()->name); ?> | Click to stop">
                                <!-- Secret Agent / Spy Icon -->
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                </svg>
                                <span class="text-sm font-medium hidden lg:inline">Stop</span>
                            </button>
                        </form>
                    <?php endif; ?>

                    <!-- Simple Theme Toggle -->
                    <button onclick="toggleTheme()" type="button" class="inline-flex items-center gap-2 px-3 py-2 text-gray-700 rounded-lg border border-gray-300 hover:bg-gray-100 dark:text-gray-300 dark:border-gray-600 dark:hover:bg-gray-700 transition-colors focus:outline-none focus:ring-2 focus:ring-indigo-500" id="theme-toggle" title="Toggle theme">
                        <!-- Sun Icon (shown in light mode) -->
                        <svg class="w-5 h-5 dark:hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z"/>
                        </svg>
                        <!-- Moon Icon (shown in dark mode) -->
                        <svg class="hidden w-5 h-5 dark:block" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z"/>
                        </svg>
                        <span class="text-sm font-medium hidden lg:inline dark:hidden">Light</span>
                        <span class="text-sm font-medium hidden lg:dark:inline">Dark</span>
                    </button>

                    <?php if(auth()->guard()->guest()): ?>
                        <a href="<?php echo e(route('login')); ?>" class="text-sm font-medium text-gray-700 hover:text-gray-900 dark:text-gray-300 dark:hover:text-white">
                            Log in
                        </a>
                        <?php if(Route::has('register')): ?>
                            <a href="<?php echo e(route('register')); ?>" class="text-sm font-medium text-gray-700 hover:text-gray-900 dark:text-gray-300 dark:hover:text-white">
                                Register
                            </a>
                        <?php endif; ?>
                    <?php else: ?>
                        <!-- User Dropdown -->
                        <div x-data="{ open: false }" class="relative ml-3">
                            <div>
                                <button @click="open = !open" type="button" class="flex items-center text-sm font-medium text-gray-700 transition duration-150 ease-in-out bg-white rounded-md dark:bg-gray-800 dark:text-gray-300 hover:text-gray-900 dark:hover:text-white focus:outline-none">
                                    <div><?php echo e(Auth::user()->name); ?></div>
                                    <svg class="w-4 h-4 ml-1" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"/>
                                    </svg>
                                </button>
                            </div>

                            <div x-show="open" @click.away="open = false" x-transition x-cloak class="absolute right-0 z-20 w-56 mt-2 origin-top-right bg-white rounded-md shadow-lg dark:bg-gray-800 ring-1 ring-black ring-opacity-5">
                                <div class="py-1">
                                    <?php if(auth()->user()->isSeller()): ?>
                                        <?php
                                            $managers = auth()->user()->managers;
                                        ?>
                                        <?php if($managers->isNotEmpty()): ?>
                                            <div class="px-4 py-2 border-b border-gray-200 dark:border-gray-700">
                                                <div class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide mb-1">
                                                    Managed By
                                                </div>
                                                <?php $__currentLoopData = $managers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manager): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="flex items-center gap-2 mt-1">
                                                        <span class="inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200">
                                                            <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                                <path d="M9 6a3 3 0 11-6 0 3 3 0 016 0zM17 6a3 3 0 11-6 0 3 3 0 016 0zM12.93 17c.046-.327.07-.66.07-1a6.97 6.97 0 00-1.5-4.33A5 5 0 0119 16v1h-6.07zM6 11a5 5 0 015 5v1H1v-1a5 5 0 015-5z"/>
                                                            </svg>
                                                            <?php echo e($manager->name); ?>

                                                        </span>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <a href="<?php echo e(route('profile.edit')); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                        Profile
                                    </a>
                                    <a href="<?php echo e(route('whatsapp-settings.index')); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                        Notifications
                                    </a>
                                    <?php if(auth()->user()->isSeller()): ?>
                                        <a href="<?php echo e(route('settings.google-sheets')); ?>" class="flex items-center justify-between px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                            <span>Google Sheets</span>
                                            <?php if(auth()->user()->google_sheets_sync_enabled): ?>
                                                <span class="inline-flex items-center px-1.5 py-0.5 text-xs font-medium rounded bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200">
                                                    <svg class="w-2.5 h-2.5 mr-0.5" fill="currentColor" viewBox="0 0 20 20">
                                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                                    </svg>
                                                    On
                                                </span>
                                            <?php endif; ?>
                                        </a>
                                    <?php endif; ?>
                                    <?php if(auth()->user()->isAdmin()): ?>
                                        <div class="border-t border-gray-200 dark:border-gray-700 my-1"></div>
                                        <a href="<?php echo e(route('poslaju-settings.index')); ?>" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                            Courier
                                        </a>
                                    <?php endif; ?>
                                    <div class="border-t border-gray-200 dark:border-gray-700 my-1"></div>
                                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="block w-full px-4 py-2 text-sm text-left text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700">
                                            Log Out
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Mobile menu button -->
                <div class="flex items-center space-x-2 -mr-2 sm:hidden">
                    <!-- Mobile Stop Impersonating Button -->
                    <?php if(session()->has('impersonate_admin_id')): ?>
                        <form action="<?php echo e(route('users.stop-impersonating')); ?>" method="POST" class="inline">
                            <?php echo csrf_field(); ?>
                            <button type="submit"
                                    class="p-2 text-white bg-orange-500 hover:bg-orange-600 rounded-lg border border-orange-600 transition-colors focus:outline-none shadow-md"
                                    title="Stop impersonating <?php echo e(auth()->user()->name); ?>">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                </svg>
                            </button>
                        </form>
                    <?php endif; ?>

                    <!-- Mobile Theme Toggle -->
                    <button onclick="toggleTheme()" type="button" class="p-2 text-gray-700 rounded-lg border border-gray-300 hover:bg-gray-100 dark:text-gray-300 dark:border-gray-600 dark:hover:bg-gray-700 transition-colors focus:outline-none" title="Toggle theme">
                        <!-- Sun Icon (shown in light mode) -->
                        <svg class="w-5 h-5 dark:hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z"/>
                        </svg>
                        <!-- Moon Icon (shown in dark mode) -->
                        <svg class="hidden w-5 h-5 dark:block" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z"/>
                        </svg>
                    </button>

                    <button @click="mobileMenuOpen = !mobileMenuOpen" type="button" class="inline-flex items-center justify-center p-2 text-gray-400 transition duration-150 ease-in-out rounded-md dark:text-gray-500 hover:text-gray-500 hover:bg-gray-100 dark:hover:bg-gray-900 focus:outline-none focus:bg-gray-100 dark:focus:bg-gray-900 focus:text-gray-500">
                        <svg class="w-6 h-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                            <path :class="{'hidden': mobileMenuOpen, 'inline-flex': !mobileMenuOpen }" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
                            <path :class="{'hidden': !mobileMenuOpen, 'inline-flex': mobileMenuOpen }" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>
            </div>
        </div>

        <!-- Mobile menu -->
        <div :class="{'block': mobileMenuOpen, 'hidden': !mobileMenuOpen}" class="hidden sm:hidden">
            <?php if(auth()->guard()->check()): ?>
            <div class="pt-2 pb-3 space-y-1">
                <a href="<?php echo e(route('dashboard')); ?>" class="block py-2 pl-3 pr-4 text-base font-medium border-l-4 <?php echo e(request()->routeIs('dashboard') ? 'border-indigo-500 text-indigo-700 bg-indigo-50 dark:bg-indigo-900/50 dark:text-indigo-300' : 'border-transparent text-gray-600 hover:text-gray-800 hover:bg-gray-50 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-200 dark:hover:bg-gray-700'); ?>">
                    Dashboard
                </a>

                <!-- Reports Section -->
                <div class="border-l-4 <?php echo e(request()->routeIs('reports.*') ? 'border-indigo-500 bg-indigo-50 dark:bg-indigo-900/50' : 'border-transparent'); ?>">
                    <div class="block py-2 pl-3 pr-4 text-base font-medium text-gray-800 dark:text-gray-200">
                        Reports
                    </div>
                    <a href="<?php echo e(route('reports.sales')); ?>" class="block py-2 pl-6 pr-4 text-sm font-medium <?php echo e(request()->routeIs('reports.sales*') ? 'text-indigo-700 dark:text-indigo-300' : 'text-gray-600 dark:text-gray-400 hover:text-gray-800 dark:hover:text-gray-200'); ?>">
                        Sales Report
                    </a>
                    <!-- Future reports can be added here -->
                </div>

                <!-- Forecasting (Admin Only) -->
                <?php if(auth()->user()->isAdmin()): ?>
                    <a href="<?php echo e(route('forecasting.index')); ?>" class="block py-2 pl-3 pr-4 text-base font-medium border-l-4 <?php echo e(request()->routeIs('forecasting.*') ? 'border-indigo-500 text-indigo-700 bg-indigo-50 dark:bg-indigo-900/50 dark:text-indigo-300' : 'border-transparent text-gray-600 hover:text-gray-800 hover:bg-gray-50 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-200 dark:hover:bg-gray-700'); ?>">
                        Forecasting
                    </a>
                <?php endif; ?>

                <!-- Management Section -->
                <?php if(auth()->user()->isAdmin()): ?>
                    <!-- Admin: Full Management Menu -->
                    <div class="border-l-4 <?php echo e(request()->routeIs('stores.*') || request()->routeIs('users.*') || request()->routeIs('sales-pages.*') ? 'border-indigo-500 bg-indigo-50 dark:bg-indigo-900/50' : 'border-transparent'); ?>">
                        <div class="block py-2 pl-3 pr-4 text-base font-medium text-gray-800 dark:text-gray-200">
                            Management
                        </div>
                        <a href="<?php echo e(route('stores.index')); ?>" class="block py-2 pl-6 pr-4 text-sm font-medium <?php echo e(request()->routeIs('stores.index') || request()->routeIs('stores.edit') || request()->routeIs('stores.show') ? 'text-indigo-700 dark:text-indigo-300' : 'text-gray-600 dark:text-gray-400 hover:text-gray-800 dark:hover:text-gray-200'); ?>">
                            Store
                        </a>
                        <a href="<?php echo e(route('stores.webhooks.index')); ?>" class="block py-2 pl-6 pr-4 text-sm font-medium <?php echo e(request()->routeIs('stores.webhooks.*') ? 'text-indigo-700 dark:text-indigo-300' : 'text-gray-600 dark:text-gray-400 hover:text-gray-800 dark:hover:text-gray-200'); ?>">
                            Channel
                        </a>
                        <a href="<?php echo e(route('sales-pages.index')); ?>" class="block py-2 pl-6 pr-4 text-sm font-medium <?php echo e(request()->routeIs('sales-pages.*') ? 'text-indigo-700 dark:text-indigo-300' : 'text-gray-600 dark:text-gray-400 hover:text-gray-800 dark:hover:text-gray-200'); ?>">
                            Page
                        </a>
                        <a href="<?php echo e(route('users.index')); ?>" class="block py-2 pl-6 pr-4 text-sm font-medium <?php echo e(request()->routeIs('users.*') ? 'text-indigo-700 dark:text-indigo-300' : 'text-gray-600 dark:text-gray-400 hover:text-gray-800 dark:hover:text-gray-200'); ?>">
                            User Management
                        </a>
                        <a href="<?php echo e(route('settings.index')); ?>" class="block py-2 pl-6 pr-4 text-sm font-medium <?php echo e(request()->routeIs('settings.*') ? 'text-indigo-700 dark:text-indigo-300' : 'text-gray-600 dark:text-gray-400 hover:text-gray-800 dark:hover:text-gray-200'); ?>">
                            System Settings
                        </a>
                    </div>
                <?php elseif(auth()->user()->isManager()): ?>
                    <!-- Manager: Management Section -->
                    <div class="border-l-4 <?php echo e(request()->routeIs('stores.*') || request()->routeIs('users.*') || request()->routeIs('sales-pages.*') ? 'border-indigo-500 bg-indigo-50 dark:bg-indigo-900/50' : 'border-transparent'); ?>">
                        <div class="block py-2 pl-3 pr-4 text-base font-medium text-gray-800 dark:text-gray-200">
                            Management
                        </div>
                        <a href="<?php echo e(route('users.index', ['role' => 'seller'])); ?>" class="block py-2 pl-6 pr-4 text-sm font-medium <?php echo e(request()->routeIs('users.index') ? 'text-indigo-700 dark:text-indigo-300' : 'text-gray-600 dark:text-gray-400 hover:text-gray-800 dark:hover:text-gray-200'); ?>">
                            View Sellers
                        </a>
                        <a href="<?php echo e(route('stores.index')); ?>" class="block py-2 pl-6 pr-4 text-sm font-medium <?php echo e(request()->routeIs('stores.index') || request()->routeIs('stores.edit') || request()->routeIs('stores.show') ? 'text-indigo-700 dark:text-indigo-300' : 'text-gray-600 dark:text-gray-400 hover:text-gray-800 dark:hover:text-gray-200'); ?>">
                            View Stores
                        </a>
                        <a href="<?php echo e(route('sales-pages.index')); ?>" class="block py-2 pl-6 pr-4 text-sm font-medium <?php echo e(request()->routeIs('sales-pages.*') ? 'text-indigo-700 dark:text-indigo-300' : 'text-gray-600 dark:text-gray-400 hover:text-gray-800 dark:hover:text-gray-200'); ?>">
                            View Pages
                        </a>
                    </div>
                <?php else: ?>
                    <!-- Seller: My Stores Section -->
                    <div class="border-l-4 <?php echo e(request()->routeIs('stores.*') || request()->routeIs('sales-pages.*') ? 'border-indigo-500 bg-indigo-50 dark:bg-indigo-900/50' : 'border-transparent'); ?>">
                        <div class="block py-2 pl-3 pr-4 text-base font-medium text-gray-800 dark:text-gray-200">
                            My Stores
                        </div>
                        <a href="<?php echo e(route('stores.index')); ?>" class="block py-2 pl-6 pr-4 text-sm font-medium <?php echo e(request()->routeIs('stores.index') || request()->routeIs('stores.edit') || request()->routeIs('stores.show') ? 'text-indigo-700 dark:text-indigo-300' : 'text-gray-600 dark:text-gray-400 hover:text-gray-800 dark:hover:text-gray-200'); ?>">
                            View My Stores
                        </a>
                        <a href="<?php echo e(route('sales-pages.index')); ?>" class="block py-2 pl-6 pr-4 text-sm font-medium <?php echo e(request()->routeIs('sales-pages.*') ? 'text-indigo-700 dark:text-indigo-300' : 'text-gray-600 dark:text-gray-400 hover:text-gray-800 dark:hover:text-gray-200'); ?>">
                            View My Pages
                        </a>
                    </div>
                <?php endif; ?>

                <a href="<?php echo e(route('orders.index')); ?>" class="block py-2 pl-3 pr-4 text-base font-medium border-l-4 <?php echo e(request()->routeIs('orders.*') && !request()->routeIs('checkout*') ? 'border-indigo-500 text-indigo-700 bg-indigo-50 dark:bg-indigo-900/50 dark:text-indigo-300' : 'border-transparent text-gray-600 hover:text-gray-800 hover:bg-gray-50 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-200 dark:hover:bg-gray-700'); ?>">
                    Orders
                </a>

                <a href="<?php echo e(route('checkout')); ?>" class="block py-2 pl-3 pr-4 text-base font-medium border-l-4 <?php echo e(request()->routeIs('checkout*') ? 'border-indigo-500 text-indigo-700 bg-indigo-50 dark:bg-indigo-900/50 dark:text-indigo-300' : 'border-transparent text-gray-600 hover:text-gray-800 hover:bg-gray-50 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-200 dark:hover:bg-gray-700'); ?>">
                    Checkout
                </a>

                <!-- Products Section -->
                <div class="border-l-4 <?php echo e(request()->routeIs('products.*') ? 'border-indigo-500 bg-indigo-50 dark:bg-indigo-900/50' : 'border-transparent'); ?>">
                    <div class="block py-2 pl-3 pr-4 text-base font-medium text-gray-800 dark:text-gray-200">
                        Products
                    </div>
                    <a href="<?php echo e(route('products.index')); ?>" class="block py-2 pl-6 pr-4 text-sm font-medium <?php echo e(request()->routeIs('products.index') && !request('type') ? 'text-indigo-700 dark:text-indigo-300' : 'text-gray-600 dark:text-gray-400 hover:text-gray-800 dark:hover:text-gray-200'); ?>">
                        All Products
                    </a>
                    <a href="<?php echo e(route('products.index', ['type' => 'single'])); ?>" class="block py-2 pl-6 pr-4 text-sm font-medium <?php echo e(request('type') == 'single' ? 'text-indigo-700 dark:text-indigo-300' : 'text-gray-600 dark:text-gray-400 hover:text-gray-800 dark:hover:text-gray-200'); ?>">
                        Single Products
                    </a>
                    <a href="<?php echo e(route('products.index', ['type' => 'bundle'])); ?>" class="block py-2 pl-6 pr-4 text-sm font-medium <?php echo e(request('type') == 'bundle' ? 'text-indigo-700 dark:text-indigo-300' : 'text-gray-600 dark:text-gray-400 hover:text-gray-800 dark:hover:text-gray-200'); ?>">
                        Bundles / Packages
                    </a>
                    <a href="<?php echo e(route('products.create')); ?>" class="block py-2 pl-6 pr-4 text-sm font-medium <?php echo e(request()->routeIs('products.create') ? 'text-indigo-700 dark:text-indigo-300' : 'text-gray-600 dark:text-gray-400 hover:text-gray-800 dark:hover:text-gray-200'); ?>">
                        + Add New Product
                    </a>
                </div>
            </div>

            <div class="pt-4 pb-3 border-t border-gray-200 dark:border-gray-700">
                <div class="flex items-center px-4">
                    <div class="shrink-0">
                        <div class="flex items-center justify-center w-10 h-10 text-white bg-indigo-600 rounded-full">
                            <?php echo e(strtoupper(substr(Auth::user()->name, 0, 1))); ?>

                        </div>
                    </div>
                    <div class="ml-3">
                        <div class="text-base font-medium text-gray-800 dark:text-white"><?php echo e(Auth::user()->name); ?></div>
                        <div class="text-sm font-medium text-gray-500 dark:text-gray-400"><?php echo e(Auth::user()->email); ?></div>
                    </div>
                </div>

                <div class="mt-3 space-y-1">
                    <a href="<?php echo e(route('profile.edit')); ?>" class="block px-4 py-2 text-base font-medium text-gray-600 dark:text-gray-400 hover:text-gray-800 hover:bg-gray-100 dark:hover:text-gray-200 dark:hover:bg-gray-700">
                        Profile & Settings
                    </a>
                    <?php if(auth()->user()->isAdmin()): ?>
                        <a href="<?php echo e(route('poslaju-settings.index')); ?>" class="block px-4 py-2 text-base font-medium text-gray-600 dark:text-gray-400 hover:text-gray-800 hover:bg-gray-100 dark:hover:text-gray-200 dark:hover:bg-gray-700">
                            Courier
                        </a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('whatsapp-settings.index')); ?>" class="block px-4 py-2 text-base font-medium text-gray-600 dark:text-gray-400 hover:text-gray-800 hover:bg-gray-100 dark:hover:text-gray-200 dark:hover:bg-gray-700">
                        Notifications
                    </a>
                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="block w-full px-4 py-2 text-base font-medium text-left text-gray-600 dark:text-gray-400 hover:text-gray-800 hover:bg-gray-100 dark:hover:text-gray-200 dark:hover:bg-gray-700">
                            Log Out
                        </button>
                    </form>
                </div>
            </div>
            <?php else: ?>
            <div class="pt-2 pb-3 space-y-1">
                <a href="<?php echo e(route('login')); ?>" class="block py-2 pl-3 pr-4 text-base font-medium text-gray-600 border-l-4 border-transparent dark:text-gray-400 hover:text-gray-800 hover:bg-gray-50 hover:border-gray-300 dark:hover:text-gray-200 dark:hover:bg-gray-700">
                    Log in
                </a>
                <?php if(Route::has('register')): ?>
                <a href="<?php echo e(route('register')); ?>" class="block py-2 pl-3 pr-4 text-base font-medium text-gray-600 border-l-4 border-transparent dark:text-gray-400 hover:text-gray-800 hover:bg-gray-50 hover:border-gray-300 dark:hover:text-gray-200 dark:hover:bg-gray-700">
                    Register
                </a>
                <?php endif; ?>
            </div>
            <?php endif; ?>
        </div>
    </nav>

    <!-- Page Content -->
    <main>
        <?php if(session('success')): ?>
            <div class="px-4 py-3 mx-auto mt-4 max-w-7xl sm:px-6 lg:px-8" id="flash-success-message">
                <div class="p-4 text-green-700 bg-green-100 border border-green-400 rounded dark:bg-green-900/50 dark:border-green-700 dark:text-green-300 relative">
                    <?php echo e(session('success')); ?>

                    <button onclick="this.parentElement.parentElement.remove()" class="absolute top-2 right-2 text-green-700 dark:text-green-300 hover:text-green-900 dark:hover:text-green-100">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>
            </div>
            <script>
                // Auto-dismiss flash message after 5 seconds
                setTimeout(function() {
                    const flashMsg = document.getElementById('flash-success-message');
                    if (flashMsg) {
                        flashMsg.style.transition = 'opacity 0.5s';
                        flashMsg.style.opacity = '0';
                        setTimeout(function() { flashMsg.remove(); }, 500);
                    }
                }, 5000);
            </script>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="px-4 py-3 mx-auto mt-4 max-w-7xl sm:px-6 lg:px-8">
                <div class="p-4 text-red-700 bg-red-100 border border-red-400 rounded dark:bg-red-900/50 dark:border-red-700 dark:text-red-300">
                    <?php echo e(session('error')); ?>

                </div>
            </div>
        <?php endif; ?>

        <?php echo $__env->yieldContent('content'); ?>

        <?php if(isset($slot)): ?>
            <?php echo e($slot); ?>

        <?php endif; ?>
    </main>

    <!-- Footer -->
    <footer class="py-6 mt-12 bg-white border-t border-gray-200 dark:bg-gray-800 dark:border-gray-700">
        <div class="px-4 mx-auto max-w-7xl sm:px-6 lg:px-8">
            <div class="text-center text-gray-600 dark:text-gray-400">
                <p><?php echo e(App\Models\SystemSetting::getFooterText()); ?></p>
            </div>
        </div>
    </footer>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\multistore\resources\views/layouts/app.blade.php ENDPATH**/ ?>