<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
    <div class="max-w-4xl mx-auto">
        <!-- Header -->
        <div class="mb-6">
            <h1 class="text-2xl font-bold text-gray-900 dark:text-white">WhatsApp Notification Settings</h1>
            <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
                Configure WhatsApp notifications for your customers. Choose between Official API or WasapBot (unofficial)
            </p>
        </div>

        <?php if(session('success')): ?>
            <div class="mb-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded-md">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="mb-4 p-4 bg-red-100 border border-red-400 text-red-700 rounded-md">
                <ul class="list-disc list-inside">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <!-- Settings Form -->
        <form action="<?php echo e(route('whatsapp-settings.update')); ?>" method="POST" class="space-y-6">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <!-- Provider Selection Section -->
            <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">WhatsApp Provider</h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
                    Choose your WhatsApp messaging provider
                </p>

                <div>
                    <label for="provider" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        Provider <span class="text-red-500">*</span>
                    </label>
                    <select name="provider" id="provider" required
                        onchange="toggleProviderFields()"
                        class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        <option value="">Select Provider</option>
                        <option value="wasapbot" <?php echo e(old('provider', $settings->provider ?? '') == 'wasapbot' ? 'selected' : ''); ?>>
                            WasapBot.my (Unofficial - Cheaper)
                        </option>
                        <option value="official" <?php echo e(old('provider', $settings->provider ?? '') == 'official' ? 'selected' : ''); ?>>
                            WhatsApp Official Business API
                        </option>
                        <option value="twilio" <?php echo e(old('provider', $settings->provider ?? '') == 'twilio' ? 'selected' : ''); ?>>
                            Twilio WhatsApp
                        </option>
                        <option value="wati" <?php echo e(old('provider', $settings->provider ?? '') == 'wati' ? 'selected' : ''); ?>>
                            WATI (WhatsApp Team Inbox)
                        </option>
                        <option value="webhook" <?php echo e(old('provider', $settings->provider ?? '') == 'webhook' ? 'selected' : ''); ?>>
                            Custom Webhook
                        </option>
                    </select>
                </div>
            </div>

            <!-- WasapBot Credentials Section -->
            <div id="wasapbot_section" class="bg-white dark:bg-gray-800 shadow rounded-lg p-6" style="display: none;">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">
                    WasapBot.my Credentials
                </h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
                    Get your credentials from <a href="https://wasapbot.my" target="_blank" class="text-blue-600 hover:underline">WasapBot.my</a>
                </p>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="wasapbot_instance_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Instance ID <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="wasapbot_instance_id" id="wasapbot_instance_id"
                            value="<?php echo e(old('wasapbot_instance_id', $settings->wasapbot_instance_id ?? '')); ?>"
                            placeholder="e.g., 683C0ED166349"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        <p class="mt-1 text-xs text-gray-500">Your WasapBot Instance ID</p>
                    </div>

                    <div>
                        <label for="access_token" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Access Token <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="access_token" id="access_token"
                            value="<?php echo e(old('access_token', $settings->access_token ?? '')); ?>"
                            placeholder="e.g., 67637dfdbe0fd"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        <p class="mt-1 text-xs text-gray-500">Your WasapBot Access Token</p>
                    </div>

                    <div>
                        <label for="wasapbot_port" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Port
                        </label>
                        <input type="text" name="wasapbot_port" id="wasapbot_port"
                            value="<?php echo e(old('wasapbot_port', $settings->wasapbot_port ?? '0010')); ?>"
                            placeholder="e.g., 0010"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        <p class="mt-1 text-xs text-gray-500">Default: 0010</p>
                    </div>

                    <div>
                        <label for="wasapbot_phone_number" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Phone Number
                        </label>
                        <input type="text" name="wasapbot_phone_number" id="wasapbot_phone_number"
                            value="<?php echo e(old('wasapbot_phone_number', $settings->wasapbot_phone_number ?? '')); ?>"
                            placeholder="e.g., 60129040085@s.whatsapp.net"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        <p class="mt-1 text-xs text-gray-500">Your WhatsApp number (optional)</p>
                    </div>
                </div>
            </div>

            <!-- Official WhatsApp API Credentials Section -->
            <div id="official_section" class="bg-white dark:bg-gray-800 shadow rounded-lg p-6" style="display: none;">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">
                    WhatsApp Official API Credentials
                </h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
                    Get your credentials from <a href="https://developers.facebook.com" target="_blank" class="text-blue-600 hover:underline">Meta Business</a>
                </p>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="phone_number_id_official" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Phone Number ID <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="phone_number_id" id="phone_number_id_official"
                            value="<?php echo e(old('phone_number_id', $settings->phone_number_id ?? '')); ?>"
                            placeholder="e.g., 123456789012345"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                    </div>

                    <div>
                        <label for="business_account_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Business Account ID
                        </label>
                        <input type="text" name="business_account_id" id="business_account_id"
                            value="<?php echo e(old('business_account_id', $settings->business_account_id ?? '')); ?>"
                            placeholder="e.g., 123456789012345"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                    </div>

                    <div class="md:col-span-2">
                        <label for="access_token_official" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Access Token <span class="text-red-500">*</span>
                        </label>
                        <textarea name="access_token" id="access_token_official" rows="2"
                            placeholder="e.g., EAAxxxxxxxxxxxxx..."
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white"><?php echo e(old('access_token', $settings->access_token ?? '')); ?></textarea>
                    </div>
                </div>
            </div>

            <!-- Twilio Credentials Section -->
            <div id="twilio_section" class="bg-white dark:bg-gray-800 shadow rounded-lg p-6" style="display: none;">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">
                    Twilio WhatsApp Credentials
                </h2>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="api_key_twilio" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Account SID <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="api_key" id="api_key_twilio"
                            value="<?php echo e(old('api_key', $settings->api_key ?? '')); ?>"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                    </div>

                    <div>
                        <label for="api_secret_twilio" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Auth Token <span class="text-red-500">*</span>
                        </label>
                        <input type="password" name="api_secret" id="api_secret_twilio"
                            value="<?php echo e(old('api_secret', $settings->api_secret ?? '')); ?>"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                    </div>

                    <div class="md:col-span-2">
                        <label for="phone_number_id_twilio" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Twilio WhatsApp Number <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="phone_number_id" id="phone_number_id_twilio"
                            value="<?php echo e(old('phone_number_id', $settings->phone_number_id ?? '')); ?>"
                            placeholder="whatsapp:+14155238886"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                    </div>
                </div>
            </div>

            <!-- WATI Credentials Section -->
            <div id="wati_section" class="bg-white dark:bg-gray-800 shadow rounded-lg p-6" style="display: none;">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">
                    WATI Credentials
                </h2>

                <div class="grid grid-cols-1 gap-4">
                    <div>
                        <label for="api_url_wati" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            WATI API URL <span class="text-red-500">*</span>
                        </label>
                        <input type="url" name="api_url" id="api_url_wati"
                            value="<?php echo e(old('api_url', $settings->api_url ?? '')); ?>"
                            placeholder="https://live-server-123.wati.io"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                    </div>

                    <div>
                        <label for="access_token_wati" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Access Token <span class="text-red-500">*</span>
                        </label>
                        <input type="password" name="access_token" id="access_token_wati"
                            value="<?php echo e(old('access_token', $settings->access_token ?? '')); ?>"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                    </div>
                </div>
            </div>

            <!-- Custom Webhook Section -->
            <div id="webhook_section" class="bg-white dark:bg-gray-800 shadow rounded-lg p-6" style="display: none;">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">
                    Custom Webhook Configuration
                </h2>

                <div class="grid grid-cols-1 gap-4">
                    <div>
                        <label for="api_url_webhook" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Webhook URL <span class="text-red-500">*</span>
                        </label>
                        <input type="url" name="api_url" id="api_url_webhook"
                            value="<?php echo e(old('api_url', $settings->api_url ?? '')); ?>"
                            placeholder="https://your-service.com/webhook"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                    </div>

                    <div>
                        <label for="api_key_webhook" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            API Key (Optional)
                        </label>
                        <input type="text" name="api_key" id="api_key_webhook"
                            value="<?php echo e(old('api_key', $settings->api_key ?? '')); ?>"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        <p class="mt-1 text-xs text-gray-500">Will be sent as X-API-Key header or Bearer token</p>
                    </div>
                </div>
            </div>

            <!-- Notification Triggers Section -->
            <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Notification Triggers</h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
                    Choose when to send WhatsApp notifications to customers
                </p>

                <div class="space-y-3">
                    <div class="flex items-start">
                        <input type="checkbox" name="notify_on_order_created" id="notify_on_order_created" value="1"
                            <?php echo e(old('notify_on_order_created', $settings->notify_on_order_created ?? false) ? 'checked' : ''); ?>

                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded mt-1">
                        <div class="ml-2">
                            <label for="notify_on_order_created" class="block text-sm text-gray-900 dark:text-white font-medium">
                                Order Created - When new order is received
                            </label>
                            <p class="text-xs text-gray-500 dark:text-gray-400 mt-0.5">
                                ℹ️ Only applies to internal orders (Sales Pages & Manual Checkout). Synced WooCommerce and Webhook orders are excluded to prevent spam.
                            </p>
                        </div>
                    </div>

                    <div class="flex items-center">
                        <input type="checkbox" name="notify_on_order_processing" id="notify_on_order_processing" value="1"
                            <?php echo e(old('notify_on_order_processing', $settings->notify_on_order_processing ?? false) ? 'checked' : ''); ?>

                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                        <label for="notify_on_order_processing" class="ml-2 block text-sm text-gray-900 dark:text-white">
                            Order Processing - When order status changes to processing
                        </label>
                    </div>

                    <div class="flex items-center">
                        <input type="checkbox" name="notify_on_order_completed" id="notify_on_order_completed" value="1"
                            <?php echo e(old('notify_on_order_completed', $settings->notify_on_order_completed ?? false) ? 'checked' : ''); ?>

                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                        <label for="notify_on_order_completed" class="ml-2 block text-sm text-gray-900 dark:text-white">
                            Order Completed - When order is marked as completed
                        </label>
                    </div>

                    <div class="flex items-center">
                        <input type="checkbox" name="notify_on_order_cancelled" id="notify_on_order_cancelled" value="1"
                            <?php echo e(old('notify_on_order_cancelled', $settings->notify_on_order_cancelled ?? false) ? 'checked' : ''); ?>

                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                        <label for="notify_on_order_cancelled" class="ml-2 block text-sm text-gray-900 dark:text-white">
                            Order Cancelled - When order is cancelled
                        </label>
                    </div>

                    <div class="flex items-center">
                        <input type="checkbox" name="notify_on_awb_generated" id="notify_on_awb_generated" value="1"
                            <?php echo e(old('notify_on_awb_generated', $settings->notify_on_awb_generated ?? true) ? 'checked' : ''); ?>

                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                        <label for="notify_on_awb_generated" class="ml-2 block text-sm text-gray-900 dark:text-white">
                            AWB Generated - When tracking number is generated
                        </label>
                    </div>
                </div>
            </div>

            <!-- Message Templates Section -->
            <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Message Templates</h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
                    Customize the message templates. Available variables: {customer_name}, {order_number}, {total}, {currency}, {tracking_number}, {courier}, {tracking_url}, {store_name}
                </p>

                <div class="space-y-4">
                    <div>
                        <label for="template_order_created" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Order Created Template
                        </label>
                        <textarea name="template_order_created" id="template_order_created" rows="4"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white font-mono text-sm"><?php echo old('template_order_created', $settings->template_order_created ?? \App\Models\WhatsAppSetting::getDefaultTemplates()['order_created']); ?></textarea>
                    </div>

                    <div>
                        <label for="template_order_processing" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Order Processing Template
                        </label>
                        <textarea name="template_order_processing" id="template_order_processing" rows="4"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white font-mono text-sm"><?php echo old('template_order_processing', $settings->template_order_processing ?? \App\Models\WhatsAppSetting::getDefaultTemplates()['order_processing']); ?></textarea>
                    </div>

                    <div>
                        <label for="template_order_completed" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Order Completed Template
                        </label>
                        <textarea name="template_order_completed" id="template_order_completed" rows="4"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white font-mono text-sm"><?php echo old('template_order_completed', $settings->template_order_completed ?? \App\Models\WhatsAppSetting::getDefaultTemplates()['order_completed']); ?></textarea>
                    </div>

                    <div>
                        <label for="template_order_cancelled" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Order Cancelled Template
                        </label>
                        <textarea name="template_order_cancelled" id="template_order_cancelled" rows="4"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white font-mono text-sm"><?php echo old('template_order_cancelled', $settings->template_order_cancelled ?? \App\Models\WhatsAppSetting::getDefaultTemplates()['order_cancelled']); ?></textarea>
                    </div>

                    <div>
                        <label for="template_awb_generated" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            AWB Generated Template
                        </label>
                        <textarea name="template_awb_generated" id="template_awb_generated" rows="4"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white font-mono text-sm"><?php echo old('template_awb_generated', $settings->template_awb_generated ?? \App\Models\WhatsAppSetting::getDefaultTemplates()['awb_generated']); ?></textarea>
                    </div>
                </div>
            </div>

            <!-- Additional Settings Section -->
            <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Additional Settings</h2>

                <div class="space-y-4">
                    <div>
                        <label for="sender_name" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Sender/Store Name
                        </label>
                        <input type="text" name="sender_name" id="sender_name"
                            value="<?php echo e(old('sender_name', $settings->sender_name ?? auth()->user()->company_name ?? '')); ?>"
                            placeholder="e.g., My Store"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        <p class="mt-1 text-xs text-gray-500">This will be used in message templates as {store_name}</p>
                    </div>

                    <div class="flex items-center">
                        <input type="checkbox" name="is_active" id="is_active" value="1"
                            <?php echo e(old('is_active', $settings->is_active ?? false) ? 'checked' : ''); ?>

                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                        <label for="is_active" class="ml-2 block text-sm text-gray-900 dark:text-white">
                            Enable WhatsApp Notifications
                        </label>
                    </div>
                </div>
            </div>

            <!-- Submit Button -->
            <div class="flex justify-end space-x-3">
                <a href="<?php echo e(route('dashboard')); ?>"
                    class="px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                    Cancel
                </a>
                <button type="submit"
                    class="px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                    Save Settings
                </button>
            </div>
        </form>
    </div>
</div>

<script>
function toggleProviderFields() {
    const provider = document.getElementById('provider').value;

    // Hide all provider sections
    document.getElementById('wasapbot_section').style.display = 'none';
    document.getElementById('official_section').style.display = 'none';
    document.getElementById('twilio_section').style.display = 'none';
    document.getElementById('wati_section').style.display = 'none';
    document.getElementById('webhook_section').style.display = 'none';

    // Disable all provider-specific fields
    document.querySelectorAll('#wasapbot_section input, #wasapbot_section textarea').forEach(field => field.disabled = true);
    document.querySelectorAll('#official_section input, #official_section textarea').forEach(field => field.disabled = true);
    document.querySelectorAll('#twilio_section input, #twilio_section textarea').forEach(field => field.disabled = true);
    document.querySelectorAll('#wati_section input, #wati_section textarea').forEach(field => field.disabled = true);
    document.querySelectorAll('#webhook_section input, #webhook_section textarea').forEach(field => field.disabled = true);

    // Show selected provider section and enable its fields
    if (provider === 'wasapbot') {
        document.getElementById('wasapbot_section').style.display = 'block';
        document.querySelectorAll('#wasapbot_section input, #wasapbot_section textarea').forEach(field => field.disabled = false);
    } else if (provider === 'official') {
        document.getElementById('official_section').style.display = 'block';
        document.querySelectorAll('#official_section input, #official_section textarea').forEach(field => field.disabled = false);
    } else if (provider === 'twilio') {
        document.getElementById('twilio_section').style.display = 'block';
        document.querySelectorAll('#twilio_section input, #twilio_section textarea').forEach(field => field.disabled = false);
    } else if (provider === 'wati') {
        document.getElementById('wati_section').style.display = 'block';
        document.querySelectorAll('#wati_section input, #wati_section textarea').forEach(field => field.disabled = false);
    } else if (provider === 'webhook') {
        document.getElementById('webhook_section').style.display = 'block';
        document.querySelectorAll('#webhook_section input, #webhook_section textarea').forEach(field => field.disabled = false);
    }
}

// Initialize on page load
document.addEventListener('DOMContentLoaded', function() {
    toggleProviderFields();
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\multistore\resources\views/whatsapp-settings/index.blade.php ENDPATH**/ ?>