<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
    <div class="max-w-4xl mx-auto">
        <!-- Header -->
        <div class="mb-6">
            <h1 class="text-2xl font-bold text-gray-900 dark:text-white">Courier Settings</h1>
            <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
                Configure your courier account details and shipping settings
            </p>
        </div>

        <!-- Courier Tabs Navigation -->
        <?php
            $activeCourier = request()->get('courier', 'poslaju');
        ?>
        <div class="mb-6">
            <div class="border-b border-gray-200 dark:border-gray-700">
                <nav class="-mb-px flex space-x-8" aria-label="Tabs">
                    <!-- Pos Laju Tab -->
                    <a href="<?php echo e(route('poslaju-settings.index', ['courier' => 'poslaju'])); ?>"
                       class="<?php if($activeCourier === 'poslaju'): ?> border-blue-500 text-blue-600 dark:text-blue-400 <?php else: ?> border-transparent text-gray-500 dark:text-gray-400 hover:text-gray-700 hover:border-gray-300 dark:hover:text-gray-300 <?php endif; ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                        <svg class="w-5 h-5 inline-block mr-2 -mt-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"/>
                        </svg>
                        Pos Laju
                    </a>

                    <!-- NinjaVan Tab -->
                    <a href="<?php echo e(route('poslaju-settings.index', ['courier' => 'ninjavan'])); ?>"
                       class="<?php if($activeCourier === 'ninjavan'): ?> border-blue-500 text-blue-600 dark:text-blue-400 <?php else: ?> border-transparent text-gray-500 dark:text-gray-400 hover:text-gray-700 hover:border-gray-300 dark:hover:text-gray-300 <?php endif; ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm group">
                        <svg class="w-5 h-5 inline-block mr-2 -mt-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                        </svg>
                        NinjaVan
                        <span class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800 dark:bg-yellow-900/30 dark:text-yellow-300">
                            Coming Soon
                        </span>
                    </a>

                    <!-- J&T Express Tab -->
                    <a href="<?php echo e(route('poslaju-settings.index', ['courier' => 'jnt'])); ?>"
                       class="<?php if($activeCourier === 'jnt'): ?> border-blue-500 text-blue-600 dark:text-blue-400 <?php else: ?> border-transparent text-gray-500 dark:text-gray-400 hover:text-gray-700 hover:border-gray-300 dark:hover:text-gray-300 <?php endif; ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                        <svg class="w-5 h-5 inline-block mr-2 -mt-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 8h14M5 8a2 2 0 110-4h14a2 2 0 110 4M5 8v10a2 2 0 002 2h10a2 2 0 002-2V8m-9 4h4"/>
                        </svg>
                        J&T Express
                        <span class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800 dark:bg-yellow-900/30 dark:text-yellow-300">
                            Coming Soon
                        </span>
                    </a>

                    <!-- EasyParcel Tab -->
                    <a href="<?php echo e(route('poslaju-settings.index', ['courier' => 'easyparcel'])); ?>"
                       class="<?php if($activeCourier === 'easyparcel'): ?> border-blue-500 text-blue-600 dark:text-blue-400 <?php else: ?> border-transparent text-gray-500 dark:text-gray-400 hover:text-gray-700 hover:border-gray-300 dark:hover:text-gray-300 <?php endif; ?> whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm">
                        <svg class="w-5 h-5 inline-block mr-2 -mt-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v13m0-13V6a2 2 0 112 2h-2zm0 0V5.5A2.5 2.5 0 109.5 8H12zm-7 4h14M5 12a2 2 0 110-4h14a2 2 0 110 4M5 12v7a2 2 0 002 2h10a2 2 0 002-2v-7"/>
                        </svg>
                        EasyParcel
                        <span class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800 dark:bg-yellow-900/30 dark:text-yellow-300">
                            Coming Soon
                        </span>
                    </a>
                </nav>
            </div>
        </div>

        <?php if(session('success')): ?>
            <div class="mb-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded-md">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="mb-4 p-4 bg-red-100 border border-red-400 text-red-700 rounded-md">
                <ul class="list-disc list-inside">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <!-- Pos Laju Settings Form -->
        <?php if($activeCourier === 'poslaju'): ?>
        <form action="<?php echo e(route('poslaju-settings.update')); ?>" method="POST" enctype="multipart/form-data" class="space-y-6">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <!-- API Credentials Section -->
            <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">API Credentials (OAuth 2.0)</h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
                    Enter your Pos Laju OAuth 2.0 credentials. Access tokens will be automatically managed.
                </p>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="app_code" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            App Code <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="app_code" id="app_code" required
                            value="<?php echo e(old('app_code', $settings->app_code ?? '')); ?>"
                            placeholder="e.g., YOURCOMPANY.SDN.BHD."
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        <p class="mt-1 text-xs text-gray-500">Your Pos Laju App Code</p>
                    </div>

                    <div>
                        <label for="secret_code" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Secret Code <span class="text-red-500">*</span>
                        </label>
                        <input type="password" name="secret_code" id="secret_code" required
                            value="<?php echo e(old('secret_code', $settings->secret_code ?? '')); ?>"
                            placeholder="e.g., YOURCOMPANY.SDN.BHD.@1234"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        <p class="mt-1 text-xs text-gray-500">Your Pos Laju Secret Code</p>
                    </div>

                    <div>
                        <label for="client_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Client ID <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="client_id" id="client_id" required
                            value="<?php echo e(old('client_id', $settings->client_id ?? '')); ?>"
                            placeholder="e.g., 95e37568-9d6c-4f16-bed0-681c6f2b1ad3"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        <p class="mt-1 text-xs text-gray-500">OAuth 2.0 Client ID (UUID format)</p>
                    </div>

                    <div>
                        <label for="client_secret" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Client Secret <span class="text-red-500">*</span>
                        </label>
                        <input type="password" name="client_secret" id="client_secret" required
                            value="<?php echo e(old('client_secret', $settings->client_secret ?? '')); ?>"
                            placeholder="e.g., b0cfa683-6563-4d44-a8e6-4d638591176d"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        <p class="mt-1 text-xs text-gray-500">OAuth 2.0 Client Secret (UUID format)</p>
                    </div>
                </div>

                <?php if($settings && $settings->hasValidToken()): ?>
                    <div class="mt-4 p-3 bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-md">
                        <div class="flex items-center">
                            <svg class="w-5 h-5 text-green-600 dark:text-green-400 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                            </svg>
                            <span class="text-sm text-green-800 dark:text-green-200">
                                ✓ OAuth Token Active (Expires: <?php echo e($settings->token_expires_at->diffForHumans()); ?>)
                            </span>
                        </div>
                    </div>
                <?php elseif($settings && $settings->hasOAuthCredentials()): ?>
                    <div class="mt-4 p-3 bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 rounded-md">
                        <div class="flex items-center">
                            <svg class="w-5 h-5 text-yellow-600 dark:text-yellow-400 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                            </svg>
                            <span class="text-sm text-yellow-800 dark:text-yellow-200">
                                Token will be generated automatically when you generate your first AWB
                            </span>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Deprecated fields (hidden, kept for backward compatibility) -->
                <input type="hidden" name="api_key" value="<?php echo e(old('api_key', $settings->api_key ?? '')); ?>">
                <input type="hidden" name="secret_key" value="<?php echo e(old('secret_key', $settings->secret_key ?? '')); ?>">
            </div>

            <!-- Account Information Section -->
            <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Account Information</h2>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="account_number" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Account Number <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="account_number" id="account_number" required
                            value="<?php echo e(old('account_number', $settings->account_number ?? '')); ?>"
                            placeholder="e.g., 8800564892"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        <p class="mt-1 text-xs text-gray-500">Registered Pos Malaysia account number (active account)</p>
                    </div>

                    <div>
                        <label for="poslaju_account_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Product Code <span class="text-red-500">*</span>
                        </label>
                        <select name="poslaju_account_id" id="poslaju_account_id" required
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                            <option value="80000000" <?php echo e(old('poslaju_account_id', $settings->poslaju_account_id ?? '80000000') == '80000000' ? 'selected' : ''); ?>>80000000 - Normal Pos Laju</option>
                            <option value="80000001" <?php echo e(old('poslaju_account_id', $settings->poslaju_account_id ?? '80000000') == '80000001' ? 'selected' : ''); ?>>80000001 - International Outbound</option>
                            <option value="80001121" <?php echo e(old('poslaju_account_id', $settings->poslaju_account_id ?? '80000000') == '80001121' ? 'selected' : ''); ?>>80001121 - International Air Parcel</option>
                        </select>
                        <p class="mt-1 text-xs text-gray-500">Standard Product code according to Pos Malaysia catalog</p>
                    </div>
                </div>
            </div>

            <!-- Shipping Configuration Section -->
            <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Shipping Configuration</h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
                    Configure default shipping settings for AWB generation.
                </p>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <!-- Hidden fields for database compatibility -->
                    <input type="hidden" name="product_code" value="<?php echo e(old('product_code', $settings->product_code ?? 'PL')); ?>">
                    <input type="hidden" name="webhook_required" value="0">

                    <div>
                        <label for="subscription_code" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Subscription Code
                        </label>
                        <input type="text" name="subscription_code" id="subscription_code"
                            value="<?php echo e(old('subscription_code', $settings->subscription_code ?? '')); ?>"
                            placeholder="e.g., ERD, MYCODE (leave empty to let Pos Laju auto-generate)"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        <p class="mt-1 text-xs text-gray-500">Optional: Leave empty to let Pos Laju auto-assign. Get valid codes from SendParcel Portal.</p>
                    </div>

                    <div>
                        <label for="item_type" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Item Type <span class="text-red-500">*</span>
                        </label>
                        <select name="item_type" id="item_type" required
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                            <option value="Document" <?php echo e(old('item_type', $settings->item_type ?? 'Parcel') == 'Document' ? 'selected' : ''); ?>>0 - Document</option>
                            <option value="Merchandise" <?php echo e(old('item_type', $settings->item_type ?? 'Parcel') == 'Merchandise' ? 'selected' : ''); ?>>1 - Merchandise</option>
                            <option value="Parcel" <?php echo e(old('item_type', $settings->item_type ?? 'Parcel') == 'Parcel' ? 'selected' : ''); ?>>2 - Parcel</option>
                        </select>
                        <p class="mt-1 text-xs text-gray-500">Item type code (0=Document, 1=Merchandise, 2=Parcel)</p>
                    </div>

                    <div>
                        <label for="service_level" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Service Level <span class="text-red-500">*</span>
                        </label>
                        <select name="service_level" id="service_level" required
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                            <option value="Standard" <?php echo e(old('service_level', $settings->service_level ?? 'Standard') == 'Standard' ? 'selected' : ''); ?>>Standard</option>
                            <option value="Express" <?php echo e(old('service_level', $settings->service_level ?? 'Standard') == 'Express' ? 'selected' : ''); ?>>Express</option>
                        </select>
                        <p class="mt-1 text-xs text-gray-500">Default value is "Standard"</p>
                    </div>

                    <div>
                        <label for="order_validity" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Order Validity (Days) <span class="text-red-500">*</span>
                        </label>
                        <input type="number" name="order_validity" id="order_validity" required min="7" max="30"
                            value="<?php echo e(old('order_validity', $settings->order_validity ?? 7)); ?>"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                        <p class="mt-1 text-xs text-gray-500">Number of days the order remains valid (Min: 7, Max: 30)</p>
                    </div>
                </div>
            </div>

            <!-- Sender Information Section -->
            <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Sender Information</h2>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label for="sender_name" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Sender Name <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="sender_name" id="sender_name" required
                            value="<?php echo e(old('sender_name', $settings->sender_name ?? auth()->user()->company_name ?? auth()->user()->name)); ?>"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                    </div>

                    <div>
                        <label for="sender_phone" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Sender Phone <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="sender_phone" id="sender_phone" required
                            value="<?php echo e(old('sender_phone', $settings->sender_phone ?? auth()->user()->company_phone)); ?>"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                    </div>

                    <div class="md:col-span-2">
                        <label for="sender_address" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Sender Address <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="sender_address" id="sender_address" required
                            value="<?php echo e(old('sender_address', $settings->sender_address ?? auth()->user()->company_address)); ?>"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                    </div>

                    <div>
                        <label for="sender_postcode" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Postcode <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="sender_postcode" id="sender_postcode" required
                            value="<?php echo e(old('sender_postcode', $settings->sender_postcode ?? auth()->user()->company_postcode)); ?>"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                    </div>

                    <div>
                        <label for="sender_city" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            City <span class="text-red-500">*</span>
                        </label>
                        <input type="text" name="sender_city" id="sender_city" required
                            value="<?php echo e(old('sender_city', $settings->sender_city ?? auth()->user()->company_city)); ?>"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                    </div>

                    <div class="md:col-span-2">
                        <label for="sender_state" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            State <span class="text-red-500">*</span>
                        </label>
                        <select name="sender_state" id="sender_state" required
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                            <option value="">Select State</option>
                            <?php $__currentLoopData = ['Johor', 'Kedah', 'Kelantan', 'Melaka', 'Negeri Sembilan', 'Pahang', 'Penang', 'Perak', 'Perlis', 'Selangor', 'Terengganu', 'Sabah', 'Sarawak', 'Kuala Lumpur', 'Labuan', 'Putrajaya']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($state); ?>" <?php echo e(old('sender_state', $settings->sender_state ?? auth()->user()->company_state) == $state ? 'selected' : ''); ?>>
                                    <?php echo e($state); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </div>

            <!-- Default Shipping Settings Section -->
            <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Default Shipping Settings</h2>

                <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <div>
                        <label for="default_weight" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Weight (Kg) <span class="text-red-500">*</span>
                        </label>
                        <input type="number" name="default_weight" id="default_weight" step="0.01" min="0.1" required
                            value="<?php echo e(old('default_weight', $settings->default_weight ?? '0.3')); ?>"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                    </div>

                    <div>
                        <label for="default_dimension_l" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Length (cm) <span class="text-red-500">*</span>
                        </label>
                        <input type="number" name="default_dimension_l" id="default_dimension_l" min="1" required
                            value="<?php echo e(old('default_dimension_l', $settings->default_dimension_l ?? '1')); ?>"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                    </div>

                    <div>
                        <label for="default_dimension_w" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Width (cm) <span class="text-red-500">*</span>
                        </label>
                        <input type="number" name="default_dimension_w" id="default_dimension_w" min="1" required
                            value="<?php echo e(old('default_dimension_w', $settings->default_dimension_w ?? '1')); ?>"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                    </div>

                    <div>
                        <label for="default_dimension_h" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Height (cm) <span class="text-red-500">*</span>
                        </label>
                        <input type="number" name="default_dimension_h" id="default_dimension_h" min="1" required
                            value="<?php echo e(old('default_dimension_h', $settings->default_dimension_h ?? '1')); ?>"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white">
                    </div>
                </div>
            </div>

            <!-- Branding Section -->
            <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Branding (AWB Labels)</h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
                    Upload logos to display on AWB shipping labels. Recommended size: 200x60px (PNG with transparent background)
                </p>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Poslaju/Courier Logo -->
                    <div>
                        <label for="poslaju_logo" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Courier Logo (Top Left)
                        </label>
                        <?php if($settings && $settings->poslaju_logo_path): ?>
                            <div class="mb-3 p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                                <img src="<?php echo e(asset($settings->poslaju_logo_path)); ?>" alt="Courier Logo" class="h-16 object-contain mb-2">
                                <label class="flex items-center text-sm text-gray-600 dark:text-gray-400">
                                    <input type="checkbox" name="remove_poslaju_logo" value="1" class="mr-2">
                                    Remove current logo
                                </label>
                            </div>
                        <?php endif; ?>
                        <input type="file" name="poslaju_logo" id="poslaju_logo" accept="image/*"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white text-sm">
                        <p class="mt-1 text-xs text-gray-500">Upload Pos Laju or other courier logo</p>
                    </div>

                    <!-- Company Logo -->
                    <div>
                        <label for="company_logo" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Company Logo (Top Right)
                        </label>
                        <?php if($settings && $settings->company_logo_path): ?>
                            <div class="mb-3 p-3 bg-gray-50 dark:bg-gray-700 rounded-lg">
                                <img src="<?php echo e(asset($settings->company_logo_path)); ?>" alt="Company Logo" class="h-16 object-contain mb-2">
                                <label class="flex items-center text-sm text-gray-600 dark:text-gray-400">
                                    <input type="checkbox" name="remove_company_logo" value="1" class="mr-2">
                                    Remove current logo
                                </label>
                            </div>
                        <?php endif; ?>
                        <input type="file" name="company_logo" id="company_logo" accept="image/*"
                            class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:text-white text-sm">
                        <p class="mt-1 text-xs text-gray-500">Upload your company logo</p>
                    </div>
                </div>
            </div>

            <!-- Settings Options Section -->
            <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Options</h2>

                <div class="space-y-3">
                    <div class="flex items-center">
                        <input type="checkbox" name="is_active" id="is_active" value="1"
                            <?php echo e(old('is_active', $settings->is_active ?? true) ? 'checked' : ''); ?>

                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                        <label for="is_active" class="ml-2 block text-sm text-gray-900 dark:text-white">
                            Enable Pos Laju Integration
                        </label>
                    </div>

                    <div class="flex items-center">
                        <input type="checkbox" name="test_mode" id="test_mode" value="1"
                            <?php echo e(old('test_mode', $settings->test_mode ?? false) ? 'checked' : ''); ?>

                            class="h-4 w-4 text-yellow-600 focus:ring-yellow-500 border-gray-300 rounded">
                        <label for="test_mode" class="ml-2 block text-sm text-gray-900 dark:text-white">
                            <span class="font-semibold text-yellow-600 dark:text-yellow-400">🧪 Test Mode</span> - Generate fake tracking numbers (for development/testing)
                        </label>
                    </div>
                    <p class="ml-6 text-xs text-gray-500 dark:text-gray-400">
                        When enabled, AWB generation will create test tracking numbers like TEST251023000001MY without calling Pos Laju API
                    </p>

                    <div class="flex items-center pt-2">
                        <input type="checkbox" name="hide_product_names" id="hide_product_names" value="1"
                            <?php echo e(old('hide_product_names', $settings->hide_product_names ?? false) ? 'checked' : ''); ?>

                            class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                        <label for="hide_product_names" class="ml-2 block text-sm text-gray-900 dark:text-white">
                            <span class="font-semibold">🔒 Hide Product Names on AWB</span> - Show only SKU for security
                        </label>
                    </div>
                    <p class="ml-6 text-xs text-gray-500 dark:text-gray-400">
                        When enabled, AWB labels will display SKU codes instead of full product names to prevent product information from being visible during shipping
                    </p>
                </div>
            </div>

            <!-- Webhook Configuration Info (Read-only) -->
            <div class="bg-gradient-to-br from-blue-50 to-indigo-50 dark:from-gray-800 dark:to-gray-700 border-2 border-blue-200 dark:border-blue-800 shadow rounded-lg p-6">
                <div class="flex items-center mb-4">
                    <svg class="w-6 h-6 text-blue-600 dark:text-blue-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                    </svg>
                    <h2 class="text-lg font-semibold text-gray-900 dark:text-white">Webhook Configuration (Auto Order Completion)</h2>
                </div>

                <p class="text-sm text-gray-700 dark:text-gray-300 mb-4">
                    Use these details to configure your Pos Laju webhook at
                    <a href="https://trackingintegration.pos.com.my/Tracking.WebhookV3.Portal/Subscriptions" target="_blank"
                       class="text-blue-600 dark:text-blue-400 hover:underline font-medium">
                        SendParcel Portal
                        <svg class="w-4 h-4 inline ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"/>
                        </svg>
                    </a>
                </p>

                <div class="space-y-4">
                    <!-- Webhook URL -->
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                            Post Back Address
                        </label>
                        <div class="flex items-center gap-2">
                            <input type="text" readonly
                                   value="<?php echo e(url('/api/poslaju/webhook')); ?>"
                                   id="webhook-url"
                                   class="flex-1 px-3 py-2 bg-white dark:bg-gray-900 border-2 border-gray-300 dark:border-gray-600 rounded-md text-sm font-mono text-gray-900 dark:text-white">
                            <button type="button" onclick="copyToClipboard('webhook-url')"
                                    class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 transition text-sm font-medium whitespace-nowrap">
                                <svg class="w-4 h-4 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"/>
                                </svg>
                                Copy
                            </button>
                        </div>
                    </div>

                    <!-- Configuration Details -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 bg-white dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                        <div>
                            <label class="block text-xs font-semibold text-gray-600 dark:text-gray-400 mb-1">Require Webhook</label>
                            <div class="text-sm text-gray-900 dark:text-white font-mono">☑ Checked</div>
                        </div>
                        <div>
                            <label class="block text-xs font-semibold text-gray-600 dark:text-gray-400 mb-1">Body ContentType</label>
                            <div class="text-sm text-gray-900 dark:text-white font-mono">None</div>
                        </div>
                        <div>
                            <label class="block text-xs font-semibold text-gray-600 dark:text-gray-400 mb-1">Authentication Type</label>
                            <div class="text-sm text-gray-900 dark:text-white font-mono">QueryString</div>
                        </div>
                        <div>
                            <label class="block text-xs font-semibold text-gray-600 dark:text-gray-400 mb-1">Require Authenticate</label>
                            <div class="text-sm text-gray-900 dark:text-white font-mono">☐ Unchecked</div>
                        </div>
                    </div>

                    <!-- Benefits Info -->
                    <div class="bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-lg p-4">
                        <h3 class="text-sm font-semibold text-green-800 dark:text-green-300 mb-2">✅ Webhook Benefits:</h3>
                        <ul class="text-sm text-green-700 dark:text-green-400 space-y-1 ml-4">
                            <li>• <strong>Auto-complete orders</strong> when Pos Laju delivers to customers</li>
                            <li>• <strong>Real-time tracking updates</strong> for all shipments</li>
                            <li>• <strong>Auto-sync to WooCommerce</strong> when order is completed</li>
                            <li>• <strong>Complete audit trail</strong> of all tracking events</li>
                        </ul>
                    </div>

                    <!-- Warning for Local -->
                    <?php if(str_contains(url('/'), 'localhost') || str_contains(url('/'), '.test') || str_contains(url('/'), '127.0.0.1')): ?>
                    <div class="bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 rounded-lg p-4">
                        <div class="flex items-start">
                            <svg class="w-5 h-5 text-yellow-600 dark:text-yellow-400 mr-2 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                            </svg>
                            <div class="text-sm text-yellow-700 dark:text-yellow-300">
                                <strong>Local Environment Detected:</strong> This webhook URL won't work on local development.
                                Use your production domain (https://yourdomain.com/api/poslaju/webhook) when deploying to live server.
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Submit Button -->
            <div class="flex justify-end space-x-3">
                <a href="<?php echo e(route('dashboard')); ?>"
                    class="px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-700 hover:bg-gray-50 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                    Cancel
                </a>
                <button type="submit"
                    class="px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                    Save Settings
                </button>
            </div>
        </form>
        <?php endif; ?>

        <!-- NinjaVan Coming Soon -->
        <?php if($activeCourier === 'ninjavan'): ?>
        <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-12 text-center">
            <div class="max-w-md mx-auto">
                <div class="mb-6">
                    <svg class="w-24 h-24 mx-auto text-gray-300 dark:text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                    </svg>
                </div>
                <h3 class="text-2xl font-bold text-gray-900 dark:text-white mb-3">NinjaVan Integration</h3>
                <p class="text-gray-600 dark:text-gray-400 mb-6">
                    NinjaVan courier integration is coming soon! This will allow you to:
                </p>
                <ul class="text-left text-gray-600 dark:text-gray-400 space-y-2 mb-8">
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-green-500 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Generate NinjaVan AWB tracking numbers</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-green-500 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Real-time shipment tracking</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-green-500 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Auto-complete orders on delivery</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-green-500 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Print shipping labels and AWB</span>
                    </li>
                </ul>
                <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4">
                    <p class="text-sm text-blue-700 dark:text-blue-300">
                        <strong>Stay tuned!</strong> We're working hard to bring NinjaVan integration to your store.
                    </p>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- J&T Express Coming Soon -->
        <?php if($activeCourier === 'jnt'): ?>
        <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-12 text-center">
            <div class="max-w-md mx-auto">
                <div class="mb-6">
                    <svg class="w-24 h-24 mx-auto text-gray-300 dark:text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M5 8h14M5 8a2 2 0 110-4h14a2 2 0 110 4M5 8v10a2 2 0 002 2h10a2 2 0 002-2V8m-9 4h4"/>
                    </svg>
                </div>
                <h3 class="text-2xl font-bold text-gray-900 dark:text-white mb-3">J&T Express Integration</h3>
                <p class="text-gray-600 dark:text-gray-400 mb-6">
                    J&T Express courier integration is coming soon! This will allow you to:
                </p>
                <ul class="text-left text-gray-600 dark:text-gray-400 space-y-2 mb-8">
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-green-500 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Generate J&T Express AWB tracking numbers</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-green-500 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Real-time shipment tracking</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-green-500 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Auto-complete orders on delivery</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-green-500 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Print shipping labels and AWB</span>
                    </li>
                </ul>
                <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4">
                    <p class="text-sm text-blue-700 dark:text-blue-300">
                        <strong>Stay tuned!</strong> We're working hard to bring J&T Express integration to your store.
                    </p>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- EasyParcel Coming Soon -->
        <?php if($activeCourier === 'easyparcel'): ?>
        <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-12 text-center">
            <div class="max-w-md mx-auto">
                <div class="mb-6">
                    <svg class="w-24 h-24 mx-auto text-gray-300 dark:text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 8v13m0-13V6a2 2 0 112 2h-2zm0 0V5.5A2.5 2.5 0 109.5 8H12zm-7 4h14M5 12a2 2 0 110-4h14a2 2 0 110 4M5 12v7a2 2 0 002 2h10a2 2 0 002-2v-7"/>
                    </svg>
                </div>
                <h3 class="text-2xl font-bold text-gray-900 dark:text-white mb-3">EasyParcel Integration</h3>
                <p class="text-gray-600 dark:text-gray-400 mb-6">
                    EasyParcel multi-courier integration is coming soon! This will allow you to:
                </p>
                <ul class="text-left text-gray-600 dark:text-gray-400 space-y-2 mb-8">
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-green-500 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Access multiple couriers through one platform</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-green-500 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Compare shipping rates instantly</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-green-500 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Generate AWB for multiple courier services</span>
                    </li>
                    <li class="flex items-start">
                        <svg class="w-5 h-5 text-green-500 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Track all shipments in one place</span>
                    </li>
                </ul>
                <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4">
                    <p class="text-sm text-blue-700 dark:text-blue-300">
                        <strong>Stay tuned!</strong> We're working hard to bring EasyParcel integration to your store.
                    </p>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<script>
function copyToClipboard(elementId) {
    const element = document.getElementById(elementId);
    element.select();
    element.setSelectionRange(0, 99999); // For mobile devices

    try {
        document.execCommand('copy');

        // Show success feedback
        const button = event.target.closest('button');
        const originalHTML = button.innerHTML;
        button.innerHTML = '<svg class="w-4 h-4 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>Copied!';
        button.classList.add('bg-green-600');
        button.classList.remove('bg-blue-600');

        setTimeout(() => {
            button.innerHTML = originalHTML;
            button.classList.remove('bg-green-600');
            button.classList.add('bg-blue-600');
        }, 2000);
    } catch (err) {
        alert('Failed to copy. Please copy manually: ' + element.value);
    }
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\multistore\resources\views/poslaju-settings/index.blade.php ENDPATH**/ ?>