<?php $__env->startSection('title', 'Create TikTok Shop'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6">
        <a href="<?php echo e(route('tiktok-shops-management.index')); ?>"
           class="inline-flex items-center text-sm text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-200">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
            </svg>
            Back to TikTok Shops
        </a>
    </div>

    <div class="bg-white dark:bg-gray-800 shadow rounded-lg">
        <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
            <h2 class="text-xl font-semibold">Create New TikTok Shop</h2>
            <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                Add a new TikTok Shop to the system. You can assign managers to this shop later.
            </p>
        </div>

        <form action="<?php echo e(route('tiktok-shops-management.store')); ?>" method="POST" class="p-6 space-y-6">
            <?php echo csrf_field(); ?>

            <!-- Shop Name -->
            <div>
                <label for="name" class="block text-sm font-medium mb-2">
                    Shop Name <span class="text-red-500">*</span>
                </label>
                <input type="text"
                       name="name"
                       id="name"
                       value="<?php echo e(old('name')); ?>"
                       required
                       class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent dark:bg-gray-700 dark:text-white"
                       placeholder="e.g., Mamadil TikTok Shop">
                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                    Enter a unique name for this TikTok Shop account
                </p>
            </div>

            <!-- Description -->
            <div>
                <label for="description" class="block text-sm font-medium mb-2">
                    Description (Optional)
                </label>
                <textarea name="description"
                          id="description"
                          rows="3"
                          class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent dark:bg-gray-700 dark:text-white"
                          placeholder="e.g., Official TikTok Shop for electronics products"><?php echo e(old('description')); ?></textarea>
                <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Status -->
            <div>
                <label class="block text-sm font-medium mb-2">Status</label>
                <div class="flex items-center">
                    <input type="checkbox"
                           name="is_active"
                           id="is_active"
                           value="1"
                           <?php echo e(old('is_active', true) ? 'checked' : ''); ?>

                           class="w-4 h-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500 dark:border-gray-600 dark:bg-gray-700">
                    <label for="is_active" class="ml-2 text-sm">
                        Active (Shop is currently in use)
                    </label>
                </div>
                <?php $__errorArgs = ['is_active'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Assign Managers -->
            <div>
                <label class="block text-sm font-medium mb-2">Assign Managers (Optional)</label>
                <p class="text-xs text-gray-500 dark:text-gray-400 mb-3">
                    Select which managers can access and upload data to this TikTok Shop
                </p>
                <div class="space-y-2">
                    <?php
                        $managers = \App\Models\User::where('role', 'manager')->orderBy('name')->get();
                    ?>
                    <?php if($managers->count() > 0): ?>
                        <?php $__currentLoopData = $managers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $manager): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label class="flex items-center space-x-2">
                                <input type="checkbox"
                                       name="manager_ids[]"
                                       value="<?php echo e($manager->id); ?>"
                                       <?php echo e((is_array(old('manager_ids')) && in_array($manager->id, old('manager_ids'))) ? 'checked' : ''); ?>

                                       class="rounded border-gray-300 dark:border-gray-600 text-blue-600 focus:ring-blue-500">
                                <span class="text-sm"><?php echo e($manager->name); ?> (<?php echo e($manager->email); ?>)</span>
                            </label>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <p class="text-sm text-gray-500 dark:text-gray-400">
                            No managers available. You can assign managers later from User Management.
                        </p>
                    <?php endif; ?>
                    <?php $__errorArgs = ['manager_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <!-- Form Actions -->
            <div class="flex items-center justify-end gap-3 pt-4 border-t border-gray-200 dark:border-gray-700">
                <a href="<?php echo e(route('tiktok-shops-management.index')); ?>"
                   class="px-5 py-2.5 border border-gray-300 dark:border-gray-600 text-gray-700 dark:text-gray-300 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 font-medium">
                    Cancel
                </a>
                <button type="submit"
                        class="px-5 py-2.5 bg-blue-600 text-white rounded-lg hover:bg-blue-700 shadow-md hover:shadow-lg transition-all duration-200 font-medium">
                    Create TikTok Shop
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\multistore\resources\views/tiktok-shops-management/create.blade.php ENDPATH**/ ?>