<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
    <!-- Header -->
    <div class="mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-900 dark:text-white">📱 TikTok Shop Management</h1>
                <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">Simplified view of your TikTok Shop sales and advertising costs</p>
            </div>
            <a href="<?php echo e(route('tiktok-shop.upload')); ?>" class="px-5 py-2.5 bg-blue-600 text-white text-base font-bold rounded-lg hover:bg-blue-700 shadow-md transition-all">
                Upload New Data
            </a>
        </div>
    </div>

    <!-- Shop Selector (if multiple shops available) -->
    <?php if($availableShops->count() > 1): ?>
    <div class="mb-6">
        <form method="GET" action="<?php echo e(route('tiktok-shop.index')); ?>" class="flex items-center gap-4">
            <input type="hidden" name="start_date" value="<?php echo e($startDate); ?>">
            <input type="hidden" name="end_date" value="<?php echo e($endDate); ?>">

            <label class="text-sm font-medium text-gray-700 dark:text-gray-300">Filter by Shop:</label>
            <select name="shop_id" onchange="this.form.submit()" class="px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 dark:bg-gray-700 dark:text-white">
                <option value="">All TikTok Shops</option>
                <?php $__currentLoopData = $availableShops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($shop->id); ?>" <?php echo e($selectedShopId == $shop->id ? 'selected' : ''); ?>>
                        <?php echo e($shop->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

            <?php if($selectedShopId): ?>
                <a href="<?php echo e(route('tiktok-shop.index', ['start_date' => $startDate, 'end_date' => $endDate])); ?>"
                   class="text-sm text-blue-600 hover:text-blue-800 dark:text-blue-400">
                    Clear Filter
                </a>
            <?php endif; ?>
        </form>
    </div>
    <?php endif; ?>

    <!-- Multi-Shop Summary Card (shown when viewing all shops) -->
    <?php if($shopSummaries && $shopSummaries->count() > 0): ?>
    <div class="bg-gradient-to-r from-blue-50 to-indigo-50 dark:from-blue-900/20 dark:to-indigo-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-6 mb-6">
        <h3 class="text-lg font-bold text-blue-900 dark:text-blue-200 mb-4">
            📊 All TikTok Shops Summary (<?php echo e(\Carbon\Carbon::parse($startDate)->format('M d')); ?> - <?php echo e(\Carbon\Carbon::parse($endDate)->format('M d, Y')); ?>)
        </h3>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            <?php
                $totalOrders = 0;
                $totalRevenue = 0;
                $totalSettlement = 0;
            ?>

            <?php $__currentLoopData = $availableShops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $shopData = $shopSummaries->get($shop->id);
                    $orders = $shopData->total_orders ?? 0;
                    $revenue = $shopData->total_revenue ?? 0;
                    $settlement = $shopData->total_settlement ?? 0;

                    $totalOrders += $orders;
                    $totalRevenue += $revenue;
                    $totalSettlement += $settlement;
                ?>

                <a href="<?php echo e(route('tiktok-shop.index', ['shop_id' => $shop->id, 'start_date' => $startDate, 'end_date' => $endDate])); ?>"
                   class="block bg-white dark:bg-gray-800 rounded-lg p-4 border-2 border-transparent hover:border-blue-500 transition-all shadow-sm hover:shadow-md">
                    <div class="flex items-start justify-between mb-2">
                        <h4 class="font-semibold text-gray-900 dark:text-white"><?php echo e($shop->name); ?></h4>
                        <svg class="w-5 h-5 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                        </svg>
                    </div>
                    <div class="space-y-1 text-sm">
                        <div class="flex justify-between">
                            <span class="text-gray-600 dark:text-gray-400">Orders:</span>
                            <span class="font-semibold text-gray-900 dark:text-white"><?php echo e(number_format($orders)); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600 dark:text-gray-400">Revenue:</span>
                            <span class="font-semibold text-green-600 dark:text-green-400">RM <?php echo e(number_format($revenue, 2)); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600 dark:text-gray-400">Settlement:</span>
                            <span class="font-semibold text-indigo-600 dark:text-indigo-400">RM <?php echo e(number_format($settlement, 2)); ?></span>
                        </div>
                    </div>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Grand Total -->
        <?php if($availableShops->count() > 1): ?>
        <div class="mt-4 pt-4 border-t-2 border-blue-300 dark:border-blue-700">
            <div class="flex justify-between items-center">
                <span class="text-sm font-bold text-blue-900 dark:text-blue-200">TOTAL (All Shops):</span>
                <div class="flex gap-6 text-sm font-bold">
                    <span class="text-gray-900 dark:text-white"><?php echo e(number_format($totalOrders)); ?> orders</span>
                    <span class="text-green-600 dark:text-green-400">RM <?php echo e(number_format($totalRevenue, 2)); ?></span>
                    <span class="text-indigo-600 dark:text-indigo-400">RM <?php echo e(number_format($totalSettlement, 2)); ?></span>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
    <?php endif; ?>

    <!-- Summary Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
        <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-4">
            <div class="text-xs text-gray-600 dark:text-gray-400">Total Orders</div>
            <div class="text-2xl font-bold text-gray-900 dark:text-white"><?php echo e(number_format($summary->total_orders ?? 0)); ?></div>
            <div class="text-xs text-gray-500 dark:text-gray-400 mt-1"><?php echo e($summary->total_refunds ?? 0); ?> refunds</div>
        </div>

        <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-4">
            <div class="text-xs text-gray-600 dark:text-gray-400">Gross Revenue</div>
            <div class="text-2xl font-bold text-green-600 dark:text-green-400">RM <?php echo e(number_format($summary->total_revenue ?? 0, 2)); ?></div>
            <?php if(($summary->total_refund_amount ?? 0) > 0): ?>
            <div class="text-xs text-red-600 dark:text-red-400 mt-1">- RM <?php echo e(number_format($summary->total_refund_amount ?? 0, 2)); ?> refunds</div>
            <?php else: ?>
            <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">Avg: RM <?php echo e(number_format($summary->avg_order_value ?? 0, 2)); ?></div>
            <?php endif; ?>
        </div>

        <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-4">
            <div class="text-xs text-gray-600 dark:text-gray-400">TikTok Fees</div>
            <div class="text-2xl font-bold text-orange-600 dark:text-orange-400">RM <?php echo e(number_format(abs($summary->total_fees ?? 0), 2)); ?></div>
            <?php $feePercent = ($summary->total_revenue ?? 0) > 0 ? (abs($summary->total_fees ?? 0) / ($summary->total_revenue ?? 0)) * 100 : 0; ?>
            <div class="text-xs text-gray-500 dark:text-gray-400 mt-1"><?php echo e(number_format($feePercent, 1)); ?>% of gross</div>
        </div>

        <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-4 border-2 border-indigo-500">
            <div class="text-xs text-gray-600 dark:text-gray-400 flex items-center">
                <span>💰 Bank Transfer Amount</span>
            </div>
            <div class="text-2xl font-bold text-indigo-600 dark:text-indigo-400">RM <?php echo e(number_format($summary->total_settlement ?? 0, 2)); ?></div>
            <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">After refunds & fees</div>
        </div>
    </div>

    <!-- Revenue Breakdown (Optional: Show calculation) -->
    <?php if(($summary->total_refund_amount ?? 0) > 0): ?>
    <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4 mb-6">
        <h3 class="text-sm font-semibold text-blue-900 dark:text-blue-200 mb-3">💡 Settlement Calculation</h3>
        <div class="space-y-2 text-sm">
            <div class="flex justify-between text-gray-700 dark:text-gray-300">
                <span>Gross Revenue (<?php echo e(number_format($summary->total_orders ?? 0)); ?> orders)</span>
                <span class="font-mono">RM <?php echo e(number_format($summary->total_revenue ?? 0, 2)); ?></span>
            </div>
            <div class="flex justify-between text-red-600 dark:text-red-400">
                <span>Less: Refunds (<?php echo e($summary->total_refunds ?? 0); ?> refunds)</span>
                <span class="font-mono">- RM <?php echo e(number_format($summary->total_refund_amount ?? 0, 2)); ?></span>
            </div>
            <div class="flex justify-between text-orange-600 dark:text-orange-400">
                <span>Less: TikTok Fees</span>
                <span class="font-mono">- RM <?php echo e(number_format(abs($summary->total_fees ?? 0), 2)); ?></span>
            </div>
            <div class="border-t border-blue-300 dark:border-blue-700 pt-2 mt-2"></div>
            <div class="flex justify-between text-indigo-600 dark:text-indigo-400 font-bold text-base">
                <span>= Bank Transfer Amount</span>
                <span class="font-mono">RM <?php echo e(number_format($summary->total_settlement ?? 0, 2)); ?></span>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Ads Spending Summary -->
    <?php if($adsSpending && count($adsSpending) > 0): ?>
    <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6 mb-6">
        <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">💰 Ads Spending by Month</h2>

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                <thead class="bg-purple-50 dark:bg-purple-900/20">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-purple-900 dark:text-purple-200">Month</th>
                        <th class="px-6 py-3 text-right text-xs font-semibold text-purple-900 dark:text-purple-200">Transactions</th>
                        <th class="px-6 py-3 text-right text-xs font-semibold text-purple-900 dark:text-purple-200">Total Spent</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                    <?php $__currentLoopData = $adsSpending; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-purple-50 dark:hover:bg-purple-900/10">
                        <td class="px-6 py-3 text-sm font-medium text-gray-900 dark:text-white">
                            <?php echo e(\Carbon\Carbon::parse($month->month . '-01')->format('F Y')); ?>

                        </td>
                        <td class="px-6 py-3 text-sm text-right text-gray-600 dark:text-gray-400">
                            <?php echo e(number_format($month->transaction_count)); ?> payments
                        </td>
                        <td class="px-6 py-3 text-sm text-right font-mono font-bold text-purple-600 dark:text-purple-400">
                            RM <?php echo e(number_format($month->total_spent, 2)); ?>

                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <tr class="bg-purple-100 dark:bg-purple-900/30 font-bold">
                        <td class="px-6 py-3 text-sm text-gray-900 dark:text-white">Total</td>
                        <td class="px-6 py-3 text-sm text-right text-gray-900 dark:text-white">
                            <?php echo e(number_format($adsSpending->sum('transaction_count'))); ?> payments
                        </td>
                        <td class="px-6 py-3 text-sm text-right font-mono text-purple-700 dark:text-purple-300">
                            RM <?php echo e(number_format($adsSpending->sum('total_spent'), 2)); ?>

                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

        <p class="text-xs text-gray-500 dark:text-gray-400 mt-3">
            💡 This shows your TikTok Ads spending. Use this for manual ROI calculations across all sales channels.
        </p>
    </div>
    <?php endif; ?>

    <!-- Filter -->
    <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-4 mb-6">
        <!-- Quick Filter Buttons -->
        <div class="mb-4">
            <label class="text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2 block">Quick Filters:</label>
            <div class="flex flex-wrap gap-2">
                <?php
                    $quickFilters = [
                        'this_month' => ['label' => 'This Month', 'start' => now()->startOfMonth()->format('Y-m-d'), 'end' => now()->endOfMonth()->format('Y-m-d')],
                        'last_month' => ['label' => 'Last Month', 'start' => now()->subMonth()->startOfMonth()->format('Y-m-d'), 'end' => now()->subMonth()->endOfMonth()->format('Y-m-d')],
                        '6_months' => ['label' => '6 Months', 'start' => now()->subMonths(6)->startOfMonth()->format('Y-m-d'), 'end' => now()->endOfMonth()->format('Y-m-d')],
                        'this_year' => ['label' => 'This Year', 'start' => now()->startOfYear()->format('Y-m-d'), 'end' => now()->endOfYear()->format('Y-m-d')],
                        'last_year' => ['label' => 'Last Year', 'start' => now()->subYear()->startOfYear()->format('Y-m-d'), 'end' => now()->subYear()->endOfYear()->format('Y-m-d')],
                    ];
                    $isCustom = true;
                ?>

                <?php $__currentLoopData = $quickFilters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $filter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $isActive = ($startDate === $filter['start'] && $endDate === $filter['end']);
                        if ($isActive) $isCustom = false;
                    ?>
                    <a href="<?php echo e(route('tiktok-shop.index', array_merge(['start_date' => $filter['start'], 'end_date' => $filter['end']], $selectedShopId ? ['shop_id' => $selectedShopId] : []))); ?>"
                       class="px-4 py-2 text-sm font-medium rounded-lg transition-all <?php echo e($isActive ? 'bg-blue-600 text-white shadow-md' : 'bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-300 hover:bg-gray-200 dark:hover:bg-gray-600'); ?>">
                        <?php echo e($filter['label']); ?>

                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <button type="button" onclick="toggleCustomRange()" id="customRangeBtn"
                        class="px-4 py-2 text-sm font-medium rounded-lg transition-all <?php echo e($isCustom ? 'bg-blue-600 text-white shadow-md' : 'bg-gray-100 dark:bg-gray-700 text-gray-700 dark:text-gray-300 hover:bg-gray-200 dark:hover:bg-gray-600'); ?>">
                    Custom Range
                </button>
            </div>
        </div>

        <!-- Custom Range Form (Hidden by default, shown when Custom Range is active) -->
        <div id="customRangeForm" style="display: <?php echo e($isCustom ? 'block' : 'none'); ?>;" class="border-t border-gray-200 dark:border-gray-700 pt-4">
            <form method="GET" action="<?php echo e(route('tiktok-shop.index')); ?>" class="flex gap-3 items-end">
                <?php if($selectedShopId): ?>
                    <input type="hidden" name="shop_id" value="<?php echo e($selectedShopId); ?>">
                <?php endif; ?>
                <div class="flex-1">
                    <label class="text-xs text-gray-600 dark:text-gray-400">Settlement Start Date</label>
                    <input type="date" name="start_date" value="<?php echo e($startDate); ?>" required class="w-full px-3 py-2 text-sm border rounded dark:bg-gray-700 dark:border-gray-600">
                </div>
                <div class="flex-1">
                    <label class="text-xs text-gray-600 dark:text-gray-400">Settlement End Date</label>
                    <input type="date" name="end_date" value="<?php echo e($endDate); ?>" required class="w-full px-3 py-2 text-sm border rounded dark:bg-gray-700 dark:border-gray-600">
                </div>
                <button type="submit" class="px-5 py-2.5 bg-blue-600 text-white text-base font-bold rounded-lg hover:bg-blue-700 shadow-md transition-all">Filter</button>
            </form>
        </div>

        <p class="text-xs text-gray-500 dark:text-gray-400 mt-3">💡 Filtering by settlement date (when TikTok paid you), not order date</p>
    </div>

    <script>
        function toggleCustomRange() {
            const form = document.getElementById('customRangeForm');
            const isHidden = form.style.display === 'none';
            form.style.display = isHidden ? 'block' : 'none';
        }
    </script>

    <!-- Transactions List -->
    <div class="bg-white dark:bg-gray-800 shadow rounded-lg overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
            <h2 class="text-lg font-semibold text-gray-900 dark:text-white">Transactions (<?php echo e($transactions->total()); ?>)</h2>
        </div>

        <?php if($transactions->count() > 0): ?>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 dark:text-gray-300">Settled Date</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 dark:text-gray-300">Order ID</th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 dark:text-gray-300">Type</th>
                        <th class="px-6 py-3 text-right text-xs font-semibold text-gray-700 dark:text-gray-300">Revenue</th>
                        <th class="px-6 py-3 text-right text-xs font-semibold text-gray-700 dark:text-gray-300">Fees</th>
                        <th class="px-6 py-3 text-right text-xs font-semibold text-gray-700 dark:text-gray-300">Net</th>
                        <th class="px-6 py-3 text-center text-xs font-semibold text-gray-700 dark:text-gray-300">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                    <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
                        <td class="px-6 py-3 text-sm text-gray-900 dark:text-white">
                            <?php echo e($transaction->settled_date ? $transaction->settled_date->format('Y-m-d') : '-'); ?>

                            <?php if($transaction->order_date != $transaction->settled_date): ?>
                            <span class="text-xs text-gray-500 dark:text-gray-400 block">Order: <?php echo e($transaction->order_date->format('Y-m-d')); ?></span>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-3 text-sm font-mono text-gray-600 dark:text-gray-400"><?php echo e(Str::limit($transaction->order_id, 20)); ?></td>
                        <td class="px-6 py-3">
                            <?php if($transaction->type === 'Order'): ?>
                                <span class="px-2 py-1 text-xs rounded bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200">Order</span>
                            <?php else: ?>
                                <span class="px-2 py-1 text-xs rounded bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200"><?php echo e($transaction->type); ?></span>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-3 text-sm text-right font-mono text-gray-900 dark:text-white">RM <?php echo e(number_format($transaction->total_revenue, 2)); ?></td>
                        <td class="px-6 py-3 text-sm text-right font-mono text-red-600">RM <?php echo e(number_format(abs($transaction->total_fees), 2)); ?></td>
                        <td class="px-6 py-3 text-sm text-right font-mono font-semibold text-indigo-600">RM <?php echo e(number_format($transaction->net_settlement, 2)); ?></td>
                        <td class="px-6 py-3 text-center">
                            <form action="<?php echo e(route('tiktok-shop.destroy', $transaction->id)); ?>" method="POST" class="inline" onsubmit="return confirm('Delete this transaction?')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="px-3 py-1.5 bg-red-600 text-white text-xs font-semibold rounded hover:bg-red-700 transition-all">Delete</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <div class="px-6 py-4 border-t border-gray-200 dark:border-gray-700">
            <?php echo e($transactions->links()); ?>

        </div>
        <?php else: ?>
        <div class="p-12 text-center">
            <div class="text-4xl mb-4">📱</div>
            <p class="text-gray-600 dark:text-gray-400 mb-4 text-lg font-medium">No TikTok Shop data yet</p>
            <a href="<?php echo e(route('tiktok-shop.upload')); ?>" class="px-6 py-3 bg-blue-600 text-white text-base font-bold rounded-lg hover:bg-blue-700 shadow-md transition-all inline-block">
                Upload Your First Report
            </a>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\multistore\resources\views/tiktok-shop/index.blade.php ENDPATH**/ ?>