<?php $__env->startSection('title', 'Edit Order #' . $order->order_number); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6">
        <h1 class="text-2xl font-bold">Edit Order #<?php echo e($order->order_number); ?></h1>
        <p class="text-gray-600 dark:text-gray-400">
            <?php if($order->store): ?>
                Store: <?php echo e($order->store->name); ?>

            <?php elseif($order->webhookSource): ?>
                Source: <?php echo e($order->webhookSource->name); ?>

            <?php elseif($order->is_manual): ?>
                Source: Checkout Form
            <?php else: ?>
                Source: Manual Order
            <?php endif; ?>
        </p>
    </div>

    <!-- Success Message -->
    <?php if(session('success')): ?>
        <div class="mb-6 p-4 bg-green-100 border-l-4 border-green-500 text-green-700 dark:bg-green-900 dark:text-green-200">
            <p class="font-medium"><?php echo e(session('success')); ?></p>
        </div>
    <?php endif; ?>

    <!-- Error Message -->
    <?php if(session('error')): ?>
        <div class="mb-6 p-4 bg-red-100 border-l-4 border-red-500 text-red-700 dark:bg-red-900 dark:text-red-200">
            <p class="font-medium"><?php echo e(session('error')); ?></p>
        </div>
    <?php endif; ?>

    <!-- Validation Errors -->
    <?php if($errors->any()): ?>
        <div class="mb-6 p-4 bg-red-100 border-l-4 border-red-500 text-red-700 dark:bg-red-900 dark:text-red-200">
            <p class="font-medium mb-2">Please fix the following errors:</p>
            <ul class="list-disc list-inside">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('orders.update', $order)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <!-- Order Status -->
            <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
                <h3 class="text-lg font-semibold mb-4">Order Status</h3>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium mb-2">Status</label>
                        <select name="status" 
                                class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700">
                            <option value="processing" <?php echo e($order->status == 'processing' ? 'selected' : ''); ?>>Processing</option>
                            <option value="completed" <?php echo e($order->status == 'completed' ? 'selected' : ''); ?>>Completed</option>
                            <option value="cancelled" <?php echo e($order->status == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                            <option value="refunded" <?php echo e($order->status == 'refunded' ? 'selected' : ''); ?>>Refunded</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-2">Payment Method</label>
                        <input type="text" value="<?php echo e($order->payment_method_title); ?>" 
                               class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700" 
                               readonly>
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-2">Total</label>
                        <input type="text" value="<?php echo e($order->formatCurrency()); ?>"
                               class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                               readonly>
                    </div>
                </div>
            </div>

            <!-- Billing Information -->
            <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
                <h3 class="text-lg font-semibold mb-4">Billing Information</h3>
                <div class="space-y-4">
                    <?php
                        // Support both WooCommerce format (first_name/last_name) and sales page format (name)
                        $billingFirstName = $order->billing['first_name'] ?? '';
                        $billingLastName = $order->billing['last_name'] ?? '';
                        $billingName = $order->billing['name'] ?? '';

                        // If sales page format (has 'name'), split it or use as first name
                        if ($billingName && !$billingFirstName && !$billingLastName) {
                            $nameParts = explode(' ', $billingName, 2);
                            $billingFirstName = $nameParts[0] ?? '';
                            $billingLastName = $nameParts[1] ?? '';
                        }

                        // Support both WooCommerce format (address_1) and sales page format (address)
                        $billingAddress = $order->billing['address_1'] ?? $order->billing['address'] ?? '';
                    ?>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium mb-2">First Name</label>
                            <input type="text" name="billing[first_name]"
                                   value="<?php echo e($billingFirstName); ?>"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 uppercase"
                                   style="text-transform: uppercase;">
                        </div>
                        <div>
                            <label class="block text-sm font-medium mb-2">Last Name</label>
                            <input type="text" name="billing[last_name]"
                                   value="<?php echo e($billingLastName); ?>"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 uppercase"
                                   style="text-transform: uppercase;">
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-2">Email</label>
                        <input type="email" name="billing[email]"
                               value="<?php echo e($order->billing['email'] ?? ''); ?>"
                               class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700">
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-2">Phone</label>
                        <input type="text" name="billing[phone]"
                               value="<?php echo e($order->billing['phone'] ?? ''); ?>"
                               class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700">
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-2">Address</label>
                        <input type="text" name="billing[address_1]"
                               value="<?php echo e($billingAddress); ?>"
                               class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 uppercase"
                               style="text-transform: uppercase;">
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium mb-2">City</label>
                            <input type="text" name="billing[city]"
                                   value="<?php echo e($order->billing['city'] ?? ''); ?>"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 uppercase"
                                   style="text-transform: uppercase;">
                        </div>
                        <div>
                            <label class="block text-sm font-medium mb-2">Postcode</label>
                            <input type="text" name="billing[postcode]"
                                   value="<?php echo e($order->billing['postcode'] ?? ''); ?>"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Shipping Information -->
            <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
                <h3 class="text-lg font-semibold mb-4">Shipping Information</h3>
                <div class="space-y-4">
                    <?php
                        // Support both WooCommerce format (first_name/last_name) and sales page format (name)
                        $shippingFirstName = $order->shipping['first_name'] ?? '';
                        $shippingLastName = $order->shipping['last_name'] ?? '';
                        $shippingName = $order->shipping['name'] ?? '';

                        // If sales page format (has 'name'), split it or use as first name
                        if ($shippingName && !$shippingFirstName && !$shippingLastName) {
                            $nameParts = explode(' ', $shippingName, 2);
                            $shippingFirstName = $nameParts[0] ?? '';
                            $shippingLastName = $nameParts[1] ?? '';
                        }

                        // Support both WooCommerce format (address_1) and sales page format (address)
                        $shippingAddress = $order->shipping['address_1'] ?? $order->shipping['address'] ?? '';
                    ?>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium mb-2">First Name</label>
                            <input type="text" name="shipping[first_name]"
                                   value="<?php echo e($shippingFirstName); ?>"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 uppercase"
                                   style="text-transform: uppercase;">
                        </div>
                        <div>
                            <label class="block text-sm font-medium mb-2">Last Name</label>
                            <input type="text" name="shipping[last_name]"
                                   value="<?php echo e($shippingLastName); ?>"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 uppercase"
                                   style="text-transform: uppercase;">
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-2">Address</label>
                        <input type="text" name="shipping[address_1]"
                               value="<?php echo e($shippingAddress); ?>"
                               class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 uppercase"
                               style="text-transform: uppercase;">
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium mb-2">City</label>
                            <input type="text" name="shipping[city]"
                                   value="<?php echo e($order->shipping['city'] ?? ''); ?>"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 uppercase"
                                   style="text-transform: uppercase;">
                        </div>
                        <div>
                            <label class="block text-sm font-medium mb-2">Postcode</label>
                            <input type="text" name="shipping[postcode]"
                                   value="<?php echo e($order->shipping['postcode'] ?? ''); ?>"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Order Items -->
            <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
                <h3 class="text-lg font-semibold mb-4">Order Items</h3>
                <div class="space-y-2">
                    <?php $__currentLoopData = $order->getExpandedLineItems(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expandedItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $item = $expandedItem['item'];
                        $isBundle = $expandedItem['is_bundle'];
                        $bundleDetails = $expandedItem['bundle_details'];
                    ?>
                    <div class="py-2 border-b border-gray-200 dark:border-gray-700 <?php echo e($isBundle ? 'bg-purple-50 dark:bg-purple-900/10 px-3 rounded' : ''); ?>">
                        <div class="flex justify-between">
                            <div>
                                <div class="font-medium flex items-center gap-2">
                                    <?php echo e($item['name']); ?>

                                    <?php if($isBundle): ?>
                                        <span class="px-2 py-0.5 text-xs font-medium rounded bg-purple-100 text-purple-800 dark:bg-purple-900 dark:text-purple-200">
                                            BUNDLE
                                        </span>
                                    <?php endif; ?>
                                </div>
                                <div class="text-sm text-gray-500 dark:text-gray-400">
                                    Qty: <?php echo e($item['quantity']); ?> × <?php echo e($order->formatCurrency($item['price'])); ?>

                                </div>

                                <?php if($isBundle && $bundleDetails): ?>
                                    <div class="mt-2 ml-4 text-sm space-y-1">
                                        <?php $__currentLoopData = $bundleDetails['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bundleItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="text-gray-600 dark:text-gray-400">
                                                - <?php echo e($bundleItem['name'] ?? $bundleItem['sku']); ?> x<?php echo e($bundleItem['quantity']); ?>

                                                <?php if(isset($bundleItem['sku']) && $bundleItem['sku']): ?>
                                                    <span class="text-gray-500">(<?php echo e($bundleItem['sku']); ?>)</span>
                                                <?php endif; ?>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="font-medium">
                                <?php echo e($order->formatCurrency(($item['total'] ?? ($item['price'] * $item['quantity'])))); ?>

                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="mt-6 flex justify-end space-x-4">
            <a href="<?php echo e(route('orders.index')); ?>" 
               class="px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700">
                Cancel
            </a>
            <button type="submit" 
                    class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700">
                Save Changes
            </button>
        </div>
    </form>

    <!-- Order History -->
    <?php if($order->logs->count() > 0): ?>
    <div class="mt-8 bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
        <div class="flex items-center justify-between mb-4">
            <h3 class="text-lg font-semibold">Order History</h3>
            <span class="text-sm text-gray-500 dark:text-gray-400">
                <?php echo e($order->logs->count()); ?> <?php echo e($order->logs->count() === 1 ? 'entry' : 'entries'); ?>

            </span>
        </div>
        <div class="space-y-4">
            <?php $__currentLoopData = $order->logs->take(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="border border-gray-200 dark:border-gray-700 rounded-lg p-4 bg-gray-50 dark:bg-gray-900">
                <!-- Log Header -->
                <div class="flex items-start justify-between mb-3">
                    <div>
                        <div class="flex items-center gap-2">
                            <span class="font-medium text-gray-900 dark:text-gray-100">
                                <?php echo e($log->user->name ?? 'System'); ?>

                            </span>
                            <span class="px-2 py-0.5 text-xs font-medium rounded bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200">
                                <?php echo e(ucfirst($log->action)); ?>

                            </span>
                        </div>
                        <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                            <?php echo e($log->created_at->format('M d, Y H:i:s')); ?>

                        </div>
                    </div>
                </div>

                <!-- Changes Details -->
                <?php if($log->old_data && $log->new_data): ?>
                    <?php
                        $hasChanges = false;
                    ?>
                    <div class="mt-3 space-y-2">
                        <?php $__currentLoopData = $log->new_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $newValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $oldValue = $log->old_data[$key] ?? null;

                                // Skip if no change
                                if ($oldValue === $newValue) {
                                    continue;
                                }

                                $hasChanges = true;

                                // Format field name
                                $fieldName = ucfirst(str_replace(['_', '.'], ' ', $key));

                                // Handle nested arrays (like billing, shipping)
                                if (is_array($newValue) && is_array($oldValue)) {
                                    // This is a nested field like billing or shipping
                                    $nestedChanges = [];
                                    foreach ($newValue as $nestedKey => $nestedNewValue) {
                                        $nestedOldValue = $oldValue[$nestedKey] ?? '';
                                        if ($nestedOldValue != $nestedNewValue) {
                                            $nestedChanges[] = [
                                                'field' => ucfirst(str_replace('_', ' ', $nestedKey)),
                                                'old' => $nestedOldValue,
                                                'new' => $nestedNewValue
                                            ];
                                        }
                                    }

                                    if (count($nestedChanges) > 0) {
                                        echo '<div class="pl-3 border-l-2 border-blue-300 dark:border-blue-600">';
                                        echo '<div class="text-xs font-semibold text-gray-700 dark:text-gray-300 mb-1">' . $fieldName . ':</div>';
                                        foreach ($nestedChanges as $change) {
                                            echo '<div class="text-xs text-gray-600 dark:text-gray-400 ml-2">';
                                            echo '<span class="font-medium">' . $change['field'] . ':</span> ';
                                            echo '<span class="line-through text-red-600 dark:text-red-400">' . ($change['old'] ?: '(empty)') . '</span>';
                                            echo ' → ';
                                            echo '<span class="text-green-600 dark:text-green-400 font-medium">' . ($change['new'] ?: '(empty)') . '</span>';
                                            echo '</div>';
                                        }
                                        echo '</div>';
                                    }
                                } else {
                                    // Simple field change
                                    $displayOld = is_string($oldValue) ? $oldValue : json_encode($oldValue);
                                    $displayNew = is_string($newValue) ? $newValue : json_encode($newValue);
                            ?>
                                    <div class="text-xs text-gray-600 dark:text-gray-400">
                                        <span class="font-medium"><?php echo e($fieldName); ?>:</span>
                                        <span class="line-through text-red-600 dark:text-red-400"><?php echo e($displayOld ?: '(empty)'); ?></span>
                                        →
                                        <span class="text-green-600 dark:text-green-400 font-medium"><?php echo e($displayNew ?: '(empty)'); ?></span>
                                    </div>
                            <?php
                                }
                            ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <?php if(!$hasChanges): ?>
                            <div class="text-xs text-gray-500 dark:text-gray-400 italic">
                                No changes detected
                            </div>
                        <?php endif; ?>
                    </div>
                <?php else: ?>
                    <div class="text-xs text-gray-500 dark:text-gray-400 italic">
                        No change details available
                    </div>
                <?php endif; ?>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php if($order->logs->count() > 10): ?>
            <div class="text-center pt-4 border-t border-gray-200 dark:border-gray-700">
                <p class="text-sm text-gray-500 dark:text-gray-400">
                    Showing 10 most recent entries. <?php echo e($order->logs->count() - 10); ?> older entries hidden for performance.
                </p>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\multistore\resources\views/orders/edit.blade.php ENDPATH**/ ?>