<?php $__env->startSection('title', 'Add New User'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6">
        <h1 class="text-2xl font-bold">Add New User</h1>
        <p class="text-gray-600 dark:text-gray-400">Create a new admin or seller account</p>
    </div>

    <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
        <form action="<?php echo e(route('users.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>

            <div class="space-y-6">
                <!-- Account Information -->
                <div>
                    <h3 class="text-lg font-semibold mb-4 border-b pb-2">Account Information</h3>
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium mb-2">Name *</label>
                            <input type="text" name="name" value="<?php echo e(old('name')); ?>" required
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="John Doe">
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">Email *</label>
                            <input type="email" name="email" value="<?php echo e(old('email')); ?>" required
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="john@example.com">
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">Password *</label>
                            <input type="password" name="password" required
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="Minimum 8 characters">
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">Confirm Password *</label>
                            <input type="password" name="password_confirmation" required
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="Re-enter password">
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">Role *</label>
                            <select name="role" id="role" required
                                    class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700">
                                <option value="">Select Role</option>
                                <option value="admin" <?php echo e(old('role') === 'admin' ? 'selected' : ''); ?>>Admin - Full access to all stores</option>
                                <option value="seller" <?php echo e(old('role') === 'seller' ? 'selected' : ''); ?>>Seller - Limited to assigned stores</option>
                                <option value="manager" <?php echo e(old('role') === 'manager' ? 'selected' : ''); ?>>Manager - Monitor and process orders for assigned sellers</option>
                            </select>
                            <?php $__errorArgs = ['role'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

                <!-- Store Assignment (Seller Only) -->
                <div id="store-assignment" style="display: none;">
                    <h3 class="text-lg font-semibold mb-4 border-b pb-2">Store Assignment</h3>
                    <div class="space-y-2">
                        <?php if($stores->count() > 0): ?>
                            <?php $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <label class="flex items-center space-x-2">
                                    <input type="checkbox" name="store_ids[]" value="<?php echo e($store->id); ?>"
                                           <?php echo e(is_array(old('store_ids')) && in_array($store->id, old('store_ids')) ? 'checked' : ''); ?>

                                           class="rounded border-gray-300 dark:border-gray-600">
                                    <span class="text-sm"><?php echo e($store->name); ?></span>
                                </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <p class="text-sm text-gray-500 dark:text-gray-400">No stores available. Create stores first.</p>
                        <?php endif; ?>
                        <?php $__errorArgs = ['store_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <!-- Seller Assignment (Manager Only) -->
                <div id="seller-assignment" style="display: none;">
                    <h3 class="text-lg font-semibold mb-4 border-b pb-2">Seller Assignment</h3>
                    <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
                        Select which sellers this manager can monitor and process orders for.
                    </p>
                    <div class="space-y-2">
                        <?php
                            $sellers = \App\Models\User::where('role', 'seller')->orderBy('name')->get();
                        ?>
                        <?php if($sellers->count() > 0): ?>
                            <?php $__currentLoopData = $sellers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seller): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <label class="flex items-center space-x-2">
                                    <input type="checkbox" name="seller_ids[]" value="<?php echo e($seller->id); ?>"
                                           <?php echo e(is_array(old('seller_ids')) && in_array($seller->id, old('seller_ids')) ? 'checked' : ''); ?>

                                           class="rounded border-gray-300 dark:border-gray-600">
                                    <span class="text-sm"><?php echo e($seller->name); ?> (<?php echo e($seller->email); ?>)</span>
                                </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <p class="text-sm text-gray-500 dark:text-gray-400">No sellers available. Create sellers first.</p>
                        <?php endif; ?>
                        <?php $__errorArgs = ['seller_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <!-- Company Information (Optional) -->
                <div>
                    <h3 class="text-lg font-semibold mb-4 border-b pb-2">Company Information (Optional)</h3>
                    <div class="grid grid-cols-2 gap-4">
                        <div class="col-span-2">
                            <label class="block text-sm font-medium mb-2">Company Name</label>
                            <input type="text" name="company_name" value="<?php echo e(old('company_name')); ?>"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="ABC Trading Sdn Bhd">
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">Registration Number</label>
                            <input type="text" name="company_registration" value="<?php echo e(old('company_registration')); ?>"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="202301234567">
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">Company Phone</label>
                            <input type="text" name="company_phone" value="<?php echo e(old('company_phone')); ?>"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="+60123456789">
                        </div>

                        <div class="col-span-2">
                            <label class="block text-sm font-medium mb-2">Company Address</label>
                            <textarea name="company_address" rows="2"
                                      class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                      placeholder="123 Business Street"><?php echo e(old('company_address')); ?></textarea>
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">City</label>
                            <input type="text" name="company_city" value="<?php echo e(old('company_city')); ?>"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="Kuala Lumpur">
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">State</label>
                            <input type="text" name="company_state" value="<?php echo e(old('company_state')); ?>"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="Selangor">
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">Postcode</label>
                            <input type="text" name="company_postcode" value="<?php echo e(old('company_postcode')); ?>"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="50000">
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">Country</label>
                            <input type="text" name="company_country" value="<?php echo e(old('company_country', 'Malaysia')); ?>"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="Malaysia">
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">Company Email</label>
                            <input type="email" name="company_email" value="<?php echo e(old('company_email')); ?>"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="info@company.com">
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">Website</label>
                            <input type="url" name="company_website" value="<?php echo e(old('company_website')); ?>"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="https://company.com">
                        </div>
                    </div>
                </div>
            </div>

            <div class="mt-6 flex justify-end gap-3">
                <a href="<?php echo e(route('users.index')); ?>"
                   class="inline-flex items-center gap-2 px-5 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors font-medium">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                    Cancel
                </a>
                <button type="submit"
                        class="inline-flex items-center gap-2 px-5 py-2.5 bg-blue-600 text-white rounded-lg hover:bg-blue-700 shadow-md hover:shadow-lg transition-all font-medium">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                    Create User
                </button>
            </div>
        </form>
    </div>
</div>

<script>
    // Show/hide store and seller assignment based on role
    document.getElementById('role').addEventListener('change', function() {
        const storeAssignment = document.getElementById('store-assignment');
        const sellerAssignment = document.getElementById('seller-assignment');

        if (this.value === 'seller') {
            storeAssignment.style.display = 'block';
            sellerAssignment.style.display = 'none';
        } else if (this.value === 'manager') {
            storeAssignment.style.display = 'none';
            sellerAssignment.style.display = 'block';
        } else {
            storeAssignment.style.display = 'none';
            sellerAssignment.style.display = 'none';
        }
    });

    // Trigger on page load if role is pre-selected
    const currentRole = document.getElementById('role').value;
    if (currentRole === 'seller') {
        document.getElementById('store-assignment').style.display = 'block';
    } else if (currentRole === 'manager') {
        document.getElementById('seller-assignment').style.display = 'block';
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\multistore\resources\views/users/create.blade.php ENDPATH**/ ?>