<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50 dark:bg-gray-900 py-8">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">

        <!-- Header -->
        <div class="mb-8">
            <h1 class="text-3xl font-bold text-gray-900 dark:text-white">Google Sheets Sync</h1>
            <p class="mt-2 text-gray-600 dark:text-gray-400">
                Automatically sync your orders to Google Sheets in real-time
            </p>
        </div>

        <!-- Success/Error Messages -->
        <?php if(session('success')): ?>
            <div class="mb-6 bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 text-green-800 dark:text-green-200 px-4 py-3 rounded-lg">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="mb-6 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 text-red-800 dark:text-red-200 px-4 py-3 rounded-lg">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('info')): ?>
            <div class="mb-6 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 text-blue-800 dark:text-blue-200 px-4 py-3 rounded-lg">
                <?php echo e(session('info')); ?>

            </div>
        <?php endif; ?>

        <!-- Main Card -->
        <div class="bg-white dark:bg-gray-800 shadow-lg rounded-lg overflow-hidden">

            <!-- Feature Explanation -->
            <div class="p-6 border-b border-gray-200 dark:border-gray-700">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">
                    How It Works
                </h2>
                <div class="space-y-3 text-sm text-gray-600 dark:text-gray-400">
                    <div class="flex items-start">
                        <svg class="w-5 h-5 text-green-500 mr-3 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Every order you create will automatically sync to your personal Google Sheet</span>
                    </div>
                    <div class="flex items-start">
                        <svg class="w-5 h-5 text-green-500 mr-3 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>The Google Sheet is created in YOUR Google Drive - you own it completely</span>
                    </div>
                    <div class="flex items-start">
                        <svg class="w-5 h-5 text-green-500 mr-3 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Access your sales data from anywhere via Google Sheets mobile app</span>
                    </div>
                    <div class="flex items-start">
                        <svg class="w-5 h-5 text-green-500 mr-3 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span>Create custom reports, charts, and formulas in your sheet</span>
                    </div>
                </div>
            </div>

            <!-- Connection Status -->
            <div class="p-6">
                <?php if(auth()->user()->google_sheets_sync_enabled): ?>
                    <!-- Connected State -->
                    <div class="flex items-center justify-between p-4 bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-lg mb-6">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <svg class="w-8 h-8 text-green-500" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <h3 class="text-lg font-semibold text-green-900 dark:text-green-100">
                                    Connected
                                </h3>
                                <p class="text-sm text-green-700 dark:text-green-300">
                                    <?php echo e(auth()->user()->google_email); ?>

                                </p>
                                <?php if(auth()->user()->google_sheets_last_sync): ?>
                                    <p class="text-xs text-green-600 dark:text-green-400 mt-1">
                                        Last synced: <?php echo e(auth()->user()->google_sheets_last_sync->diffForHumans()); ?>

                                    </p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Actions for Connected State -->
                    <div class="space-y-4">
                        <!-- Main Action Buttons (all in one line) -->
                        <div class="flex flex-wrap gap-3">
                            <!-- Open Google Sheet -->
                            <?php if(auth()->user()->google_sheet_id): ?>
                                <a href="https://docs.google.com/spreadsheets/d/<?php echo e(auth()->user()->google_sheet_id); ?>"
                                   target="_blank"
                                   class="inline-flex items-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition">
                                    <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                        <path d="M11 3a1 1 0 100 2h2.586l-6.293 6.293a1 1 0 101.414 1.414L15 6.414V9a1 1 0 102 0V4a1 1 0 00-1-1h-5z"/>
                                        <path d="M5 5a2 2 0 00-2 2v8a2 2 0 002 2h8a2 2 0 002-2v-3a1 1 0 10-2 0v3H5V7h3a1 1 0 000-2H5z"/>
                                    </svg>
                                    Google Sheet
                                </a>
                            <?php endif; ?>

                            <!-- Sync 10 Orders -->
                            <form action="<?php echo e(route('google-sheets.sync-recent')); ?>" method="POST" class="inline-block">
                                <?php echo csrf_field(); ?>
                                <button type="submit"
                                        class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition">
                                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                                    </svg>
                                    Sync 10 Orders
                                </button>
                            </form>

                            <!-- Disconnect -->
                            <form action="<?php echo e(route('google-sheets.disconnect')); ?>" method="POST" class="inline-block"
                                  onsubmit="return confirm('Are you sure? Your orders will no longer sync to Google Sheets. Your existing sheet will remain in your Google Drive.');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit"
                                        class="inline-flex items-center px-4 py-2 bg-red-600 hover:bg-red-700 text-white font-medium rounded-lg transition">
                                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                                    </svg>
                                    Disconnect Google Account
                                </button>
                            </form>
                        </div>

                        <!-- Help Text -->
                        <p class="text-xs text-gray-500 dark:text-gray-400">
                            💡 For historical data, please enter past orders manually to avoid rate limiting.
                        </p>

                        <!-- Disaster Recovery: Import Orders (Admin Only or Impersonating) -->
                        <?php if(auth()->user()->isAdmin() || session()->has('impersonate')): ?>
                            <form action="<?php echo e(route('google-sheets.import-preview')); ?>" method="GET" class="inline-block">
                                <input type="hidden" name="user_id" value="<?php echo e(auth()->user()->id); ?>">
                                <button type="submit"
                                        class="inline-flex items-center px-4 py-2 bg-orange-600 hover:bg-orange-700 text-white font-medium rounded-lg transition">
                                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-8l-4-4m0 0L8 8m4-4v12"/>
                                    </svg>
                                    Import Missing Orders
                                </button>
                            </form>
                        <?php endif; ?>
                    </div>

                    <!-- Disaster Recovery Information (Admin Only or Impersonating) -->
                    <?php if(auth()->user()->isAdmin() || session()->has('impersonate')): ?>
                        <div class="mt-6 p-4 bg-orange-50 dark:bg-orange-900/20 border border-orange-200 dark:border-orange-800 rounded-lg">
                            <div class="flex gap-3">
                                <svg class="w-5 h-5 text-orange-600 dark:text-orange-400 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                                </svg>
                                <div class="flex-1">
                                    <h4 class="text-sm font-semibold text-orange-900 dark:text-orange-200 mb-1">Disaster Recovery</h4>
                                    <p class="text-sm text-orange-800 dark:text-orange-300 mb-2">
                                        Use "Import Missing Orders" to recover orders from Google Sheets after database restore.
                                    </p>
                                    <ul class="text-xs text-orange-700 dark:text-orange-400 space-y-1 list-disc list-inside">
                                        <li><strong>Step 1:</strong> Put site in <a href="<?php echo e(route('settings.index')); ?>" class="underline hover:text-orange-900">Maintenance Mode</a></li>
                                        <li><strong>Step 2:</strong> Restore database backup</li>
                                        <li><strong>Step 3:</strong> Impersonate each seller and click "Import Missing Orders"</li>
                                        <li><strong>Step 4:</strong> Review conflicts, then confirm import for each seller</li>
                                        <li><strong>Step 5:</strong> Bring site back up from Settings</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                <?php else: ?>
                    <!-- Not Connected State -->
                    <div class="flex items-center justify-between p-4 bg-gray-50 dark:bg-gray-700/50 border border-gray-200 dark:border-gray-600 rounded-lg mb-6">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100">
                                    Not Connected
                                </h3>
                                <p class="text-sm text-gray-600 dark:text-gray-400">
                                    Connect your Google account to start syncing orders
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Connect Button -->
                    <a href="<?php echo e(route('google-sheets.auth')); ?>"
                       class="inline-flex items-center px-6 py-3 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition shadow-lg hover:shadow-xl">
                        <svg class="w-6 h-6 mr-3" viewBox="0 0 48 48">
                            <path fill="#FFC107" d="M43.611,20.083H42V20H24v8h11.303c-1.649,4.657-6.08,8-11.303,8c-6.627,0-12-5.373-12-12c0-6.627,5.373-12,12-12c3.059,0,5.842,1.154,7.961,3.039l5.657-5.657C34.046,6.053,29.268,4,24,4C12.955,4,4,12.955,4,24c0,11.045,8.955,20,20,20c11.045,0,20-8.955,20-20C44,22.659,43.862,21.35,43.611,20.083z"/>
                            <path fill="#FF3D00" d="M6.306,14.691l6.571,4.819C14.655,15.108,18.961,12,24,12c3.059,0,5.842,1.154,7.961,3.039l5.657-5.657C34.046,6.053,29.268,4,24,4C16.318,4,9.656,8.337,6.306,14.691z"/>
                            <path fill="#4CAF50" d="M24,44c5.166,0,9.86-1.977,13.409-5.192l-6.19-5.238C29.211,35.091,26.715,36,24,36c-5.202,0-9.619-3.317-11.283-7.946l-6.522,5.025C9.505,39.556,16.227,44,24,44z"/>
                            <path fill="#1976D2" d="M43.611,20.083H42V20H24v8h11.303c-0.792,2.237-2.231,4.166-4.087,5.571c0.001-0.001,0.002-0.001,0.003-0.002l6.19,5.238C36.971,39.205,44,34,44,24C44,22.659,43.862,21.35,43.611,20.083z"/>
                        </svg>
                        Connect Google Account
                    </a>

                    <p class="mt-4 text-sm text-gray-500 dark:text-gray-400">
                        By connecting, you authorize this app to create and manage a Google Sheet in your Google Drive.
                    </p>
                <?php endif; ?>
            </div>

        </div>

        <!-- FAQ -->
        <div class="mt-8 bg-white dark:bg-gray-800 shadow-lg rounded-lg overflow-hidden">
            <div class="p-6">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">
                    Frequently Asked Questions
                </h2>

                <div class="space-y-4">
                    <details class="group">
                        <summary class="cursor-pointer font-medium text-gray-900 dark:text-white hover:text-blue-600 dark:hover:text-blue-400">
                            What data is synced to Google Sheets?
                        </summary>
                        <p class="mt-2 text-sm text-gray-600 dark:text-gray-400 pl-4">
                            Order number, date, customer details (name, phone, email, address), products, quantities, SKUs, order total, payment method, status, and tracking number.
                        </p>
                    </details>

                    <details class="group">
                        <summary class="cursor-pointer font-medium text-gray-900 dark:text-white hover:text-blue-600 dark:hover:text-blue-400">
                            When does the sync happen?
                        </summary>
                        <p class="mt-2 text-sm text-gray-600 dark:text-gray-400 pl-4">
                            Immediately after you create or update an order from the sales page or checkout form. The sync usually completes within 5 seconds.
                        </p>
                    </details>

                    <details class="group">
                        <summary class="cursor-pointer font-medium text-gray-900 dark:text-white hover:text-blue-600 dark:hover:text-blue-400">
                            Can I edit the Google Sheet?
                        </summary>
                        <p class="mt-2 text-sm text-gray-600 dark:text-gray-400 pl-4">
                            Yes! The sheet is created in your Google Drive and you have full control. You can add formulas, charts, or custom columns. However, don't delete the header row.
                        </p>
                    </details>

                    <details class="group">
                        <summary class="cursor-pointer font-medium text-gray-900 dark:text-white hover:text-blue-600 dark:hover:text-blue-400">
                            What happens if I disconnect?
                        </summary>
                        <p class="mt-2 text-sm text-gray-600 dark:text-gray-400 pl-4">
                            New orders will stop syncing to Google Sheets. Your existing Google Sheet will remain in your Drive unchanged. You can reconnect anytime.
                        </p>
                    </details>

                    <details class="group">
                        <summary class="cursor-pointer font-medium text-gray-900 dark:text-white hover:text-blue-600 dark:hover:text-blue-400">
                            Can admin see my Google Sheet?
                        </summary>
                        <p class="mt-2 text-sm text-gray-600 dark:text-gray-400 pl-4">
                            No. The sheet is created in YOUR Google Drive using YOUR Google account. Only you have access to it.
                        </p>
                    </details>
                </div>
            </div>
        </div>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\multistore\resources\views/settings/google-sheets.blade.php ENDPATH**/ ?>