<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Header -->
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-900 dark:text-white">👥 Seller KPI Performance</h1>
        <p class="text-gray-600 dark:text-gray-400">Track individual seller performance and achievements</p>
    </div>

    <?php echo $__env->make('forecasting.partials.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Filters -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm p-4 mb-6">
        <form method="GET" action="<?php echo e(route('forecasting.seller-kpi.index')); ?>" class="flex flex-wrap gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Year</label>
                <select name="year" class="form-select rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white">
                    <?php for($y = date('Y'); $y >= 2022; $y--): ?>
                        <option value="<?php echo e($y); ?>" <?php echo e($year == $y ? 'selected' : ''); ?>><?php echo e($y); ?></option>
                    <?php endfor; ?>
                </select>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Month</label>
                <select name="month" class="form-select rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white">
                    <?php $__currentLoopData = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m => $monthName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($m + 1); ?>" <?php echo e($month == ($m + 1) ? 'selected' : ''); ?>><?php echo e($monthName); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Grade Filter</label>
                <select name="grade" class="form-select rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white">
                    <option value="">All Grades</option>
                    <option value="A" <?php echo e(request('grade') == 'A' ? 'selected' : ''); ?>>A (Exceeding)</option>
                    <option value="B" <?php echo e(request('grade') == 'B' ? 'selected' : ''); ?>>B (Good)</option>
                    <option value="C" <?php echo e(request('grade') == 'C' ? 'selected' : ''); ?>>C (Average)</option>
                    <option value="D" <?php echo e(request('grade') == 'D' ? 'selected' : ''); ?>>D (Below)</option>
                    <option value="F" <?php echo e(request('grade') == 'F' ? 'selected' : ''); ?>>F (Needs Attention)</option>
                </select>
            </div>

            <div class="flex items-end">
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-md">
                    Filter
                </button>
            </div>

            <div class="flex items-end ml-auto gap-2">
                <a href="<?php echo e(route('forecasting.seller-kpi.set-targets')); ?>" class="bg-purple-600 hover:bg-purple-700 text-white px-4 py-2 rounded-md">
                    Set Targets
                </a>
                <button type="button" onclick="syncSales()" class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-md">
                    Sync Sales Data
                </button>
            </div>
        </form>
    </div>

    <!-- Summary Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm p-4">
            <div class="text-sm text-gray-600 dark:text-gray-400 mb-1">Total Sellers</div>
            <div class="text-2xl font-bold text-gray-800 dark:text-white"><?php echo e($summary['total_sellers']); ?></div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm p-4">
            <div class="text-sm text-gray-600 dark:text-gray-400 mb-1">
                Total Sales (Direct Sales Only)
                <span class="text-xs block text-gray-500 dark:text-gray-500 mt-1">Sum of all sellers' direct sales</span>
            </div>
            <div class="text-2xl font-bold text-gray-800 dark:text-white">
                RM <?php echo e(number_format($summary['total_sales'], 2)); ?>

            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm p-4">
            <div class="text-sm text-gray-600 dark:text-gray-400 mb-1">Avg Achievement</div>
            <div class="text-2xl font-bold text-gray-800 dark:text-white">
                <?php echo e(number_format($summary['avg_achievement'], 1)); ?>%
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm p-4">
            <div class="text-sm text-gray-600 dark:text-gray-400 mb-1">Grade Distribution</div>
            <div class="flex gap-2 text-sm mt-2">
                <span class="bg-green-100 text-green-800 px-2 py-1 rounded">A: <?php echo e($summary['grades']['A']); ?></span>
                <span class="bg-blue-100 text-blue-800 px-2 py-1 rounded">B: <?php echo e($summary['grades']['B']); ?></span>
                <span class="bg-yellow-100 text-yellow-800 px-2 py-1 rounded">C: <?php echo e($summary['grades']['C']); ?></span>
                <span class="bg-orange-100 text-orange-800 px-2 py-1 rounded">D: <?php echo e($summary['grades']['D']); ?></span>
                <span class="bg-red-100 text-red-800 px-2 py-1 rounded">F: <?php echo e($summary['grades']['F']); ?></span>
            </div>
        </div>
    </div>

    <!-- Sellers Table -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Seller</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Target (RM)</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Actual (RM)</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Achievement</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Grade</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Trend</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Orders</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">AOV (RM)</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                    <?php $__empty_1 = true; $__currentLoopData = $enrichedForecasts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $forecast): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
                            <td class="px-4 py-3 whitespace-nowrap">
                                <div class="flex items-center gap-2">
                                    <span class="text-sm font-medium text-gray-900 dark:text-white"><?php echo e($forecast->user->name); ?></span>
                                    <?php if($forecast->user->isManager()): ?>
                                        <span class="text-xs bg-purple-100 text-purple-800 dark:bg-purple-900 dark:text-purple-300 px-2 py-0.5 rounded">Manager</span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-600 dark:text-gray-400">
                                <?php echo e(number_format($forecast->target_sales, 2)); ?>

                            </td>
                            <td class="px-4 py-3 whitespace-nowrap">
                                <div class="text-sm font-semibold text-gray-900 dark:text-white">
                                    <?php echo e(number_format($forecast->cumulative_sales, 2)); ?>

                                </div>
                                <?php if($forecast->user->isManager() && $forecast->team_sales > 0): ?>
                                    <div class="text-xs text-gray-500 dark:text-gray-400">
                                        Direct: <?php echo e(number_format($forecast->actual_sales, 2)); ?> | Team: <?php echo e(number_format($forecast->team_sales, 2)); ?>

                                    </div>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap">
                                <span class="text-sm font-semibold <?php echo e($forecast->cumulative_achievement >= 100 ? 'text-green-600' : ($forecast->cumulative_achievement >= 80 ? 'text-blue-600' : 'text-red-600')); ?>">
                                    <?php echo e(number_format($forecast->cumulative_achievement, 1)); ?>%
                                </span>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap">
                                <?php
                                    $gradeColors = [
                                        'A' => 'bg-green-100 text-green-800',
                                        'B' => 'bg-blue-100 text-blue-800',
                                        'C' => 'bg-yellow-100 text-yellow-800',
                                        'D' => 'bg-orange-100 text-orange-800',
                                        'F' => 'bg-red-100 text-red-800',
                                    ];
                                ?>
                                <span class="px-2 py-1 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo e($gradeColors[$forecast->cumulative_grade] ?? 'bg-gray-100 text-gray-800'); ?>">
                                    <?php echo e($forecast->cumulative_grade); ?>

                                </span>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap">
                                <?php if($forecast->trend == 'growing'): ?>
                                    <span class="text-green-600">↗ Growing</span>
                                <?php elseif($forecast->trend == 'declining'): ?>
                                    <span class="text-red-600">↘ Declining</span>
                                <?php else: ?>
                                    <span class="text-gray-600">→ Stable</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-600 dark:text-gray-400">
                                <?php echo e(number_format($forecast->orders_count)); ?>

                            </td>
                            <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-600 dark:text-gray-400">
                                <?php echo e(number_format($forecast->aov, 2)); ?>

                            </td>
                            <td class="px-4 py-3 whitespace-nowrap text-sm">
                                <a href="<?php echo e(route('forecasting.seller-kpi.show', $forecast->user_id)); ?>" class="text-blue-600 hover:text-blue-800">
                                    View Details
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="px-4 py-8 text-center text-gray-500 dark:text-gray-400">
                                No seller data found for this period. Click "Sync Sales Data" to load from orders.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
function syncSales() {
    if (!confirm('This will sync sales data from the orders table. Continue?')) return;

    const year = document.querySelector('select[name="year"]').value;
    const month = document.querySelector('select[name="month"]').value;

    fetch('<?php echo e(route("forecasting.seller-kpi.sync")); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        },
        body: JSON.stringify({ year, month })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert(data.message);
            window.location.reload();
        } else {
            alert('Error: ' + data.message);
        }
    })
    .catch(error => {
        alert('Error syncing data: ' + error);
    });
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\multistore\resources\views/forecasting/seller-kpi/index.blade.php ENDPATH**/ ?>