<?php $__env->startSection('title', 'Stores'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold"><?php echo e(auth()->user()->isAdmin() ? 'WooCommerce Stores' : 'My Stores'); ?></h1>
        <?php if(!auth()->user()->isManager()): ?>
        <a href="<?php echo e(route('stores.create')); ?>"
           class="inline-flex items-center gap-2 px-5 py-2.5 bg-blue-600 text-white rounded-lg hover:bg-blue-700 shadow-md hover:shadow-lg transition-all duration-200 font-medium">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
            </svg>
            Add New Store
        </a>
        <?php endif; ?>
    </div>

    <?php if($stores->count() > 0): ?>
    <div class="bg-white dark:bg-gray-800 shadow rounded-lg overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
            <thead class="bg-gray-50 dark:bg-gray-700">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Store Name</th>
                    <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">URL</th>
                    <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Total Orders</th>
                    <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Last Sync</th>
                    <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                <?php $__currentLoopData = $stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $store): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm font-medium"><?php echo e($store->name); ?></div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <a href="<?php echo e($store->url); ?>" target="_blank" 
                           class="text-sm text-blue-600 dark:text-blue-400 hover:underline">
                            <?php echo e($store->url); ?>

                        </a>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="flex flex-col space-y-1">
                            <?php if($store->is_active): ?>
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200">
                                    Active
                                </span>
                            <?php else: ?>
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200">
                                    Inactive
                                </span>
                            <?php endif; ?>
                            <?php if($store->webhooks_enabled): ?>
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200"
                                      title="Real-time sync active">
                                    🔄 Webhooks
                                </span>
                            <?php endif; ?>
                        </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <?php echo e($store->orders_count ?? 0); ?>

                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                        <?php echo e($store->last_sync ? $store->last_sync->diffForHumans() : 'Never'); ?>

                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <div class="flex items-center gap-1.5">
                            <!-- View -->
                            <a href="<?php echo e(route('stores.show', $store)); ?>"
                               class="p-2 text-blue-600 dark:text-blue-400 hover:bg-blue-50 dark:hover:bg-blue-900/20 rounded-lg transition-colors"
                               title="View">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                </svg>
                            </a>
                            <!-- Edit -->
                            <a href="<?php echo e(route('stores.edit', $store)); ?>"
                               class="p-2 text-indigo-600 dark:text-indigo-400 hover:bg-indigo-50 dark:hover:bg-indigo-900/20 rounded-lg transition-colors"
                               title="Edit">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                </svg>
                            </a>
                            <!-- Sync Current Month -->
                            <form action="<?php echo e(route('stores.sync', $store)); ?>" method="POST" class="inline">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="sync_type" value="current_month">
                                <button type="submit"
                                        class="p-2 text-green-600 dark:text-green-400 hover:bg-green-50 dark:hover:bg-green-900/20 rounded-lg transition-colors"
                                        title="Sync Current Month">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                                    </svg>
                                </button>
                            </form>
                            <!-- Major Sync -->
                            <button type="button"
                                    onclick="openMajorSyncModal(<?php echo e($store->id); ?>, '<?php echo e($store->name); ?>')"
                                    class="p-2 text-purple-600 dark:text-purple-400 hover:bg-purple-50 dark:hover:bg-purple-900/20 rounded-lg transition-colors"
                                    title="Major Sync">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                            </button>
                            <!-- Webhooks Toggle -->
                            <?php if($store->webhooks_enabled): ?>
                                <form action="<?php echo e(route('stores.webhooks.disable', $store)); ?>" method="POST" class="inline">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit"
                                            class="p-2 text-orange-600 dark:text-orange-400 hover:bg-orange-50 dark:hover:bg-orange-900/20 rounded-lg transition-colors"
                                            title="Disable Webhooks">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"/>
                                        </svg>
                                    </button>
                                </form>
                            <?php else: ?>
                                <form action="<?php echo e(route('stores.webhooks.enable', $store)); ?>" method="POST" class="inline">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit"
                                            class="p-2 text-blue-600 dark:text-blue-400 hover:bg-blue-50 dark:hover:bg-blue-900/20 rounded-lg transition-colors"
                                            title="Enable Webhooks">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                                        </svg>
                                    </button>
                                </form>
                            <?php endif; ?>
                            <!-- Delete -->
                            <form action="<?php echo e(route('stores.destroy', $store)); ?>" method="POST"
                                  class="inline"
                                  onsubmit="return confirm('Are you sure you want to delete this store?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit"
                                        class="p-2 text-red-600 dark:text-red-400 hover:bg-red-50 dark:hover:bg-red-900/20 rounded-lg transition-colors"
                                        title="Delete">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                                    </svg>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        
        <?php if($stores->hasPages()): ?>
        <div class="bg-white dark:bg-gray-800 px-4 py-3 border-t border-gray-200 dark:border-gray-700 sm:px-6">
            <?php echo e($stores->links()); ?>

        </div>
        <?php endif; ?>
    </div>
    <?php else: ?>
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-6 text-center">
        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
        </svg>
        <h3 class="mt-2 text-sm font-medium">No stores configured</h3>
        <?php if(auth()->user()->isManager()): ?>
        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">You can view stores from your assigned sellers.</p>
        <?php else: ?>
        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">Get started by adding your first WooCommerce store.</p>
        <div class="mt-6">
            <a href="<?php echo e(route('stores.create')); ?>"
               class="inline-flex items-center gap-2 px-5 py-2.5 bg-blue-600 text-white rounded-lg hover:bg-blue-700 shadow-md hover:shadow-lg transition-all duration-200 font-medium">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
                </svg>
                Add New Store
            </a>
        </div>
        <?php endif; ?>
    </div>
    <?php endif; ?>
</div>

<!-- Major Sync Confirmation Modal -->
<div id="majorSyncModal" class="hidden fixed z-50 inset-0 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
    <div class="flex items-center justify-center min-h-screen px-4 pt-4 pb-20 text-center sm:p-0">
        <!-- Backdrop with smooth transition -->
        <div class="fixed inset-0 bg-gray-900 bg-opacity-60 backdrop-blur-sm transition-opacity duration-300" aria-hidden="true" onclick="closeMajorSyncModal()"></div>

        <!-- Modal Panel -->
        <div class="relative inline-block align-middle bg-white dark:bg-gray-800 rounded-2xl text-left shadow-2xl transform transition-all sm:my-8 sm:max-w-xl sm:w-full overflow-hidden">

            <!-- Header -->
            <div class="bg-purple-600 px-6 py-5 sm:px-8">
                <div class="flex items-start justify-between">
                    <div class="flex items-center space-x-3">
                        <div class="flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-xl bg-purple-500">
                            <svg class="h-6 w-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                            </svg>
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-white">
                                Major Historical Sync
                            </h3>
                            <p class="text-purple-100 text-sm mt-0.5">
                                Store: <span id="modal-store-name" class="font-semibold text-white"></span>
                            </p>
                        </div>
                    </div>
                    <button onclick="closeMajorSyncModal()" class="text-white hover:text-purple-100 transition-colors">
                        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>
            </div>

            <!-- Content -->
            <div class="px-6 py-6 sm:px-8 sm:py-8">

                <!-- Sync Details Card -->
                <div class="bg-gradient-to-br from-gray-50 to-gray-100 dark:from-gray-700/50 dark:to-gray-800/50 rounded-xl p-5 mb-5 border border-gray-200 dark:border-gray-600">
                    <div class="flex items-start space-x-3">
                        <div class="flex-shrink-0">
                            <div class="h-10 w-10 rounded-lg bg-purple-100 dark:bg-purple-900/30 flex items-center justify-center">
                                <svg class="h-5 w-5 text-purple-600 dark:text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                                </svg>
                            </div>
                        </div>
                        <div class="flex-1 min-w-0">
                            <h4 class="text-sm font-semibold text-gray-900 dark:text-white mb-3">
                                What will be synced
                            </h4>
                            <div class="grid grid-cols-2 gap-3 text-xs">
                                <div class="flex items-center space-x-2">
                                    <div class="h-1.5 w-1.5 rounded-full bg-purple-500"></div>
                                    <span class="text-gray-700 dark:text-gray-300">24 months history</span>
                                </div>
                                <div class="flex items-center space-x-2">
                                    <div class="h-1.5 w-1.5 rounded-full bg-purple-500"></div>
                                    <span class="text-gray-700 dark:text-gray-300">All order statuses</span>
                                </div>
                                <div class="flex items-center space-x-2">
                                    <div class="h-1.5 w-1.5 rounded-full bg-purple-500"></div>
                                    <span class="text-gray-700 dark:text-gray-300">Several minutes</span>
                                </div>
                                <div class="flex items-center space-x-2">
                                    <div class="h-1.5 w-1.5 rounded-full bg-purple-500"></div>
                                    <span class="text-gray-700 dark:text-gray-300">Thousands of orders</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- WhatsApp Info Card -->
                <div class="bg-green-50 dark:bg-green-900/10 rounded-xl p-4 mb-6 border border-green-200 dark:border-green-800">
                    <div class="flex items-start space-x-3">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-green-600 dark:text-green-400" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                            </svg>
                        </div>
                        <div class="flex-1">
                            <p class="text-sm text-gray-700 dark:text-gray-300">
                                WhatsApp notifications <span class="font-semibold text-green-700 dark:text-green-400">automatically disabled</span> for synced orders
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Confirmation Toggle -->
                <div class="bg-gray-50 dark:bg-gray-700/50 rounded-xl p-5 border-2 border-dashed border-gray-300 dark:border-gray-600">
                    <label class="flex items-start space-x-3 cursor-pointer group">
                        <div class="relative flex items-start">
                            <input type="checkbox" id="confirmMajorSync" class="peer h-5 w-5 rounded border-2 border-gray-300 dark:border-gray-500 text-purple-600 focus:ring-2 focus:ring-purple-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition-all cursor-pointer">
                            <svg class="absolute h-5 w-5 text-white pointer-events-none hidden peer-checked:block" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"/>
                            </svg>
                        </div>
                        <span class="text-sm text-gray-700 dark:text-gray-300 select-none">
                            I understand this is a <span class="font-semibold">major operation</span> that will sync 24 months of historical data and may take several minutes to complete.
                        </span>
                    </label>
                </div>
            </div>

            <!-- Footer Actions -->
            <div class="bg-gray-50 dark:bg-gray-750 px-6 py-4 sm:px-8 sm:flex sm:flex-row-reverse gap-3 border-t border-gray-200 dark:border-gray-700">
                <form id="majorSyncForm" method="POST" class="inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" id="confirmMajorSyncBtn" disabled
                            class="w-full sm:w-auto inline-flex items-center justify-center px-6 py-2.5 rounded-lg border border-transparent text-sm font-semibold text-white bg-purple-600 hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500 disabled:opacity-40 disabled:cursor-not-allowed disabled:hover:bg-purple-600 transition-all duration-200 shadow-sm">
                        <svg class="h-4 w-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                        </svg>
                        Start Major Sync
                    </button>
                </form>
                <button type="button" onclick="closeMajorSyncModal()"
                        class="w-full sm:w-auto mt-3 sm:mt-0 inline-flex items-center justify-center px-6 py-2.5 rounded-lg border border-gray-300 dark:border-gray-600 text-sm font-medium text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-800 hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-500 transition-all duration-200">
                    Cancel
                </button>
            </div>
        </div>
    </div>
</div>

<script>
function openMajorSyncModal(storeId, storeName) {
    document.getElementById('modal-store-name').textContent = storeName;
    document.getElementById('majorSyncForm').action = '/orders/sync-store/' + storeId + '/major';
    document.getElementById('majorSyncModal').classList.remove('hidden');
    document.getElementById('confirmMajorSync').checked = false;
    document.getElementById('confirmMajorSyncBtn').disabled = true;
}

function closeMajorSyncModal() {
    document.getElementById('majorSyncModal').classList.add('hidden');
    document.getElementById('confirmMajorSync').checked = false;
    document.getElementById('confirmMajorSyncBtn').disabled = true;
}

document.getElementById('confirmMajorSync').addEventListener('change', function() {
    document.getElementById('confirmMajorSyncBtn').disabled = !this.checked;
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\multistore\resources\views/stores/index.blade.php ENDPATH**/ ?>