<?php $__env->startSection('title', 'Cloudflare Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-900 dark:text-white">Cloudflare Settings</h1>
        <p class="text-gray-600 dark:text-gray-400 mt-1">Configure Cloudflare API integration for automatic DNS management</p>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <ul class="list-disc list-inside">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <!-- Status Banner -->
    <?php if($isConfigured): ?>
        <div class="bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-lg p-4 mb-6">
            <div class="flex items-center">
                <svg class="h-5 w-5 text-green-500 mr-3" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                </svg>
                <div>
                    <p class="text-sm font-medium text-green-800 dark:text-green-200">Cloudflare integration is configured</p>
                    <p class="text-xs text-green-700 dark:text-green-300 mt-1">Automatic DNS management is available</p>
                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 rounded-lg p-4 mb-6">
            <div class="flex items-center">
                <svg class="h-5 w-5 text-yellow-500 mr-3" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                </svg>
                <div>
                    <p class="text-sm font-medium text-yellow-800 dark:text-yellow-200">Cloudflare integration not configured</p>
                    <p class="text-xs text-yellow-700 dark:text-yellow-300 mt-1">Configure API credentials below to enable automatic DNS management</p>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('cloudflare-settings.update')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <!-- Cloudflare API Credentials -->
        <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg overflow-hidden mb-6">
            <div class="p-6 border-b border-gray-200 dark:border-gray-700">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Cloudflare API Credentials</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
                    Enter your Cloudflare API credentials to enable automatic DNS record management
                </p>
            </div>

            <div class="p-6 space-y-6">
                <!-- API Token -->
                <div>
                    <label for="cloudflare_api_token" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        API Token <span class="text-red-500">*</span>
                    </label>
                    <input type="text"
                           name="cloudflare_api_token"
                           id="cloudflare_api_token"
                           value="<?php echo e(old('cloudflare_api_token', $settings['cloudflare_api_token'])); ?>"
                           class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                           placeholder="Your Cloudflare API Token">
                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                        Create an API token at: <a href="https://dash.cloudflare.com/profile/api-tokens" target="_blank" class="text-blue-600 dark:text-blue-400 hover:underline">Cloudflare Dashboard</a>
                        <br>Required permissions: Zone.DNS (Edit)
                    </p>
                </div>

                <!-- Zone ID -->
                <div>
                    <label for="cloudflare_zone_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        Zone ID <span class="text-red-500">*</span>
                    </label>
                    <input type="text"
                           name="cloudflare_zone_id"
                           id="cloudflare_zone_id"
                           value="<?php echo e(old('cloudflare_zone_id', $settings['cloudflare_zone_id'])); ?>"
                           class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                           placeholder="Your Cloudflare Zone ID">
                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                        Find your Zone ID in the Cloudflare dashboard under your domain's Overview section
                    </p>
                </div>

                <!-- Email (Optional) -->
                <div>
                    <label for="cloudflare_email" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        Account Email <span class="text-gray-400">(Optional)</span>
                    </label>
                    <input type="email"
                           name="cloudflare_email"
                           id="cloudflare_email"
                           value="<?php echo e(old('cloudflare_email', $settings['cloudflare_email'])); ?>"
                           class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                           placeholder="your@email.com">
                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                        Your Cloudflare account email (optional, but recommended for legacy API key authentication)
                    </p>
                </div>

                <!-- Test Connection Button -->
                <?php if($isConfigured): ?>
                <div class="pt-4 border-t border-gray-200 dark:border-gray-700">
                    <button type="button"
                            onclick="testCloudflareConnection()"
                            class="px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 text-sm">
                        Test Connection
                    </button>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Server Configuration -->
        <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg overflow-hidden mb-6">
            <div class="p-6 border-b border-gray-200 dark:border-gray-700">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Server Configuration</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
                    Server settings for DNS record creation
                </p>
            </div>

            <div class="p-6">
                <div>
                    <label for="server_ip" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        Server IP Address <span class="text-red-500">*</span>
                    </label>
                    <input type="text"
                           name="server_ip"
                           id="server_ip"
                           value="<?php echo e(old('server_ip', $settings['server_ip'])); ?>"
                           class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                           placeholder="xxx.xxx.xxx.xxx">
                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                        The IP address where custom domains should point. This will be used when creating DNS A records.
                    </p>
                </div>
            </div>
        </div>

        <!-- Automation Settings -->
        <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg overflow-hidden mb-6">
            <div class="p-6 border-b border-gray-200 dark:border-gray-700">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Automation Settings</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
                    Configure automatic domain management features
                </p>
            </div>

            <div class="p-6 space-y-6">
                <!-- Auto DNS Creation -->
                <div class="flex items-start">
                    <div class="flex items-center h-5">
                        <input type="checkbox"
                               name="auto_dns_enabled"
                               id="auto_dns_enabled"
                               value="1"
                               <?php echo e($settings['auto_dns_enabled'] ? 'checked' : ''); ?>

                               class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    <div class="ml-3">
                        <label for="auto_dns_enabled" class="font-medium text-gray-700 dark:text-gray-300">
                            Automatic DNS Record Creation
                        </label>
                        <p class="text-sm text-gray-600 dark:text-gray-400">
                            Automatically create DNS records in Cloudflare when sellers add a new custom domain.
                            <br>
                            <span class="text-xs">⚠️ Requires valid Cloudflare API credentials and server IP configured</span>
                        </p>
                    </div>
                </div>

                <!-- Auto Verification -->
                <div class="flex items-start">
                    <div class="flex items-center h-5">
                        <input type="checkbox"
                               name="auto_verification_enabled"
                               id="auto_verification_enabled"
                               value="1"
                               <?php echo e($settings['auto_verification_enabled'] ? 'checked' : ''); ?>

                               class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    <div class="ml-3">
                        <label for="auto_verification_enabled" class="font-medium text-gray-700 dark:text-gray-300">
                            Automatic Domain Verification
                        </label>
                        <p class="text-sm text-gray-600 dark:text-gray-400">
                            Automatically verify domains by checking DNS propagation after record creation.
                            <br>
                            <span class="text-xs">⚠️ This will verify domains as soon as DNS resolves correctly</span>
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Save Button -->
        <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg p-6">
            <div class="flex items-center justify-between">
                <p class="text-sm text-gray-600 dark:text-gray-400">
                    Save your Cloudflare settings to enable automatic DNS management
                </p>
                <button type="submit"
                        class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 font-medium">
                    Save Settings
                </button>
            </div>
        </div>
    </form>

    <!-- Help Section -->
    <div class="mt-6 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-6">
        <h3 class="text-sm font-semibold text-blue-900 dark:text-blue-200 mb-2">How to get Cloudflare API credentials:</h3>
        <ol class="list-decimal list-inside text-sm text-blue-800 dark:text-blue-300 space-y-1">
            <li>Login to your Cloudflare account at <a href="https://dash.cloudflare.com" target="_blank" class="underline">dash.cloudflare.com</a></li>
            <li>Go to <strong>My Profile</strong> → <strong>API Tokens</strong></li>
            <li>Click <strong>Create Token</strong></li>
            <li>Use <strong>Edit zone DNS</strong> template or create custom token with Zone.DNS (Edit) permission</li>
            <li>Copy the generated API token</li>
            <li>Find your <strong>Zone ID</strong> in your domain's Overview page (right sidebar)</li>
        </ol>
        <p class="mt-3 text-xs text-blue-700 dark:text-blue-400">
            📚 Full documentation: <a href="<?php echo e(url('/docs/CUSTOM_DOMAIN_SETUP.md')); ?>" class="underline">Custom Domain Setup Guide</a>
        </p>
    </div>
</div>

<script>
function testCloudflareConnection() {
    const button = event.target;
    const originalText = button.textContent;

    button.disabled = true;
    button.textContent = 'Testing...';

    fetch('<?php echo e(route('cloudflare-settings.test')); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        }
    })
    .then(response => response.json().catch(() => ({success: false, message: 'Invalid response'})))
    .then(data => {
        if (data.success) {
            alert('✅ ' + (data.message || 'Connection successful!'));
        } else {
            alert('❌ ' + (data.message || 'Connection failed'));
        }
    })
    .catch(error => {
        // Since we're redirecting, check if page reloaded with success/error message
        location.reload();
    })
    .finally(() => {
        button.disabled = false;
        button.textContent = originalText;
    });
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\multistore\resources\views/cloudflare-settings/index.blade.php ENDPATH**/ ?>