<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Header -->
    <div class="mb-6 flex items-center justify-between">
        <div>
            <h1 class="text-2xl font-bold text-gray-900 dark:text-white">📝 Marketing Strategy Input</h1>
            <p class="text-gray-600 dark:text-gray-400">
                <?php
                    $months = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];
                    $periodType = request('period_type', 'monthly');
                ?>
                <?php if($periodType === 'yearly'): ?>
                    Full Year <?php echo e($year); ?>

                <?php else: ?>
                    <?php echo e($months[$month - 1]); ?> <?php echo e($year); ?>

                <?php endif; ?>
            </p>
        </div>
        <div>
            <a href="<?php echo e(route('forecasting.marketing-strategy.index')); ?>" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-md">
                View Dashboard
            </a>
        </div>
    </div>

    <?php echo $__env->make('forecasting.partials.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <?php if(session('success')): ?>
    <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
        <?php echo e(session('success')); ?>

    </div>
    <?php endif; ?>

    <!-- Content Wrapper for Better Form Layout -->
    <div class="max-w-4xl mx-auto">

    <!-- Period Selector -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm p-4 mb-6">
        <form method="GET" action="<?php echo e(route('forecasting.marketing-strategy.input')); ?>" class="flex gap-4 items-end">
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Analysis Type</label>
                <select name="period_type" class="form-select rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white" onchange="this.form.submit()">
                    <option value="monthly" <?php echo e($periodType === 'monthly' ? 'selected' : ''); ?>>Monthly (Tactical)</option>
                    <option value="yearly" <?php echo e($periodType === 'yearly' ? 'selected' : ''); ?>>Yearly (Strategic)</option>
                </select>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Year</label>
                <select name="year" class="form-select rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white" onchange="this.form.submit()">
                    <?php for($y = date('Y'); $y >= 2022; $y--): ?>
                        <option value="<?php echo e($y); ?>" <?php echo e($year == $y ? 'selected' : ''); ?>><?php echo e($y); ?></option>
                    <?php endfor; ?>
                </select>
            </div>

            <?php if($periodType === 'monthly'): ?>
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Month</label>
                <select name="month" class="form-select rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white" onchange="this.form.submit()">
                    <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m => $monthName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($m + 1); ?>" <?php echo e($month == ($m + 1) ? 'selected' : ''); ?>><?php echo e($monthName); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <?php endif; ?>
        </form>
    </div>

    <?php if($periodType === 'yearly'): ?>
    <!-- Yearly Summary Info with Toggle -->
    <div class="bg-gradient-to-r from-purple-50 to-blue-50 dark:from-purple-900/20 dark:to-blue-900/20 border border-purple-200 dark:border-purple-800 rounded-lg p-6 mb-6">
        <div class="flex items-center justify-between mb-4">
            <h3 class="text-lg font-bold text-purple-900 dark:text-purple-300">📊 Year <?php echo e($year); ?> Summary</h3>
            <!-- Toggle Switch for Yearly -->
            <div class="flex items-center gap-3">
                <span class="text-xs font-medium text-gray-600 dark:text-gray-400" id="toggleLabelYearly">All Sales</span>
                <button type="button" onclick="toggleRevenueMode()"
                        class="relative inline-flex h-6 w-11 items-center rounded-full bg-gray-300 dark:bg-gray-600 transition-colors focus:outline-none focus:ring-2 focus:ring-purple-500 focus:ring-offset-2"
                        id="revenueToggleYearly">
                    <span class="inline-block h-4 w-4 transform rounded-full bg-white transition-transform translate-x-1" id="toggleThumbYearly"></span>
                </button>
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div>
                <div class="text-sm font-medium text-purple-800 dark:text-purple-400 mb-1">Total Marketing Spend</div>
                <div class="text-2xl font-bold text-purple-900 dark:text-purple-300">
                    RM <?php echo e(number_format($existingData->total_marketing_spend ?? 0, 2)); ?>

                </div>
            </div>
            <div id="yearlyRevenueSection">
                <div class="text-sm font-medium text-blue-800 dark:text-blue-400 mb-1">Total Revenue Generated</div>
                <div id="yearlyAllSalesView">
                    <div class="text-2xl font-bold text-blue-900 dark:text-blue-300">
                        RM <?php echo e(number_format($actualRevenue, 2)); ?>

                    </div>
                    <div class="text-xs text-blue-700 dark:text-blue-400 mt-1">
                        All Sales (HQ + Stokis + Agent)
                    </div>
                </div>
                <div id="yearlyHqOnlyView" class="hidden">
                    <div class="text-2xl font-bold text-purple-900 dark:text-purple-300">
                        RM <?php echo e(number_format($hqRevenue, 2)); ?>

                    </div>
                    <div class="text-xs text-purple-700 dark:text-purple-400 mt-1">
                        HQ Sales Only
                    </div>
                </div>
            </div>
            <div id="yearlyRoiSection">
                <div class="text-sm font-medium text-green-800 dark:text-green-400 mb-1">Average ROI</div>
                <div id="yearlyAllSalesRoi">
                    <div class="text-2xl font-bold text-green-900 dark:text-green-300">
                        <?php echo e(number_format($existingData->roi_percentage ?? 0, 2)); ?>%
                    </div>
                    <?php
                        $totalSpend = $existingData->total_marketing_spend ?? 0;
                        $allRatio = $totalSpend > 0 ? $actualRevenue / $totalSpend : 0;
                    ?>
                    <div class="text-sm text-green-800 dark:text-green-300 font-semibold">
                        Ratio: <?php echo e(number_format($allRatio, 2)); ?>x
                    </div>
                    <div class="text-xs text-green-700 dark:text-green-400 mt-1">
                        Based on All Sales
                    </div>
                </div>
                <div id="yearlyHqOnlyRoi" class="hidden">
                    <div class="text-2xl font-bold text-purple-900 dark:text-purple-300" id="yearlyHqRoiValue">
                        <?php
                            $hqRoi = $totalSpend > 0 ? (($hqRevenue - $totalSpend) / $totalSpend) * 100 : 0;
                            $hqRatio = $totalSpend > 0 ? $hqRevenue / $totalSpend : 0;
                        ?>
                        <?php echo e(number_format($hqRoi, 2)); ?>%
                    </div>
                    <div class="text-sm text-purple-800 dark:text-purple-300 font-semibold">
                        Ratio: <?php echo e(number_format($hqRatio, 2)); ?>x
                    </div>
                    <div class="text-xs text-purple-700 dark:text-purple-400 mt-1">
                        Based on HQ Sales Only
                    </div>
                </div>
            </div>
        </div>

        <div class="mt-4 text-sm text-purple-700 dark:text-purple-400">
            Aggregated from <?php echo e($existingData->months_count ?? 0); ?> months of data
        </div>

        <!-- Marketing ROI Explanation when HQ Only is active -->
        <div id="yearlyHqExplanation" class="hidden mt-4 text-xs text-purple-600 dark:text-purple-500 bg-purple-100 dark:bg-purple-900/30 rounded px-3 py-2">
            <strong>Marketing ROI Relevancy:</strong> HQ sales better reflect marketing effectiveness since marketing spend primarily drives HQ sales, not agent/stokis sales.
        </div>
    </div>

    <!-- Yearly Breakdown Table - All Sales View -->
    <div id="yearlyChannelAllSales" class="bg-white dark:bg-gray-800 rounded-lg shadow-sm p-6 mb-6">
        <h3 class="text-lg font-semibold text-gray-800 dark:text-white mb-4">Channel Breakdown (Full Year - All Sales)</h3>
        <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
            <div class="border dark:border-gray-700 rounded-lg p-4">
                <div class="text-sm text-gray-600 dark:text-gray-400 mb-1">Brand Ambassadors</div>
                <div class="text-xl font-bold text-gray-900 dark:text-white">
                    RM <?php echo e(number_format($existingData->brand_ambassador_spend ?? 0, 2)); ?>

                </div>
            </div>
            <div class="border dark:border-gray-700 rounded-lg p-4">
                <div class="text-sm text-gray-600 dark:text-gray-400 mb-1">Ads</div>
                <div class="text-xl font-bold text-gray-900 dark:text-white">
                    RM <?php echo e(number_format($existingData->ads_spend ?? 0, 2)); ?>

                </div>
            </div>
            <div class="border dark:border-gray-700 rounded-lg p-4">
                <div class="text-sm text-gray-600 dark:text-gray-400 mb-1">Social Media</div>
                <div class="text-xl font-bold text-gray-900 dark:text-white">
                    RM <?php echo e(number_format($existingData->social_media_spend ?? 0, 2)); ?>

                </div>
            </div>
            <div class="border dark:border-gray-700 rounded-lg p-4">
                <div class="text-sm text-gray-600 dark:text-gray-400 mb-1">Events</div>
                <div class="text-xl font-bold text-gray-900 dark:text-white">
                    RM <?php echo e(number_format($existingData->events_spend ?? 0, 2)); ?>

                </div>
            </div>
            <div class="border dark:border-gray-700 rounded-lg p-4">
                <div class="text-sm text-gray-600 dark:text-gray-400 mb-1">Other</div>
                <div class="text-xl font-bold text-gray-900 dark:text-white">
                    RM <?php echo e(number_format($existingData->other_spend ?? 0, 2)); ?>

                </div>
            </div>
            <div class="border-2 border-green-500 dark:border-green-700 rounded-lg p-4 bg-green-50 dark:bg-green-900/20">
                <div class="text-sm text-green-600 dark:text-green-400 mb-1 font-semibold">Total Profit (All Sales)</div>
                <div class="text-xl font-bold text-green-900 dark:text-green-300">
                    RM <?php echo e(number_format(($actualRevenue - ($existingData->total_marketing_spend ?? 0)), 2)); ?>

                </div>
                <div class="text-xs text-green-700 dark:text-green-400 mt-1">
                    Revenue: RM <?php echo e(number_format($actualRevenue, 2)); ?>

                </div>
            </div>
        </div>
    </div>

    <!-- Yearly Breakdown Table - HQ Only View -->
    <div id="yearlyChannelHqOnly" class="hidden bg-white dark:bg-gray-800 rounded-lg shadow-sm p-6 mb-6">
        <h3 class="text-lg font-semibold text-gray-800 dark:text-white mb-4">Channel Breakdown (Full Year - HQ Sales Only)</h3>
        <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
            <div class="border dark:border-gray-700 rounded-lg p-4">
                <div class="text-sm text-gray-600 dark:text-gray-400 mb-1">Brand Ambassadors</div>
                <div class="text-xl font-bold text-gray-900 dark:text-white">
                    RM <?php echo e(number_format($existingData->brand_ambassador_spend ?? 0, 2)); ?>

                </div>
            </div>
            <div class="border dark:border-gray-700 rounded-lg p-4">
                <div class="text-sm text-gray-600 dark:text-gray-400 mb-1">Ads</div>
                <div class="text-xl font-bold text-gray-900 dark:text-white">
                    RM <?php echo e(number_format($existingData->ads_spend ?? 0, 2)); ?>

                </div>
            </div>
            <div class="border dark:border-gray-700 rounded-lg p-4">
                <div class="text-sm text-gray-600 dark:text-gray-400 mb-1">Social Media</div>
                <div class="text-xl font-bold text-gray-900 dark:text-white">
                    RM <?php echo e(number_format($existingData->social_media_spend ?? 0, 2)); ?>

                </div>
            </div>
            <div class="border dark:border-gray-700 rounded-lg p-4">
                <div class="text-sm text-gray-600 dark:text-gray-400 mb-1">Events</div>
                <div class="text-xl font-bold text-gray-900 dark:text-white">
                    RM <?php echo e(number_format($existingData->events_spend ?? 0, 2)); ?>

                </div>
            </div>
            <div class="border dark:border-gray-700 rounded-lg p-4">
                <div class="text-sm text-gray-600 dark:text-gray-400 mb-1">Other</div>
                <div class="text-xl font-bold text-gray-900 dark:text-white">
                    RM <?php echo e(number_format($existingData->other_spend ?? 0, 2)); ?>

                </div>
            </div>
            <div class="border-2 border-purple-500 dark:border-purple-700 rounded-lg p-4 bg-purple-50 dark:bg-purple-900/20">
                <div class="text-sm text-purple-600 dark:text-purple-400 mb-1 font-semibold">HQ Profit</div>
                <div class="text-xl font-bold text-purple-900 dark:text-purple-300">
                    RM <?php echo e(number_format(($hqRevenue - ($existingData->total_marketing_spend ?? 0)), 2)); ?>

                </div>
                <div class="text-xs text-purple-700 dark:text-purple-400 mt-1">
                    HQ Revenue: RM <?php echo e(number_format($hqRevenue, 2)); ?>

                </div>
            </div>
        </div>
        <div class="mt-4 text-xs text-purple-600 dark:text-purple-500 bg-purple-100 dark:bg-purple-900/30 rounded px-3 py-2">
            <strong>Note:</strong> Stokis Sales (RM <?php echo e(number_format($stokisSales, 2)); ?>) and Agent Sales (RM <?php echo e(number_format($agentSales, 2)); ?>) are excluded from this view.
        </div>
    </div>

    <?php else: ?>
    <!-- Monthly Revenue Info with Toggle -->
    <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4 mb-6">
        <div class="flex items-center justify-between mb-3">
            <div class="text-sm font-medium text-blue-800 dark:text-blue-400">Revenue for this Month</div>
            <!-- Toggle Switch -->
            <div class="flex items-center gap-3">
                <span class="text-xs font-medium text-gray-600 dark:text-gray-400" id="toggleLabel">All Sales</span>
                <button type="button" onclick="toggleRevenueMode()"
                        class="relative inline-flex h-6 w-11 items-center rounded-full bg-gray-300 dark:bg-gray-600 transition-colors focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2"
                        id="revenueToggle">
                    <span class="inline-block h-4 w-4 transform rounded-full bg-white transition-transform translate-x-1" id="toggleThumb"></span>
                </button>
            </div>
        </div>

        <div id="allSalesView">
            <div class="text-2xl font-bold text-blue-900 dark:text-blue-300">
                RM <?php echo e(number_format($actualRevenue, 2)); ?>

            </div>
            <div class="text-xs text-blue-700 dark:text-blue-400 mt-1">
                Total Sales (HQ: RM <?php echo e(number_format($hqRevenue, 2)); ?> + Stokis: RM <?php echo e(number_format($stokisSales, 2)); ?> + Agent: RM <?php echo e(number_format($agentSales, 2)); ?>)
            </div>
        </div>

        <div id="hqOnlyView" class="hidden">
            <div class="text-2xl font-bold text-purple-900 dark:text-purple-300">
                RM <?php echo e(number_format($hqRevenue, 2)); ?>

            </div>
            <div class="text-xs text-purple-700 dark:text-purple-400 mt-1">
                HQ Sales Only (Excluding Stokis: RM <?php echo e(number_format($stokisSales, 2)); ?>, Agent: RM <?php echo e(number_format($agentSales, 2)); ?>)
            </div>
            <div class="text-xs text-purple-600 dark:text-purple-500 mt-2 bg-purple-100 dark:bg-purple-900/30 rounded px-2 py-1">
                <strong>Marketing ROI Relevancy:</strong> This shows HQ sales only, which better reflects marketing spend effectiveness since marketing primarily affects HQ sales.
            </div>
        </div>
    </div>

    <!-- Monthly Input Form -->
    <form method="POST" action="<?php echo e(route('forecasting.marketing-strategy.save')); ?>" class="bg-white dark:bg-gray-800 rounded-lg shadow-sm p-6">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="year" value="<?php echo e($year); ?>">
        <input type="hidden" name="month" value="<?php echo e($month); ?>">

        <div class="space-y-6">
            <!-- Marketing Spend Breakdown -->
            <div>
                <h3 class="text-lg font-semibold text-gray-800 dark:text-white mb-4">Marketing Spend Breakdown</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                            Brand Ambassador Spend (RM)
                        </label>
                        <input type="number" step="0.01" name="brand_ambassador_spend"
                               value="<?php echo e(old('brand_ambassador_spend', $existingData->brand_ambassador_spend ?? 0)); ?>"
                               class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                               required>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                            Ads Spend (Facebook, Google, etc.) (RM)
                        </label>
                        <input type="number" step="0.01" name="ads_spend"
                               value="<?php echo e(old('ads_spend', $existingData->ads_spend ?? 0)); ?>"
                               class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                               required>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                            Social Media Spend (Influencer, Content) (RM)
                        </label>
                        <input type="number" step="0.01" name="social_media_spend"
                               value="<?php echo e(old('social_media_spend', $existingData->social_media_spend ?? 0)); ?>"
                               class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                               required>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                            Events Spend (Trade Shows, etc.) (RM)
                        </label>
                        <input type="number" step="0.01" name="events_spend"
                               value="<?php echo e(old('events_spend', $existingData->events_spend ?? 0)); ?>"
                               class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                               required>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                            Other Marketing Spend (RM)
                        </label>
                        <input type="number" step="0.01" name="other_spend"
                               value="<?php echo e(old('other_spend', $existingData->other_spend ?? 0)); ?>"
                               class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                               required>
                    </div>

                    <div class="bg-gray-50 dark:bg-gray-700 rounded-lg p-4">
                        <div class="text-sm text-gray-600 dark:text-gray-400 mb-1">Total Marketing Spend</div>
                        <div id="totalSpend" class="text-2xl font-bold text-gray-800 dark:text-white">
                            RM 0.00
                        </div>
                    </div>
                </div>
            </div>

            <!-- Detailed Channel Breakdowns -->
            <div class="border-t border-gray-200 dark:border-gray-700 pt-6">
                <button type="button" onclick="toggleSection('detailedBreakdowns')"
                        class="w-full flex items-center justify-between text-left bg-gradient-to-r from-blue-50 to-purple-50 dark:from-blue-900/20 dark:to-purple-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4 hover:shadow-md transition-all">
                    <div class="flex items-center gap-3">
                        <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                        </svg>
                        <div>
                            <h3 class="text-lg font-semibold text-gray-800 dark:text-white">Detailed Channel Breakdowns</h3>
                            <p class="text-sm text-gray-600 dark:text-gray-400">Track spending & revenue per platform for precise AI insights</p>
                        </div>
                    </div>
                    <svg id="detailedBreakdownsIcon" class="w-5 h-5 text-gray-600 dark:text-gray-400 transform transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>

                <div id="detailedBreakdowns" class="hidden mt-4 space-y-6">
                    <!-- Ads Spend Breakdown -->
                    <div class="bg-blue-50 dark:bg-blue-900/10 border border-blue-200 dark:border-blue-800 rounded-lg p-6">
                        <h4 class="text-md font-bold text-blue-900 dark:text-blue-300 mb-4 flex items-center gap-2">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            Paid Ads Breakdown (by Platform)
                        </h4>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Facebook Ads (RM)</label>
                                <input type="number" step="0.01" name="ads_facebook"
                                       value="<?php echo e(old('ads_facebook', $existingData->ads_facebook ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                                       onchange="updateTotal()">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Instagram Ads (RM)</label>
                                <input type="number" step="0.01" name="ads_instagram"
                                       value="<?php echo e(old('ads_instagram', $existingData->ads_instagram ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                                       onchange="updateTotal()">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">TikTok Ads (RM)</label>
                                <input type="number" step="0.01" name="ads_tiktok"
                                       value="<?php echo e(old('ads_tiktok', $existingData->ads_tiktok ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                                       onchange="updateTotal()">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Google Ads (RM)</label>
                                <input type="number" step="0.01" name="ads_google"
                                       value="<?php echo e(old('ads_google', $existingData->ads_google ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                                       onchange="updateTotal()">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">YouTube Ads (RM)</label>
                                <input type="number" step="0.01" name="ads_youtube"
                                       value="<?php echo e(old('ads_youtube', $existingData->ads_youtube ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                                       onchange="updateTotal()">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Twitter/X Ads (RM)</label>
                                <input type="number" step="0.01" name="ads_twitter"
                                       value="<?php echo e(old('ads_twitter', $existingData->ads_twitter ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                                       onchange="updateTotal()">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">LinkedIn Ads (RM)</label>
                                <input type="number" step="0.01" name="ads_linkedin"
                                       value="<?php echo e(old('ads_linkedin', $existingData->ads_linkedin ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                                       onchange="updateTotal()">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Other Ads (RM)</label>
                                <input type="number" step="0.01" name="ads_other"
                                       value="<?php echo e(old('ads_other', $existingData->ads_other ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                                       onchange="updateTotal()">
                            </div>
                        </div>
                    </div>

                    <!-- Social Media Spend Breakdown -->
                    <div class="bg-purple-50 dark:bg-purple-900/10 border border-purple-200 dark:border-purple-800 rounded-lg p-6">
                        <h4 class="text-md font-bold text-purple-900 dark:text-purple-300 mb-4 flex items-center gap-2">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8h2a2 2 0 012 2v6a2 2 0 01-2 2h-2v4l-4-4H9a1.994 1.994 0 01-1.414-.586m0 0L11 14h4a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2v4l.586-.586z"></path>
                            </svg>
                            Organic Social Media Spend (Content, Influencers)
                        </h4>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Facebook Organic (RM)</label>
                                <input type="number" step="0.01" name="social_facebook"
                                       value="<?php echo e(old('social_facebook', $existingData->social_facebook ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                                       onchange="updateTotal()">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Instagram Organic (RM)</label>
                                <input type="number" step="0.01" name="social_instagram"
                                       value="<?php echo e(old('social_instagram', $existingData->social_instagram ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                                       onchange="updateTotal()">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">TikTok Organic (RM)</label>
                                <input type="number" step="0.01" name="social_tiktok"
                                       value="<?php echo e(old('social_tiktok', $existingData->social_tiktok ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                                       onchange="updateTotal()">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">YouTube Content (RM)</label>
                                <input type="number" step="0.01" name="social_youtube"
                                       value="<?php echo e(old('social_youtube', $existingData->social_youtube ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                                       onchange="updateTotal()">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Twitter/X Organic (RM)</label>
                                <input type="number" step="0.01" name="social_twitter"
                                       value="<?php echo e(old('social_twitter', $existingData->social_twitter ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                                       onchange="updateTotal()">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">LinkedIn Organic (RM)</label>
                                <input type="number" step="0.01" name="social_linkedin"
                                       value="<?php echo e(old('social_linkedin', $existingData->social_linkedin ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                                       onchange="updateTotal()">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Other Social (RM)</label>
                                <input type="number" step="0.01" name="social_other"
                                       value="<?php echo e(old('social_other', $existingData->social_other ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                                       onchange="updateTotal()">
                            </div>
                        </div>
                    </div>

                    <!-- Revenue Breakdown by Sales Channel -->
                    <div class="bg-green-50 dark:bg-green-900/10 border border-green-200 dark:border-green-800 rounded-lg p-6">
                        <h4 class="text-md font-bold text-green-900 dark:text-green-300 mb-4 flex items-center gap-2">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            Revenue by Sales Channel
                        </h4>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Checkout Forms (RM)</label>
                                <input type="number" step="0.01" name="revenue_checkout_form"
                                       value="<?php echo e(old('revenue_checkout_form', $existingData->revenue_checkout_form ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Sales Pages (RM)</label>
                                <input type="number" step="0.01" name="revenue_sales_pages"
                                       value="<?php echo e(old('revenue_sales_pages', $existingData->revenue_sales_pages ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Webstore/WooCommerce (RM)</label>
                                <input type="number" step="0.01" name="revenue_webstore"
                                       value="<?php echo e(old('revenue_webstore', $existingData->revenue_webstore ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Marketplace (Shopee/Lazada) (RM)</label>
                                <input type="number" step="0.01" name="revenue_marketplace"
                                       value="<?php echo e(old('revenue_marketplace', $existingData->revenue_marketplace ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Direct Sales (Walk-in/Phone) (RM)</label>
                                <input type="number" step="0.01" name="revenue_direct"
                                       value="<?php echo e(old('revenue_direct', $existingData->revenue_direct ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Other Revenue Sources (RM)</label>
                                <input type="number" step="0.01" name="revenue_other"
                                       value="<?php echo e(old('revenue_other', $existingData->revenue_other ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white">
                            </div>
                        </div>
                    </div>

                    <!-- Conversion Tracking -->
                    <div class="bg-yellow-50 dark:bg-yellow-900/10 border border-yellow-200 dark:border-yellow-800 rounded-lg p-6">
                        <h4 class="text-md font-bold text-yellow-900 dark:text-yellow-300 mb-4 flex items-center gap-2">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"></path>
                            </svg>
                            Conversion Tracking (Number of Orders)
                        </h4>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Checkout Form Orders</label>
                                <input type="number" step="1" name="conversions_checkout_form"
                                       value="<?php echo e(old('conversions_checkout_form', $existingData->conversions_checkout_form ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Sales Page Orders</label>
                                <input type="number" step="1" name="conversions_sales_pages"
                                       value="<?php echo e(old('conversions_sales_pages', $existingData->conversions_sales_pages ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Webstore Orders</label>
                                <input type="number" step="1" name="conversions_webstore"
                                       value="<?php echo e(old('conversions_webstore', $existingData->conversions_webstore ?? 0)); ?>"
                                       class="form-input w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white">
                            </div>
                        </div>
                    </div>

                    <!-- Channel Notes -->
                    <div class="bg-gray-50 dark:bg-gray-900/20 border border-gray-200 dark:border-gray-700 rounded-lg p-6">
                        <h4 class="text-md font-bold text-gray-900 dark:text-gray-300 mb-4 flex items-center gap-2">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                            </svg>
                            Channel-Specific Notes
                        </h4>
                        <textarea name="channel_notes" rows="3"
                                  class="form-textarea w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                                  placeholder="Example: TikTok video #1234 went viral - 2M views, 150 sales. Facebook ads performed poorly on mobile but great on desktop."><?php echo e(old('channel_notes', $existingData->channel_notes ?? '')); ?></textarea>
                    </div>
                </div>
            </div>

            <!-- Campaign Details -->
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                    Campaign Details
                </label>
                <textarea name="campaign_details" rows="4"
                          class="form-textarea w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                          placeholder="Describe the campaigns that ran this month (e.g., New product launch, Holiday sale, Influencer collaboration)"><?php echo e(old('campaign_details', $existingData->campaign_details ?? '')); ?></textarea>
            </div>

            <!-- Target Audience -->
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                    Target Audience
                </label>
                <textarea name="target_audience" rows="2"
                          class="form-textarea w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white"
                          placeholder="Who did you target? (e.g., Women 25-45, interested in skincare)"><?php echo e(old('target_audience', $existingData->target_audience ?? '')); ?></textarea>
            </div>

            <!-- Channels Used -->
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Channels Used
                </label>
                <div class="grid grid-cols-2 md:grid-cols-4 gap-3">
                    <?php
                        $channels = ['Facebook', 'Instagram', 'TikTok', 'Google Ads', 'YouTube', 'Twitter', 'LinkedIn', 'Others'];
                        $existingChannels = $existingData ? explode(', ', $existingData->channels_used) : [];
                    ?>
                    <?php $__currentLoopData = $channels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $channel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <label class="flex items-center">
                            <input type="checkbox" name="channels[]" value="<?php echo e($channel); ?>"
                                   <?php echo e(in_array($channel, $existingChannels) ? 'checked' : ''); ?>

                                   class="form-checkbox rounded border-gray-300 text-blue-600 mr-2">
                            <span class="text-sm text-gray-700 dark:text-gray-300"><?php echo e($channel); ?></span>
                        </label>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <input type="hidden" name="channels_used" id="channelsInput" value="<?php echo e(old('channels_used', $existingData->channels_used ?? '')); ?>">
            </div>

            <!-- Submit Buttons -->
            <div class="flex gap-3 pt-4 border-t border-gray-200 dark:border-gray-700">
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded-md font-semibold">
                    Save Marketing Data
                </button>

                <?php if($existingData): ?>
                <button type="button" onclick="getAiSuggestions()"
                        class="bg-purple-600 hover:bg-purple-700 text-white px-6 py-3 rounded-md font-semibold flex items-center gap-2">
                    <img src="<?php echo e(asset('images/chatbot-aicon.png')); ?>" alt="AI" class="w-5 h-5">
                    Suggestions
                </button>
                <?php endif; ?>
            </div>
        </div>
    </form>
    <?php endif; ?>

    <?php if($periodType === 'yearly' && ($existingData->months_count ?? 0) > 0): ?>
    <!-- Yearly AI Analysis Button -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm p-6 text-center">
        <h3 class="text-lg font-semibold text-gray-800 dark:text-white mb-3">
            Strategic Analysis for <?php echo e($year); ?>

        </h3>
        <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
            Get AI-powered strategic recommendations based on the full year's performance
        </p>
        <button type="button" onclick="getAiSuggestions()"
                class="bg-gradient-to-r from-purple-600 to-pink-600 hover:from-purple-700 hover:to-pink-700 text-white px-8 py-3 rounded-md font-semibold text-lg flex items-center gap-2 mx-auto">
            <img src="<?php echo e(asset('images/chatbot-aicon.png')); ?>" alt="AI" class="w-6 h-6">
            Strategic Insights for <?php echo e($year + 1); ?>

        </button>
    </div>
    <?php endif; ?>

    <!-- AI Suggestions Display -->
    <?php if($existingData && ($existingData->ai_analysis || $existingData->ai_recommendations)): ?>
    <div class="mt-6">
        <!-- Header -->
        <div class="bg-gradient-to-r from-purple-600 to-pink-600 rounded-t-lg p-6 text-white">
            <div class="flex items-center gap-3">
                <img src="<?php echo e(asset('images/chatbot-aicon.png')); ?>" alt="AI" class="w-8 h-8">
                <div>
                    <h3 class="text-2xl font-bold">AI-Powered Insights</h3>
                    <p class="text-purple-100 text-sm">Strategic analysis and actionable recommendations</p>
                </div>
            </div>
        </div>

        <!-- Analysis Section -->
        <?php if($existingData->ai_analysis): ?>
        <div class="bg-white dark:bg-gray-800 border-x border-purple-200 dark:border-purple-800 p-6">
            <div class="flex items-center gap-2 mb-4">
                <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                </svg>
                <h4 class="text-xl font-bold text-gray-900 dark:text-white">Performance Analysis</h4>
            </div>

            <div class="space-y-3">
                <?php
                    // Parse analysis into bullet points
                    $analysisLines = explode("\n", $existingData->ai_analysis);
                    $bulletPoints = [];
                    foreach($analysisLines as $line) {
                        $line = trim($line);
                        if(preg_match('/^\d+\.\s+\*\*(.+?)\*\*:\s*(.+)$/', $line, $matches)) {
                            // Format: 1. **Title**: Description
                            $bulletPoints[] = ['title' => $matches[1], 'text' => $matches[2]];
                        } elseif(preg_match('/^[-•]\s*(.+)$/', $line, $matches)) {
                            // Format: - Text or • Text
                            $bulletPoints[] = ['title' => null, 'text' => $matches[1]];
                        } elseif(!empty($line) && !in_array($line, ['Analysis:', 'ANALYSIS:', '###'])) {
                            $bulletPoints[] = ['title' => null, 'text' => $line];
                        }
                    }
                ?>

                <?php $__currentLoopData = $bulletPoints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="flex gap-3 p-4 bg-blue-50 dark:bg-blue-900/20 rounded-lg border border-blue-200 dark:border-blue-800 hover:shadow-md transition-shadow">
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-blue-600 text-white rounded-full flex items-center justify-center font-bold text-sm">
                            <?php echo e($index + 1); ?>

                        </div>
                    </div>
                    <div class="flex-1">
                        <?php if($point['title']): ?>
                            <h5 class="font-bold text-blue-900 dark:text-blue-300 mb-1"><?php echo e($point['title']); ?></h5>
                            <p class="text-gray-700 dark:text-gray-300 text-sm leading-relaxed"><?php echo e($point['text']); ?></p>
                        <?php else: ?>
                            <p class="text-gray-700 dark:text-gray-300 leading-relaxed"><?php echo e($point['text']); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php endif; ?>

        <!-- Recommendations Section -->
        <?php if($existingData->ai_recommendations): ?>
        <div class="bg-white dark:bg-gray-800 border-x border-b border-purple-200 dark:border-purple-800 rounded-b-lg p-6">
            <div class="flex items-center gap-2 mb-4">
                <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <h4 class="text-xl font-bold text-gray-900 dark:text-white">Action Plan</h4>
                <span class="ml-auto text-xs bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200 px-3 py-1 rounded-full font-semibold">
                    <?php echo e(substr_count($existingData->ai_recommendations, "\n") + 1); ?> Recommendations
                </span>
            </div>

            <div class="space-y-3">
                <?php
                    // Parse recommendations into action items
                    $recommendationLines = explode("\n", $existingData->ai_recommendations);
                    $recommendations = [];
                    foreach($recommendationLines as $line) {
                        $line = trim($line);
                        if(preg_match('/^\d+\.\s+\*\*(.+?)\*\*:\s*(.+)$/', $line, $matches)) {
                            // Format: 1. **Title**: Description
                            $recommendations[] = ['title' => $matches[1], 'text' => $matches[2]];
                        } elseif(preg_match('/^\d+\.\s+(.+)$/', $line, $matches)) {
                            // Format: 1. Text
                            $recommendations[] = ['title' => null, 'text' => $matches[1]];
                        } elseif(preg_match('/^[-•]\s*(.+)$/', $line, $matches)) {
                            // Format: - Text or • Text
                            $recommendations[] = ['title' => null, 'text' => $matches[1]];
                        } elseif(!empty($line) && !in_array($line, ['Recommendations:', 'RECOMMENDATIONS:', '###'])) {
                            $recommendations[] = ['title' => null, 'text' => $line];
                        }
                    }
                ?>

                <?php $__currentLoopData = $recommendations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $rec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="flex gap-3 p-4 bg-green-50 dark:bg-green-900/20 rounded-lg border border-green-200 dark:border-green-800 hover:shadow-md transition-shadow group">
                    <div class="flex-shrink-0 pt-1">
                        <input type="checkbox" class="w-5 h-5 text-green-600 border-gray-300 rounded focus:ring-green-500"
                               onchange="this.parentElement.parentElement.classList.toggle('opacity-50')">
                    </div>
                    <div class="flex-1">
                        <?php if($rec['title']): ?>
                            <h5 class="font-bold text-green-900 dark:text-green-300 mb-1 flex items-start gap-2">
                                <span class="flex-shrink-0 text-green-600 font-bold"><?php echo e($index + 1); ?>.</span>
                                <span><?php echo e($rec['title']); ?></span>
                            </h5>
                            <p class="text-gray-700 dark:text-gray-300 text-sm leading-relaxed ml-5"><?php echo e($rec['text']); ?></p>
                        <?php else: ?>
                            <p class="text-gray-700 dark:text-gray-300 leading-relaxed flex items-start gap-2">
                                <span class="flex-shrink-0 text-green-600 font-bold"><?php echo e($index + 1); ?>.</span>
                                <span><?php echo e($rec['text']); ?></span>
                            </p>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Action Button -->
            <div class="mt-6 pt-6 border-t border-gray-200 dark:border-gray-700">
                <button type="button" onclick="getAiSuggestions()" class="w-full sm:w-auto bg-gradient-to-r from-green-600 to-blue-600 hover:from-green-700 hover:to-blue-700 text-white px-6 py-3 rounded-lg font-semibold flex items-center justify-center gap-2 transition-all">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                    </svg>
                    Refresh Insights
                </button>
            </div>
        </div>
        <?php endif; ?>
    </div>
    <?php endif; ?>

    </div>
    <!-- End Content Wrapper -->

    <!-- Loading Modal -->
    <div id="aiLoadingModal" class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50">
        <div class="bg-white dark:bg-gray-800 rounded-lg p-8 max-w-sm">
            <div class="text-center">
                <div class="animate-spin rounded-full h-16 w-16 border-b-2 border-purple-600 mx-auto mb-4"></div>
                <div class="text-lg font-semibold text-gray-800 dark:text-white mb-2">Generating AI Suggestions...</div>
                <div class="text-sm text-gray-600 dark:text-gray-400">This may take 10-30 seconds</div>
            </div>
        </div>
    </div>
</div>

<script>
// Revenue toggle mode state (false = All Sales, true = HQ Only)
let isHqOnlyMode = false;

// Toggle between All Sales and HQ Only revenue display
function toggleRevenueMode() {
    isHqOnlyMode = !isHqOnlyMode;

    // Monthly toggle elements
    const allSalesView = document.getElementById('allSalesView');
    const hqOnlyView = document.getElementById('hqOnlyView');
    const toggleLabel = document.getElementById('toggleLabel');
    const toggleButton = document.getElementById('revenueToggle');
    const toggleThumb = document.getElementById('toggleThumb');

    // Yearly toggle elements
    const yearlyAllSalesView = document.getElementById('yearlyAllSalesView');
    const yearlyHqOnlyView = document.getElementById('yearlyHqOnlyView');
    const yearlyAllSalesRoi = document.getElementById('yearlyAllSalesRoi');
    const yearlyHqOnlyRoi = document.getElementById('yearlyHqOnlyRoi');
    const yearlyHqExplanation = document.getElementById('yearlyHqExplanation');
    const toggleLabelYearly = document.getElementById('toggleLabelYearly');
    const toggleButtonYearly = document.getElementById('revenueToggleYearly');
    const toggleThumbYearly = document.getElementById('toggleThumbYearly');

    // Yearly channel breakdown elements
    const yearlyChannelAllSales = document.getElementById('yearlyChannelAllSales');
    const yearlyChannelHqOnly = document.getElementById('yearlyChannelHqOnly');

    if (isHqOnlyMode) {
        // Switch to HQ Only mode
        if (allSalesView) {
            allSalesView.classList.add('hidden');
            hqOnlyView.classList.remove('hidden');
            toggleLabel.textContent = 'HQ Only';
            toggleButton.classList.remove('bg-gray-300', 'dark:bg-gray-600');
            toggleButton.classList.add('bg-purple-600');
            toggleThumb.classList.remove('translate-x-1');
            toggleThumb.classList.add('translate-x-6');
        }

        if (yearlyAllSalesView) {
            yearlyAllSalesView.classList.add('hidden');
            yearlyHqOnlyView.classList.remove('hidden');
            yearlyAllSalesRoi.classList.add('hidden');
            yearlyHqOnlyRoi.classList.remove('hidden');
            yearlyHqExplanation.classList.remove('hidden');
            toggleLabelYearly.textContent = 'HQ Only';
            toggleButtonYearly.classList.remove('bg-gray-300', 'dark:bg-gray-600');
            toggleButtonYearly.classList.add('bg-purple-600');
            toggleThumbYearly.classList.remove('translate-x-1');
            toggleThumbYearly.classList.add('translate-x-6');
        }

        // Toggle yearly channel breakdown
        if (yearlyChannelAllSales && yearlyChannelHqOnly) {
            yearlyChannelAllSales.classList.add('hidden');
            yearlyChannelHqOnly.classList.remove('hidden');
        }
    } else {
        // Switch to All Sales mode
        if (allSalesView) {
            allSalesView.classList.remove('hidden');
            hqOnlyView.classList.add('hidden');
            toggleLabel.textContent = 'All Sales';
            toggleButton.classList.add('bg-gray-300', 'dark:bg-gray-600');
            toggleButton.classList.remove('bg-purple-600');
            toggleThumb.classList.add('translate-x-1');
            toggleThumb.classList.remove('translate-x-6');
        }

        if (yearlyAllSalesView) {
            yearlyAllSalesView.classList.remove('hidden');
            yearlyHqOnlyView.classList.add('hidden');
            yearlyAllSalesRoi.classList.remove('hidden');
            yearlyHqOnlyRoi.classList.add('hidden');
            yearlyHqExplanation.classList.add('hidden');
            toggleLabelYearly.textContent = 'All Sales';
            toggleButtonYearly.classList.add('bg-gray-300', 'dark:bg-gray-600');
            toggleButtonYearly.classList.remove('bg-purple-600');
            toggleThumbYearly.classList.add('translate-x-1');
            toggleThumbYearly.classList.remove('translate-x-6');
        }

        // Toggle yearly channel breakdown
        if (yearlyChannelAllSales && yearlyChannelHqOnly) {
            yearlyChannelAllSales.classList.remove('hidden');
            yearlyChannelHqOnly.classList.add('hidden');
        }
    }
}

// Calculate total spend
function updateTotal() {
    const inputs = [
        'brand_ambassador_spend',
        'ads_spend',
        'social_media_spend',
        'events_spend',
        'other_spend'
    ];

    let total = 0;
    inputs.forEach(name => {
        const value = parseFloat(document.querySelector(`input[name="${name}"]`).value) || 0;
        total += value;
    });

    document.getElementById('totalSpend').textContent = 'RM ' + total.toLocaleString('en-MY', {minimumFractionDigits: 2, maximumFractionDigits: 2});
}

// Toggle collapsible sections
function toggleSection(sectionId) {
    const section = document.getElementById(sectionId);
    const icon = document.getElementById(sectionId + 'Icon');

    if (section.classList.contains('hidden')) {
        section.classList.remove('hidden');
        icon.classList.add('rotate-180');
    } else {
        section.classList.add('hidden');
        icon.classList.remove('rotate-180');
    }
}

// Update channels input
function updateChannels() {
    const checkboxes = document.querySelectorAll('input[name="channels[]"]:checked');
    const values = Array.from(checkboxes).map(cb => cb.value);
    document.getElementById('channelsInput').value = values.join(', ');
}

// Add event listeners
document.querySelectorAll('input[type="number"]').forEach(input => {
    input.addEventListener('input', updateTotal);
});

document.querySelectorAll('input[name="channels[]"]').forEach(checkbox => {
    checkbox.addEventListener('change', updateChannels);
});

// Form submission (only for monthly mode)
<?php if($periodType === 'monthly'): ?>
const form = document.querySelector('form');
if (form) {
    form.addEventListener('submit', function(e) {
        updateChannels();
    });
}
<?php endif; ?>

// Initial calculations
updateTotal();
updateChannels();

// Get AI Suggestions
function getAiSuggestions() {
    const modal = document.getElementById('aiLoadingModal');
    modal.classList.remove('hidden');

    // Determine revenue mode based on toggle state
    const revenueMode = isHqOnlyMode ? 'hq_only' : 'all_sales';

    fetch('<?php echo e(route("forecasting.marketing-strategy.ai")); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        },
        body: JSON.stringify({
            year: <?php echo e($year); ?>,
            month: <?php echo e($month); ?>,
            period_type: '<?php echo e($periodType); ?>',
            revenue_mode: revenueMode
        })
    })
    .then(response => response.json())
    .then(data => {
        modal.classList.add('hidden');
        if (data.success) {
            <?php if($periodType === 'yearly'): ?>
            // For yearly analysis, display results without reload
            displayYearlyResults(data.suggestions, data.revenue_mode || 'all_sales');
            <?php else: ?>
            // For monthly, reload to show saved data
            window.location.reload();
            <?php endif; ?>
        } else {
            alert('Error: ' + data.message);
        }
    })
    .catch(error => {
        modal.classList.add('hidden');
        alert('Error getting AI suggestions: ' + error);
    });
}

<?php if($periodType === 'yearly'): ?>
// Display yearly strategic results
function displayYearlyResults(suggestions, revenueMode) {
    // Create results container if it doesn't exist
    let resultsDiv = document.getElementById('yearlyAiResults');
    if (!resultsDiv) {
        resultsDiv = document.createElement('div');
        resultsDiv.id = 'yearlyAiResults';
        resultsDiv.className = 'mt-6';
        document.querySelector('.max-w-4xl').appendChild(resultsDiv);
    }

    // Parse analysis into structured format
    const analysisItems = parseAiText(suggestions.analysis || '');
    const recommendationItems = parseAiText(suggestions.recommendations || '');

    // Determine mode badge
    const isHqMode = revenueMode === 'hq_only';
    const modeBadge = isHqMode
        ? '<span class="ml-3 px-3 py-1 bg-purple-800 rounded-full text-xs font-semibold">HQ Sales Only Analysis</span>'
        : '<span class="ml-3 px-3 py-1 bg-blue-800 rounded-full text-xs font-semibold">All Sales Analysis</span>';

    const modeDescription = isHqMode
        ? '<p class="text-sm text-purple-100 mt-2">📊 This analysis focuses on HQ sales only, providing accurate marketing effectiveness insights.</p>'
        : '<p class="text-sm text-purple-100 mt-2">📊 This analysis includes all sales channels (HQ + Stokis + Agent).</p>';

    resultsDiv.innerHTML = `
        <!-- Header -->
        <div class="bg-gradient-to-r from-purple-600 to-pink-600 rounded-t-lg p-6 text-white">
            <div class="flex items-center gap-3">
                <img src="<?php echo e(asset('images/chatbot-aicon.png')); ?>" alt="AI" class="w-8 h-8">
                <div class="flex-1">
                    <div class="flex items-center">
                        <h3 class="text-2xl font-bold">AI-Powered Strategic Insights</h3>
                        ${modeBadge}
                    </div>
                    <p class="text-purple-100 text-sm">Long-term planning for <?php echo e($year + 1); ?></p>
                    ${modeDescription}
                </div>
            </div>
        </div>

        <!-- Analysis Section -->
        ${suggestions.analysis ? `
            <div class="bg-white dark:bg-gray-800 border-x border-purple-200 dark:border-purple-800 p-6">
                <div class="flex items-center gap-2 mb-4">
                    <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                    </svg>
                    <h4 class="text-xl font-bold text-gray-900 dark:text-white">Strategic Analysis</h4>
                </div>
                <div class="space-y-3">${analysisItems}</div>
            </div>
        ` : ''}

        <!-- Recommendations Section -->
        ${suggestions.recommendations ? `
            <div class="bg-white dark:bg-gray-800 border-x border-b border-purple-200 dark:border-purple-800 rounded-b-lg p-6">
                <div class="flex items-center gap-2 mb-4">
                    <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <h4 class="text-xl font-bold text-gray-900 dark:text-white">Strategic Action Plan for <?php echo e($year + 1); ?></h4>
                </div>
                <div class="space-y-3">${recommendationItems}</div>
            </div>
        ` : ''}
    `;

    // Scroll to results
    resultsDiv.scrollIntoView({ behavior: 'smooth', block: 'center' });
}

// Helper function to parse AI text into cards
function parseAiText(text) {
    const lines = text.split('\n');
    let html = '';
    let counter = 0;

    lines.forEach(line => {
        line = line.trim();

        // Match numbered items with bold titles: 1. **Title**: Description
        const titleMatch = line.match(/^\d+\.\s+\*\*(.+?)\*\*:\s*(.+)$/);
        if (titleMatch) {
            counter++;
            html += `
                <div class="flex gap-3 p-4 bg-blue-50 dark:bg-blue-900/20 rounded-lg border border-blue-200 dark:border-blue-800 hover:shadow-md transition-shadow">
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-blue-600 text-white rounded-full flex items-center justify-center font-bold text-sm">${counter}</div>
                    </div>
                    <div class="flex-1">
                        <h5 class="font-bold text-blue-900 dark:text-blue-300 mb-1">${titleMatch[1]}</h5>
                        <p class="text-gray-700 dark:text-gray-300 text-sm leading-relaxed">${titleMatch[2]}</p>
                    </div>
                </div>
            `;
            return;
        }

        // Match numbered items: 1. Text
        const numberedMatch = line.match(/^\d+\.\s+(.+)$/);
        if (numberedMatch) {
            counter++;
            html += `
                <div class="flex gap-3 p-4 bg-green-50 dark:bg-green-900/20 rounded-lg border border-green-200 dark:border-green-800 hover:shadow-md transition-shadow">
                    <div class="flex-shrink-0">
                        <div class="w-8 h-8 bg-green-600 text-white rounded-full flex items-center justify-center font-bold text-sm">${counter}</div>
                    </div>
                    <div class="flex-1">
                        <p class="text-gray-700 dark:text-gray-300 leading-relaxed">${numberedMatch[1]}</p>
                    </div>
                </div>
            `;
            return;
        }

        // Match bullet points: - Text or • Text
        const bulletMatch = line.match(/^[-•]\s*(.+)$/);
        if (bulletMatch) {
            counter++;
            html += `
                <div class="flex gap-3 p-4 bg-gray-50 dark:bg-gray-900/20 rounded-lg border border-gray-200 dark:border-gray-700">
                    <span class="text-purple-600 font-bold">•</span>
                    <p class="text-gray-700 dark:text-gray-300 leading-relaxed">${bulletMatch[1]}</p>
                </div>
            `;
            return;
        }

        // Regular text (not empty, not headers)
        if (line && !line.match(/^(Analysis|Recommendations|ANALYSIS|RECOMMENDATIONS|###)/i)) {
            html += `<p class="text-gray-700 dark:text-gray-300 leading-relaxed p-2">${line}</p>`;
        }
    });

    return html || '<p class="text-gray-500 dark:text-gray-400">No insights available.</p>';
}
<?php endif; ?>
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\multistore\resources\views/forecasting/marketing-strategy/input.blade.php ENDPATH**/ ?>