@extends('layouts.app')

@section('title', auth()->user()->isManager() ? 'My Sellers' : 'User Management')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">{{ auth()->user()->isManager() ? 'My Sellers' : 'User Management' }}</h1>
        @if(auth()->user()->isAdmin())
            <a href="{{ route('users.create') }}"
               class="inline-flex items-center gap-2 px-5 py-2.5 bg-blue-600 text-white rounded-lg hover:bg-blue-700 shadow-md hover:shadow-lg transition-all duration-200 font-medium">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"/>
                </svg>
                Add New User
            </a>
        @endif
    </div>

    @if($users->count() > 0)
    <div class="bg-white dark:bg-gray-800 shadow rounded-lg overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
            <thead class="bg-gray-50 dark:bg-gray-700">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Name</th>
                    <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Email</th>
                    <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Role</th>
                    <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">
                        @if(auth()->user()->isAdmin())
                            Assigned Stores
                        @else
                            Assign Platform
                        @endif
                    </th>
                    <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Created</th>
                    @if(auth()->user()->isAdmin())
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Actions</th>
                    @endif
                </tr>
            </thead>
            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                @foreach($users as $user)
                <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm font-medium">{{ $user->name }}</div>
                        @if($user->company_name)
                            <div class="text-xs text-gray-500 dark:text-gray-400">{{ $user->company_name }}</div>
                        @endif
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm">{{ $user->email }}</div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        @if($user->role === 'admin')
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-purple-100 text-purple-800 dark:bg-purple-900 dark:text-purple-200">
                                Admin
                            </span>
                        @elseif($user->role === 'manager')
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200">
                                Manager
                            </span>
                        @else
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200">
                                Seller
                            </span>
                        @endif
                    </td>
                    <td class="px-6 py-4 text-sm text-gray-500 dark:text-gray-400">
                        @if($user->role === 'admin')
                            @if(auth()->user()->isAdmin())
                                <span class="text-gray-400 italic">All Stores</span>
                            @else
                                <span class="text-gray-400 italic">All Platforms</span>
                            @endif
                        @elseif($user->role === 'manager')
                            @php
                                $storesCount = $user->stores_count ?? $user->stores()->count();
                                $pagesCount = $user->salesPages()->count();
                                $sellersCount = $user->managedSellers()->count();
                                $tiktokShopsCount = $user->tiktok_shops_count ?? $user->tiktokShops()->count();
                                $platforms = [];
                                if ($storesCount > 0) $platforms[] = $storesCount . ' ' . Str::plural('store', $storesCount);
                                if ($pagesCount > 0) $platforms[] = $pagesCount . ' ' . Str::plural('page', $pagesCount);
                                if ($sellersCount > 0) $platforms[] = $sellersCount . ' ' . Str::plural('seller', $sellersCount);
                                if ($tiktokShopsCount > 0) $platforms[] = $tiktokShopsCount . ' TikTok ' . Str::plural('Shop', $tiktokShopsCount);
                            @endphp
                            @if(count($platforms) > 0)
                                <div class="flex flex-col gap-1">
                                    @foreach($platforms as $platform)
                                        <span class="text-xs">{{ $platform }}</span>
                                    @endforeach
                                </div>
                            @else
                                <span class="text-red-500">No platforms assigned</span>
                            @endif
                        @else
                            @php
                                $storesCount = $user->stores()->count();
                                $pagesCount = $user->salesPages()->count();
                                $platforms = [];
                                if ($storesCount > 0) $platforms[] = $storesCount . ' ' . Str::plural('store', $storesCount);
                                if ($pagesCount > 0) $platforms[] = $pagesCount . ' ' . Str::plural('page', $pagesCount);
                            @endphp
                            @if(count($platforms) > 0)
                                <div class="flex flex-col gap-1">
                                    @foreach($platforms as $platform)
                                        <span class="text-xs">{{ $platform }}</span>
                                    @endforeach
                                </div>
                            @else
                                <span class="text-red-500">No platforms assigned</span>
                            @endif
                        @endif
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                        {{ $user->created_at->format('M d, Y') }}
                    </td>
                    @if(auth()->user()->isAdmin())
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <div class="flex items-center gap-2">
                                @if($user->id !== auth()->id())
                                    <!-- Login as User Button -->
                                    <form action="{{ route('users.impersonate', $user) }}" method="POST" class="inline">
                                        @csrf
                                        <button type="submit"
                                                class="inline-flex items-center gap-1 px-3 py-1.5 text-green-600 dark:text-green-400 hover:bg-green-50 dark:hover:bg-green-900/20 rounded-lg transition-colors font-medium"
                                                title="Login as this user to help them">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                            </svg>
                                            Login as
                                        </button>
                                    </form>
                                @endif

                                <a href="{{ route('users.edit', $user) }}"
                                   class="inline-flex items-center gap-1 px-3 py-1.5 text-indigo-600 dark:text-indigo-400 hover:bg-indigo-50 dark:hover:bg-indigo-900/20 rounded-lg transition-colors font-medium">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                    </svg>
                                    Edit
                                </a>
                                @if($user->id !== auth()->id())
                                    <form action="{{ route('users.destroy', $user) }}" method="POST" class="inline"
                                          onsubmit="return confirm('Are you sure you want to delete this user?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit"
                                                class="inline-flex items-center gap-1 px-3 py-1.5 text-red-600 dark:text-red-400 hover:bg-red-50 dark:hover:bg-red-900/20 rounded-lg transition-colors font-medium">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                                            </svg>
                                            Delete
                                        </button>
                                    </form>
                                @else
                                    <span class="px-3 py-1.5 text-gray-400 italic text-sm">Current User</span>
                                @endif
                            </div>
                        </td>
                    @endif
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        {{ $users->links() }}
    </div>
    @else
    <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6 text-center">
        <p class="text-gray-500 dark:text-gray-400">No users found.</p>
    </div>
    @endif
</div>
@endsection
