@extends('layouts.app')

@section('title', 'Add New User')

@section('content')
<div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6">
        <h1 class="text-2xl font-bold">Add New User</h1>
        <p class="text-gray-600 dark:text-gray-400">Create a new admin or seller account</p>
    </div>

    <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
        <form action="{{ route('users.store') }}" method="POST">
            @csrf

            <div class="space-y-6">
                <!-- Account Information -->
                <div>
                    <h3 class="text-lg font-semibold mb-4 border-b pb-2">Account Information</h3>
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium mb-2">Name *</label>
                            <input type="text" name="name" value="{{ old('name') }}" required
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="John Doe">
                            @error('name')
                                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">Email *</label>
                            <input type="email" name="email" value="{{ old('email') }}" required
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="john@example.com">
                            @error('email')
                                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">Password *</label>
                            <input type="password" name="password" required
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="Minimum 8 characters">
                            @error('password')
                                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                            @enderror
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">Confirm Password *</label>
                            <input type="password" name="password_confirmation" required
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="Re-enter password">
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">Role *</label>
                            <select name="role" id="role" required
                                    class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700">
                                <option value="">Select Role</option>
                                <option value="admin" {{ old('role') === 'admin' ? 'selected' : '' }}>Admin - Full access to all stores</option>
                                <option value="seller" {{ old('role') === 'seller' ? 'selected' : '' }}>Seller - Limited to assigned stores</option>
                                <option value="manager" {{ old('role') === 'manager' ? 'selected' : '' }}>Manager - Monitor and process orders for assigned sellers</option>
                            </select>
                            @error('role')
                                <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Store Assignment (Seller Only) -->
                <div id="store-assignment" style="display: none;">
                    <h3 class="text-lg font-semibold mb-4 border-b pb-2">Store Assignment</h3>
                    <div class="space-y-2">
                        @if($stores->count() > 0)
                            @foreach($stores as $store)
                                <label class="flex items-center space-x-2">
                                    <input type="checkbox" name="store_ids[]" value="{{ $store->id }}"
                                           {{ is_array(old('store_ids')) && in_array($store->id, old('store_ids')) ? 'checked' : '' }}
                                           class="rounded border-gray-300 dark:border-gray-600">
                                    <span class="text-sm">{{ $store->name }}</span>
                                </label>
                            @endforeach
                        @else
                            <p class="text-sm text-gray-500 dark:text-gray-400">No stores available. Create stores first.</p>
                        @endif
                        @error('store_ids')
                            <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <!-- Seller Assignment (Manager Only) -->
                <div id="seller-assignment" style="display: none;">
                    <h3 class="text-lg font-semibold mb-4 border-b pb-2">Seller Assignment</h3>
                    <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
                        Select which sellers this manager can monitor and process orders for.
                    </p>
                    <div class="space-y-2">
                        @php
                            $sellers = \App\Models\User::where('role', 'seller')->orderBy('name')->get();
                        @endphp
                        @if($sellers->count() > 0)
                            @foreach($sellers as $seller)
                                <label class="flex items-center space-x-2">
                                    <input type="checkbox" name="seller_ids[]" value="{{ $seller->id }}"
                                           {{ is_array(old('seller_ids')) && in_array($seller->id, old('seller_ids')) ? 'checked' : '' }}
                                           class="rounded border-gray-300 dark:border-gray-600">
                                    <span class="text-sm">{{ $seller->name }} ({{ $seller->email }})</span>
                                </label>
                            @endforeach
                        @else
                            <p class="text-sm text-gray-500 dark:text-gray-400">No sellers available. Create sellers first.</p>
                        @endif
                        @error('seller_ids')
                            <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <!-- Company Information (Optional) -->
                <div>
                    <h3 class="text-lg font-semibold mb-4 border-b pb-2">Company Information (Optional)</h3>
                    <div class="grid grid-cols-2 gap-4">
                        <div class="col-span-2">
                            <label class="block text-sm font-medium mb-2">Company Name</label>
                            <input type="text" name="company_name" value="{{ old('company_name') }}"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="ABC Trading Sdn Bhd">
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">Registration Number</label>
                            <input type="text" name="company_registration" value="{{ old('company_registration') }}"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="202301234567">
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">Company Phone</label>
                            <input type="text" name="company_phone" value="{{ old('company_phone') }}"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="+60123456789">
                        </div>

                        <div class="col-span-2">
                            <label class="block text-sm font-medium mb-2">Company Address</label>
                            <textarea name="company_address" rows="2"
                                      class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                      placeholder="123 Business Street">{{ old('company_address') }}</textarea>
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">City</label>
                            <input type="text" name="company_city" value="{{ old('company_city') }}"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="Kuala Lumpur">
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">State</label>
                            <input type="text" name="company_state" value="{{ old('company_state') }}"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="Selangor">
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">Postcode</label>
                            <input type="text" name="company_postcode" value="{{ old('company_postcode') }}"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="50000">
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">Country</label>
                            <input type="text" name="company_country" value="{{ old('company_country', 'Malaysia') }}"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="Malaysia">
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">Company Email</label>
                            <input type="email" name="company_email" value="{{ old('company_email') }}"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="info@company.com">
                        </div>

                        <div>
                            <label class="block text-sm font-medium mb-2">Website</label>
                            <input type="url" name="company_website" value="{{ old('company_website') }}"
                                   class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                                   placeholder="https://company.com">
                        </div>
                    </div>
                </div>
            </div>

            <div class="mt-6 flex justify-end gap-3">
                <a href="{{ route('users.index') }}"
                   class="inline-flex items-center gap-2 px-5 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors font-medium">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                    Cancel
                </a>
                <button type="submit"
                        class="inline-flex items-center gap-2 px-5 py-2.5 bg-blue-600 text-white rounded-lg hover:bg-blue-700 shadow-md hover:shadow-lg transition-all font-medium">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                    Create User
                </button>
            </div>
        </form>
    </div>
</div>

<script>
    // Show/hide store and seller assignment based on role
    document.getElementById('role').addEventListener('change', function() {
        const storeAssignment = document.getElementById('store-assignment');
        const sellerAssignment = document.getElementById('seller-assignment');

        if (this.value === 'seller') {
            storeAssignment.style.display = 'block';
            sellerAssignment.style.display = 'none';
        } else if (this.value === 'manager') {
            storeAssignment.style.display = 'none';
            sellerAssignment.style.display = 'block';
        } else {
            storeAssignment.style.display = 'none';
            sellerAssignment.style.display = 'none';
        }
    });

    // Trigger on page load if role is pre-selected
    const currentRole = document.getElementById('role').value;
    if (currentRole === 'seller') {
        document.getElementById('store-assignment').style.display = 'block';
    } else if (currentRole === 'manager') {
        document.getElementById('seller-assignment').style.display = 'block';
    }
</script>
@endsection
