@extends('layouts.app')

@section('title', 'Create TikTok Shop')

@section('content')
<div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6">
        <a href="{{ route('tiktok-shops-management.index') }}"
           class="inline-flex items-center text-sm text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-200">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
            </svg>
            Back to TikTok Shops
        </a>
    </div>

    <div class="bg-white dark:bg-gray-800 shadow rounded-lg">
        <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
            <h2 class="text-xl font-semibold">Create New TikTok Shop</h2>
            <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                Add a new TikTok Shop to the system. You can assign managers to this shop later.
            </p>
        </div>

        <form action="{{ route('tiktok-shops-management.store') }}" method="POST" class="p-6 space-y-6">
            @csrf

            <!-- Shop Name -->
            <div>
                <label for="name" class="block text-sm font-medium mb-2">
                    Shop Name <span class="text-red-500">*</span>
                </label>
                <input type="text"
                       name="name"
                       id="name"
                       value="{{ old('name') }}"
                       required
                       class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent dark:bg-gray-700 dark:text-white"
                       placeholder="e.g., Mamadil TikTok Shop">
                @error('name')
                    <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                    Enter a unique name for this TikTok Shop account
                </p>
            </div>

            <!-- Description -->
            <div>
                <label for="description" class="block text-sm font-medium mb-2">
                    Description (Optional)
                </label>
                <textarea name="description"
                          id="description"
                          rows="3"
                          class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent dark:bg-gray-700 dark:text-white"
                          placeholder="e.g., Official TikTok Shop for electronics products">{{ old('description') }}</textarea>
                @error('description')
                    <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <!-- Status -->
            <div>
                <label class="block text-sm font-medium mb-2">Status</label>
                <div class="flex items-center">
                    <input type="checkbox"
                           name="is_active"
                           id="is_active"
                           value="1"
                           {{ old('is_active', true) ? 'checked' : '' }}
                           class="w-4 h-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500 dark:border-gray-600 dark:bg-gray-700">
                    <label for="is_active" class="ml-2 text-sm">
                        Active (Shop is currently in use)
                    </label>
                </div>
                @error('is_active')
                    <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                @enderror
            </div>

            <!-- Assign Managers -->
            <div>
                <label class="block text-sm font-medium mb-2">Assign Managers (Optional)</label>
                <p class="text-xs text-gray-500 dark:text-gray-400 mb-3">
                    Select which managers can access and upload data to this TikTok Shop
                </p>
                <div class="space-y-2">
                    @php
                        $managers = \App\Models\User::where('role', 'manager')->orderBy('name')->get();
                    @endphp
                    @if($managers->count() > 0)
                        @foreach($managers as $manager)
                            <label class="flex items-center space-x-2">
                                <input type="checkbox"
                                       name="manager_ids[]"
                                       value="{{ $manager->id }}"
                                       {{ (is_array(old('manager_ids')) && in_array($manager->id, old('manager_ids'))) ? 'checked' : '' }}
                                       class="rounded border-gray-300 dark:border-gray-600 text-blue-600 focus:ring-blue-500">
                                <span class="text-sm">{{ $manager->name }} ({{ $manager->email }})</span>
                            </label>
                        @endforeach
                    @else
                        <p class="text-sm text-gray-500 dark:text-gray-400">
                            No managers available. You can assign managers later from User Management.
                        </p>
                    @endif
                    @error('manager_ids')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <!-- Form Actions -->
            <div class="flex items-center justify-end gap-3 pt-4 border-t border-gray-200 dark:border-gray-700">
                <a href="{{ route('tiktok-shops-management.index') }}"
                   class="px-5 py-2.5 border border-gray-300 dark:border-gray-600 text-gray-700 dark:text-gray-300 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 font-medium">
                    Cancel
                </a>
                <button type="submit"
                        class="px-5 py-2.5 bg-blue-600 text-white rounded-lg hover:bg-blue-700 shadow-md hover:shadow-lg transition-all duration-200 font-medium">
                    Create TikTok Shop
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
