@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="max-w-5xl mx-auto">
        <!-- Header -->
        <div class="mb-6">
            <h1 class="text-2xl font-bold text-gray-900 dark:text-white">📊 Preview TikTok Shop Import</h1>
            <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">Review the data before importing</p>
        </div>

        @php
            $summary = $result['summary'];
        @endphp

        <!-- Summary Cards -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
            <!-- Total Transactions -->
            <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-4">
                <div class="text-xs text-gray-600 dark:text-gray-400">Total Transactions</div>
                <div class="text-2xl font-bold text-gray-900 dark:text-white">{{ number_format($result['parsed']) }}</div>
                <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                    {{ $summary['total_orders'] }} orders, {{ $summary['total_refunds'] }} refunds
                </div>
            </div>

            <!-- Total Revenue -->
            <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-4">
                <div class="text-xs text-gray-600 dark:text-gray-400">Gross Revenue</div>
                <div class="text-2xl font-bold text-green-600 dark:text-green-400">
                    RM {{ number_format($summary['total_revenue'], 2) }}
                </div>
                <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                    Avg: RM {{ number_format($summary['avg_order_value'], 2) }}
                </div>
            </div>

            <!-- Total Fees -->
            <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-4">
                <div class="text-xs text-gray-600 dark:text-gray-400">TikTok Fees</div>
                <div class="text-2xl font-bold text-red-600 dark:text-red-400">
                    RM {{ number_format(abs($summary['total_fees']), 2) }}
                </div>
                @php
                    $feePercentage = $summary['total_revenue'] > 0 ? (abs($summary['total_fees']) / $summary['total_revenue']) * 100 : 0;
                @endphp
                <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                    {{ number_format($feePercentage, 1) }}% of revenue
                </div>
            </div>

            <!-- Net Settlement -->
            <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-4">
                <div class="text-xs text-gray-600 dark:text-gray-400">Net Settlement</div>
                <div class="text-2xl font-bold text-indigo-600 dark:text-indigo-400">
                    RM {{ number_format($summary['total_settlement'], 2) }}
                </div>
                <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                    After all fees
                </div>
            </div>
        </div>

        <!-- Date Range & Status -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
            <!-- Date Range -->
            <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4">
                <div class="text-sm font-semibold text-blue-900 dark:text-blue-200 mb-2">📅 Date Range</div>
                <div class="text-lg font-bold text-blue-800 dark:text-blue-300">
                    {{ \Carbon\Carbon::parse($summary['date_range']['from'])->format('M d, Y') }}
                    →
                    {{ \Carbon\Carbon::parse($summary['date_range']['to'])->format('M d, Y') }}
                </div>
                @php
                    $daysDiff = \Carbon\Carbon::parse($summary['date_range']['from'])->diffInDays(\Carbon\Carbon::parse($summary['date_range']['to'])) + 1;
                @endphp
                <div class="text-xs text-blue-700 dark:text-blue-400 mt-1">
                    {{ $daysDiff }} days of data
                </div>
            </div>

            <!-- Import Status -->
            <div class="bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-lg p-4">
                <div class="text-sm font-semibold text-green-900 dark:text-green-200 mb-2">✅ Ready to Import</div>
                <div class="text-lg font-bold text-green-800 dark:text-green-300">
                    {{ number_format($result['parsed']) }} new transactions
                </div>
                @if($result['skipped'] > 0)
                    <div class="text-xs text-yellow-700 dark:text-yellow-400 mt-1">
                        ⚠️ {{ $result['skipped'] }} rows skipped (duplicates or errors)
                    </div>
                @else
                    <div class="text-xs text-green-700 dark:text-green-400 mt-1">
                        No duplicates found
                    </div>
                @endif
            </div>
        </div>

        <!-- Sample Data Preview -->
        <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6 mb-6">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">📋 Sample Data (First 10 transactions)</h3>

            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                    <thead class="bg-gray-50 dark:bg-gray-700">
                        <tr>
                            <th class="px-4 py-2 text-left text-xs font-semibold text-gray-700 dark:text-gray-300">Date</th>
                            <th class="px-4 py-2 text-left text-xs font-semibold text-gray-700 dark:text-gray-300">Type</th>
                            <th class="px-4 py-2 text-right text-xs font-semibold text-gray-700 dark:text-gray-300">Revenue</th>
                            <th class="px-4 py-2 text-right text-xs font-semibold text-gray-700 dark:text-gray-300">Fees</th>
                            <th class="px-4 py-2 text-right text-xs font-semibold text-gray-700 dark:text-gray-300">Net</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                        @foreach(array_slice($result['transactions'], 0, 10) as $transaction)
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
                            <td class="px-4 py-2 text-sm text-gray-900 dark:text-white">
                                {{ \Carbon\Carbon::parse($transaction['order_date'])->format('Y-m-d') }}
                            </td>
                            <td class="px-4 py-2">
                                @if($transaction['type'] === 'Order')
                                    <span class="px-2 py-1 text-xs font-semibold rounded bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200">
                                        Order
                                    </span>
                                @elseif($transaction['type'] === 'Refund')
                                    <span class="px-2 py-1 text-xs font-semibold rounded bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200">
                                        Refund
                                    </span>
                                @else
                                    <span class="px-2 py-1 text-xs font-semibold rounded bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300">
                                        {{ $transaction['type'] }}
                                    </span>
                                @endif
                            </td>
                            <td class="px-4 py-2 text-sm text-right font-mono text-gray-900 dark:text-white">
                                RM {{ number_format($transaction['total_revenue'], 2) }}
                            </td>
                            <td class="px-4 py-2 text-sm text-right font-mono text-red-600 dark:text-red-400">
                                RM {{ number_format(abs($transaction['total_fees']), 2) }}
                            </td>
                            <td class="px-4 py-2 text-sm text-right font-mono font-semibold text-indigo-600 dark:text-indigo-400">
                                RM {{ number_format($transaction['net_settlement'], 2) }}
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            @if(count($result['transactions']) > 10)
                <p class="text-xs text-gray-500 dark:text-gray-400 mt-3 text-center">
                    Showing 10 of {{ number_format(count($result['transactions'])) }} transactions
                </p>
            @endif
        </div>

        <!-- Errors (if any) -->
        @if(!empty($result['errors']) && count($result['errors']) > 0)
        <div class="bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 rounded-lg p-4 mb-6">
            <h3 class="text-sm font-semibold text-yellow-900 dark:text-yellow-200 mb-2">⚠️ Skipped Rows</h3>
            <div class="text-xs text-yellow-800 dark:text-yellow-300 space-y-1 max-h-40 overflow-y-auto">
                @foreach(array_slice($result['errors'], 0, 10) as $error)
                    <div>• {{ $error }}</div>
                @endforeach
                @if(count($result['errors']) > 10)
                    <div class="text-yellow-700 dark:text-yellow-400 mt-2">
                        ... and {{ count($result['errors']) - 10 }} more
                    </div>
                @endif
            </div>
        </div>
        @endif

        <!-- Action Buttons -->
        <form action="{{ route('tiktok-shop.import') }}" method="POST">
            @csrf
            <div class="flex gap-3">
                <button type="submit"
                        class="flex-1 px-6 py-3 bg-green-500 text-white font-semibold rounded-lg hover:bg-green-600 focus:outline-none focus:ring-2 focus:ring-green-500">
                    ✅ Confirm & Import {{ number_format($result['parsed']) }} Transactions
                </button>
                <a href="{{ route('tiktok-shop.upload') }}"
                   class="px-6 py-3 bg-gray-300 dark:bg-gray-600 text-gray-700 dark:text-gray-300 font-semibold rounded-lg hover:bg-gray-400 dark:hover:bg-gray-500 text-center">
                    Cancel
                </a>
            </div>
        </form>

        <!-- Note -->
        <div class="mt-4 p-3 bg-gray-50 dark:bg-gray-700 rounded text-xs text-gray-600 dark:text-gray-400">
            <strong>Note:</strong> Duplicate orders (same Order ID) will be automatically skipped. Your existing data is safe.
        </div>
    </div>
</div>
@endsection
