@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="max-w-5xl mx-auto">
        <!-- Header -->
        <div class="mb-6">
            <h1 class="text-2xl font-bold text-gray-900 dark:text-white">💰 Preview Ads Spending Data</h1>
            <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">Review your data before importing</p>
        </div>

        <!-- Summary Card -->
        <div class="bg-gradient-to-r from-purple-500 to-purple-600 rounded-lg shadow-lg p-6 mb-6 text-white">
            <h2 class="text-lg font-semibold mb-4">📊 Upload Summary</h2>
            <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                <div>
                    <div class="text-xs opacity-90">Total Transactions</div>
                    <div class="text-2xl font-bold">{{ number_format($result['summary']['total_transactions']) }}</div>
                </div>
                <div>
                    <div class="text-xs opacity-90">Successful</div>
                    <div class="text-2xl font-bold">{{ number_format($result['summary']['successful_transactions']) }}</div>
                </div>
                <div>
                    <div class="text-xs opacity-90">Total Spent</div>
                    <div class="text-2xl font-bold">{{ $result['summary']['currency'] }} {{ number_format($result['summary']['total_spent'], 2) }}</div>
                </div>
                <div>
                    <div class="text-xs opacity-90">Parsed Rows</div>
                    <div class="text-2xl font-bold">{{ $result['parsed'] }} / {{ $result['total_rows'] }}</div>
                </div>
            </div>
        </div>

        <!-- Errors -->
        @if(!empty($result['errors']))
        <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg p-4 mb-6">
            <h3 class="text-sm font-semibold text-red-900 dark:text-red-200 mb-2">⚠️ Errors ({{ count($result['errors']) }})</h3>
            <ul class="text-xs text-red-800 dark:text-red-300 space-y-1 ml-4 list-disc max-h-40 overflow-y-auto">
                @foreach($result['errors'] as $error)
                <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
        @endif

        <!-- Sample Data -->
        <div class="bg-white dark:bg-gray-800 shadow rounded-lg overflow-hidden mb-6">
            <div class="px-6 py-4 bg-purple-50 dark:bg-purple-900/20 border-b border-purple-200 dark:border-purple-800">
                <h3 class="text-lg font-semibold text-purple-900 dark:text-purple-200">Sample Transactions (First 10)</h3>
            </div>

            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                    <thead class="bg-gray-50 dark:bg-gray-700">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 dark:text-gray-300">Transaction Time</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 dark:text-gray-300">Transaction ID</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 dark:text-gray-300">Payment Method</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 dark:text-gray-300">Status</th>
                            <th class="px-6 py-3 text-right text-xs font-semibold text-gray-700 dark:text-gray-300">Amount</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 dark:text-gray-300">Type</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                        @foreach(array_slice($result['transactions'], 0, 10) as $transaction)
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
                            <td class="px-6 py-3 text-sm text-gray-900 dark:text-white">
                                {{ $transaction['transaction_time']->format('Y-m-d H:i') }}
                            </td>
                            <td class="px-6 py-3 text-sm font-mono text-gray-600 dark:text-gray-400">
                                {{ Str::limit($transaction['transaction_id'], 25) }}
                            </td>
                            <td class="px-6 py-3 text-xs text-gray-600 dark:text-gray-400">
                                {{ Str::limit($transaction['payment_method'], 30) }}
                            </td>
                            <td class="px-6 py-3">
                                @if($transaction['status'] === 'Success')
                                    <span class="px-2 py-1 text-xs rounded bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200">Success</span>
                                @else
                                    <span class="px-2 py-1 text-xs rounded bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-200">{{ $transaction['status'] }}</span>
                                @endif
                            </td>
                            <td class="px-6 py-3 text-sm text-right font-mono font-semibold text-purple-600 dark:text-purple-400">
                                {{ $transaction['currency'] }} {{ number_format($transaction['amount'], 2) }}
                            </td>
                            <td class="px-6 py-3 text-xs text-gray-600 dark:text-gray-400">
                                {{ $transaction['transaction_type'] }}
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            @if(count($result['transactions']) > 10)
            <div class="px-6 py-3 bg-gray-50 dark:bg-gray-700 text-center text-sm text-gray-600 dark:text-gray-400">
                ... and {{ count($result['transactions']) - 10 }} more transactions
            </div>
            @endif
        </div>

        <!-- Actions -->
        <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
            <div class="flex gap-3">
                <form action="{{ route('tiktok-shop.ads.import') }}" method="POST" class="flex-1">
                    @csrf
                    <button type="submit"
                            class="w-full px-6 py-3 bg-purple-600 text-white text-base font-bold rounded-lg hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-purple-500 shadow-md transition-all">
                        ✅ Confirm & Import {{ count($result['transactions']) }} Transactions
                    </button>
                </form>

                <a href="{{ route('tiktok-shop.index') }}"
                   class="px-6 py-3 bg-red-600 text-white text-base font-semibold rounded-lg hover:bg-red-700 text-center shadow-md transition-all">
                    Cancel
                </a>
            </div>

            <p class="text-xs text-gray-500 dark:text-gray-400 mt-3 text-center">
                💡 Duplicate transactions will be automatically skipped during import
            </p>
        </div>
    </div>
</div>
@endsection
