@extends('layouts.app')

@section('title', 'Generic Webhooks')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-2xl font-bold">Generic Webhooks</h1>
            <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">Accept orders from any payment form or platform</p>
        </div>
        <a href="{{ route('stores.webhooks.create') }}"
           class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
            Add New Webhook
        </a>
    </div>

    @if($webhooks->count() > 0)
    <div class="bg-white dark:bg-gray-800 shadow rounded-lg overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
            <thead class="bg-gray-50 dark:bg-gray-700">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Name</th>
                    <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Type</th>
                    <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Total Requests</th>
                    <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Success Rate</th>
                    <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                @foreach($webhooks as $webhook)
                <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm font-medium">{{ $webhook->name }}</div>
                        <div class="text-xs text-gray-500 dark:text-gray-400">
                            Created {{ $webhook->created_at->diffForHumans() }}
                        </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-200">
                            {{ ucfirst($webhook->type) }}
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        @if($webhook->is_active)
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200">
                                Active
                            </span>
                        @else
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200">
                                Inactive
                            </span>
                        @endif
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <div class="space-y-1">
                            <div>Total: {{ $webhook->webhook_logs_count ?? 0 }}</div>
                            <div class="text-xs text-green-600 dark:text-green-400">
                                Success: {{ $webhook->success_count ?? 0 }}
                            </div>
                            @if(($webhook->failed_count ?? 0) > 0)
                            <div class="text-xs text-red-600 dark:text-red-400">
                                Failed: {{ $webhook->failed_count }}
                            </div>
                            @endif
                        </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        @php
                            $total = $webhook->webhook_logs_count ?? 0;
                            $success = $webhook->success_count ?? 0;
                            $rate = $total > 0 ? round(($success / $total) * 100, 1) : 0;
                        @endphp
                        <div class="flex items-center">
                            <div class="flex-1">
                                <div class="flex items-baseline">
                                    <span class="text-lg font-semibold
                                        {{ $rate >= 90 ? 'text-green-600 dark:text-green-400' : ($rate >= 70 ? 'text-yellow-600 dark:text-yellow-400' : 'text-red-600 dark:text-red-400') }}">
                                        {{ $rate }}%
                                    </span>
                                </div>
                                <div class="mt-1 w-full bg-gray-200 dark:bg-gray-700 rounded-full h-2">
                                    <div class="h-2 rounded-full
                                        {{ $rate >= 90 ? 'bg-green-500' : ($rate >= 70 ? 'bg-yellow-500' : 'bg-red-500') }}"
                                        style="width: {{ $rate }}%">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <div class="flex items-center space-x-3">
                            <a href="{{ route('stores.webhooks.show', $webhook) }}"
                               class="text-blue-600 dark:text-blue-400 hover:text-blue-900">
                                View
                            </a>
                            <a href="{{ route('stores.webhooks.edit', $webhook) }}"
                               class="text-indigo-600 dark:text-indigo-400 hover:text-indigo-900">
                                Edit
                            </a>
                            <form action="{{ route('stores.webhooks.toggle', $webhook) }}" method="POST" class="inline">
                                @csrf
                                <button type="submit"
                                        class="{{ $webhook->is_active ? 'text-orange-600 dark:text-orange-400 hover:text-orange-900' : 'text-green-600 dark:text-green-400 hover:text-green-900' }}">
                                    {{ $webhook->is_active ? 'Disable' : 'Enable' }}
                                </button>
                            </form>
                            <form action="{{ route('stores.webhooks.destroy', $webhook) }}" method="POST"
                                  class="inline"
                                  onsubmit="return confirm('Are you sure you want to delete this webhook source?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit"
                                        class="text-red-600 dark:text-red-400 hover:text-red-900">
                                    Delete
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    @else
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow p-6 text-center">
        <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
        </svg>
        <h3 class="mt-2 text-sm font-medium">No webhooks configured</h3>
        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
            Get started by creating a webhook to accept orders from payment forms, Stripe, PayPal, or any platform.
        </p>
        <div class="mt-6">
            <a href="{{ route('stores.webhooks.create') }}"
               class="inline-flex items-center px-4 py-2 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700">
                Add New Webhook
            </a>
        </div>
    </div>
    @endif
</div>
@endsection
