@extends('layouts.app')

@section('title', 'Edit Webhook')

@section('content')
<div class="max-w-2xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6">
        <h1 class="text-2xl font-bold">Edit Webhook</h1>
        <p class="text-gray-600 dark:text-gray-400">Update webhook source settings</p>
    </div>

    <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
        <form action="{{ route('stores.webhooks.update', $webhook) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium mb-2">Webhook Name *</label>
                    <input type="text" name="name" value="{{ old('name', $webhook->name) }}" required
                           class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                           placeholder="My Payment Form">
                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                        A friendly name to identify this webhook source
                    </p>
                    @error('name')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium mb-2">Type</label>
                    <select name="type"
                            class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700">
                        <option value="generic" {{ old('type', $webhook->type) == 'generic' ? 'selected' : '' }}>Generic Webhook</option>
                        <option value="whatsapp" {{ old('type', $webhook->type) == 'whatsapp' ? 'selected' : '' }}>WhatsApp Notification 📱</option>
                        <option value="stripe" {{ old('type', $webhook->type) == 'stripe' ? 'selected' : '' }}>Stripe</option>
                        <option value="paypal" {{ old('type', $webhook->type) == 'paypal' ? 'selected' : '' }}>PayPal</option>
                        <option value="payment_form" {{ old('type', $webhook->type) == 'payment_form' ? 'selected' : '' }}>Payment Form</option>
                        <option value="other" {{ old('type', $webhook->type) == 'other' ? 'selected' : '' }}>Other</option>
                    </select>
                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                        Select the type of webhook source
                    </p>
                    @error('type')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium mb-2">Secret Key (Optional)</label>
                    <input type="text" name="secret_key" value="{{ old('secret_key', $webhook->secret_key) }}"
                           class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                           placeholder="Optional secret key for verification">
                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                        For platforms that support webhook signing (e.g., Stripe webhook secret)
                    </p>
                    @error('secret_key')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div class="bg-gray-50 dark:bg-gray-900 p-4 rounded-md border border-gray-200 dark:border-gray-700">
                    <label class="block text-sm font-medium mb-2">Webhook URL</label>
                    <div class="flex items-center space-x-2">
                        <input type="text" readonly
                               value="{{ $webhook->webhook_url }}"
                               class="flex-1 rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-800 text-sm"
                               id="webhookUrl">
                        <button type="button"
                                onclick="copyWebhookUrl()"
                                class="px-3 py-2 bg-gray-600 text-white rounded-md hover:bg-gray-700 text-sm whitespace-nowrap">
                            Copy URL
                        </button>
                    </div>
                    <p class="mt-2 text-xs text-gray-500 dark:text-gray-400">
                        Use this URL in your payment platform's webhook settings
                    </p>
                </div>

                <div class="bg-yellow-50 dark:bg-yellow-900 p-4 rounded-md">
                    <h4 class="text-sm font-semibold mb-2">Note:</h4>
                    <p class="text-sm">
                        The webhook token cannot be changed from this form for security reasons.
                        If you need a new webhook URL, use the "Regenerate Token" button on the details page.
                    </p>
                </div>
            </div>

            <div class="mt-6 flex justify-end space-x-3">
                <a href="{{ route('stores.webhooks.show', $webhook) }}"
                   class="px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md hover:bg-gray-50 dark:hover:bg-gray-700">
                    Cancel
                </a>
                <button type="submit"
                        class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700">
                    Update Webhook
                </button>
            </div>
        </form>
    </div>
</div>

<script>
function copyWebhookUrl() {
    const input = document.getElementById('webhookUrl');
    input.select();
    document.execCommand('copy');
    alert('Webhook URL copied to clipboard!');
}
</script>
@endsection
