@extends('layouts.app')

@section('title', 'Add New Webhook')

@section('content')
<div class="max-w-2xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6">
        <h1 class="text-2xl font-bold">Add New Webhook</h1>
        <p class="text-gray-600 dark:text-gray-400">Create a webhook to receive orders from any platform</p>
    </div>

    <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
        <form action="{{ route('stores.webhooks.store') }}" method="POST">
            @csrf

            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium mb-2">Webhook Name *</label>
                    <input type="text" name="name" value="{{ old('name') }}" required
                           class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                           placeholder="My Payment Form">
                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                        A friendly name to identify this webhook source
                    </p>
                    @error('name')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium mb-2">Type</label>
                    <select name="type" id="webhook_type"
                            class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700">
                        <option value="generic" {{ old('type') == 'generic' ? 'selected' : '' }}>Generic Webhook</option>
                        <option value="whatsapp" {{ old('type') == 'whatsapp' ? 'selected' : '' }}>WhatsApp Notification 📱</option>
                        <option value="stripe" {{ old('type') == 'stripe' ? 'selected' : '' }}>Stripe</option>
                        <option value="paypal" {{ old('type') == 'paypal' ? 'selected' : '' }}>PayPal</option>
                        <option value="payment_form" {{ old('type') == 'payment_form' ? 'selected' : '' }}>Payment Form</option>
                        <option value="other" {{ old('type') == 'other' ? 'selected' : '' }}>Other</option>
                    </select>
                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                        Select the type of webhook source
                    </p>
                    @error('type')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <!-- WhatsApp-specific info box -->
                <div id="whatsapp_info" class="bg-green-50 dark:bg-green-900/20 p-4 rounded-md border border-green-200 dark:border-green-800 hidden">
                    <div class="flex items-start gap-2">
                        <svg class="w-5 h-5 text-green-600 dark:text-green-400 mt-0.5" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/>
                        </svg>
                        <div class="flex-1">
                            <h4 class="text-sm font-semibold text-green-800 dark:text-green-200 mb-2">WhatsApp Notification Webhook</h4>
                            <p class="text-sm text-green-700 dark:text-green-300 mb-2">
                                This webhook will send order updates to your WhatsApp service automatically when:
                            </p>
                            <ul class="text-sm text-green-700 dark:text-green-300 space-y-1 list-disc list-inside ml-2">
                                <li>Order status changes (Processing, Completed, Cancelled)</li>
                                <li>AWB/Tracking number is generated</li>
                                <li>New order is created</li>
                            </ul>
                            <p class="text-sm text-green-700 dark:text-green-300 mt-2">
                                <strong>Payload includes:</strong> Customer phone, formatted message, order details, tracking info
                            </p>
                        </div>
                    </div>
                </div>

                <script>
                    document.addEventListener('DOMContentLoaded', function() {
                        const typeSelect = document.getElementById('webhook_type');
                        const whatsappInfo = document.getElementById('whatsapp_info');

                        function toggleWhatsAppInfo() {
                            if (typeSelect.value === 'whatsapp') {
                                whatsappInfo.classList.remove('hidden');
                            } else {
                                whatsappInfo.classList.add('hidden');
                            }
                        }

                        typeSelect.addEventListener('change', toggleWhatsAppInfo);
                        toggleWhatsAppInfo(); // Check on page load
                    });
                </script>

                <div>
                    <label class="block text-sm font-medium mb-2">Secret Key (Optional)</label>
                    <input type="text" name="secret_key" value="{{ old('secret_key') }}"
                           class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                           placeholder="Optional secret key for verification">
                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                        For platforms that support webhook signing (e.g., Stripe webhook secret)
                    </p>
                    @error('secret_key')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div class="bg-blue-50 dark:bg-blue-900 p-4 rounded-md">
                    <h4 class="text-sm font-semibold mb-2">How it works:</h4>
                    <ol class="text-sm space-y-1 list-decimal list-inside">
                        <li>Create this webhook source</li>
                        <li>Copy the generated webhook URL</li>
                        <li>Paste it in your payment form or platform's webhook settings</li>
                        <li>Configure it to send data on payment success</li>
                        <li>Orders will automatically be created when payments succeed</li>
                    </ol>
                </div>

                <div class="bg-yellow-50 dark:bg-yellow-900 p-4 rounded-md">
                    <h4 class="text-sm font-semibold mb-2">Supported Platforms:</h4>
                    <ul class="text-sm space-y-1 list-disc list-inside">
                        <li>Payment Forms (Tally, Typeform, Google Forms with payment)</li>
                        <li>Payment Gateways (Stripe, PayPal, Razorpay, etc.)</li>
                        <li>E-commerce platforms with webhook support</li>
                        <li>Any service that can send JSON data via POST request</li>
                    </ul>
                </div>
            </div>

            <div class="mt-6 flex justify-end space-x-3">
                <a href="{{ route('stores.webhooks.index') }}"
                   class="px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-md hover:bg-gray-50 dark:hover:bg-gray-700">
                    Cancel
                </a>
                <button type="submit"
                        class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700">
                    Create Webhook
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
