@extends('layouts.app')

@section('title', 'Store Details')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6">
        <div class="flex justify-between items-start">
            <div>
                <h1 class="text-2xl font-bold">{{ $store->name }}</h1>
                <p class="text-gray-600 dark:text-gray-400">{{ $store->url }}</p>
            </div>
            <div class="flex space-x-3">
                <a href="{{ route('stores.edit', $store) }}"
                   class="px-4 py-2 bg-indigo-600 text-white rounded-lg hover:bg-indigo-700">
                    Edit
                </a>
                <a href="{{ route('stores.index') }}"
                   class="px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700">
                    Back to Stores
                </a>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
        <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
            <div class="flex items-center">
                <div class="flex-1">
                    <p class="text-sm text-gray-600 dark:text-gray-400">Status</p>
                    <p class="text-2xl font-bold">
                        @if($store->is_active)
                            <span class="text-green-600 dark:text-green-400">Active</span>
                        @else
                            <span class="text-red-600 dark:text-red-400">Inactive</span>
                        @endif
                    </p>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
            <div class="flex items-center">
                <div class="flex-1">
                    <p class="text-sm text-gray-600 dark:text-gray-400">Total Orders</p>
                    <p class="text-2xl font-bold">{{ $store->orders_count ?? 0 }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
            <div class="flex items-center">
                <div class="flex-1">
                    <p class="text-sm text-gray-600 dark:text-gray-400">Webhooks</p>
                    <p class="text-2xl font-bold">
                        @if($store->webhooks_enabled)
                            <span class="text-green-600 dark:text-green-400">Enabled</span>
                        @else
                            <span class="text-gray-600 dark:text-gray-400">Disabled</span>
                        @endif
                    </p>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
            <div class="flex items-center">
                <div class="flex-1">
                    <p class="text-sm text-gray-600 dark:text-gray-400">Last Sync</p>
                    <p class="text-sm font-bold">
                        {{ $store->last_sync ? $store->last_sync->diffForHumans() : 'Never' }}
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Store Details -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow mb-6">
        <div class="p-6">
            <h2 class="text-lg font-semibold mb-4">Store Configuration</h2>

            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium mb-2">Store Prefix</label>
                    <input type="text" readonly
                           value="{{ $store->store_prefix }}"
                           class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 text-sm">
                </div>

                <div>
                    <label class="block text-sm font-medium mb-2">Store URL</label>
                    <div class="flex items-center space-x-2">
                        <input type="text" readonly
                               value="{{ $store->url }}"
                               class="flex-1 rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 text-sm">
                        <a href="{{ $store->url }}" target="_blank"
                           class="px-3 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 text-sm whitespace-nowrap">
                            Visit Store
                        </a>
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-medium mb-2">Consumer Key</label>
                    <input type="password" readonly
                           value="{{ $store->consumer_key }}"
                           class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 text-sm">
                </div>

                <div class="pt-4 border-t border-gray-200 dark:border-gray-700">
                    <label class="block text-sm font-medium mb-2">Sync Orders</label>
                    <form action="{{ route('stores.sync', $store) }}" method="POST" class="flex flex-col sm:flex-row items-start sm:items-center gap-3">
                        @csrf
                        <div class="flex-1 w-full sm:w-auto">
                            <select name="sync_type" class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 dark:bg-gray-700 rounded-md text-sm">
                                <option value="current_month" selected>📅 Current Month Only - For active order verification</option>
                                <option value="recent">⏱️ Recent (Last 30 Days) - Recent orders sync</option>
                                <option value="historical">📦 Historical (12 Months) - Full historical sync</option>
                            </select>
                        </div>
                        <button type="submit"
                                class="w-full sm:w-auto px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700 text-sm whitespace-nowrap">
                            Sync Orders
                        </button>
                    </form>
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-2">
                        💡 <strong>Recommended:</strong> Use "Current Month Only" for daily operations. Past data can be entered manually in Seller KPI section.
                    </p>
                </div>

                <div class="pt-4 border-t border-gray-200 dark:border-gray-700">
                    <label class="block text-sm font-medium mb-2">Webhooks (Real-time Sync)</label>
                    <div class="flex space-x-3">

                    @if($store->webhooks_enabled)
                        <form action="{{ route('stores.webhooks.disable', $store) }}" method="POST">
                            @csrf
                            <button type="submit"
                                    class="px-4 py-2 bg-orange-600 text-white rounded-md hover:bg-orange-700 text-sm">
                                Disable Webhooks
                            </button>
                        </form>
                    @else
                        <form action="{{ route('stores.webhooks.enable', $store) }}" method="POST">
                            @csrf
                            <button type="submit"
                                    class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 text-sm">
                                Enable Webhooks
                            </button>
                        </form>
                    @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Orders -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow">
        <div class="p-6 border-b border-gray-200 dark:border-gray-700">
            <h2 class="text-lg font-semibold">Recent Orders</h2>
            <p class="text-sm text-gray-600 dark:text-gray-400">Last 10 orders from this store</p>
        </div>

        @if($recentOrders->count() > 0)
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                <thead class="bg-gray-50 dark:bg-gray-700">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Order Number</th>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Customer</th>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Total</th>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Date</th>
                        <th class="px-6 py-3 text-left text-xs font-medium uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                    @foreach($recentOrders as $order)
                    <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            {{ $order->display_order_id }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            {{ $order->billing['first_name'] ?? '' }} {{ $order->billing['last_name'] ?? '' }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            {{ $order->currency }} {{ number_format($order->total, 2) }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full
                                {{ $order->status === 'completed' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' :
                                   ($order->status === 'processing' ? 'bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200' :
                                   'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-200') }}">
                                {{ ucfirst($order->status) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                            {{ $order->created_at->format('M d, Y') }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <a href="{{ route('orders.show', $order) }}"
                               class="text-blue-600 dark:text-blue-400 hover:underline">
                                View
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @else
        <div class="p-6 text-center">
            <p class="text-gray-500 dark:text-gray-400">No orders found for this store</p>
            <p class="text-sm text-gray-400 dark:text-gray-500 mt-2">
                Try syncing orders from WooCommerce
            </p>
        </div>
        @endif
    </div>
</div>
@endsection
