@extends('layouts.app')

@section('title', 'Edit Store')

@section('content')
<div class="max-w-2xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6">
        <h1 class="text-2xl font-bold">Edit Store: {{ $store->name }}</h1>
    </div>

    <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
        <form action="{{ route('stores.update', $store) }}" method="POST">
            @csrf
            @method('PUT')
            
            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium mb-2">Store Name *</label>
                    <input type="text" name="name" value="{{ old('name', $store->name) }}" required
                           class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700">
                    @error('name')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium mb-2">Store URL *</label>
                    <input type="url" name="url" value="{{ old('url', $store->url) }}" required
                           class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700">
                    @error('url')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium mb-2">Consumer Key *</label>
                    <input type="text" name="consumer_key" value="{{ old('consumer_key', $store->consumer_key) }}" required
                           class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700">
                    @error('consumer_key')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium mb-2">Consumer Secret *</label>
                    <input type="text" name="consumer_secret" value="{{ old('consumer_secret', $store->consumer_secret) }}" required
                           class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700">
                    @error('consumer_secret')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="flex items-center">
                        <input type="checkbox" name="is_active" value="1" 
                               {{ old('is_active', $store->is_active) ? 'checked' : '' }}
                               class="rounded border-gray-300 dark:border-gray-600">
                        <span class="ml-2">Store is active</span>
                    </label>
                </div>
            </div>

            <div class="mt-6 flex justify-between">
                <button type="button" onclick="if(confirm('Are you sure you want to delete this store?')) document.getElementById('delete-form').submit();"
                        class="px-4 py-2 bg-red-600 text-white rounded-md hover:bg-red-700">
                    Delete Store
                </button>
                
                <div class="flex gap-3">
                    <a href="{{ route('stores.index') }}"
                       class="inline-flex items-center gap-2 px-5 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors font-medium">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                        Cancel
                    </a>
                    <button type="submit"
                            class="inline-flex items-center gap-2 px-5 py-2.5 bg-blue-600 text-white rounded-lg hover:bg-blue-700 shadow-md hover:shadow-lg transition-all font-medium">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        Update Store
                    </button>
                </div>
            </div>
        </form>

        <form id="delete-form" action="{{ route('stores.destroy', $store) }}" method="POST" class="hidden">
           @csrf
           @method('DELETE')
       </form>
   </div>
</div>
@endsection