@extends('layouts.app')

@section('title', 'Add New Store')

@section('content')
<div class="max-w-2xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6">
        <h1 class="text-2xl font-bold">Add New Store</h1>
        <p class="text-gray-600 dark:text-gray-400">Connect a WooCommerce store to the system</p>
    </div>

    <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
        <form action="{{ route('stores.store') }}" method="POST">
            @csrf
            
            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium mb-2">Store Name *</label>
                    <input type="text" name="name" value="{{ old('name') }}" required
                           class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                           placeholder="My WooCommerce Store">
                    @error('name')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block text-sm font-medium mb-2">Store Prefix (Auto-generated)</label>
                    <input type="text" name="store_prefix" value="{{ old('store_prefix') }}" 
                            class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                            placeholder="Leave empty for auto-generation (e.g., ABC, XYZ)"
                            maxlength="10">
                        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                            A unique 2-5 character prefix for this store's orders. Leave empty to auto-generate.
                        </p>
                    @error('store_prefix')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block text-sm font-medium mb-2">Store URL *</label>
                    <input type="url" name="url" value="{{ old('url') }}" required
                           class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                           placeholder="https://mystore.com">
                    @error('url')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium mb-2">Consumer Key *</label>
                    <input type="text" name="consumer_key" value="{{ old('consumer_key') }}" required
                           class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                           placeholder="ck_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx">
                    @error('consumer_key')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium mb-2">Consumer Secret *</label>
                    <input type="text" name="consumer_secret" value="{{ old('consumer_secret') }}" required
                           class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700"
                           placeholder="cs_xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx">
                    @error('consumer_secret')
                        <p class="mt-1 text-sm text-red-600 dark:text-red-400">{{ $message }}</p>
                    @enderror
                </div>

                <div class="bg-blue-50 dark:bg-blue-900 p-4 rounded-md">
                    <h4 class="text-sm font-semibold mb-2">How to get WooCommerce API Keys:</h4>
                    <ol class="text-sm space-y-1 list-decimal list-inside">
                        <li>Go to your WordPress admin dashboard</li>
                        <li>Navigate to WooCommerce → Settings → Advanced → REST API</li>
                        <li>Click "Add key"</li>
                        <li>Add a description and select Read/Write permissions</li>
                        <li>Click "Generate API key"</li>
                        <li>Copy the Consumer key and Consumer secret</li>
                    </ol>
                </div>
            </div>

            <div class="mt-6 flex justify-end gap-3">
                <a href="{{ route('stores.index') }}"
                   class="inline-flex items-center gap-2 px-5 py-2.5 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors font-medium">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                    Cancel
                </a>
                <button type="submit"
                        class="inline-flex items-center gap-2 px-5 py-2.5 bg-blue-600 text-white rounded-lg hover:bg-blue-700 shadow-md hover:shadow-lg transition-all font-medium">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                    Add Store
                </button>
            </div>
        </form>
    </div>
</div>
@endsection