@extends('layouts.app')

@section('title', 'Import Orders Preview')

@section('content')
<div class="min-h-screen bg-gray-50 dark:bg-gray-900 py-8">
    <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">

        <!-- Header -->
        <div class="mb-8">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold text-gray-900 dark:text-white">Import Orders Preview</h1>
                    <p class="mt-2 text-gray-600 dark:text-gray-400">
                        Review what will be imported from Google Sheets before confirming
                    </p>
                </div>
                <a href="{{ route('settings.google-sheets') }}"
                   class="inline-flex items-center px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                    </svg>
                    Back to Google Sheets
                </a>
            </div>
        </div>

        <!-- Warning Banner -->
        <div class="mb-6 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg p-4">
            <div class="flex gap-3">
                <svg class="w-6 h-6 text-red-600 dark:text-red-400 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                </svg>
                <div class="flex-1">
                    <h3 class="text-sm font-semibold text-red-900 dark:text-red-200 mb-1">Critical Warning</h3>
                    <p class="text-sm text-red-800 dark:text-red-300">
                        Make sure the site is in <strong>Maintenance Mode</strong> before proceeding with import.
                        If users create orders during import, it will cause order number conflicts.
                    </p>
                </div>
            </div>
        </div>

        <!-- Preview Output -->
        <div class="bg-white dark:bg-gray-800 shadow-lg rounded-lg overflow-hidden mb-6">
            <div class="p-6 border-b border-gray-200 dark:border-gray-700">
                <h2 class="text-lg font-semibold text-gray-900 dark:text-white">
                    Dry-Run Results
                </h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
                    This is a preview only. No changes have been made yet.
                </p>
            </div>

            <div class="p-6">
                <div class="bg-gray-900 dark:bg-black rounded-lg p-4 overflow-auto">
                    <pre class="text-xs text-green-400 font-mono whitespace-pre-wrap">{{ $output }}</pre>
                </div>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="bg-white dark:bg-gray-800 shadow-lg rounded-lg overflow-hidden">
            <div class="p-6">
                <div class="flex items-center justify-between">
                    <div class="flex-1">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">
                            Ready to Import?
                        </h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400">
                            Review the preview above carefully. If there are conflicts, resolve them manually before proceeding.
                        </p>
                    </div>

                    <div class="flex gap-3 ml-6">
                        <a href="{{ route('settings.google-sheets') }}"
                           class="inline-flex items-center px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700">
                            Cancel
                        </a>

                        <form action="{{ route('google-sheets.import') }}" method="POST" class="inline-block">
                            @csrf
                            <input type="hidden" name="user_id" value="{{ $targetUserId }}">
                            <button type="submit"
                                    onclick="return confirm('⚠️ WARNING: This will import orders from Google Sheets.\n\nMake sure:\n1. Site is in Maintenance Mode\n2. Database has been restored\n3. No conflicts in preview above\n\nContinue?');"
                                    class="inline-flex items-center px-6 py-2 bg-orange-600 hover:bg-orange-700 text-white font-medium rounded-lg transition shadow-md hover:shadow-lg">
                                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-8l-4-4m0 0L8 8m4-4v12"/>
                                </svg>
                                Confirm Import
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Help Section -->
        <div class="mt-6 p-4 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg">
            <div class="flex gap-3">
                <svg class="w-5 h-5 text-blue-600 dark:text-blue-400 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                </svg>
                <div class="flex-1">
                    <h4 class="text-sm font-semibold text-blue-900 dark:text-blue-200 mb-1">Understanding the Preview</h4>
                    <ul class="text-sm text-blue-800 dark:text-blue-300 space-y-1">
                        <li><strong>✓ Green text:</strong> Orders that will be imported successfully</li>
                        <li><strong>⚠️ Yellow warnings:</strong> Orders already exist (will be skipped)</li>
                        <li><strong>💥 Red conflicts:</strong> Same order number but different customer - RESOLVE MANUALLY FIRST!</li>
                        <li><strong>Sequences:</strong> Order number sequences will be fixed automatically</li>
                    </ul>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection
