@extends('layouts.app')

@section('title', 'Domain Details')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6">
        <div class="flex justify-between items-start">
            <div>
                <h1 class="text-2xl font-bold">{{ $sellerDomain->domain }}</h1>
                <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
                    Custom domain configuration and verification
                </p>
            </div>
            <div class="flex space-x-3">
                <a href="{{ route('seller-domains.edit', $sellerDomain) }}"
                   class="px-4 py-2 bg-indigo-600 text-white rounded-lg hover:bg-indigo-700">
                    Edit
                </a>
                <a href="{{ route('seller-domains.index') }}"
                   class="px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700">
                    Back to Domains
                </a>
            </div>
        </div>
    </div>

    @if(session('success'))
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            {{ session('success') }}
        </div>
    @endif

    @if(session('error'))
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            {{ session('error') }}
        </div>
    @endif

    <!-- Status Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
        <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
            <div class="flex items-center">
                <div class="flex-1">
                    <p class="text-sm text-gray-600 dark:text-gray-400">Status</p>
                    <p class="text-lg font-bold mt-1">
                        @if($sellerDomain->isVerified())
                            <span class="text-green-600 dark:text-green-400">Active</span>
                        @else
                            <span class="text-yellow-600 dark:text-yellow-400">Pending</span>
                        @endif
                    </p>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
            <div class="flex items-center">
                <div class="flex-1">
                    <p class="text-sm text-gray-600 dark:text-gray-400">Primary Domain</p>
                    <p class="text-lg font-bold mt-1">
                        @if($sellerDomain->is_primary)
                            <span class="text-blue-600 dark:text-blue-400">Yes</span>
                        @else
                            <span class="text-gray-600 dark:text-gray-400">No</span>
                        @endif
                    </p>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
            <div class="flex items-center">
                <div class="flex-1">
                    <p class="text-sm text-gray-600 dark:text-gray-400">Default Page</p>
                    <p class="text-sm font-bold mt-1">
                        {{ $sellerDomain->defaultSalesPage->name ?? 'Not Set' }}
                    </p>
                </div>
            </div>
        </div>

        <div class="bg-white dark:bg-gray-800 p-6 rounded-lg shadow">
            <div class="flex items-center">
                <div class="flex-1">
                    <p class="text-sm text-gray-600 dark:text-gray-400">Added</p>
                    <p class="text-sm font-bold mt-1">
                        {{ $sellerDomain->created_at->diffForHumans() }}
                    </p>
                </div>
            </div>
        </div>
    </div>

    @if(!$sellerDomain->isVerified())
    <!-- Verification Instructions -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow mb-6">
        <div class="p-6 border-b border-gray-200 dark:border-gray-700">
            <h2 class="text-lg font-semibold">Domain Verification Required</h2>
            <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
                Follow these steps to verify and activate your custom domain
            </p>
        </div>

        <div class="p-6">
            <!-- Step 1: DNS Configuration -->
            <div class="mb-6">
                <h3 class="text-base font-semibold mb-3">Step 1: Configure DNS Records</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
                    Add the following DNS records at your domain registrar or DNS provider:
                </p>

                <div class="bg-gray-50 dark:bg-gray-900 rounded-lg p-4 space-y-4">
                    <!-- A Record -->
                    <div class="border-b border-gray-200 dark:border-gray-700 pb-4 last:border-0 last:pb-0">
                        <div class="flex items-start justify-between mb-2">
                            <span class="text-xs font-semibold text-gray-700 dark:text-gray-300 bg-blue-100 dark:bg-blue-900 px-2 py-1 rounded">A RECORD</span>
                        </div>
                        <div class="grid grid-cols-3 gap-3 text-sm">
                            <div>
                                <label class="block text-xs text-gray-500 dark:text-gray-400 mb-1">Type</label>
                                <code class="block bg-white dark:bg-gray-800 px-3 py-2 rounded border border-gray-300 dark:border-gray-600">A</code>
                            </div>
                            <div>
                                <label class="block text-xs text-gray-500 dark:text-gray-400 mb-1">Name</label>
                                <code class="block bg-white dark:bg-gray-800 px-3 py-2 rounded border border-gray-300 dark:border-gray-600">@</code>
                            </div>
                            <div>
                                <label class="block text-xs text-gray-500 dark:text-gray-400 mb-1">Value</label>
                                <code class="block bg-white dark:bg-gray-800 px-3 py-2 rounded border border-gray-300 dark:border-gray-600">YOUR_SERVER_IP</code>
                            </div>
                        </div>
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-2">
                            Replace YOUR_SERVER_IP with your actual server IP address
                        </p>
                    </div>

                    <!-- CNAME Record (optional www) -->
                    <div class="border-b border-gray-200 dark:border-gray-700 pb-4 last:border-0 last:pb-0">
                        <div class="flex items-start justify-between mb-2">
                            <span class="text-xs font-semibold text-gray-700 dark:text-gray-300 bg-purple-100 dark:bg-purple-900 px-2 py-1 rounded">CNAME RECORD (Optional)</span>
                        </div>
                        <div class="grid grid-cols-3 gap-3 text-sm">
                            <div>
                                <label class="block text-xs text-gray-500 dark:text-gray-400 mb-1">Type</label>
                                <code class="block bg-white dark:bg-gray-800 px-3 py-2 rounded border border-gray-300 dark:border-gray-600">CNAME</code>
                            </div>
                            <div>
                                <label class="block text-xs text-gray-500 dark:text-gray-400 mb-1">Name</label>
                                <code class="block bg-white dark:bg-gray-800 px-3 py-2 rounded border border-gray-300 dark:border-gray-600">www</code>
                            </div>
                            <div>
                                <label class="block text-xs text-gray-500 dark:text-gray-400 mb-1">Value</label>
                                <code class="block bg-white dark:bg-gray-800 px-3 py-2 rounded border border-gray-300 dark:border-gray-600">{{ $sellerDomain->domain }}</code>
                            </div>
                        </div>
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-2">
                            Add this record if you want www.{{ $sellerDomain->domain }} to work
                        </p>
                    </div>
                </div>
            </div>

            <!-- Step 2: SSL Configuration -->
            <div class="mb-6">
                <h3 class="text-base font-semibold mb-3">Step 2: SSL Configuration (Cloudflare Recommended)</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
                    For SSL/HTTPS support, we recommend using Cloudflare:
                </p>
                <ul class="list-disc list-inside text-sm text-gray-600 dark:text-gray-400 space-y-2 ml-4">
                    <li>Point your domain nameservers to Cloudflare</li>
                    <li>Enable "Full" or "Full (strict)" SSL/TLS encryption mode</li>
                    <li>Turn on "Always Use HTTPS" option</li>
                    <li>Cloudflare will automatically provide free SSL certificate</li>
                </ul>
            </div>

            <!-- Step 3: Verification Token -->
            <div class="mb-6">
                <h3 class="text-base font-semibold mb-3">Step 3: Verification Token</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-3">
                    Your verification token (for future automated verification):
                </p>
                <div class="bg-gray-50 dark:bg-gray-900 rounded-lg p-4">
                    <div class="flex items-center justify-between">
                        <code class="text-sm font-mono text-gray-800 dark:text-gray-200">{{ $sellerDomain->verification_token }}</code>
                        <button onclick="copyToClipboard('{{ $sellerDomain->verification_token }}')"
                                class="ml-4 px-3 py-1 bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-300 rounded hover:bg-gray-300 dark:hover:bg-gray-600 text-xs">
                            Copy
                        </button>
                    </div>
                </div>
            </div>

            <!-- Step 4: Wait for DNS Propagation -->
            <div class="mb-6">
                <h3 class="text-base font-semibold mb-3">Step 4: Wait for DNS Propagation</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400">
                    DNS changes can take 24-48 hours to fully propagate worldwide. You can check propagation status at
                    <a href="https://dnschecker.org" target="_blank" class="text-blue-600 dark:text-blue-400 hover:underline">dnschecker.org</a>
                </p>
            </div>

            <!-- Step 5: Manual Verification -->
            <div>
                <h3 class="text-base font-semibold mb-3">Step 5: Verify Domain</h3>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
                    Once DNS records are configured and propagated, click the button below to verify your domain:
                </p>
                <form action="{{ route('seller-domains.verify', $sellerDomain) }}" method="POST">
                    @csrf
                    <button type="submit"
                            class="px-6 py-3 bg-green-600 text-white rounded-lg hover:bg-green-700 font-medium">
                        Verify Domain Now
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Important Notes -->
    <div class="bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 rounded-lg p-6 mb-6">
        <div class="flex">
            <div class="flex-shrink-0">
                <svg class="h-5 w-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                </svg>
            </div>
            <div class="ml-3">
                <h3 class="text-sm font-medium text-yellow-800 dark:text-yellow-200">
                    Important Notes
                </h3>
                <div class="mt-2 text-sm text-yellow-700 dark:text-yellow-300">
                    <ul class="list-disc list-inside space-y-1">
                        <li>Make sure your DNS records point to the correct server IP address</li>
                        <li>Your domain will not work until it's verified and activated</li>
                        <li>All your sales pages will be accessible via: {{ $sellerDomain->domain }}/page-slug</li>
                        @if($sellerDomain->defaultSalesPage)
                        <li>Your default page "{{ $sellerDomain->defaultSalesPage->name }}" will appear at: {{ $sellerDomain->domain }}</li>
                        @endif
                    </ul>
                </div>
            </div>
        </div>
    </div>
    @else
    <!-- Domain is Verified -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow mb-6">
        <div class="p-6 border-b border-gray-200 dark:border-gray-700">
            <div class="flex items-center">
                <svg class="h-6 w-6 text-green-500 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <div>
                    <h2 class="text-lg font-semibold">Domain Verified & Active</h2>
                    <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
                        Your domain was verified on {{ $sellerDomain->verified_at->format('M d, Y \a\t g:i A') }}
                    </p>
                </div>
            </div>
        </div>

        <div class="p-6">
            <h3 class="text-base font-semibold mb-3">Domain Information</h3>
            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium mb-2 text-gray-700 dark:text-gray-300">Domain URL</label>
                    <div class="flex items-center space-x-2">
                        <input type="text" readonly
                               value="{{ $sellerDomain->url }}"
                               class="flex-1 rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 text-sm">
                        <a href="{{ $sellerDomain->url }}" target="_blank"
                           class="px-3 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 text-sm whitespace-nowrap">
                            Visit Domain
                        </a>
                    </div>
                </div>

                @if($sellerDomain->defaultSalesPage)
                <div>
                    <label class="block text-sm font-medium mb-2 text-gray-700 dark:text-gray-300">Default Sales Page</label>
                    <div class="flex items-center space-x-2">
                        <input type="text" readonly
                               value="{{ $sellerDomain->defaultSalesPage->name }}"
                               class="flex-1 rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 text-sm">
                        <a href="{{ route('sales-pages.edit', $sellerDomain->defaultSalesPage) }}"
                           class="px-3 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 text-sm whitespace-nowrap">
                            Edit Page
                        </a>
                    </div>
                </div>
                @endif

                @if($sellerDomain->notes)
                <div>
                    <label class="block text-sm font-medium mb-2 text-gray-700 dark:text-gray-300">Notes</label>
                    <textarea readonly rows="3"
                              class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 text-sm">{{ $sellerDomain->notes }}</textarea>
                </div>
                @endif
            </div>
        </div>
    </div>

    <!-- How Your Pages Work with This Domain -->
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow mb-6">
        <div class="p-6 border-b border-gray-200 dark:border-gray-700">
            <h2 class="text-lg font-semibold">How Your Pages Work with This Domain</h2>
            <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
                All your sales pages are accessible via your custom domain
            </p>
        </div>

        <div class="p-6">
            <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4">
                <h3 class="text-sm font-medium text-blue-800 dark:text-blue-200 mb-3">Access Your Pages</h3>
                <div class="text-sm text-blue-700 dark:text-blue-300 space-y-2">
                    @if($sellerDomain->defaultSalesPage)
                    <div>
                        <p class="font-medium">Domain Root (/):</p>
                        <p class="ml-4">{{ $sellerDomain->url }} → Shows "{{ $sellerDomain->defaultSalesPage->name }}"</p>
                    </div>
                    @endif
                    <div>
                        <p class="font-medium">Individual Sales Pages:</p>
                        <p class="ml-4">{{ $sellerDomain->url }}/your-page-slug</p>
                    </div>
                    <p class="mt-3 pt-3 border-t border-blue-200 dark:border-blue-700">
                        <strong>Note:</strong> Page slugs remain the same, just accessed via your custom domain instead of the platform domain.
                    </p>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>

<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        alert('Verification token copied to clipboard!');
    }, function(err) {
        console.error('Could not copy text: ', err);
    });
}
</script>
@endsection
