@extends('layouts.app')

@section('title', 'Add Custom Domain')

@section('content')
<div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6">
        <h1 class="text-2xl font-bold">Add Custom Domain</h1>
        <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
            Connect your own domain to your sales pages
        </p>
    </div>

    @if($errors->any())
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <ul class="list-disc list-inside">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
        <form action="{{ route('seller-domains.store') }}" method="POST">
            @csrf

            <!-- Domain Name -->
            <div class="mb-6">
                <label for="domain" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Domain Name <span class="text-red-500">*</span>
                </label>
                <input type="text"
                       name="domain"
                       id="domain"
                       value="{{ old('domain') }}"
                       placeholder="yourdomain.com"
                       class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                       required>
                <p class="mt-1 text-xs text-gray-500">
                    Enter your domain without http:// or https:// (e.g., yourdomain.com)
                </p>
            </div>

            <!-- Default Sales Page -->
            <div class="mb-6">
                <label for="default_sales_page_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Default Sales Page
                </label>
                <select name="default_sales_page_id"
                        id="default_sales_page_id"
                        class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="">Select a page (optional)</option>
                    @foreach($salesPages as $page)
                        <option value="{{ $page->id }}" {{ old('default_sales_page_id') == $page->id ? 'selected' : '' }}>
                            {{ $page->name }}
                        </option>
                    @endforeach
                </select>
                <p class="mt-1 text-xs text-gray-500">
                    This page will be shown when visitors access your domain root (e.g., yourdomain.com)
                </p>
            </div>

            <!-- Primary Domain -->
            <div class="mb-6">
                <label class="flex items-center">
                    <input type="checkbox"
                           name="is_primary"
                           value="1"
                           {{ old('is_primary') ? 'checked' : '' }}
                           class="rounded border-gray-300 text-indigo-600 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <span class="ml-2 text-sm text-gray-700 dark:text-gray-300">
                        Set as primary domain
                    </span>
                </label>
                <p class="mt-1 text-xs text-gray-500 ml-6">
                    Primary domain will be used as the default domain for all your sales pages
                </p>
            </div>

            <!-- Info Box -->
            <div class="mb-6 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg p-4">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                        </svg>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm font-medium text-blue-800 dark:text-blue-200">
                            DNS Configuration Required
                        </h3>
                        <div class="mt-2 text-sm text-blue-700 dark:text-blue-300">
                            <p>After adding your domain, you'll need to:</p>
                            <ul class="list-disc list-inside mt-2 space-y-1">
                                <li>Configure DNS records at your domain registrar</li>
                                <li>Wait for DNS propagation (can take up to 24-48 hours)</li>
                                <li>Verify domain ownership</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Actions -->
            <div class="flex items-center justify-end space-x-3">
                <a href="{{ route('seller-domains.index') }}"
                   class="inline-flex items-center px-4 py-2 bg-gray-300 dark:bg-gray-600 text-gray-700 dark:text-gray-300 rounded-lg hover:bg-gray-400 dark:hover:bg-gray-700">
                    Cancel
                </a>
                <button type="submit"
                        class="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                    Add Domain
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
