@extends('layouts.base')

@section('title', 'Thank You - Order Received')

@php
    // Favicon fallback logic
    if (isset($salesPage)) {
        $faviconPath = $salesPage->getFaviconPath()
            ?? $salesPage->user->company_logo
            ?? asset('favicon.ico');
    } else {
        $faviconPath = asset('favicon.ico');
    }
@endphp
<link rel="icon" type="image/x-icon" href="{{ asset($faviconPath) }}">
<link rel="shortcut icon" type="image/x-icon" href="{{ asset($faviconPath) }}">

@push('scripts')

    @if(isset($salesPage) && isset($order))
        @if($salesPage->facebook_pixel_id)
        <!-- Facebook Pixel Code -->
        <script>
            !function(f,b,e,v,n,t,s)
            {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
            n.callMethod.apply(n,arguments):n.queue.push(arguments)};
            if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
            n.queue=[];t=b.createElement(e);t.async=!0;
            t.src=v;s=b.getElementsByTagName(e)[0];
            s.parentNode.insertBefore(t,s)}(window, document,'script',
            'https://connect.facebook.net/en_US/fbevents.js');
            fbq('init', '{{ $salesPage->facebook_pixel_id }}');
            fbq('track', 'PageView');
            // Track Purchase Conversion
            fbq('track', 'Purchase', {
                value: {{ $order->total }},
                currency: '{{ $order->currency }}',
                content_type: 'product',
                contents: [
                    @foreach($order->line_items as $item)
                    {
                        id: '{{ $item['product_id'] ?? '' }}',
                        quantity: {{ $item['quantity'] }},
                        item_price: {{ $item['price'] }}
                    }{{ !$loop->last ? ',' : '' }}
                    @endforeach
                ]
            });
        </script>
        <noscript>
            <img height="1" width="1" style="display:none"
                 src="https://www.facebook.com/tr?id={{ $salesPage->facebook_pixel_id }}&ev=PageView&noscript=1"/>
        </noscript>
        @endif

        @if($salesPage->google_analytics_id)
        <!-- Google Analytics -->
        <script async src="https://www.googletagmanager.com/gtag/js?id={{ $salesPage->google_analytics_id }}"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
            gtag('config', '{{ $salesPage->google_analytics_id }}');
            // Track Purchase Event
            gtag('event', 'purchase', {
                transaction_id: '{{ $order->order_number }}',
                value: {{ $order->total }},
                currency: '{{ $order->currency }}',
                items: [
                    @foreach($order->line_items as $item)
                    {
                        item_id: '{{ $item['product_id'] ?? '' }}',
                        item_name: '{{ addslashes($item['name']) }}',
                        price: {{ $item['price'] }},
                        quantity: {{ $item['quantity'] }}
                    }{{ !$loop->last ? ',' : '' }}
                    @endforeach
                ]
            });
        </script>
        @endif

        @if($salesPage->tiktok_pixel_id)
        <!-- TikTok Pixel Code -->
        <script>
            !function (w, d, t) {
                w.TiktokAnalyticsObject=t;var ttq=w[t]=w[t]||[];ttq.methods=["page","track","identify","instances","debug","on","off","once","ready","alias","group","enableCookie","disableCookie"],ttq.setAndDefer=function(t,e){t[e]=function(){t.push([e].concat(Array.prototype.slice.call(arguments,0)))}};for(var i=0;i<ttq.methods.length;i++)ttq.setAndDefer(ttq,ttq.methods[i]);ttq.instance=function(t){for(var e=ttq._i[t]||[],n=0;n<ttq.methods.length;n++)ttq.setAndDefer(e,ttq.methods[n]);return e},ttq.load=function(e,n){var i="https://analytics.tiktok.com/i18n/pixel/events.js";ttq._i=ttq._i||{},ttq._i[e]=[],ttq._i[e]._u=i,ttq._t=ttq._t||{},ttq._t[e]=+new Date,ttq._o=ttq._o||{},ttq._o[e]=n||{};var o=document.createElement("script");o.type="text/javascript",o.async=!0,o.src=i+"?sdkid="+e+"&lib="+t;var a=document.getElementsByTagName("script")[0];a.parentNode.insertBefore(o,a)};
                ttq.load('{{ $salesPage->tiktok_pixel_id }}');
                ttq.page();
                // Track CompletePayment Event
                ttq.track('CompletePayment', {
                    value: {{ $order->total }},
                    currency: '{{ $order->currency }}',
                    contents: [
                        @foreach($order->line_items as $item)
                        {
                            content_id: '{{ $item['product_id'] ?? '' }}',
                            content_name: '{{ addslashes($item['name']) }}',
                            price: {{ $item['price'] }},
                            quantity: {{ $item['quantity'] }}
                        }{{ !$loop->last ? ',' : '' }}
                        @endforeach
                    ]
                });
            }(window, document, 'ttq');
        </script>
        @endif
    @endif
@endpush

@section('body')
<div class="min-h-screen flex items-center justify-center px-4 py-8 bg-gradient-to-br from-gray-50 to-gray-100 dark:from-gray-900 dark:to-gray-800">
        <div class="max-w-2xl w-full">

        <!-- Success Header -->
        <div class="text-center mb-8">
            <div class="inline-flex items-center justify-center w-20 h-20 bg-gradient-to-br from-green-400 to-green-600 rounded-full mb-4 shadow-lg">
                <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"></path>
                </svg>
            </div>
            <h1 class="text-4xl font-bold text-gray-900 dark:text-white mb-2">Thank You!</h1>
            <p class="text-lg text-gray-600 dark:text-gray-400">Your order has been successfully placed</p>
        </div>

        @if(isset($order))
        <!-- Order Summary Card -->
        <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-xl overflow-hidden mb-6">
            <!-- Header -->
            <div class="bg-gradient-to-r from-blue-500 to-blue-600 dark:from-blue-600 dark:to-blue-700 px-6 py-4">
                    <div class="flex justify-between items-center">
                        <div>
                            <p class="text-blue-100 text-sm font-medium mb-1">Order Number</p>
                            <p class="text-white text-2xl font-bold">{{ $order->order_number }}</p>
                        </div>
                        <span class="px-4 py-2 bg-yellow-400 text-yellow-900 text-sm font-bold rounded-full">
                            Awaiting Payment
                        </span>
                    </div>
                </div>

            <!-- Customer Details -->
            <div class="px-6 py-6 border-b border-gray-100 dark:border-gray-700">
                <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-4">Customer Information</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">Name</p>
                        @php
                            // Support both formats: 'name' or 'first_name' + 'last_name'
                            $customerName = $order->billing['name'] ?? trim(($order->billing['first_name'] ?? '') . ' ' . ($order->billing['last_name'] ?? ''));
                        @endphp
                        <p class="text-base font-semibold text-gray-900 dark:text-white">{{ $customerName ?: 'N/A' }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">Phone Number</p>
                        <p class="text-base font-semibold text-gray-900 dark:text-white">{{ $order->billing['phone'] ?? 'N/A' }}</p>
                    </div>
                    @if(!empty($order->billing['email']))
                    <div class="md:col-span-2">
                        <p class="text-sm text-gray-500 dark:text-gray-400 mb-1">Email</p>
                        <p class="text-base font-semibold text-gray-900 dark:text-white">{{ $order->billing['email'] }}</p>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Order Items -->
            <div class="px-6 py-6 border-b border-gray-100 dark:border-gray-700">
                <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-4">Order Items</h3>
                <div class="space-y-3">
                    @foreach($order->line_items as $item)
                    <div class="flex justify-between items-start py-3 px-4 bg-gray-50 dark:bg-gray-700 rounded-xl">
                        <div class="flex-1">
                            <p class="font-semibold text-gray-900 dark:text-white mb-1">{{ $item['name'] }}</p>
                            <p class="text-sm text-gray-600 dark:text-gray-400">Quantity: {{ $item['quantity'] }} × RM {{ number_format($item['price'], 2) }}</p>
                        </div>
                        <p class="font-bold text-lg text-gray-900 dark:text-white ml-4">RM {{ number_format($item['price'] * $item['quantity'], 2) }}</p>
                    </div>
                    @endforeach
                </div>
            </div>

            <!-- Total -->
            <div class="px-6 py-6">
                <div class="flex justify-between items-center">
                    <span class="text-xl font-bold text-gray-900 dark:text-white">Total Amount</span>
                    <span class="text-3xl font-bold text-green-600 dark:text-green-400">RM {{ number_format($order->total, 2) }}</span>
                </div>
            </div>
        </div>

        <!-- Next Steps Card -->
        <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-xl p-6 mb-6">
            <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-6">Next Steps</h3>
            <div class="space-y-4">
                @if($order->payment_method === 'cod')
                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0 w-8 h-8 bg-blue-500 dark:bg-blue-600 text-white rounded-full flex items-center justify-center font-bold text-sm">1</div>
                        <p class="text-gray-700 dark:text-gray-300 pt-1">Our team will contact you via WhatsApp shortly</p>
                    </div>
                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0 w-8 h-8 bg-blue-500 dark:bg-blue-600 text-white rounded-full flex items-center justify-center font-bold text-sm">2</div>
                        <p class="text-gray-700 dark:text-gray-300 pt-1"><span class="font-semibold">(COD)</span> Pay to courier when you receive the product</p>
                    </div>
                @else
                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0 w-8 h-8 bg-blue-500 dark:bg-blue-600 text-white rounded-full flex items-center justify-center font-bold text-sm">1</div>
                        <p class="text-gray-700 dark:text-gray-300 pt-1">Our team will contact you via WhatsApp shortly</p>
                    </div>
                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0 w-8 h-8 bg-blue-500 dark:bg-blue-600 text-white rounded-full flex items-center justify-center font-bold text-sm">2</div>
                        <p class="text-gray-700 dark:text-gray-300 pt-1">Payment information will be sent to you</p>
                    </div>
                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0 w-8 h-8 bg-blue-500 dark:bg-blue-600 text-white rounded-full flex items-center justify-center font-bold text-sm">3</div>
                        <p class="text-gray-700 dark:text-gray-300 pt-1">Please make payment and send proof of payment</p>
                    </div>
                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0 w-8 h-8 bg-blue-500 dark:bg-blue-600 text-white rounded-full flex items-center justify-center font-bold text-sm">4</div>
                        <p class="text-gray-700 dark:text-gray-300 pt-1">Your order will be processed after payment confirmation</p>
                    </div>
                @endif
            </div>
        </div>
        @else
        <!-- Fallback if no order -->
        <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-xl p-8 text-center">
            <div class="inline-flex items-center justify-center w-16 h-16 bg-blue-100 dark:bg-blue-900 rounded-full mb-4">
                <svg class="w-8 h-8 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
            </div>
            <p class="text-gray-700 dark:text-gray-300 text-lg">Your order has been received and is being processed.</p>
        </div>
        @endif

        <!-- Back Button -->
        <div class="text-center mt-8">
            @if(isset($salesPage))
            <a href="{{ route('sales-page.show', ['seller' => $salesPage->user->getUrlSlug(), 'slug' => $salesPage->slug]) }}"
               class="inline-block px-8 py-3 bg-gray-800 hover:bg-gray-900 dark:bg-gray-700 dark:hover:bg-gray-600 text-white rounded-xl font-semibold transition-all duration-200 shadow-lg hover:shadow-xl transform hover:scale-[1.02]">
                ← Back to Sales Page
            </a>
            @else
            <a href="{{ url('/') }}"
               class="inline-block px-8 py-3 bg-gray-800 hover:bg-gray-900 dark:bg-gray-700 dark:hover:bg-gray-600 text-white rounded-xl font-semibold transition-all duration-200 shadow-lg hover:shadow-xl transform hover:scale-[1.02]">
                ← Back to Home
            </a>
            @endif
        </div>

    </div>
</div>

<script>
    // Auto-scroll to top on page load
    window.scrollTo(0, 0);
</script>
@endsection
