@extends('layouts.base')

@section('title', $user->name . ' - Sales Pages')

@push('styles')
<style>
    .card-hover {
        transition: all 0.3s ease;
    }
    .card-hover:hover {
        transform: translateY(-5px);
        box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
    }
    .sales-card {
        width: 276px;
    }
    .feature-image {
        width: 276px;
        height: 200px;
        object-fit: cover;
    }

    /* Mobile responsive */
    @media (max-width: 768px) {
        .sales-card {
            width: 100% !important;
            max-width: 400px;
        }
        .feature-image {
            width: 100% !important;
            height: 200px;
        }
    }
</style>
@endpush

@section('body')
<div class="min-h-screen bg-gradient-to-br from-blue-50 to-indigo-100 dark:from-gray-900 dark:to-gray-800">
    <!-- Standalone Dark Mode Toggle -->
    <div class="fixed z-50" style="top: 0.5rem; right: 0.5rem;">
        <button onclick="toggleTheme()" class="p-3 rounded-full bg-white dark:bg-gray-800 shadow-lg hover:shadow-xl transition-all">
            <svg class="w-6 h-6 text-gray-800 dark:text-gray-200 hidden dark:block" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z"/>
            </svg>
            <svg class="w-6 h-6 text-gray-800 dark:text-gray-200 block dark:hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z"/>
            </svg>
        </button>
    </div>

    <div class="container mx-auto px-4 py-12">
    @php
        // Favicon fallback: user company logo > profile photo > system default
        $faviconPath = $user->company_logo
            ?? $user->profile_photo
            ?? asset('favicon.ico');
    @endphp
    <link rel="icon" type="image/x-icon" href="{{ asset($faviconPath) }}">
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset($faviconPath) }}">
    <!-- Seller Profile Section -->
    <div class="mx-auto bg-white dark:bg-gray-800 rounded-2xl shadow-xl p-8 mb-8" style="max-width: 400px;">
        <div class="flex flex-col items-center text-center">
            <!-- Profile Photo (1:1 ratio, 128x128, rounded border) -->
            @if($user->profile_photo)
                <img src="{{ asset($user->profile_photo) }}"
                     alt="{{ $user->name }}"
                     class="w-32 h-32 rounded-full object-cover border-4 border-gray-200 dark:border-gray-600 shadow-lg mb-4">
            @else
                <div class="w-32 h-32 rounded-full bg-gradient-to-br from-blue-400 to-indigo-600 flex items-center justify-center text-white text-4xl font-bold shadow-lg border-4 border-gray-200 dark:border-gray-600 mb-4">
                    {{ strtoupper(substr($user->name, 0, 1)) }}
                </div>
            @endif

            <!-- Seller Name with Verified Badge -->
            <div class="flex items-center justify-center gap-2 mb-1">
                <h1 class="text-2xl font-bold text-gray-900 dark:text-white">{{ $user->name }}</h1>
                <!-- Facebook-style Verified Badge -->
                <svg class="w-6 h-6 text-blue-500" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1.5 15l-4-4 1.41-1.41L10.5 14.17l5.59-5.59L17.5 10l-7 7z"/>
                </svg>
            </div>

            <!-- Seller Short Code -->
            @if($user->short_name)
                <p class="text-sm text-gray-500 dark:text-gray-400 bg-gray-100 dark:bg-gray-700 px-3 py-1 rounded-full mb-3">
                    {{ $user->short_name }}
                </p>
            @endif

            <!-- WhatsApp Contact Button -->
            @if($user->phone)
                <a href="https://wa.me/{{ preg_replace('/[^0-9]/', '', $user->phone) }}"
                   target="_blank"
                   class="inline-flex items-center gap-2 px-5 py-2.5 mt-4 bg-green-500 hover:bg-green-600 text-white font-medium rounded-full transition-all shadow-md hover:shadow-lg transform hover:scale-105">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                        <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/>
                    </svg>
                    <span>{{ $user->phone }}</span>
                </a>
            @endif
        </div>
    </div>

    <!-- Sales Pages Section -->
    <div class="mx-auto" style="max-width: 900px;">
        <h2 class="text-3xl font-bold text-center text-gray-900 dark:text-white mb-8">Browse My Sales Pages</h2>

        @if($salesPages->isEmpty())
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md p-12 text-center">
                <svg class="w-16 h-16 text-gray-400 dark:text-gray-500 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                </svg>
                <p class="text-xl text-gray-600 dark:text-gray-300">No sales pages available at the moment.</p>
                <p class="text-sm text-gray-500 dark:text-gray-400 mt-2">Check back soon for updates!</p>
            </div>
        @else
            <div class="flex flex-wrap gap-6 justify-center">
                @foreach($salesPages as $page)
                    <a href="{{ route('sales-page.show', [$user->getUrlSlug(), $page->slug]) }}"
                       class="card-hover block sales-card">
                        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-md overflow-hidden h-full flex flex-col">
                                <!-- Feature Image -->
                                @php
                                    $featureImage = null;
                                    if ($page->html_content) {
                                        preg_match('/<img[^>]+src=["\']([^"\']+)["\'][^>]*>/i', $page->html_content, $matches);
                                        $featureImage = $matches[1] ?? null;
                                    }
                                @endphp

                                @if($featureImage)
                                    <img src="{{ $featureImage }}"
                                         alt="{{ $page->name }}"
                                         class="feature-image">
                                @else
                                    <div class="feature-image bg-gradient-to-r from-blue-500 to-indigo-600 flex justify-center items-center">
                                        <h3 class="text-xl font-bold text-white text-center px-4">{{ $page->name }}</h3>
                                    </div>
                                @endif

                            <!-- Card Body -->
                            <div class="p-6 flex-grow flex flex-col">
                                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">{{ $page->name }}</h3>

                                @if($page->meta_description)
                                    <p class="text-gray-600 dark:text-gray-400 text-sm mb-4 flex-grow">
                                        {{ Str::limit($page->meta_description, 100) }}
                                    </p>
                                @endif

                                <!-- View Button -->
                                <div class="mt-auto">
                                    <span class="inline-flex items-center justify-center w-full px-4 py-3 bg-blue-600 hover:bg-blue-700 dark:bg-blue-500 dark:hover:bg-blue-600 text-white font-semibold rounded-lg transition-colors">
                                        View Page
                                        <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
                                        </svg>
                                    </span>
                                </div>
                            </div>

                            <!-- Card Footer - Stats -->
                            <div class="px-6 py-4 bg-gray-50 dark:bg-gray-900 border-t border-gray-100 dark:border-gray-700">
                                <div class="flex justify-between text-sm text-gray-600 dark:text-gray-400">
                                    <div class="flex items-center">
                                        <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M10 12a2 2 0 100-4 2 2 0 000 4z"/>
                                            <path fill-rule="evenodd" d="M.458 10C1.732 5.943 5.522 3 10 3s8.268 2.943 9.542 7c-1.274 4.057-5.064 7-9.542 7S1.732 14.057.458 10zM14 10a4 4 0 11-8 0 4 4 0 018 0z" clip-rule="evenodd"/>
                                        </svg>
                                        {{ number_format($page->total_views) }} views
                                    </div>
                                    <div class="flex items-center">
                                        <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M3 1a1 1 0 000 2h1.22l.305 1.222a.997.997 0 00.01.042l1.358 5.43-.893.892C3.74 11.846 4.632 14 6.414 14H15a1 1 0 000-2H6.414l1-1H14a1 1 0 00.894-.553l3-6A1 1 0 0017 3H6.28l-.31-1.243A1 1 0 005 1H3zM16 16.5a1.5 1.5 0 11-3 0 1.5 1.5 0 013 0zM6.5 18a1.5 1.5 0 100-3 1.5 1.5 0 000 3z"/>
                                        </svg>
                                        {{ number_format($page->total_orders) }} orders
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a>
                @endforeach
            </div>
        @endif
    </div>
</div>
</div>
@endsection
