@extends('layouts.base')

@section('title', 'Select Payment Method - ' . $salesPage->name)

@push('styles')
<style>
    :root {
        --primary-color: {{ $salesPage->primary_color ?? '#3b82f6' }};
    }

    body {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        min-height: 100vh;
        padding: 20px 10px;
    }

    .dark body {
        background: linear-gradient(135deg, #1e3a8a 0%, #581c87 100%);
    }

    .payment-option {
        transition: all 0.3s ease;
    }

    .payment-option:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
    }

    .payment-option input[type="radio"]:checked + label {
        border-color: var(--primary-color);
        background-color: rgba(59, 130, 246, 0.05);
    }

    .dark .payment-option input[type="radio"]:checked + label {
        background-color: rgba(59, 130, 246, 0.15);
    }
</style>
@endpush

@section('body')
@php
    // Favicon fallback logic: sales page > user company logo > system default
    $faviconPath = $salesPage->getFaviconPath()
        ?? $salesPage->user->company_logo
        ?? asset('favicon.ico');
@endphp
<link rel="icon" type="image/x-icon" href="{{ asset($faviconPath) }}">
<link rel="shortcut icon" type="image/x-icon" href="{{ asset($faviconPath) }}">

<div class="max-w-2xl mx-auto">
    @if($salesPage->logo_path && $salesPage->show_logo)
    <div class="text-center py-4 px-3 bg-white dark:bg-gray-800 rounded-xl border-b mb-4">
        <img src="{{ asset($salesPage->logo_path) }}" alt="{{ $salesPage->name }}" class="h-12 mx-auto">
    </div>
    @endif

    <!-- Order Summary -->
    <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 mb-4">
        <h2 class="text-xl font-bold mb-4 text-gray-900 dark:text-white" style="color: var(--primary-color)">Order Summary</h2>

        <div class="space-y-3 mb-4 pb-4 border-b dark:border-gray-700">
            @foreach($salesPageOrder->items as $item)
            <div class="flex justify-between items-start">
                <div class="flex-1">
                    <div class="font-medium text-gray-900 dark:text-white">{{ $item['name'] }}</div>
                    <div class="text-sm text-gray-500 dark:text-gray-400">Qty: {{ $item['quantity'] }} × RM {{ number_format($item['price'], 2) }}</div>
                </div>
                <div class="font-bold text-gray-900 dark:text-white">RM {{ number_format($item['quantity'] * $item['price'], 2) }}</div>
            </div>
            @endforeach
        </div>

        <div class="space-y-2">
            <div class="flex justify-between text-base text-gray-900 dark:text-white">
                <span>Subtotal</span>
                <span class="font-bold">RM {{ number_format($salesPageOrder->total_amount, 2) }}</span>
            </div>
            <div id="fee-display" class="flex justify-between text-base text-gray-600 dark:text-gray-400" style="display: none;">
                <span id="fee-label">Fee</span>
                <span class="font-bold" id="fee-amount">RM 0.00</span>
            </div>
            <div class="flex justify-between text-lg font-bold pt-3 border-t-2 dark:border-gray-700 text-gray-900 dark:text-white">
                <span>Total</span>
                <span id="grand-total" style="color: var(--primary-color)">RM {{ number_format($salesPageOrder->total_amount, 2) }}</span>
            </div>
        </div>

        <!-- Customer Details -->
        <div class="mt-6 pt-6 border-t dark:border-gray-700">
            <h3 class="font-bold mb-3 text-gray-700 dark:text-gray-300">Delivery Information</h3>
            <div class="space-y-1 text-sm text-gray-600 dark:text-gray-400">
                    <p><strong>{{ $salesPageOrder->customer_name }}</strong></p>
                    <p>{{ $salesPageOrder->customer_phone }}</p>
                    @if($salesPageOrder->customer_email)
                    <p>{{ $salesPageOrder->customer_email }}</p>
                    @endif
                    <p class="mt-2">{{ $salesPageOrder->customer_address }}</p>
                    <p>{{ $salesPageOrder->customer_postcode }} {{ $salesPageOrder->customer_city }}</p>
                    <p>{{ $salesPageOrder->customer_state }}, Malaysia</p>
                </div>
            </div>
        </div>

    <!-- Payment Method Selection -->
    <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6">
        <h2 class="text-xl font-bold mb-2 text-gray-900 dark:text-white" style="color: var(--primary-color)">Select Payment Method</h2>
        <p class="text-sm text-gray-600 dark:text-gray-400 mb-6">Choose how you want to complete your payment</p>

            <form id="payment-form" action="{{ route('sales-page.payment.process', $salesPageOrder->id) }}" method="POST">
                @csrf

                <div class="space-y-4">
                <!-- FPX / Online Banking -->
                <div class="payment-option">
                    <input type="radio" name="payment_method" id="fpx" value="fpx" class="hidden" required>
                    <label for="fpx" class="flex items-center p-4 border-2 border-gray-300 dark:border-gray-600 dark:bg-gray-700 rounded-lg cursor-pointer">
                        <div class="flex-1">
                            <div class="flex items-center gap-3">
                                <div class="w-12 h-12 bg-blue-100 dark:bg-blue-900 rounded-lg flex items-center justify-center">
                                    <svg class="w-6 h-6 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"/>
                                    </svg>
                                </div>
                                <div>
                                    <div class="font-bold text-gray-900 dark:text-white">Online Banking (FPX)</div>
                                    <div class="text-sm text-gray-600 dark:text-gray-400">Pay via bank transfer</div>
                                    @if($fpxFee > 0)
                                    <div class="text-xs text-blue-600 dark:text-blue-400 mt-1">+RM {{ number_format($fpxFee, 2) }} processing fee</div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="ml-4">
                            <span class="inline-flex px-3 py-1 text-xs font-semibold rounded-full bg-green-100 dark:bg-green-900 text-green-800 dark:text-green-200">Instant</span>
                        </div>
                    </label>
                </div>

                <!-- DuitNow QR -->
                <div class="payment-option">
                    <input type="radio" name="payment_method" id="duitnow" value="duitnow" class="hidden" required>
                    <label for="duitnow" class="flex items-center p-4 border-2 border-gray-300 dark:border-gray-600 dark:bg-gray-700 rounded-lg cursor-pointer">
                        <div class="flex-1">
                            <div class="flex items-center gap-3">
                                <div class="w-12 h-12 bg-purple-100 dark:bg-purple-900 rounded-lg flex items-center justify-center">
                                    <svg class="w-6 h-6 text-purple-600 dark:text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v1m6 11h2m-6 0h-2v4m0-11v3m0 0h.01M12 12h4.01M16 20h4M4 12h4m12 0h.01M5 8h2a1 1 0 001-1V5a1 1 0 00-1-1H5a1 1 0 00-1 1v2a1 1 0 001 1zm12 0h2a1 1 0 001-1V5a1 1 0 00-1-1h-2a1 1 0 00-1 1v2a1 1 0 001 1zM5 20h2a1 1 0 001-1v-2a1 1 0 00-1-1H5a1 1 0 00-1 1v2a1 1 0 001 1z"/>
                                    </svg>
                                </div>
                                <div>
                                    <div class="font-bold text-gray-900 dark:text-white">DuitNow QR</div>
                                    <div class="text-sm text-gray-600 dark:text-gray-400">Scan QR code to pay</div>
                                    @if($duitnowFee > 0)
                                    <div class="text-xs text-purple-600 dark:text-purple-400 mt-1">+RM {{ number_format($duitnowFee, 2) }} processing fee</div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="ml-4">
                            <span class="inline-flex px-3 py-1 text-xs font-semibold rounded-full bg-green-100 dark:bg-green-900 text-green-800 dark:text-green-200">Instant</span>
                        </div>
                    </label>
                </div>

                <!-- Cash on Delivery -->
                <div class="payment-option">
                    <input type="radio" name="payment_method" id="cod" value="cod" class="hidden" required>
                    <label for="cod" class="flex items-center p-4 border-2 border-gray-300 dark:border-gray-600 dark:bg-gray-700 rounded-lg cursor-pointer">
                        <div class="flex-1">
                            <div class="flex items-center gap-3">
                                <div class="w-12 h-12 bg-amber-100 dark:bg-amber-900 rounded-lg flex items-center justify-center">
                                    <svg class="w-6 h-6 text-amber-600 dark:text-amber-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"/>
                                    </svg>
                                </div>
                                <div>
                                    <div class="font-bold text-gray-900 dark:text-white">Cash on Delivery (COD)</div>
                                    <div class="text-sm text-gray-600 dark:text-gray-400">Pay when you receive</div>
                                    <div class="text-xs text-amber-600 dark:text-amber-400 mt-1">+RM {{ number_format($codFee, 2) }} shipping fee</div>
                                </div>
                            </div>
                        </div>
                    </label>
                </div>
                </div>

                <button type="submit"
                        class="w-full mt-6 py-4 px-6 rounded-lg text-white font-bold text-lg shadow-lg hover:shadow-xl transition-all"
                        style="background-color: var(--primary-color)">
                    Continue to Payment
                </button>
            </form>
        </div>

    <div class="text-center mt-6">
        <p class="text-white dark:text-gray-300 text-sm">
            Secured payment processing
        </p>
    </div>
</div>

<script>
        const subtotal = {{ $salesPageOrder->total_amount }};
        const codFee = {{ $codFee }};
        const fpxFee = {{ $fpxFee }};
        const duitnowFee = {{ $duitnowFee }};

        // Handle payment method selection
        document.querySelectorAll('input[name="payment_method"]').forEach(radio => {
            radio.addEventListener('change', function() {
                const feeDisplay = document.getElementById('fee-display');
                const feeLabel = document.getElementById('fee-label');
                const feeAmount = document.getElementById('fee-amount');
                const grandTotal = document.getElementById('grand-total');

                let fee = 0;
                let label = '';

                if (this.value === 'cod') {
                    fee = codFee;
                    label = 'COD Shipping Fee';
                } else if (this.value === 'fpx') {
                    fee = fpxFee;
                    label = 'Payment Processing Fee';
                } else if (this.value === 'duitnow') {
                    fee = duitnowFee;
                    label = 'Payment Processing Fee';
                }

                if (fee > 0) {
                    feeDisplay.style.display = 'flex';
                    feeLabel.textContent = label;
                    feeAmount.textContent = `RM ${fee.toFixed(2)}`;
                    grandTotal.textContent = `RM ${(subtotal + fee).toFixed(2)}`;
                } else {
                    feeDisplay.style.display = 'none';
                    grandTotal.textContent = `RM ${subtotal.toFixed(2)}`;
                }
            });
        });
</script>
@endsection
