<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Processing - {{ $salesPageOrder->salesPage->name }}</title>

    @if($salesPageOrder->salesPage->getFaviconPath())
        <link rel="icon" type="image/x-icon" href="{{ asset($salesPageOrder->salesPage->getFaviconPath()) }}">
        <link rel="shortcut icon" type="image/x-icon" href="{{ asset($salesPageOrder->salesPage->getFaviconPath()) }}">
    @endif

    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <meta http-equiv="refresh" content="5">
</head>
<body class="bg-gray-100">
    <div class="min-h-screen flex items-center justify-center px-4">
        <div class="max-w-md w-full bg-white rounded-xl shadow-lg p-8 text-center">
            <div class="mb-6">
                <div class="inline-flex items-center justify-center w-20 h-20 bg-yellow-100 rounded-full">
                    <svg class="w-10 h-10 text-yellow-600 animate-spin" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                    </svg>
                </div>
            </div>

            <h1 class="text-2xl font-bold text-gray-900 mb-3">Processing Payment...</h1>
            <p class="text-gray-600 mb-6">We're confirming your payment. This page will refresh automatically.</p>

            <div class="bg-blue-50 rounded-lg p-4 text-sm text-blue-800">
                <p class="font-semibold mb-2">What's happening?</p>
                <ul class="text-left space-y-1 text-sm">
                    <li>✓ Payment submitted</li>
                    <li>⏳ Waiting for bank confirmation</li>
                    <li>⏳ Creating your order</li>
                </ul>
            </div>

            <p class="text-xs text-gray-500 mt-6">
                This usually takes a few seconds. Please do not close this window.
            </p>
        </div>
    </div>
</body>
</html>
