@extends('layouts.app')

@section('title', 'Edit Sales Page')

@section('content')
<div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
    <div class="mb-8 flex justify-between items-center">
        <h1 class="text-3xl font-bold text-gray-900 dark:text-gray-100">Edit Sales Page</h1>
        <a href="{{ $salesPage->getPublicUrl() }}" target="_blank"
           class="px-5 py-2.5 bg-green-600 text-white rounded-lg hover:bg-green-700 transition-colors shadow-sm">
            👁 Preview Page
        </a>
    </div>

    @if(session('success'))
        <div class="bg-green-100 dark:bg-green-900/30 border border-green-400 dark:border-green-600 text-green-700 dark:text-green-300 px-6 py-4 rounded-lg mb-6">
            {{ session('success') }}
        </div>
    @endif

    <form action="{{ route('sales-pages.update', $salesPage) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        <div class="bg-white dark:bg-gray-800 shadow-lg rounded-xl p-8 space-y-8 border border-gray-200 dark:border-gray-700">

            <!-- Basic Info -->
            <div class="pb-8 border-b border-gray-200 dark:border-gray-700">
                <h2 class="text-xl font-semibold mb-6 text-gray-900 dark:text-gray-100">Basic Information</h2>

                <div class="space-y-6">
                    <div>
                        <label class="block text-sm font-medium mb-2 text-gray-700 dark:text-gray-300">Page Name *</label>
                        <input type="text" name="name" value="{{ old('name', $salesPage->name) }}" required
                               class="w-full px-4 py-3 rounded-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 placeholder-gray-400 dark:placeholder-gray-500 focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all">
                    </div>

                    <div>
                        <label class="block text-sm font-medium mb-2 text-gray-700 dark:text-gray-300">Meta Description (SEO)</label>
                        <textarea name="meta_description" rows="3" maxlength="160"
                                  placeholder="Short description for search engines (max 160 characters)"
                                  class="w-full px-4 py-3 rounded-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 placeholder-gray-400 dark:placeholder-gray-500 focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all">{{ old('meta_description', $salesPage->meta_description) }}</textarea>
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-2">Helps improve search engine visibility</p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium mb-2 text-gray-700 dark:text-gray-300">URL Slug</label>
                        <div class="flex">
                            <span class="inline-flex items-center px-4 rounded-l-lg border border-r-0 border-gray-300 dark:border-gray-600 bg-gray-50 dark:bg-gray-900 text-gray-600 dark:text-gray-400 text-sm">
                                /p/{{ $salesPage->user->getUrlSlug() }}/
                            </span>
                            <input type="text" name="slug" value="{{ old('slug', $salesPage->slug) }}" required
                                   class="flex-1 px-4 py-3 rounded-r-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all">
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium mb-2 text-gray-700 dark:text-gray-300">Logo</label>
                        @if($salesPage->logo_path)
                            <div class="mb-3 p-3 bg-gray-50 dark:bg-gray-900 rounded-lg inline-block">
                                <img src="{{ asset($salesPage->logo_path) }}" alt="Logo" class="h-16">
                            </div>
                        @endif
                        <input type="file" name="logo" accept="image/*"
                               class="w-full px-3 py-2 text-sm text-gray-900 dark:text-gray-100 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer focus:outline-none">

                        <div class="mt-4">
                            <label class="flex items-center gap-2 cursor-pointer">
                                <input type="checkbox" name="show_logo" value="1"
                                       {{ old('show_logo', $salesPage->show_logo) ? 'checked' : '' }}
                                       class="w-4 h-4 rounded text-blue-600 focus:ring-2 focus:ring-blue-500">
                                <span class="text-sm text-gray-700 dark:text-gray-300">Show logo on sales page</span>
                            </label>
                            <p class="text-xs text-gray-500 dark:text-gray-400 mt-2 ml-6">Uncheck to hide logo from public page (you can add it in your HTML content instead)</p>
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium mb-2 text-gray-700 dark:text-gray-300">Favicon</label>
                        <p class="text-xs text-gray-500 dark:text-gray-400 mb-3">Browser tab icon (recommended: 32x32px or 64x64px)</p>

                        <div class="mb-4">
                            <label class="flex items-center gap-2 cursor-pointer">
                                <input type="checkbox" name="use_logo_as_favicon" value="1"
                                       {{ old('use_logo_as_favicon', $salesPage->use_logo_as_favicon) ? 'checked' : '' }}
                                       class="w-4 h-4 rounded text-blue-600 focus:ring-2 focus:ring-blue-500">
                                <span class="text-sm text-gray-700 dark:text-gray-300">Use logo as favicon</span>
                            </label>
                        </div>

                        @if($salesPage->favicon_path)
                            <div class="mb-3 p-3 bg-gray-50 dark:bg-gray-900 rounded-lg inline-block">
                                <img src="{{ asset($salesPage->favicon_path) }}" alt="Favicon" class="h-8">
                            </div>
                        @endif
                        <input type="file" name="favicon" accept="image/*"
                               class="w-full px-3 py-2 text-sm text-gray-900 dark:text-gray-100 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer focus:outline-none">
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-2">Upload custom favicon (leave empty to use logo)</p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium mb-2 text-gray-700 dark:text-gray-300">Primary Color</label>
                        <input type="color" name="primary_color" value="{{ old('primary_color', $salesPage->primary_color) }}"
                               class="h-12 w-24 rounded-lg border border-gray-300 dark:border-gray-600 cursor-pointer">
                    </div>

                    <div class="pt-2">
                        <label class="flex items-center gap-3 cursor-pointer p-3 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700/50 transition-colors">
                            <input type="checkbox" name="is_active" value="1"
                                   {{ old('is_active', $salesPage->is_active) ? 'checked' : '' }}
                                   class="w-5 h-5 rounded text-blue-600 focus:ring-2 focus:ring-blue-500">
                            <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Page is Active</span>
                        </label>
                    </div>
                </div>
            </div>

            <!-- Public URL -->
            <div class="bg-blue-50 dark:bg-blue-900/20 p-6 rounded-xl border border-blue-200 dark:border-blue-800">
                <label class="block text-sm font-medium mb-3 text-blue-900 dark:text-blue-100">Public URL:</label>
                <div class="flex items-center gap-3">
                    <input type="text" value="{{ $salesPage->getPublicUrl() }}" readonly
                           id="public-url"
                           class="flex-1 px-4 py-3 bg-white dark:bg-gray-800 text-gray-900 dark:text-gray-100 rounded-lg border border-blue-200 dark:border-blue-700 focus:outline-none">
                    <button type="button" onclick="copyUrl()" class="px-5 py-3 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors shadow-sm whitespace-nowrap">
                        📋 Copy
                    </button>
                </div>
            </div>

            <!-- HTML Content -->
            <div class="pb-8 border-b border-gray-200 dark:border-gray-700">
                <h2 class="text-xl font-semibold mb-4 text-gray-900 dark:text-gray-100">Page Content (HTML)</h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">Add your sales page content with images, headings, and descriptions</p>
                <textarea name="html_content" rows="20"
                          placeholder="<img src='https://example.com/banner.jpg' style='width:100%'>&#10;<h1>Product Title</h1>&#10;<p>Description...</p>"
                          class="w-full px-4 py-3 rounded-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 font-mono text-sm focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all">{{ old('html_content', $salesPage->html_content) }}</textarea>
            </div>

            <!-- Thumbnail URL -->
            <div class="pb-8 border-b border-gray-200 dark:border-gray-700">
                <h2 class="text-xl font-semibold mb-4 text-gray-900 dark:text-gray-100">Thumbnail Image URL</h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">Enter the URL of your thumbnail image from your CDN (e.g., for YouTube video thumbnails or social media sharing)</p>

                <div>
                    <label class="block text-sm font-medium mb-2 text-gray-700 dark:text-gray-300">Thumbnail URL</label>
                    <input type="text" name="thumbnail_path" value="{{ old('thumbnail_path', $salesPage->thumbnail_path) }}"
                           placeholder="https://your-cdn.com/images/thumbnail.jpg"
                           class="w-full px-4 py-3 rounded-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 placeholder-gray-400 dark:placeholder-gray-500 focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all">
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-2">Paste the full URL from your CDN or image hosting service. Recommended: 9:16 aspect ratio for vertical videos</p>
                </div>

                @if($salesPage->thumbnail_path)
                    <div class="mt-4 p-4 bg-gray-50 dark:bg-gray-900 rounded-xl border border-gray-300 dark:border-gray-600">
                        <label class="block text-sm font-medium mb-2 text-gray-700 dark:text-gray-300">Preview:</label>
                        <img src="{{ $salesPage->thumbnail_path }}" alt="Thumbnail Preview" class="h-32 rounded-lg border border-gray-300 dark:border-gray-600" onerror="this.style.display='none'">
                    </div>
                @endif
            </div>

            <!-- Legal / Marketing Content -->
            <div class="pb-8 border-b border-gray-200 dark:border-gray-700">
                <h2 class="text-xl font-semibold mb-4 text-gray-900 dark:text-gray-100">Legal / Marketing / Permission (HTML)</h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">This section appears above the footer for legal notices, marketing consent, tracking permission, etc.</p>
                <textarea name="legal_content" rows="8"
                          class="w-full px-4 py-3 rounded-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 font-mono text-sm focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all"
                          placeholder="<p>By submitting this form, you agree to our <a href='#'>Terms & Conditions</a> and <a href='#'>Privacy Policy</a>.</p>">{{ old('legal_content', $salesPage->legal_content) }}</textarea>
            </div>

            <!-- FAQ Section -->
            <div class="pb-8 border-b border-gray-200 dark:border-gray-700">
                <h2 class="text-xl font-semibold mb-4 text-gray-900 dark:text-gray-100">FAQ Section</h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-6">Add frequently asked questions with accordion-style answers (supports HTML)</p>

                <div id="faq-container" class="space-y-4">
                    @php
                        $existingFaqs = old('faq_items', $salesPage->faq_items ?? []);
                    @endphp

                    @if(!empty($existingFaqs) && count($existingFaqs) > 0)
                        @foreach($existingFaqs as $index => $faq)
                            <div class="faq-item border border-gray-300 dark:border-gray-600 rounded-xl p-5 bg-gray-50 dark:bg-gray-700/30">
                                <div class="flex justify-between items-start mb-4">
                                    <h4 class="font-semibold text-sm text-gray-900 dark:text-gray-100">FAQ #{{ $index + 1 }}</h4>
                                    <button type="button" class="remove-faq text-red-600 dark:text-red-400 hover:text-red-800 dark:hover:text-red-300 text-sm font-medium transition-colors">
                                        ✕ Remove
                                    </button>
                                </div>
                                <div class="space-y-4">
                                    <div>
                                        <label class="block text-sm font-medium mb-2 text-gray-700 dark:text-gray-300">Question</label>
                                        <input type="text" name="faq_items[{{ $index }}][question]"
                                               value="{{ $faq['question'] ?? '' }}"
                                               placeholder="e.g., How do I consume this product?"
                                               class="w-full px-4 py-3 rounded-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 placeholder-gray-400 dark:placeholder-gray-500 focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all">
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium mb-2 text-gray-700 dark:text-gray-300">Answer (HTML supported)</label>
                                        <textarea name="faq_items[{{ $index }}][answer]" rows="4"
                                                  placeholder="<p>You can consume 1-2 sachets daily...</p>"
                                                  class="w-full px-4 py-3 rounded-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 placeholder-gray-400 dark:placeholder-gray-500 font-mono text-sm focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all">{{ $faq['answer'] ?? '' }}</textarea>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>

                <button type="button" id="add-faq" class="mt-4 px-5 py-3 bg-green-600 text-white rounded-lg hover:bg-green-700 transition-colors shadow-sm font-medium">
                    + Add FAQ
                </button>
            </div>

            <!-- Order Bump / Upsell -->
            <div class="pb-8 border-b border-gray-200 dark:border-gray-700">
                <h2 class="text-xl font-semibold mb-4 text-gray-900 dark:text-gray-100">Order Bump / Upsell Offer</h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-6">Show a special offer when customer selects a product</p>

                <div class="space-y-6">
                    <!-- Enable Order Bump -->
                    <div>
                        <label class="flex items-center gap-3 cursor-pointer p-3 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700/50 transition-colors">
                            <input type="checkbox" name="order_bump_enabled" value="1"
                                   {{ old('order_bump_enabled', $salesPage->order_bump_enabled) ? 'checked' : '' }}
                                   id="order-bump-toggle"
                                   class="w-5 h-5 rounded text-blue-600 focus:ring-2 focus:ring-blue-500">
                            <span class="text-sm font-medium text-gray-700 dark:text-gray-300">Enable Order Bump/Upsell</span>
                        </label>
                    </div>

                    <div id="order-bump-settings" class="{{ old('order_bump_enabled', $salesPage->order_bump_enabled) ? '' : 'hidden' }} space-y-6 border-l-4 border-green-500 dark:border-green-600 pl-6">
                        <!-- Select Product -->
                        <div>
                            <label class="block text-sm font-medium mb-2 text-gray-700 dark:text-gray-300">Upsell Product</label>
                            <select name="order_bump_product_id" class="w-full px-4 py-3 rounded-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all">
                                <option value="">Select a product</option>
                                @foreach($products as $product)
                                    <option value="{{ $product->id }}"
                                            {{ old('order_bump_product_id', $salesPage->order_bump_product_id) == $product->id ? 'selected' : '' }}>
                                        {{ $product->name }} - RM {{ number_format($product->price, 2) }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Offer Text -->
                        <div>
                            <label class="block text-sm font-medium mb-2 text-gray-700 dark:text-gray-300">Offer Text</label>
                            <textarea name="order_bump_text" rows="3"
                                      placeholder="Example: Add RM80 get 3 Booster Serum - Special Offer!"
                                      class="w-full px-4 py-3 rounded-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 placeholder-gray-400 dark:placeholder-gray-500 focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all">{{ old('order_bump_text', $salesPage->order_bump_text) }}</textarea>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                            <!-- Background Color -->
                            <div>
                                <label class="block text-sm font-medium mb-2 text-gray-700 dark:text-gray-300">Background Color</label>
                                <input type="color" name="order_bump_bg_color"
                                       value="{{ old('order_bump_bg_color', $salesPage->order_bump_bg_color ?? '#fef3c7') }}"
                                       class="w-full h-12 rounded-lg border border-gray-300 dark:border-gray-600 cursor-pointer">
                            </div>

                            <!-- Text Color -->
                            <div>
                                <label class="block text-sm font-medium mb-2 text-gray-700 dark:text-gray-300">Text Color</label>
                                <input type="color" name="order_bump_text_color"
                                       value="{{ old('order_bump_text_color', $salesPage->order_bump_text_color ?? '#78350f') }}"
                                       class="w-full h-12 rounded-lg border border-gray-300 dark:border-gray-600 cursor-pointer">
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                            <!-- Border Style -->
                            <div>
                                <label class="block text-sm font-medium mb-2 text-gray-700 dark:text-gray-300">Border Style</label>
                                <select name="order_bump_border_style" class="w-full px-4 py-3 rounded-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all">
                                    <option value="solid" {{ old('order_bump_border_style', $salesPage->order_bump_border_style) == 'solid' ? 'selected' : '' }}>Solid</option>
                                    <option value="dashed" {{ old('order_bump_border_style', $salesPage->order_bump_border_style) == 'dashed' ? 'selected' : '' }}>Dashed</option>
                                    <option value="dotted" {{ old('order_bump_border_style', $salesPage->order_bump_border_style) == 'dotted' ? 'selected' : '' }}>Dotted</option>
                                </select>
                            </div>

                            <!-- Border Color -->
                            <div>
                                <label class="block text-sm font-medium mb-2 text-gray-700 dark:text-gray-300">Border Color</label>
                                <input type="color" name="order_bump_border_color"
                                       value="{{ old('order_bump_border_color', $salesPage->order_bump_border_color ?? '#f59e0b') }}"
                                       class="w-full h-12 rounded-lg border border-gray-300 dark:border-gray-600 cursor-pointer">
                            </div>
                        </div>

                        <!-- Preview -->
                        <div>
                            <label class="block text-sm font-medium mb-3 text-gray-700 dark:text-gray-300">Preview:</label>
                            <div id="order-bump-preview"
                                 style="background-color: {{ old('order_bump_bg_color', $salesPage->order_bump_bg_color ?? '#fef3c7') }};
                                        color: {{ old('order_bump_text_color', $salesPage->order_bump_text_color ?? '#78350f') }};
                                        border: 2px {{ old('order_bump_border_style', $salesPage->order_bump_border_style ?? 'dashed') }} {{ old('order_bump_border_color', $salesPage->order_bump_border_color ?? '#f59e0b') }};"
                                 class="p-5 rounded-xl">
                                <div class="flex items-center gap-3">
                                    <input type="checkbox" checked class="w-5 h-5 rounded">
                                    <div class="font-semibold">
                                        <span id="preview-text">{{ old('order_bump_text', $salesPage->order_bump_text) ?: 'Add RM80 get 3 Booster Serum - Special Offer!' }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Products to Sell -->
            <div class="pb-8 border-b border-gray-200 dark:border-gray-700">
                <h2 class="text-xl font-semibold mb-6 text-gray-900 dark:text-gray-100">Products to Sell</h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">Select which products will be available on this sales page</p>

                @if($products->count() > 0)
                    <div class="space-y-2 max-h-64 overflow-y-auto border border-gray-300 dark:border-gray-600 rounded-xl p-4 bg-gray-50 dark:bg-gray-700/30">
                        @foreach($products as $product)
                            <label class="flex items-center gap-3 p-3 hover:bg-white dark:hover:bg-gray-700 rounded-lg transition-colors cursor-pointer">
                                <input type="checkbox" name="available_products[]" value="{{ $product->id }}"
                                       {{ in_array($product->id, old('available_products', $salesPage->available_products ?? [])) ? 'checked' : '' }}
                                       class="w-5 h-5 rounded text-blue-600 focus:ring-2 focus:ring-blue-500">
                                <div class="flex-1">
                                    <div class="font-medium text-gray-900 dark:text-gray-100">{{ $product->name }}</div>
                                    <div class="text-sm text-gray-500 dark:text-gray-400">RM {{ number_format($product->price, 2) }}</div>
                                </div>
                            </label>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8 bg-gray-50 dark:bg-gray-700/30 rounded-xl border border-gray-300 dark:border-gray-600">
                        <svg class="w-12 h-12 mx-auto text-gray-400 dark:text-gray-500 mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4"/>
                        </svg>
                        <p class="text-gray-600 dark:text-gray-400">No products available. Create products first.</p>
                    </div>
                @endif
            </div>

            <!-- Tracking Pixels -->
            <div class="pb-8 border-b border-gray-200 dark:border-gray-700">
                <h2 class="text-xl font-semibold mb-6 text-gray-900 dark:text-gray-100">Tracking & Analytics Pixels</h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-6">Track conversions and visitor behavior with tracking pixels</p>

                <div class="space-y-6">
                    <!-- Facebook Pixel -->
                    <div class="bg-gradient-to-r from-blue-50 to-indigo-50 dark:from-blue-900/20 dark:to-indigo-900/20 p-5 rounded-xl border border-blue-200 dark:border-blue-800">
                        <div class="flex items-center gap-3 mb-3">
                            <div class="w-10 h-10 bg-blue-600 rounded-lg flex items-center justify-center">
                                <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                                </svg>
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-900 dark:text-gray-100">Facebook Pixel ID</label>
                                <p class="text-xs text-gray-600 dark:text-gray-400">Track Facebook ad conversions</p>
                            </div>
                        </div>
                        <input type="text" name="facebook_pixel_id" value="{{ old('facebook_pixel_id', $salesPage->facebook_pixel_id) }}"
                               placeholder="123456789012345"
                               class="w-full px-4 py-3 rounded-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 placeholder-gray-400 dark:placeholder-gray-500 focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all">
                    </div>

                    <!-- Google Analytics -->
                    <div class="bg-gradient-to-r from-orange-50 to-red-50 dark:from-orange-900/20 dark:to-red-900/20 p-5 rounded-xl border border-orange-200 dark:border-orange-800">
                        <div class="flex items-center gap-3 mb-3">
                            <div class="w-10 h-10 bg-orange-600 rounded-lg flex items-center justify-center">
                                <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M22.84 2.998v17.999a1.002 1.002 0 01-1.002 1.002h-5.687a.502.502 0 01-.502-.502V12.35H9.352v9.147a.502.502 0 01-.502.502H3.162a1.002 1.002 0 01-1.002-1.002V2.998a1.002 1.002 0 011.002-1.002h5.688a.502.502 0 01.502.502v9.148h6.297V2.498a.502.502 0 01.502-.502h5.687a1.002 1.002 0 011.002 1.002z"/>
                                </svg>
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-900 dark:text-gray-100">Google Analytics ID</label>
                                <p class="text-xs text-gray-600 dark:text-gray-400">Track visitor behavior and traffic sources</p>
                            </div>
                        </div>
                        <input type="text" name="google_analytics_id" value="{{ old('google_analytics_id', $salesPage->google_analytics_id) }}"
                               placeholder="G-XXXXXXXXXX or UA-XXXXXXXXX-X"
                               class="w-full px-4 py-3 rounded-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 placeholder-gray-400 dark:placeholder-gray-500 focus:ring-2 focus:ring-orange-500 focus:border-transparent transition-all">
                    </div>

                    <!-- TikTok Pixel -->
                    <div class="bg-gradient-to-r from-gray-50 to-slate-50 dark:from-gray-900/20 dark:to-slate-900/20 p-5 rounded-xl border border-gray-300 dark:border-gray-700">
                        <div class="flex items-center gap-3 mb-3">
                            <div class="w-10 h-10 bg-gray-900 dark:bg-gray-700 rounded-lg flex items-center justify-center">
                                <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M19.59 6.69a4.83 4.83 0 01-3.77-4.25V2h-3.45v13.67a2.89 2.89 0 01-5.2 1.74 2.89 2.89 0 012.31-4.64 2.93 2.93 0 01.88.13V9.4a6.84 6.84 0 00-1-.05A6.33 6.33 0 005 20.1a6.34 6.34 0 0010.86-4.43v-7a8.16 8.16 0 004.77 1.52v-3.4a4.85 4.85 0 01-1-.1z"/>
                                </svg>
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-900 dark:text-gray-100">TikTok Pixel ID</label>
                                <p class="text-xs text-gray-600 dark:text-gray-400">Track TikTok ad performance</p>
                            </div>
                        </div>
                        <input type="text" name="tiktok_pixel_id" value="{{ old('tiktok_pixel_id', $salesPage->tiktok_pixel_id) }}"
                               placeholder="XXXXXXXXXXXXXX"
                               class="w-full px-4 py-3 rounded-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 placeholder-gray-400 dark:placeholder-gray-500 focus:ring-2 focus:ring-gray-500 focus:border-transparent transition-all">
                    </div>
                </div>
            </div>

            <!-- Stats -->
            <div class="bg-gray-50 dark:bg-gray-700 p-4 rounded-lg">
                <h3 class="font-semibold mb-2">Page Statistics</h3>
                <div class="grid grid-cols-3 gap-4 text-center">
                    <div>
                        <div class="text-2xl font-bold">{{ number_format($salesPage->total_views) }}</div>
                        <div class="text-sm text-gray-600 dark:text-gray-400">Views</div>
                    </div>
                    <div>
                        <div class="text-2xl font-bold">{{ number_format($salesPage->total_orders) }}</div>
                        <div class="text-sm text-gray-600 dark:text-gray-400">Orders</div>
                    </div>
                    <div>
                        <div class="text-2xl font-bold">{{ $salesPage->getConversionRate() }}%</div>
                        <div class="text-sm text-gray-600 dark:text-gray-400">Conversion</div>
                    </div>
                </div>
            </div>

            <!-- Actions -->
            <div class="flex gap-4">
                <button type="submit"
                        class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                    Save Changes
                </button>
                <a href="{{ route('sales-pages.index') }}"
                   class="px-6 py-2 bg-gray-300 text-gray-700 rounded-lg hover:bg-gray-400">
                    Back to List
                </a>
                <a href="{{ route('sales-pages.show', $salesPage) }}"
                   class="px-6 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700">
                    📊 View Analytics
                </a>
            </div>
        </div>
    </form>
</div>

<script>
function copyUrl() {
    const input = document.getElementById('public-url');
    input.select();
    navigator.clipboard.writeText(input.value);
    alert('URL copied to clipboard!');
}

// FAQ Management
let faqIndex = {{ count(old('faq_items', $salesPage->faq_items ?? [])) }};

document.getElementById('add-faq').addEventListener('click', function() {
    const container = document.getElementById('faq-container');
    const faqItem = document.createElement('div');
    faqItem.className = 'faq-item border border-gray-300 dark:border-gray-600 rounded-lg p-4';
    faqItem.innerHTML = `
        <div class="flex justify-between items-start mb-3">
            <h4 class="font-medium text-sm">FAQ #${faqIndex + 1}</h4>
            <button type="button" class="remove-faq text-red-600 hover:text-red-800 text-sm">
                Remove
            </button>
        </div>
        <div class="space-y-3">
            <div>
                <label class="block text-sm font-medium mb-1">Question</label>
                <input type="text" name="faq_items[${faqIndex}][question]"
                       placeholder="e.g., How do I consume this product?"
                       class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700">
            </div>
            <div>
                <label class="block text-sm font-medium mb-1">Answer (HTML supported)</label>
                <textarea name="faq_items[${faqIndex}][answer]" rows="3"
                          placeholder="<p>You can consume 1-2 sachets daily...</p>"
                          class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 font-mono text-sm"></textarea>
            </div>
        </div>
    `;
    container.appendChild(faqItem);
    faqIndex++;
});

// Event delegation for removing FAQ items
document.getElementById('faq-container').addEventListener('click', function(e) {
    if (e.target.classList.contains('remove-faq')) {
        e.target.closest('.faq-item').remove();
    }
});

// Order Bump Toggle
document.getElementById('order-bump-toggle').addEventListener('change', function() {
    const settings = document.getElementById('order-bump-settings');
    if (this.checked) {
        settings.classList.remove('hidden');
    } else {
        settings.classList.add('hidden');
    }
});

// Order Bump Live Preview
function updateOrderBumpPreview() {
    const preview = document.getElementById('order-bump-preview');
    const previewText = document.getElementById('preview-text');

    const bgColor = document.querySelector('input[name="order_bump_bg_color"]').value;
    const textColor = document.querySelector('input[name="order_bump_text_color"]').value;
    const borderStyle = document.querySelector('select[name="order_bump_border_style"]').value;
    const borderColor = document.querySelector('input[name="order_bump_border_color"]').value;
    const text = document.querySelector('textarea[name="order_bump_text"]').value;

    preview.style.backgroundColor = bgColor;
    preview.style.color = textColor;
    preview.style.border = `2px ${borderStyle} ${borderColor}`;
    previewText.textContent = text || 'Add RM80 get 3 Booster Serum - Special Offer!';
}

// Add event listeners for live preview
document.querySelector('input[name="order_bump_bg_color"]').addEventListener('input', updateOrderBumpPreview);
document.querySelector('input[name="order_bump_text_color"]').addEventListener('input', updateOrderBumpPreview);
document.querySelector('select[name="order_bump_border_style"]').addEventListener('change', updateOrderBumpPreview);
document.querySelector('input[name="order_bump_border_color"]').addEventListener('input', updateOrderBumpPreview);
document.querySelector('textarea[name="order_bump_text"]').addEventListener('input', updateOrderBumpPreview);
</script>
@endsection
