@extends('layouts.app')

@section('title', 'Create Sales Page')

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6">
        <h1 class="text-2xl font-bold">Create Sales Page</h1>
    </div>

    <form action="{{ route('sales-pages.store') }}" method="POST" enctype="multipart/form-data">
        @csrf

        <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6 space-y-6">

            <!-- Basic Info -->
            <div>
                <h2 class="text-lg font-semibold mb-4">Basic Information</h2>

                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium mb-1">Page Name *</label>
                        <input type="text" name="name" value="{{ old('name') }}" required
                               class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700">
                        @error('name')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium mb-1">Meta Description (SEO)</label>
                        <textarea name="meta_description" rows="2" maxlength="160"
                                  placeholder="Short description for search engines (max 160 characters)"
                                  class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700">{{ old('meta_description') }}</textarea>
                        <p class="text-xs text-gray-500 mt-1">Helps improve search engine visibility</p>
                        @error('meta_description')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium mb-1">URL Slug (optional - auto-generated if empty)</label>
                        <div class="flex">
                            <span class="inline-flex items-center px-3 rounded-l-md border border-r-0 border-gray-300 bg-gray-50 text-gray-500 text-sm">
                                /p/{{ auth()->user()->getUrlSlug() }}/
                            </span>
                            <input type="text" name="slug" value="{{ old('slug') }}"
                                   class="flex-1 rounded-r-md border-gray-300 dark:border-gray-600 dark:bg-gray-700">
                        </div>
                        @error('slug')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium mb-1">Logo (optional)</label>
                        <input type="file" name="logo" accept="image/*"
                               class="w-full">
                        @error('logo')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror

                        <div class="mt-3">
                            <label class="flex items-center gap-2">
                                <input type="checkbox" name="show_logo" value="1"
                                       class="rounded">
                                <span class="text-sm">Show logo on sales page</span>
                            </label>
                            <p class="text-xs text-gray-500 mt-1">Check to display logo at top of sales page (you can also add it in your HTML content instead)</p>
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium mb-1">Favicon (optional)</label>
                        <p class="text-xs text-gray-500 mb-2">Browser tab icon (recommended: 32x32px or 64x64px)</p>

                        <div class="mb-3">
                            <label class="flex items-center gap-2">
                                <input type="checkbox" name="use_logo_as_favicon" value="1" checked
                                       class="rounded">
                                <span class="text-sm">Use logo as favicon</span>
                            </label>
                        </div>

                        <input type="file" name="favicon" accept="image/*" class="w-full">
                        <p class="text-xs text-gray-500 mt-1">Upload custom favicon (leave empty to use logo)</p>
                        @error('favicon')
                            <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label class="block text-sm font-medium mb-1">Primary Color</label>
                        <input type="color" name="primary_color" value="{{ old('primary_color', '#3B82F6') }}"
                               class="h-10">
                    </div>
                </div>
            </div>

            <!-- HTML Content -->
            <div>
                <h2 class="text-lg font-semibold mb-4">Page Content (HTML)</h2>
                <p class="text-sm text-gray-600 mb-2">Paste your HTML content with images, text, etc.</p>
                <textarea name="html_content" rows="15"
                          class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 font-mono text-sm"
                          placeholder="<img src='https://example.com/banner.jpg' style='width:100%'>
<h1>Product Title</h1>
<p>Description...</p>">{{ old('html_content') }}</textarea>
                @error('html_content')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- Legal / Marketing Content -->
            <div>
                <h2 class="text-lg font-semibold mb-4">Legal / Marketing / Permission (HTML) - Optional</h2>
                <p class="text-sm text-gray-600 mb-2">This section appears above the footer for legal notices, marketing consent, tracking permission, etc.</p>
                <textarea name="legal_content" rows="8"
                          class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 font-mono text-sm"
                          placeholder="<p>By submitting this form, you agree to our <a href='#'>Terms & Conditions</a> and <a href='#'>Privacy Policy</a>.</p>">{{ old('legal_content') }}</textarea>
                @error('legal_content')
                    <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                @enderror
            </div>

            <!-- FAQ Section -->
            <div>
                <h2 class="text-lg font-semibold mb-4">FAQ Section - Optional</h2>
                <p class="text-sm text-gray-600 mb-4">Add frequently asked questions with accordion-style answers (supports HTML)</p>

                <div id="faq-container" class="space-y-4">
                    <!-- FAQ items will be added here dynamically -->
                </div>

                <button type="button" id="add-faq" class="mt-3 px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700">
                    + Add FAQ
                </button>
            </div>

            <!-- Order Bump / Upsell Offer -->
            <div>
                <h2 class="text-lg font-semibold mb-4">Order Bump / Upsell Offer - Optional</h2>
                <p class="text-sm text-gray-600 mb-4">Add a special offer that shows when customers select a product</p>

                <div class="space-y-4">
                    <!-- Enable Order Bump -->
                    <div>
                        <label class="flex items-center gap-2">
                            <input type="checkbox" name="order_bump_enabled" value="1" id="order-bump-toggle"
                                   {{ old('order_bump_enabled') ? 'checked' : '' }}
                                   class="rounded">
                            <span class="text-sm font-medium">Enable Order Bump</span>
                        </label>
                    </div>

                    <!-- Order Bump Settings (hidden by default) -->
                    <div id="order-bump-settings" class="space-y-4 {{ old('order_bump_enabled') ? '' : 'hidden' }}">

                        <!-- Product Selection -->
                        <div>
                            <label class="block text-sm font-medium mb-1">Order Bump Product *</label>
                            @if($products->count() > 0)
                                <select name="order_bump_product_id"
                                        class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700">
                                    <option value="">-- Select Product --</option>
                                    @foreach($products as $product)
                                        <option value="{{ $product->id }}"
                                                {{ old('order_bump_product_id') == $product->id ? 'selected' : '' }}>
                                            {{ $product->name }} - RM {{ number_format($product->price, 2) }}
                                        </option>
                                    @endforeach
                                </select>
                            @else
                                <p class="text-sm text-gray-500">No products available. Create products first.</p>
                            @endif
                            <p class="text-xs text-gray-500 mt-1">This product will be offered as an add-on</p>
                            @error('order_bump_product_id')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Offer Text -->
                        <div>
                            <label class="block text-sm font-medium mb-1">Offer Text *</label>
                            <textarea name="order_bump_text" rows="2"
                                      placeholder="e.g., Add RM80 get 3 Booster Serum - Special Offer!"
                                      class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700">{{ old('order_bump_text') }}</textarea>
                            <p class="text-xs text-gray-500 mt-1">Compelling text to encourage customers to add this product</p>
                            @error('order_bump_text')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <!-- Styling Options -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <!-- Background Color -->
                            <div>
                                <label class="block text-sm font-medium mb-1">Background Color</label>
                                <input type="color" name="order_bump_bg_color" value="{{ old('order_bump_bg_color', '#fef3c7') }}"
                                       class="h-10 w-full">
                            </div>

                            <!-- Text Color -->
                            <div>
                                <label class="block text-sm font-medium mb-1">Text Color</label>
                                <input type="color" name="order_bump_text_color" value="{{ old('order_bump_text_color', '#78350f') }}"
                                       class="h-10 w-full">
                            </div>

                            <!-- Border Style -->
                            <div>
                                <label class="block text-sm font-medium mb-1">Border Style</label>
                                <select name="order_bump_border_style"
                                        class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700">
                                    <option value="solid" {{ old('order_bump_border_style', 'dashed') == 'solid' ? 'selected' : '' }}>Solid</option>
                                    <option value="dashed" {{ old('order_bump_border_style', 'dashed') == 'dashed' ? 'selected' : '' }}>Dashed</option>
                                    <option value="dotted" {{ old('order_bump_border_style', 'dashed') == 'dotted' ? 'selected' : '' }}>Dotted</option>
                                </select>
                            </div>

                            <!-- Border Color -->
                            <div>
                                <label class="block text-sm font-medium mb-1">Border Color</label>
                                <input type="color" name="order_bump_border_color" value="{{ old('order_bump_border_color', '#f59e0b') }}"
                                       class="h-10 w-full">
                            </div>
                        </div>

                        <!-- Live Preview -->
                        <div>
                            <label class="block text-sm font-medium mb-2">Preview:</label>
                            <div id="order-bump-preview"
                                 class="p-4 rounded-lg"
                                 style="background-color: {{ old('order_bump_bg_color', '#fef3c7') }};
                                        color: {{ old('order_bump_text_color', '#78350f') }};
                                        border: 2px {{ old('order_bump_border_style', 'dashed') }} {{ old('order_bump_border_color', '#f59e0b') }};">
                                <div class="flex items-start gap-3">
                                    <input type="checkbox" class="mt-1 w-5 h-5 rounded" disabled>
                                    <div class="flex-1">
                                        <div id="preview-text" class="font-bold text-base mb-1">
                                            {{ old('order_bump_text') ?: 'Add RM80 get 3 Booster Serum - Special Offer!' }}
                                        </div>
                                        <div class="text-sm opacity-90">
                                            Product name and price will appear here
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Products to Sell -->
            <div class="pb-8 border-b border-gray-200 dark:border-gray-700">
                <h2 class="text-xl font-semibold mb-6 text-gray-900 dark:text-gray-100">Products to Sell</h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">Select which products will be available on this sales page</p>

                @if($products->count() > 0)
                    <div class="space-y-2 max-h-64 overflow-y-auto border border-gray-300 dark:border-gray-600 rounded-xl p-4 bg-gray-50 dark:bg-gray-700/30">
                        @foreach($products as $product)
                            <label class="flex items-center gap-3 p-3 hover:bg-white dark:hover:bg-gray-700 rounded-lg transition-colors cursor-pointer">
                                <input type="checkbox" name="available_products[]" value="{{ $product->id }}"
                                       {{ in_array($product->id, old('available_products', [])) ? 'checked' : '' }}
                                       class="w-5 h-5 rounded text-blue-600 focus:ring-2 focus:ring-blue-500">
                                <div class="flex-1">
                                    <div class="font-medium text-gray-900 dark:text-gray-100">{{ $product->name }}</div>
                                    <div class="text-sm text-gray-500 dark:text-gray-400">RM {{ number_format($product->price, 2) }}</div>
                                </div>
                            </label>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8 bg-gray-50 dark:bg-gray-700/30 rounded-xl border border-gray-300 dark:border-gray-600">
                        <svg class="w-12 h-12 mx-auto text-gray-400 dark:text-gray-500 mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4"/>
                        </svg>
                        <p class="text-gray-600 dark:text-gray-400 mb-2">No products available. Create products first.</p>
                        <a href="{{ route('products.create') }}" class="inline-flex items-center gap-2 px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors text-sm font-medium">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
                            </svg>
                            Create Product
                        </a>
                    </div>
                @endif

                @error('available_products')
                    <p class="text-red-500 text-xs mt-2">{{ $message }}</p>
                @enderror
            </div>

            <!-- Tracking Pixels -->
            <div class="pb-8 border-b border-gray-200 dark:border-gray-700">
                <h2 class="text-xl font-semibold mb-6 text-gray-900 dark:text-gray-100">Tracking & Analytics Pixels</h2>
                <p class="text-sm text-gray-600 dark:text-gray-400 mb-6">Track conversions and visitor behavior with tracking pixels</p>

                <div class="space-y-6">
                    <!-- Facebook Pixel -->
                    <div class="bg-gradient-to-r from-blue-50 to-indigo-50 dark:from-blue-900/20 dark:to-indigo-900/20 p-5 rounded-xl border border-blue-200 dark:border-blue-800">
                        <div class="flex items-center gap-3 mb-3">
                            <div class="w-10 h-10 bg-blue-600 rounded-lg flex items-center justify-center">
                                <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                                </svg>
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-900 dark:text-gray-100">Facebook Pixel ID</label>
                                <p class="text-xs text-gray-600 dark:text-gray-400">Track Facebook ad conversions</p>
                            </div>
                        </div>
                        <input type="text" name="facebook_pixel_id" value="{{ old('facebook_pixel_id') }}"
                               placeholder="123456789012345"
                               class="w-full px-4 py-3 rounded-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 placeholder-gray-400 dark:placeholder-gray-500 focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all">
                    </div>

                    <!-- Google Analytics -->
                    <div class="bg-gradient-to-r from-orange-50 to-red-50 dark:from-orange-900/20 dark:to-red-900/20 p-5 rounded-xl border border-orange-200 dark:border-orange-800">
                        <div class="flex items-center gap-3 mb-3">
                            <div class="w-10 h-10 bg-orange-600 rounded-lg flex items-center justify-center">
                                <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M22.84 2.998v17.999a1.002 1.002 0 01-1.002 1.002h-5.687a.502.502 0 01-.502-.502V12.35H9.352v9.147a.502.502 0 01-.502.502H3.162a1.002 1.002 0 01-1.002-1.002V2.998a1.002 1.002 0 011.002-1.002h5.688a.502.502 0 01.502.502v9.148h6.297V2.498a.502.502 0 01.502-.502h5.687a1.002 1.002 0 011.002 1.002z"/>
                                </svg>
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-900 dark:text-gray-100">Google Analytics ID</label>
                                <p class="text-xs text-gray-600 dark:text-gray-400">Track visitor behavior and traffic sources</p>
                            </div>
                        </div>
                        <input type="text" name="google_analytics_id" value="{{ old('google_analytics_id') }}"
                               placeholder="G-XXXXXXXXXX or UA-XXXXXXXXX-X"
                               class="w-full px-4 py-3 rounded-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 placeholder-gray-400 dark:placeholder-gray-500 focus:ring-2 focus:ring-orange-500 focus:border-transparent transition-all">
                    </div>

                    <!-- TikTok Pixel -->
                    <div class="bg-gradient-to-r from-gray-50 to-slate-50 dark:from-gray-900/20 dark:to-slate-900/20 p-5 rounded-xl border border-gray-300 dark:border-gray-700">
                        <div class="flex items-center gap-3 mb-3">
                            <div class="w-10 h-10 bg-gray-900 dark:bg-gray-700 rounded-lg flex items-center justify-center">
                                <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M19.59 6.69a4.83 4.83 0 01-3.77-4.25V2h-3.45v13.67a2.89 2.89 0 01-5.2 1.74 2.89 2.89 0 012.31-4.64 2.93 2.93 0 01.88.13V9.4a6.84 6.84 0 00-1-.05A6.33 6.33 0 005 20.1a6.34 6.34 0 0010.86-4.43v-7a8.16 8.16 0 004.77 1.52v-3.4a4.85 4.85 0 01-1-.1z"/>
                                </svg>
                            </div>
                            <div>
                                <label class="block text-sm font-semibold text-gray-900 dark:text-gray-100">TikTok Pixel ID</label>
                                <p class="text-xs text-gray-600 dark:text-gray-400">Track TikTok ad performance</p>
                            </div>
                        </div>
                        <input type="text" name="tiktok_pixel_id" value="{{ old('tiktok_pixel_id') }}"
                               placeholder="XXXXXXXXXXXXXX"
                               class="w-full px-4 py-3 rounded-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100 placeholder-gray-400 dark:placeholder-gray-500 focus:ring-2 focus:ring-gray-500 focus:border-transparent transition-all">
                    </div>
                </div>
            </div>

            <!-- Actions -->
            <div class="flex gap-4">
                <button type="submit"
                        class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                    Create Sales Page
                </button>
                <a href="{{ route('sales-pages.index') }}"
                   class="px-6 py-2 bg-gray-300 text-gray-700 rounded-lg hover:bg-gray-400">
                    Cancel
                </a>
            </div>
        </div>
    </form>
</div>

<script>
// FAQ Management
let faqIndex = 0;

document.getElementById('add-faq').addEventListener('click', function() {
    const container = document.getElementById('faq-container');
    const faqItem = document.createElement('div');
    faqItem.className = 'faq-item border border-gray-300 dark:border-gray-600 rounded-lg p-4';
    faqItem.innerHTML = `
        <div class="flex justify-between items-start mb-3">
            <h4 class="font-medium text-sm">FAQ #${faqIndex + 1}</h4>
            <button type="button" class="remove-faq text-red-600 hover:text-red-800 text-sm">
                Remove
            </button>
        </div>
        <div class="space-y-3">
            <div>
                <label class="block text-sm font-medium mb-1">Question</label>
                <input type="text" name="faq_items[${faqIndex}][question]"
                       placeholder="e.g., How do I consume this product?"
                       class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700">
            </div>
            <div>
                <label class="block text-sm font-medium mb-1">Answer (HTML supported)</label>
                <textarea name="faq_items[${faqIndex}][answer]" rows="3"
                          placeholder="<p>You can consume 1-2 sachets daily...</p>"
                          class="w-full px-3 py-2 rounded-md border border-gray-300 dark:border-gray-600 dark:bg-gray-700 font-mono text-sm"></textarea>
            </div>
        </div>
    `;
    container.appendChild(faqItem);
    faqIndex++;
});

// Event delegation for removing FAQ items
document.getElementById('faq-container').addEventListener('click', function(e) {
    if (e.target.classList.contains('remove-faq')) {
        e.target.closest('.faq-item').remove();
    }
});

// Order Bump Toggle
const orderBumpToggle = document.getElementById('order-bump-toggle');
const orderBumpSettings = document.getElementById('order-bump-settings');

if (orderBumpToggle) {
    orderBumpToggle.addEventListener('change', function() {
        if (this.checked) {
            orderBumpSettings.classList.remove('hidden');
        } else {
            orderBumpSettings.classList.add('hidden');
        }
    });
}

// Order Bump Live Preview Updates
function updateOrderBumpPreview() {
    const preview = document.getElementById('order-bump-preview');
    const previewText = document.getElementById('preview-text');

    if (!preview || !previewText) return;

    const bgColor = document.querySelector('input[name="order_bump_bg_color"]').value;
    const textColor = document.querySelector('input[name="order_bump_text_color"]').value;
    const borderStyle = document.querySelector('select[name="order_bump_border_style"]').value;
    const borderColor = document.querySelector('input[name="order_bump_border_color"]').value;
    const text = document.querySelector('textarea[name="order_bump_text"]').value;

    preview.style.backgroundColor = bgColor;
    preview.style.color = textColor;
    preview.style.border = `2px ${borderStyle} ${borderColor}`;
    previewText.textContent = text || 'Add RM80 get 3 Booster Serum - Special Offer!';
}

// Attach event listeners for live preview
const bgColorInput = document.querySelector('input[name="order_bump_bg_color"]');
const textColorInput = document.querySelector('input[name="order_bump_text_color"]');
const borderStyleSelect = document.querySelector('select[name="order_bump_border_style"]');
const borderColorInput = document.querySelector('input[name="order_bump_border_color"]');
const offerTextArea = document.querySelector('textarea[name="order_bump_text"]');

if (bgColorInput) bgColorInput.addEventListener('input', updateOrderBumpPreview);
if (textColorInput) textColorInput.addEventListener('input', updateOrderBumpPreview);
if (borderStyleSelect) borderStyleSelect.addEventListener('change', updateOrderBumpPreview);
if (borderColorInput) borderColorInput.addEventListener('input', updateOrderBumpPreview);
if (offerTextArea) offerTextArea.addEventListener('input', updateOrderBumpPreview);
</script>
@endsection
